/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.User;
import com.google.common.collect.ListMultimap;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.confirmations.ConfirmationType;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.event.TownInvitePlayerEvent;
import com.palmergames.bukkit.towny.event.TownPreClaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownSpawnLevel;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.inviteobjects.PlayerJoinTownInvite;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TownCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> output;
    private static final List<String> invite;

    public TownCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.parseTownCommand(player, args);
        } else {
            try {
                this.parseTownCommandForConsole(sender, args);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        return true;
    }

    private void parseTownCommandForConsole(final CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : output) {
                sender.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listTowns(sender, split);
        } else {
            try {
                final Town town = TownyUniverse.getDataSource().getTown(split[0]);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        TownyMessaging.sendMessage((Object)sender, TownyFormatter.getStatus(town));
                    }
                });
            }
            catch (NotRegisteredException x) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
            }
        }
    }

    private void parseTownCommand(final Player player, String[] split) {
        block101: {
            try {
                if (split.length == 0) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                                Town town = resident.getTown();
                                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
                            }
                            catch (NotRegisteredException x) {
                                try {
                                    throw new TownyException(TownySettings.getLangString("msg_err_dont_belong_town"));
                                }
                                catch (TownyException e) {
                                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                                }
                            }
                        }
                    });
                    break block101;
                }
                if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
                    for (String line : output) {
                        player.sendMessage(line);
                    }
                    break block101;
                }
                if (split[0].equalsIgnoreCase("here")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_HERE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.showTownStatusHere(player);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("list")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_LIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.listTowns((CommandSender)player, split);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("new") || split[0].equalsIgnoreCase("create")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_NEW.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length == 1) {
                        throw new TownyException(TownySettings.getLangString("msg_specify_name"));
                    }
                    if (split.length >= 2) {
                        CharSequence[] newSplit = StringMgmt.remFirstArg(split);
                        String townName = String.join((CharSequence)"_", newSplit);
                        TownCommand.newTown(player, townName, player.getName(), false);
                    }
                    break block101;
                }
                if (split[0].equalsIgnoreCase("leave")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_LEAVE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townLeave(player);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("withdraw")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_WITHDRAW.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (TownySettings.isBankActionLimitedToBankPlots()) {
                        Town pTown;
                        if (TownyUniverse.isWilderness(player.getLocation().getBlock())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        TownBlock tb = TownyUniverse.getTownBlock(player.getLocation());
                        Town tbTown = tb.getTown();
                        if (tbTown != (pTown = TownyUniverse.getDataSource().getResident(player.getName()).getTown())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        boolean goodPlot = false;
                        if (tb.getType().equals((Object)TownBlockType.BANK) || tb.isHomeBlock()) {
                            goodPlot = true;
                        }
                        if (!goodPlot) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                    }
                    if (TownySettings.isBankActionDisallowedOutsideTown()) {
                        if (TownyUniverse.isWilderness(player.getLocation().getBlock())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_your_town"));
                        }
                        Coord coord = Coord.parseCoord(plugin.getCache(player).getLastLocation());
                        Town town = TownyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName()).getTownBlock(coord).getTown();
                        if (!TownyUniverse.getDataSource().getResident(player.getName()).getTown().equals(town)) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_your_town"));
                        }
                    }
                    if (split.length == 2) {
                        try {
                            this.townWithdraw(player, Integer.parseInt(split[1].trim()));
                            break block101;
                        }
                        catch (NumberFormatException e) {
                            throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    }
                    throw new TownyException(String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town withdraw"));
                }
                if (split[0].equalsIgnoreCase("deposit")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_DEPOSIT.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (TownySettings.isBankActionLimitedToBankPlots()) {
                        Town pTown;
                        if (TownyUniverse.isWilderness(player.getLocation().getBlock())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        TownBlock tb = TownyUniverse.getTownBlock(player.getLocation());
                        Town tbTown = tb.getTown();
                        if (tbTown != (pTown = TownyUniverse.getDataSource().getResident(player.getName()).getTown())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        boolean goodPlot = false;
                        if (tb.getType().equals((Object)TownBlockType.BANK) || tb.isHomeBlock()) {
                            goodPlot = true;
                        }
                        if (!goodPlot) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                    }
                    if (TownySettings.isBankActionDisallowedOutsideTown()) {
                        if (TownyUniverse.isWilderness(player.getLocation().getBlock())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_your_town"));
                        }
                        Coord coord = Coord.parseCoord(plugin.getCache(player).getLastLocation());
                        Town town = TownyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName()).getTownBlock(coord).getTown();
                        if (!TownyUniverse.getDataSource().getResident(player.getName()).getTown().equals(town)) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_your_town"));
                        }
                    }
                    if (split.length == 2) {
                        try {
                            this.townDeposit(player, Integer.parseInt(split[1].trim()));
                            break block101;
                        }
                        catch (NumberFormatException e) {
                            throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    }
                    throw new TownyException(String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town deposit"));
                }
                if (split[0].equalsIgnoreCase("plots")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_PLOTS.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Town town = null;
                    try {
                        town = split.length == 1 ? TownyUniverse.getDataSource().getResident(player.getName()).getTown() : TownyUniverse.getDataSource().getTown(split[1]);
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
                        return;
                    }
                    this.townPlots(player, town);
                    break block101;
                }
                String[] newSplit = StringMgmt.remFirstArg(split);
                if (split[0].equalsIgnoreCase("rank")) {
                    this.townRank(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("set")) {
                    this.townSet(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("buy")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_BUY.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townBuy(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("toggle")) {
                    this.townToggle(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("mayor")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_MAYOR.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townMayor(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("spawn")) {
                    TownCommand.townSpawn(player, newSplit, false);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("outpost")) {
                    if (split.length >= 2) {
                        if (split[1].equalsIgnoreCase("list")) {
                            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_OUTPOST_LIST.getNode())) {
                                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                            }
                            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                            if (resident.hasTown()) {
                                Town town = resident.getTown();
                                List<Location> outposts = town.getAllOutpostSpawns();
                                int page = 1;
                                int total = (int)Math.ceil((double)outposts.size() / 10.0);
                                if (split.length == 3) {
                                    try {
                                        page = Integer.parseInt(split[2]);
                                        if (page < 0) {
                                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative"));
                                            return;
                                        }
                                        if (page == 0) {
                                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                                            return;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                                        return;
                                    }
                                }
                                if (page > total) {
                                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getListNotEnoughPagesMsg(total));
                                    return;
                                }
                                int iMax = page * 10;
                                if (page * 10 > outposts.size()) {
                                    iMax = outposts.size();
                                }
                                ArrayList<String> outputs = new ArrayList<String>();
                                for (int i = (page - 1) * 10; i < iMax; ++i) {
                                    Location outpost = outposts.get(i);
                                    TownBlock tb = TownyUniverse.getTownBlock(outposts.get(i));
                                    String output = !tb.getName().equalsIgnoreCase("") ? "\u00a76" + Integer.toString(i + 1) + "\u00a78" + " - " + "\u00a7a" + tb.getName() + "\u00a78" + " - " + "\u00a7b" + outpost.getWorld().getName() + "\u00a78" + " - " + "\u00a7b" + "(" + outpost.getBlockX() + "," + outpost.getBlockZ() + ")" : "\u00a76" + Integer.toString(i + 1) + "\u00a78" + " - " + "\u00a7b" + outpost.getWorld().getName() + "\u00a78" + " - " + "\u00a7b" + "(" + outpost.getBlockX() + "," + outpost.getBlockZ() + ")";
                                    outputs.add(output);
                                }
                                player.sendMessage(ChatTools.formatList(TownySettings.getLangString("outpost_plu"), "\u00a76#\u00a78 - \u00a7a(Plot Name)\u00a78 - \u00a7b(Outpost World)\u00a78 - \u00a7b(Outpost Location)", outputs, TownySettings.getListPageMsg(page, total)));
                                break block101;
                            }
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_must_belong_town"));
                            return;
                        }
                        TownCommand.townSpawn(player, newSplit, true);
                        return;
                    }
                    TownCommand.townSpawn(player, newSplit, true);
                    return;
                }
                if (split[0].equalsIgnoreCase("delete")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_DELETE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.townDelete(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("reslist")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_RESLIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Town town = null;
                    try {
                        town = split.length == 1 ? TownyUniverse.getDataSource().getResident(player.getName()).getTown() : TownyUniverse.getDataSource().getTown(split[1]);
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
                        return;
                    }
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedResidents(town));
                    break block101;
                }
                if (split[0].equalsIgnoreCase("ranklist")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_RANKLIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        Town town = resident.getTown();
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getRanks(town));
                        break block101;
                    }
                    catch (NotRegisteredException x) {
                        throw new TownyException(TownySettings.getLangString("msg_err_dont_belong_town"));
                    }
                }
                if (split[0].equalsIgnoreCase("outlawlist")) {
                    Town town = null;
                    try {
                        town = split.length == 1 ? TownyUniverse.getDataSource().getResident(player.getName()).getTown() : TownyUniverse.getDataSource().getTown(split[1]);
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
                        return;
                    }
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOutlaws(town));
                    break block101;
                }
                if (split[0].equalsIgnoreCase("join")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_JOIN.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.parseTownJoin((CommandSender)player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("add")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.townAdd(player, null, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("invite") || split[0].equalsIgnoreCase("invites")) {
                    this.parseInviteCommand(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("kick")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_KICK.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.townKick(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("claim")) {
                    TownCommand.parseTownClaimCommand(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("unclaim")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownCommand.parseTownUnclaimCommand(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("online")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_ONLINE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.parseTownOnlineCommand(player, newSplit);
                    break block101;
                }
                if (split[0].equalsIgnoreCase("say")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_SAY.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Town town = TownyUniverse.getDataSource().getResident(player.getName()).getTown();
                        StringBuilder builder = new StringBuilder();
                        for (String s : newSplit) {
                            builder.append(s + " ");
                        }
                        String message = builder.toString();
                        TownyMessaging.sendPrefixedTownMessage(town, message);
                    }
                    catch (Exception town) {}
                    break block101;
                }
                if (split[0].equalsIgnoreCase("outlaw")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_OUTLAW.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.parseTownOutlawCommand(player, newSplit);
                    break block101;
                }
                try {
                    final Town town = TownyUniverse.getDataSource().getTown(split[0]);
                    Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                    if (!(TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_OTHERTOWN.getNode()) || resident.getTown() == town && resident.hasTown())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

                        @Override
                        public void run() {
                            TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
                        }
                    });
                }
                catch (NotRegisteredException x) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
                }
            }
            catch (Exception x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    private void parseInviteCommand(Player player, String[] newSplit) throws TownyException {
        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
        String received = TownySettings.getLangString("town_received_invites").replace("%a", Integer.toString(InviteHandler.getReceivedInvitesAmount(resident.getTown()))).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident.getTown())));
        String sent = TownySettings.getLangString("town_sent_invites").replace("%a", Integer.toString(InviteHandler.getSentInvitesAmount(resident.getTown()))).replace("%m", Integer.toString(InviteHandler.getSentInvitesMaxAmount(resident.getTown())));
        if (newSplit.length == 0) {
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_SEE_HOME.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            ArrayList<String> messages = new ArrayList<String>();
            for (String msg : invite) {
                messages.add(Colors.strip(msg));
            }
            messages.add(sent);
            messages.add(received);
            String[] msgs = messages.toArray(new String[0]);
            player.sendMessage(msgs);
            return;
        }
        if (newSplit.length >= 1) {
            ListMultimap<Nation, Town> nation2towns;
            Nation nation;
            List<Invite> invites;
            Town town;
            if (newSplit[0].equalsIgnoreCase("help") || newSplit[0].equalsIgnoreCase("?")) {
                for (String msg : invite) {
                    player.sendMessage(Colors.strip(msg));
                }
                return;
            }
            if (newSplit[0].equalsIgnoreCase("sent")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_LIST_SENT.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                List<Invite> sentinvites = resident.getTown().getSentInvites();
                int page = 1;
                if (newSplit.length >= 2) {
                    try {
                        page = Integer.parseInt(newSplit[1]);
                    }
                    catch (NumberFormatException e) {
                        page = 1;
                    }
                }
                InviteCommand.sendInviteList(player, sentinvites, page, true);
                player.sendMessage(sent);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("received")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_LIST_RECEIVED.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                List<Invite> receivedinvites = resident.getTown().getReceivedInvites();
                int page = 1;
                if (newSplit.length >= 2) {
                    try {
                        page = Integer.parseInt(newSplit[1]);
                    }
                    catch (NumberFormatException e) {
                        page = 1;
                    }
                }
                InviteCommand.sendInviteList(player, receivedinvites, page, false);
                player.sendMessage(received);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("accept")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ACCEPT.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                town = resident.getTown();
                invites = town.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_town_no_invites"));
                    return;
                }
                if (newSplit.length >= 2) {
                    try {
                        nation = TownyUniverse.getDataSource().getNation(newSplit[1]);
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_town_specify_invite"));
                    InviteCommand.sendInviteList(player, invites, 1, false);
                    return;
                }
                nation2towns = InviteHandler.getNationtotowninvites();
                if (nation2towns.containsKey((Object)nation) && nation2towns.get((Object)nation).contains(town)) {
                    for (Invite invite : town.getReceivedInvites()) {
                        if (!invite.getSender().equals(nation)) continue;
                        try {
                            InviteHandler.acceptInvite(invite);
                            return;
                        }
                        catch (InvalidObjectException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (newSplit[0].equalsIgnoreCase("deny")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_DENY.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                town = resident.getTown();
                invites = town.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_town_no_invites"));
                    return;
                }
                if (newSplit.length >= 2) {
                    try {
                        nation = TownyUniverse.getDataSource().getNation(newSplit[1]);
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_town_specify_invite"));
                    InviteCommand.sendInviteList(player, invites, 1, false);
                    return;
                }
                nation2towns = InviteHandler.getNationtotowninvites();
                if (nation2towns.containsKey((Object)nation) && nation2towns.get((Object)nation).contains(town)) {
                    for (Invite invite : town.getReceivedInvites()) {
                        if (!invite.getSender().equals(nation)) continue;
                        try {
                            InviteHandler.declineInvite(invite, false);
                            TownyMessaging.sendMessage((Object)player, TownySettings.getLangString("successful_deny"));
                            return;
                        }
                        catch (InvalidObjectException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                TownCommand.townAdd(player, null, newSplit);
            }
        }
    }

    private void parseTownOutlawCommand(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town outlaw"));
            player.sendMessage(ChatTools.formatCommand("", "/town outlaw", "add/remove [name]", ""));
        } else {
            Resident target;
            Resident resident;
            Town town = null;
            Town targetTown = null;
            if (split.length < 2) {
                throw new TownyException("Eg: /town outlaw add/remove [name]");
            }
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                target = TownyUniverse.getDataSource().getResident(split[1]);
                town = resident.getTown();
            }
            catch (TownyException x) {
                throw new TownyException(x.getMessage());
            }
            if (split[0].equalsIgnoreCase("add")) {
                try {
                    try {
                        targetTown = target.getTown();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    if (resident.getTown().getMayor().equals(target)) {
                        return;
                    }
                    if (targetTown != null && targetTown == town) {
                        TownCommand.townRemoveResident(town, target);
                        TownyMessaging.sendMsg(target, String.format(TownySettings.getLangString("msg_kicked_by"), player.getName()));
                        TownyMessaging.sendPrefixedTownMessage(town, String.format(TownySettings.getLangString("msg_kicked"), player.getName(), target.getName()));
                    }
                    town.addOutlaw(target);
                    TownyUniverse.getDataSource().saveTown(town);
                    TownyMessaging.sendMsg(target, String.format(TownySettings.getLangString("msg_you_have_been_declared_outlaw"), town.getName()));
                    TownyMessaging.sendPrefixedTownMessage(town, String.format(TownySettings.getLangString("msg_you_have_declared_an_outlaw"), target.getName(), town.getName()));
                }
                catch (AlreadyRegisteredException e) {
                    TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_err_resident_already_an_outlaw"));
                    return;
                }
                catch (EmptyTownException e) {
                    e.printStackTrace();
                }
            } else if (split[0].equalsIgnoreCase("remove")) {
                try {
                    town.removeOutlaw(target);
                    TownyUniverse.getDataSource().saveTown(town);
                    TownyMessaging.sendMsg(target, String.format(TownySettings.getLangString("msg_you_have_been_undeclared_outlaw"), town.getName()));
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_you_have_undeclared_an_outlaw"), target.getName(), town.getName()));
                }
                catch (NotRegisteredException e) {
                    TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_err_player_not_an_outlaw"));
                    return;
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), split[0]));
                return;
            }
            TownyUniverse.getDataSource().saveTown(town);
        }
    }

    private void townPlots(Player player, Town town) {
        ArrayList<String> out = new ArrayList<String>();
        int townOwned = 0;
        int resident = 0;
        int residentOwned = 0;
        int residentOwnedFS = 0;
        int embassy = 0;
        int embassyRO = 0;
        int embassyFS = 0;
        int shop = 0;
        int shopRO = 0;
        int shopFS = 0;
        int farm = 0;
        int arena = 0;
        int wilds = 0;
        int jail = 0;
        int inn = 0;
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (townBlock.getType() == TownBlockType.EMBASSY) {
                ++embassy;
                if (townBlock.hasResident()) {
                    ++embassyRO;
                }
                if (townBlock.isForSale()) {
                    ++embassyFS;
                }
            } else if (townBlock.getType() == TownBlockType.COMMERCIAL) {
                ++shop;
                if (townBlock.hasResident()) {
                    ++shopRO;
                }
                if (townBlock.isForSale()) {
                    ++shopFS;
                }
            } else if (townBlock.getType() == TownBlockType.FARM) {
                ++farm;
            } else if (townBlock.getType() == TownBlockType.ARENA) {
                ++arena;
            } else if (townBlock.getType() == TownBlockType.WILDS) {
                ++wilds;
            } else if (townBlock.getType() == TownBlockType.JAIL) {
                ++jail;
            } else if (townBlock.getType() == TownBlockType.INN) {
                ++inn;
            } else if (townBlock.getType() == TownBlockType.RESIDENTIAL) {
                ++resident;
                if (townBlock.hasResident()) {
                    ++residentOwned;
                }
                if (townBlock.isForSale()) {
                    ++residentOwnedFS;
                }
            }
            if (townBlock.hasResident()) continue;
            ++townOwned;
        }
        out.add(ChatTools.formatTitle(town + " Town Plots"));
        out.add("\u00a72Town Size: \u00a7a" + town.getTownBlocks().size() + " / " + TownySettings.getMaxTownBlocks(town) + (TownySettings.isSellingBonusBlocks() ? "\u00a7b [Bought: " + town.getPurchasedBlocks() + "/" + TownySettings.getMaxPurchedBlocks() + "]" : "") + (town.getBonusBlocks() > 0 ? "\u00a7b [Bonus: " + town.getBonusBlocks() + "]" : "") + (TownySettings.getNationBonusBlocks(town) > 0 ? "\u00a7b [NationBonus: " + TownySettings.getNationBonusBlocks(town) + "]" : ""));
        out.add("\u00a72Town Owned Land: \u00a7a" + townOwned);
        out.add("\u00a72Farms   : \u00a7a" + farm);
        out.add("\u00a72Arenas : \u00a7a" + arena);
        out.add("\u00a72Wilds    : \u00a7a" + wilds);
        out.add("\u00a72Jails    : \u00a7a" + jail);
        out.add("\u00a72Inns    : \u00a7a" + inn);
        out.add("\u00a72Type: \u00a7aPlayer-Owned / ForSale / Total / Daily Revenue");
        out.add("\u00a72Residential: \u00a7a" + residentOwned + " / " + residentOwnedFS + " / " + resident + " / " + (double)residentOwned * town.getPlotTax());
        out.add("\u00a72Embassies : \u00a7a" + embassyRO + " / " + embassyFS + " / " + embassy + " / " + (double)embassyRO * town.getEmbassyPlotTax());
        out.add("\u00a72Shops      : \u00a7a" + shopRO + " / " + shopFS + " / " + shop + " / " + (double)shop * town.getCommercialPlotTax());
        out.add(String.format(TownySettings.getLangString("msg_town_plots_revenue_disclaimer"), new Object[0]));
        TownyMessaging.sendMessage((Object)player, out);
    }

    private void parseTownOnlineCommand(Player player, String[] split) throws TownyException {
        if (split.length > 0) {
            try {
                Town town = TownyUniverse.getDataSource().getTown(split[0]);
                List<Resident> onlineResidents = TownyUniverse.getOnlineResidentsViewable(player, town);
                if (onlineResidents.size() > 0) {
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_town_online"), town, player));
                }
                TownyMessaging.sendMessage((Object)player, ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a7f" + "0 " + TownySettings.getLangString("res_list") + " " + TownySettings.getLangString("msg_town_online") + ": " + town));
            }
            catch (NotRegisteredException e) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
            }
        } else {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_town_online"), town, player));
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendMessage((Object)player, TownySettings.getLangString("msg_err_dont_belong_town"));
            }
        }
    }

    public void listTowns(CommandSender sender, String[] split) {
        List<Town> townsToSort = TownyUniverse.getDataSource().getTowns();
        int page = 1;
        int total = (int)Math.ceil((double)townsToSort.size() / 10.0);
        if (split.length > 1) {
            try {
                page = Integer.parseInt(split[1]);
                if (page < 0) {
                    TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_err_negative"));
                    return;
                }
                if (page == 0) {
                    TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_must_be_int"));
                    return;
                }
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_must_be_int"));
                return;
            }
        }
        if (page > total) {
            TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getListNotEnoughPagesMsg(total));
            return;
        }
        Collections.sort(townsToSort, new Comparator(){

            public int compare(Object t1, Object t2) {
                if (((Town)t2).getNumResidents() == ((Town)t1).getNumResidents()) {
                    return 0;
                }
                return ((Town)t2).getNumResidents() > ((Town)t1).getNumResidents() ? 1 : -1;
            }
        });
        int iMax = page * 10;
        if (page * 10 > townsToSort.size()) {
            iMax = townsToSort.size();
        }
        ArrayList<String> townsformatted = new ArrayList<String>();
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Town town = townsToSort.get(i);
            String output = "\u00a73" + town.getName() + "\u00a78" + " - " + "\u00a7b" + "(" + town.getNumResidents() + ")";
            if (town.isOpen()) {
                output = output + "\u00a7f (Open)";
            }
            townsformatted.add(output);
        }
        sender.sendMessage(ChatTools.formatList(TownySettings.getLangString("town_plu"), "\u00a73Town Name\u00a78 - \u00a7b(Number of Residents)", townsformatted, TownySettings.getListPageMsg(page, total)));
    }

    public void townMayor(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            this.showTownMayorHelp(player);
        }
    }

    public void showTownStatusHere(Player player) {
        try {
            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            Coord coord = Coord.parseCoord((Entity)player);
            this.showTownStatusAtCoord(player, world, coord);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public void showTownStatusAtCoord(Player player, TownyWorld world, Coord coord) throws TownyException {
        if (!world.hasTownBlock(coord)) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_not_claimed"), coord));
        }
        Town town = world.getTownBlock(coord).getTown();
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
    }

    public void showTownMayorHelp(Player player) {
        player.sendMessage(ChatTools.formatTitle("Town Mayor Help"));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "withdraw [$]", ""));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "claim", "'/town claim ?' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "unclaim", "'/town " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "[add/kick] " + TownySettings.getLangString("res_2") + " .. []", TownySettings.getLangString("res_6")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "set [] .. []", "'/town set' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "buy [] .. []", "'/town buy' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "plots", ""));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "toggle", ""));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "rank add/remove [resident] [rank]", "'/town rank ?' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "delete", ""));
    }

    public void townToggle(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "public", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "mobs", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "taxpercent", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "open", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "jail [number] [resident]", ""));
        } else {
            Town town;
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
            }
            catch (TownyException x) {
                throw new TownyException(x.getMessage());
            }
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_TOGGLE.getNode(split[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (split[0].equalsIgnoreCase("public")) {
                town.setPublic(!town.isPublic());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_public"), town.isPublic() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
            } else if (split[0].equalsIgnoreCase("pvp")) {
                this.toggleTest(player, town, StringMgmt.join(split, " "));
                boolean outsiderintown = false;
                if (TownySettings.getOutsidersPreventPVPToggle()) {
                    for (Player target : Bukkit.getOnlinePlayers()) {
                        Resident targetresident = TownyUniverse.getDataSource().getResident(target.getName());
                        Block block = target.getLocation().getBlock().getRelative(BlockFace.DOWN);
                        if (TownyUniverse.isWilderness(block)) continue;
                        WorldCoord coord = WorldCoord.parseWorldCoord(target.getLocation());
                        for (TownBlock tb : town.getTownBlocks()) {
                            if (!coord.equals(tb.getWorldCoord()) || targetresident.hasTown() && targetresident.getTown().equals(town)) continue;
                            outsiderintown = true;
                        }
                    }
                }
                if (!outsiderintown) {
                    town.setPVP(!town.isPVP());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_pvp"), town.getName(), town.isPVP() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
                } else if (outsiderintown) {
                    throw new TownyException(TownySettings.getLangString("msg_cant_toggle_pvp_outsider_in_town"));
                }
            } else if (split[0].equalsIgnoreCase("explosion")) {
                this.toggleTest(player, town, StringMgmt.join(split, " "));
                town.setBANG(!town.isBANG());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_expl"), town.getName(), town.isBANG() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
            } else if (split[0].equalsIgnoreCase("fire")) {
                this.toggleTest(player, town, StringMgmt.join(split, " "));
                town.setFire(!town.isFire());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_fire"), town.getName(), town.isFire() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
            } else if (split[0].equalsIgnoreCase("mobs")) {
                this.toggleTest(player, town, StringMgmt.join(split, " "));
                town.setHasMobs(!town.hasMobs());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_mobs"), town.getName(), town.hasMobs() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
            } else if (split[0].equalsIgnoreCase("taxpercent")) {
                town.setTaxPercentage(!town.isTaxPercentage());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_taxpercent"), town.isTaxPercentage() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
            } else if (split[0].equalsIgnoreCase("open")) {
                town.setOpen(!town.isOpen());
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_open"), town.isOpen() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
                if (town.isOpen()) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_toggle_open_on_warning"), new Object[0]));
                }
            } else if (split[0].equalsIgnoreCase("jail")) {
                if (!town.hasJailSpawn()) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_town_has_no_jails"), new Object[0]));
                }
                if (split.length <= 2) {
                    player.sendMessage(ChatTools.formatTitle("/town toggle jail"));
                    player.sendMessage(ChatTools.formatCommand("", "/town toggle jail", "[number] [resident]", ""));
                } else if (split.length == 3) {
                    try {
                        Integer.parseInt(split[1]);
                        Integer index = Integer.valueOf(split[1]);
                        Resident jailedresident = TownyUniverse.getDataSource().getResident(split[2]);
                        if (!player.hasPermission("towny.command.town.toggle.jail")) {
                            throw new TownyException(TownySettings.getLangString("msg_no_permission_to_jail_your_residents"));
                        }
                        if (!jailedresident.hasTown() && !jailedresident.isJailed()) {
                            throw new TownyException(TownySettings.getLangString("msg_resident_not_part_of_any_town"));
                        }
                        try {
                            if (jailedresident.isJailed() && index.intValue() != jailedresident.getJailSpawn()) {
                                index = jailedresident.getJailSpawn();
                            }
                            Player jailedplayer = TownyUniverse.getPlayer(jailedresident);
                            Town sendertown = resident.getTown();
                            if (jailedplayer.getUniqueId().equals(player.getUniqueId())) {
                                throw new TownyException(TownySettings.getLangString("msg_no_self_jailing"));
                            }
                            if (jailedresident.isJailed()) {
                                Town jailTown = TownyUniverse.getDataSource().getTown(jailedresident.getJailTown());
                                if (jailTown != sendertown) {
                                    throw new TownyException(TownySettings.getLangString("msg_player_not_jailed_in_your_town"));
                                }
                                jailedresident.setJailedByMayor(jailedplayer, index, sendertown);
                                return;
                            }
                            if (jailedresident.getTown() != sendertown) {
                                throw new TownyException(TownySettings.getLangString("msg_resident_not_your_town"));
                            }
                            jailedresident.setJailedByMayor(jailedplayer, index, sendertown);
                        }
                        catch (NotRegisteredException x) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
                        }
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatTools.formatTitle("/town toggle jail"));
                        player.sendMessage(ChatTools.formatCommand("", "/town toggle jail", "[number] [resident]", ""));
                        return;
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            } else {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), split[0]));
            }
            for (TownBlock townBlock : town.getTownBlocks()) {
                if (townBlock.hasResident() || townBlock.isChanged()) continue;
                townBlock.setType(townBlock.getType());
                TownyUniverse.getDataSource().saveTownBlock(townBlock);
            }
            TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(town);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            TownyUniverse.getDataSource().saveTown(town);
        }
    }

    private void toggleTest(Player player, Town town, String split) throws TownyException {
        if ((split = split.toLowerCase()).contains("mobs") && town.getWorld().isForceTownMobs()) {
            throw new TownyException(TownySettings.getLangString("msg_world_mobs"));
        }
        if (split.contains("fire") && town.getWorld().isForceFire()) {
            throw new TownyException(TownySettings.getLangString("msg_world_fire"));
        }
        if (split.contains("explosion") && town.getWorld().isForceExpl()) {
            throw new TownyException(TownySettings.getLangString("msg_world_expl"));
        }
        if (split.contains("pvp") && town.getWorld().isForcePVP()) {
            throw new TownyException(TownySettings.getLangString("msg_world_pvp"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void townRank(Player player, String[] split) throws TownyException {
        Resident target;
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town rank"));
            player.sendMessage(ChatTools.formatCommand("", "/town rank", "add/remove [resident] rank", ""));
            return;
        }
        Town town = null;
        if (split.length < 3) {
            throw new TownyException("Eg: /town rank add/remove [resident] [rank]");
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            target = TownyUniverse.getDataSource().getResident(split[1]);
            town = resident.getTown();
            if (town != target.getTown()) {
                throw new TownyException(TownySettings.getLangString("msg_resident_not_your_town"));
            }
        }
        catch (TownyException x) {
            throw new TownyException(x.getMessage());
        }
        String rank = split[2];
        if (!TownyPerms.getTownRanks().contains(rank)) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_unknown_rank_available_ranks"), rank, StringMgmt.join(TownyPerms.getTownRanks(), ",")));
        }
        if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(rank.toLowerCase()))) {
            throw new TownyException(TownySettings.getLangString("msg_no_permission_to_give_rank"));
        }
        if (split[0].equalsIgnoreCase("add")) {
            try {
                if (!target.addTownRank(split[2])) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_resident_not_your_town"));
                    return;
                }
                if (BukkitTools.isOnline(target.getName())) {
                    TownyMessaging.sendMsg(target, String.format(TownySettings.getLangString("msg_you_have_been_given_rank"), "Town", rank));
                    plugin.deleteCache(TownyUniverse.getPlayer(target));
                }
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_have_given_rank"), "Town", rank, target.getName()));
            }
            catch (AlreadyRegisteredException e) {
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_resident_already_has_rank"), target.getName(), "Town"));
                return;
            }
        }
        if (!split[0].equalsIgnoreCase("remove")) {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), split[0]));
            return;
        }
        try {
            if (target.removeTownRank(split[2])) {
                if (BukkitTools.isOnline(target.getName())) {
                    TownyMessaging.sendMsg(target, String.format(TownySettings.getLangString("msg_you_have_had_rank_taken"), "Town", rank));
                    plugin.deleteCache(TownyUniverse.getPlayer(target));
                }
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_have_taken_rank_from"), "Town", rank, target.getName()));
            }
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_resident_doesnt_have_rank"), target.getName(), "Town"));
            return;
        }
        TownyUniverse.getDataSource().saveResident(target);
    }

    public void townSet(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town set"));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "board [message ... ]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "mayor " + TownySettings.getLangString("town_help_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "homeblock", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "spawn/outpost/jail", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "perm ...", "'/town set perm' " + TownySettings.getLangString("res_5")));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "taxes [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "[plottax/shoptax/embassytax] [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "[plotprice/shopprice/embassyprice] [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "spawncost [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "name [name]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "tag [upto 4 letters] or clear", ""));
        } else {
            Resident resident;
            Town town = null;
            Nation nation = null;
            TownyWorld oldWorld = null;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
                if (town.hasNation()) {
                    nation = town.getNation();
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("board")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (split.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set board " + TownySettings.getLangString("town_help_9"));
                    return;
                }
                String line = StringMgmt.join(StringMgmt.remFirstArg(split), " ");
                if (!NameValidation.isValidString(line)) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_invalid_string_board_not_set"));
                    return;
                }
                town.setTownBoard(line);
                TownyMessaging.sendTownBoard(player, town);
            } else {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_SET.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (split[0].equalsIgnoreCase("mayor")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set mayor Dumbo");
                        return;
                    }
                    try {
                        if (!resident.isMayor()) {
                            throw new TownyException(TownySettings.getLangString("msg_not_mayor"));
                        }
                        String oldMayor = town.getMayor().getName();
                        Resident newMayor = TownyUniverse.getDataSource().getResident(split[1]);
                        town.setMayor(newMayor);
                        TownyPerms.assignPermissions(TownyUniverse.getDataSource().getResident(oldMayor), null);
                        plugin.deleteCache(oldMayor);
                        plugin.deleteCache(newMayor.getName());
                        TownyMessaging.sendTownMessage(town, TownySettings.getNewMayorMsg(newMayor.getName()));
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("taxes")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set taxes 7");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        if (town.isTaxPercentage() && amount > 100.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_percentage"));
                            return;
                        }
                        if (TownySettings.getTownDefaultTaxMinimumTax() > amount) {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_tax_minimum_not_met"), TownySettings.getTownDefaultTaxMinimumTax()));
                            return;
                        }
                        town.setTaxes(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_tax"), player.getName(), town.getTaxes()));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("plottax")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set plottax 10");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setPlotTax(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_plottax"), player.getName(), town.getPlotTax()));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("shoptax")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set shoptax 10");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setCommercialPlotTax(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_alttax"), player.getName(), "shop", town.getCommercialPlotTax()));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("embassytax")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set embassytax 10");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setEmbassyPlotTax(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_alttax"), player.getName(), "embassy", town.getEmbassyPlotTax()));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("plotprice")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set plotprice 50");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setPlotPrice(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_plotprice"), player.getName(), town.getPlotPrice()));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("shopprice")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set shopprice 50");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setCommercialPlotPrice(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_altprice"), player.getName(), "shop", town.getCommercialPlotPrice()));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("embassyprice")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set embassyprice 50");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setEmbassyPlotPrice(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_altprice"), player.getName(), "embassy", town.getEmbassyPlotPrice()));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("spawncost")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set spawncost 50");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        if (TownySettings.getSpawnTravelCost() < amount) {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_cannot_set_spawn_cost_more_than"), TownySettings.getSpawnTravelCost()));
                            return;
                        }
                        town.setSpawnCost(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_spawn_cost_set_to"), player.getName(), TownySettings.getLangString("town_sing"), split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("name")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set name BillyBobTown");
                        return;
                    }
                    if (TownySettings.getTownRenameCost() > 0.0) {
                        try {
                            if (TownySettings.isUsingEconomy() && !town.pay(TownySettings.getTownRenameCost(), String.format("Town renamed to: %s", split[1]))) {
                                throw new TownyException(String.format(TownySettings.getLangString("msg_err_no_money"), TownyEconomyHandler.getFormattedBalance(TownySettings.getTownRenameCost())));
                            }
                        }
                        catch (EconomyException e) {
                            throw new TownyException("Economy Error");
                        }
                    }
                    if (!NameValidation.isBlacklistName(split[1])) {
                        this.townRename(player, town, split[1]);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                    }
                } else if (split[0].equalsIgnoreCase("tag")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set tag PLTC");
                    } else if (split[1].equalsIgnoreCase("clear")) {
                        try {
                            town.setTag(" ");
                            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_reset_town_tag"), player.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    } else {
                        try {
                            town.setTag(NameValidation.checkAndFilterName(split[1]));
                            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_set_town_tag"), player.getName(), town.getTag()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                        catch (InvalidNameException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else {
                    if (split[0].equalsIgnoreCase("homeblock")) {
                        Coord coord = Coord.parseCoord((Entity)player);
                        try {
                            if (TownyUniverse.isWarTime()) {
                                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                            }
                            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                            if (world.getMinDistanceFromOtherTowns(coord, resident.getTown()) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                                throw new TownyException(TownySettings.getLangString("msg_too_close"));
                            }
                            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && world.getMinDistanceFromOtherTowns(coord, resident.getTown()) > TownySettings.getMaxDistanceBetweenHomeblocks() && world.hasTowns()) {
                                throw new TownyException(TownySettings.getLangString("msg_too_far"));
                            }
                            TownBlock townBlock = TownyUniverse.getDataSource().getWorld(player.getWorld().getName()).getTownBlock(coord);
                            oldWorld = town.getWorld();
                            town.setHomeBlock(townBlock);
                            town.setSpawn(player.getLocation());
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_town_home"), coord.toString()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                            return;
                        }
                    }
                    if (split[0].equalsIgnoreCase("spawn")) {
                        try {
                            town.setSpawn(player.getLocation());
                            if (town.isCapital()) {
                                nation.recheckTownDistance();
                            }
                            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_town_spawn"));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                            return;
                        }
                    }
                    if (split[0].equalsIgnoreCase("outpost")) {
                        try {
                            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName());
                            if (townyWorld.getTownBlock(Coord.parseCoord(player.getLocation())).getTown().getName().equals(town.getName())) {
                                town.addOutpostSpawn(player.getLocation());
                                TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_outpost_spawn"));
                            }
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_not_own_area"));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                            return;
                        }
                    } else {
                        if (split[0].equalsIgnoreCase("jail")) {
                            try {
                                town.addJailSpawn(player.getLocation());
                                TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_jail_spawn"));
                            }
                            catch (TownyException e) {
                                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                                return;
                            }
                        }
                        if (split[0].equalsIgnoreCase("perm")) {
                            try {
                                this.toggleTest(player, town, StringMgmt.join(split, " "));
                            }
                            catch (Exception e) {
                                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                                return;
                            }
                            String[] newSplit = StringMgmt.remFirstArg(split);
                            TownCommand.setTownBlockOwnerPermissions(player, town, newSplit);
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                            return;
                        }
                    }
                }
            }
            TownyUniverse.getDataSource().saveTown(town);
            TownyUniverse.getDataSource().saveTownList();
            if (nation != null) {
                TownyUniverse.getDataSource().saveNation(nation);
            }
            if (oldWorld != null) {
                TownyUniverse.getDataSource().saveWorld(town.getWorld());
                TownyUniverse.getDataSource().saveWorld(oldWorld);
            }
        }
    }

    public void townBuy(Player player, String[] split) {
        Town town;
        if (!TownySettings.isSellingBonusBlocks()) {
            TownyMessaging.sendErrorMsg((Object)player, "Config.yml max_purchased_blocks: '0' ");
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town buy"));
            String line = "\u00a7e[Purchased Bonus] \u00a72Cost: \u00a7a%s\u00a78 | \u00a72Max: \u00a7a%d";
            player.sendMessage(String.format(line, TownyEconomyHandler.getFormattedBalance(town.getBonusBlockCost()), TownySettings.getMaxPurchedBlocks()));
            player.sendMessage(ChatTools.formatCommand("", "/town buy", "bonus [n]", ""));
        } else {
            try {
                if (split[0].equalsIgnoreCase("bonus")) {
                    if (split.length == 2) {
                        try {
                            TownCommand.townBuyBonusTownBlocks(town, Integer.parseInt(split[1].trim()), player);
                        }
                        catch (NumberFormatException e) {
                            throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    } else {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town buy bonus #"));
                    }
                }
                TownyUniverse.getDataSource().saveTown(town);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    public static int townBuyBonusTownBlocks(Town town, int inputN, Object player) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(TownySettings.getLangString("msg_err_negative"));
        }
        int current = town.getPurchasedBlocks();
        int n = current + inputN > TownySettings.getMaxPurchedBlocks() ? TownySettings.getMaxPurchedBlocks() - current : inputN;
        if (n == 0) {
            return n;
        }
        double cost = town.getBonusBlockCostN(n);
        try {
            boolean pay = town.pay(cost, String.format("Town Buy Bonus (%d)", n));
            if (TownySettings.isUsingEconomy() && !pay) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_to_buy"), n, "bonus town blocks", TownyEconomyHandler.getFormattedBalance(cost)));
            }
            if (TownySettings.isUsingEconomy() && pay) {
                town.addPurchasedBlocks(n);
                TownyMessaging.sendMsg(player, String.format(TownySettings.getLangString("msg_buy"), n, "bonus town blocks", TownyEconomyHandler.getFormattedBalance(cost)));
            }
        }
        catch (EconomyException e1) {
            throw new TownyException("Economy Error");
        }
        return n;
    }

    public static void newTown(Player player, String name, String mayorName, boolean noCharge) {
        try {
            String filteredName;
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            if (TownySettings.hasTownLimit() && TownyUniverse.getDataSource().getTowns().size() >= TownySettings.getTownLimit()) {
                throw new TownyException(TownySettings.getLangString("msg_err_universe_limit"));
            }
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                filteredName = null;
            }
            if (filteredName == null || TownyUniverse.getDataSource().hasTown(filteredName)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(mayorName);
            if (resident.hasTown()) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_already_res"), resident.getName()));
            }
            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            if (!world.isUsingTowny()) {
                throw new TownyException(TownySettings.getLangString("msg_set_use_towny_off"));
            }
            if (!world.isClaimable()) {
                throw new TownyException(TownySettings.getLangString("msg_not_claimable"));
            }
            Coord key = Coord.parseCoord((Entity)player);
            if (world.hasTownBlock(key)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_already_claimed_1"), key));
            }
            if (world.getMinDistanceFromOtherTownsPlots(key) < TownySettings.getMinDistanceFromTownPlotblocks()) {
                throw new TownyException(TownySettings.getLangString("msg_too_close"));
            }
            if (world.getMinDistanceFromOtherTowns(key) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                throw new TownyException(TownySettings.getLangString("msg_too_close"));
            }
            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && world.getMinDistanceFromOtherTowns(key) > TownySettings.getMaxDistanceBetweenHomeblocks() && world.hasTowns()) {
                throw new TownyException(TownySettings.getLangString("msg_too_far"));
            }
            if (!noCharge && TownySettings.isUsingEconomy() && !resident.pay(TownySettings.getNewTownPrice(), "New Town Cost")) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_new_town2"), resident.getName().equals(player.getName()) ? "You" : resident.getName(), TownySettings.getNewTownPrice()));
            }
            TownCommand.newTown(world, name, resident, key, player.getLocation());
            TownyMessaging.sendGlobalMessage(TownySettings.getNewTownMsg(player.getName(), name));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, "No valid economy found, your server admin might need to install Vault.jar or set using_economy: false in the Towny config.yml");
        }
    }

    public static Town newTown(TownyWorld world, String name, Resident resident, Coord key, Location spawn) throws TownyException {
        world.newTownBlock(key);
        TownyUniverse.getDataSource().newTown(name);
        Town town = TownyUniverse.getDataSource().getTown(name);
        town.addResident(resident);
        town.setMayor(resident);
        TownBlock townBlock = world.getTownBlock(key);
        townBlock.setTown(town);
        town.setHomeBlock(townBlock);
        townBlock.setType(townBlock.getType());
        town.setSpawn(spawn);
        town.setUuid(UUID.randomUUID());
        town.setRegistered(System.currentTimeMillis());
        if (world.isUsingPlotManagementRevert()) {
            PlotBlockData plotChunk = TownyRegenAPI.getPlotChunk(townBlock);
            if (plotChunk != null) {
                TownyRegenAPI.deletePlotChunk(plotChunk);
            } else {
                plotChunk = new PlotBlockData(townBlock);
                plotChunk.initialize();
            }
            TownyRegenAPI.addPlotChunkSnapshot(plotChunk);
            plotChunk = null;
        }
        TownyMessaging.sendDebugMsg("Creating new Town account: town-" + name);
        if (TownySettings.isUsingEconomy()) {
            try {
                town.setBalance(0.0, "Deleting Town");
            }
            catch (EconomyException e) {
                e.printStackTrace();
            }
        }
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTownBlock(townBlock);
        TownyUniverse.getDataSource().saveTown(town);
        TownyUniverse.getDataSource().saveWorld(world);
        TownyUniverse.getDataSource().saveTownList();
        TownyUniverse.getDataSource().saveTownBlockList();
        plugin.updateCache(townBlock.getWorldCoord());
        BukkitTools.getPluginManager().callEvent((Event)new NewTownEvent(town));
        return town;
    }

    public void townRename(Player player, Town town, String newName) {
        try {
            TownyUniverse.getDataSource().renameTown(town, newName);
            town = TownyUniverse.getDataSource().getTown(newName);
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_name"), player.getName(), town.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public void townLeave(Player player) {
        Town town;
        Resident resident;
        try {
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            plugin.deleteCache(resident.getName());
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        if (resident.isMayor()) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getMayorAbondonMsg());
            return;
        }
        if (resident.isJailed()) {
            try {
                if (resident.getJailTown() == resident.getTown().getName()) {
                    if (TownySettings.JailDeniesTownLeave()) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_cannot_abandon_town_while_jailed"));
                        return;
                    }
                    resident.setJailed(false);
                    resident.setJailSpawn(0);
                    resident.setJailTown("");
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_player_escaped_jail_by_leaving_town"), resident.getName()));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        try {
            TownCommand.townRemoveResident(town, resident);
        }
        catch (EmptyTownException et) {
            TownyUniverse.getDataSource().removeTown(et.getTown());
        }
        catch (NotRegisteredException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
        plugin.resetCache();
        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_left_town"), resident.getName()));
        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_left_town"), resident.getName()));
        try {
            TownCommand.checkTownResidents(town, resident);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
    }

    public static void townSpawn(Player player, String[] split, Boolean outpost) throws TownyException {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            if (split.length == 0 || split.length > 0 && outpost.booleanValue()) {
                if (!resident.hasTown()) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_town"));
                    return;
                }
                Town town = resident.getTown();
                String notAffordMSG = TownySettings.getLangString("msg_err_cant_afford_tp");
                TownCommand.townSpawn(player, split, town, notAffordMSG, outpost);
            } else {
                Town town = TownyUniverse.getDataSource().getTown(split[0]);
                String notAffordMSG = String.format(TownySettings.getLangString("msg_err_cant_afford_tp_town"), town.getName());
                TownCommand.townSpawn(player, split, town, notAffordMSG, outpost);
            }
        }
        catch (NotRegisteredException e) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
        }
    }

    public static void townSpawn(Player player, String[] split, Town town, String notAffordMSG, Boolean outpost) {
        try {
            List<String> disallowedZones;
            TownSpawnLevel townSpawnPermission;
            Location spawnLoc;
            boolean isTownyAdmin = TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_SPAWN_OTHER.getNode());
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            if (outpost.booleanValue()) {
                if (!town.hasOutpostSpawn()) {
                    throw new TownyException(TownySettings.getLangString("msg_err_outpost_spawn"));
                }
                Integer index = null;
                try {
                    if (!split[split.length - 1].contains("name:")) {
                        index = Integer.parseInt(split[split.length - 1]);
                    } else {
                        split[split.length - 1] = split[split.length - 1].replace("name:", "").replace("_", " ");
                        for (Location loc : town.getAllOutpostSpawns()) {
                            String name;
                            TownBlock tboutpost = TownyUniverse.getTownBlock(loc);
                            if (tboutpost == null || !(name = tboutpost.getName()).startsWith(split[split.length - 1])) continue;
                            index = 1 + town.getAllOutpostSpawns().indexOf(loc);
                        }
                        if (index == null) {
                            index = 1;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    index = 1;
                    split[split.length - 1] = split[split.length - 1].replace("_", " ");
                    for (Location loc : town.getAllOutpostSpawns()) {
                        String name;
                        TownBlock tboutpost = TownyUniverse.getTownBlock(loc);
                        if (tboutpost == null || !(name = tboutpost.getName()).startsWith(split[split.length - 1])) continue;
                        index = 1 + town.getAllOutpostSpawns().indexOf(loc);
                    }
                }
                catch (ArrayIndexOutOfBoundsException i) {
                    index = 1;
                }
                if (TownySettings.isOutpostLimitStoppingTeleports() && TownySettings.isOutpostsLimitedByLevels() && town.isOverOutpostLimit() && Math.max(1, index) > town.getOutpostLimit()) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_over_outposts_limit"), town.getMaxOutpostSpawn(), town.getOutpostLimit()));
                }
                spawnLoc = town.getOutpostSpawn(Math.max(1, index));
            } else {
                spawnLoc = town.getSpawn();
            }
            if (isTownyAdmin) {
                townSpawnPermission = TownSpawnLevel.ADMIN;
            } else if (split.length == 0 && !outpost.booleanValue()) {
                townSpawnPermission = TownSpawnLevel.TOWN_RESIDENT;
            } else if (!resident.hasTown()) {
                townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
            } else if (resident.getTown() == town) {
                townSpawnPermission = outpost != false ? TownSpawnLevel.TOWN_RESIDENT_OUTPOST : TownSpawnLevel.TOWN_RESIDENT;
            } else if (resident.hasNation() && town.hasNation()) {
                Nation targetNation;
                Nation playerNation = resident.getTown().getNation();
                if (playerNation == (targetNation = town.getNation())) {
                    if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus()) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_ally_isnt_public"), town));
                    }
                    townSpawnPermission = TownSpawnLevel.PART_OF_NATION;
                } else {
                    if (targetNation.hasEnemy(playerNation)) {
                        throw new TownyException(TownySettings.getLangString("msg_err_public_spawn_enemy"));
                    }
                    if (targetNation.hasAlly(playerNation)) {
                        if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus()) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_ally_isnt_public"), town));
                        }
                        townSpawnPermission = TownSpawnLevel.NATION_ALLY;
                    } else {
                        townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
                    }
                }
            } else {
                townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
            }
            TownyMessaging.sendDebugMsg(townSpawnPermission.toString() + " " + townSpawnPermission.isAllowed(town));
            townSpawnPermission.checkIfAllowed(plugin, player, town);
            if (!isTownyAdmin && !(townSpawnPermission != TownSpawnLevel.UNAFFILIATED ? townSpawnPermission.hasPermissionNode(plugin, player, town) : town.isPublic())) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_public"));
            }
            if (!isTownyAdmin && !(disallowedZones = TownySettings.getDisallowedTownSpawnZones()).isEmpty()) {
                String inTown = null;
                try {
                    Location loc;
                    loc = plugin.getCache(player).getLastLocation();
                    inTown = TownyUniverse.getTownName(loc);
                }
                catch (NullPointerException e) {
                    inTown = TownyUniverse.getTownName(player.getLocation());
                }
                if (inTown == null && disallowedZones.contains("unclaimed")) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "the Wilderness"));
                }
                if (inTown != null && resident.hasNation() && TownyUniverse.getDataSource().getTown(inTown).hasNation()) {
                    Nation playerNation;
                    Nation inNation = TownyUniverse.getDataSource().getTown(inTown).getNation();
                    if (inNation.hasEnemy(playerNation = resident.getTown().getNation()) && disallowedZones.contains("enemy")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Enemy areas"));
                    }
                    if (!inNation.hasAlly(playerNation) && !inNation.hasEnemy(playerNation) && disallowedZones.contains("neutral")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Neutral towns"));
                    }
                }
            }
            double travelCost = 0.0;
            travelCost = townSpawnPermission == TownSpawnLevel.UNAFFILIATED ? townSpawnPermission.getCost(town) : townSpawnPermission.getCost();
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_SPAWN_FREECHARGE.getNode()) && travelCost > 0.0 && TownySettings.isUsingEconomy() && resident.getHoldingBalance() < travelCost) {
                throw new TownyException(notAffordMSG);
            }
            Chunk chunk = spawnLoc.getChunk();
            if (resident.isJailed()) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_cannot_spawn_while_jailed"));
                return;
            }
            boolean UsingESS = plugin.isEssentials();
            if (UsingESS && !isTownyAdmin) {
                try {
                    User user = plugin.getEssentials().getUser((Object)player);
                    if (!user.isJailed() && !resident.isJailed()) {
                        Teleport teleport = user.getTeleport();
                        if (!chunk.isLoaded()) {
                            chunk.load();
                        }
                        teleport.cooldown(true);
                        teleport.teleport(spawnLoc, null, PlayerTeleportEvent.TeleportCause.COMMAND);
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, "Error: " + e.getMessage());
                    return;
                }
            }
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_SPAWN_FREECHARGE.getNode())) {
                TownyEconomyObject payee = town;
                if (!TownySettings.isTownSpawnPaidToTown()) {
                    payee = TownyEconomyObject.SERVER_ACCOUNT;
                }
                if (travelCost > 0.0 && TownySettings.isUsingEconomy() && resident.payTo(travelCost, payee, String.format("Town Spawn (%s)", new Object[]{townSpawnPermission}))) {
                    TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_cost_spawn"), TownyEconomyHandler.getFormattedBalance(travelCost)));
                }
            }
            if (isTownyAdmin) {
                if (player.getVehicle() != null) {
                    player.getVehicle().eject();
                }
                if (!chunk.isLoaded()) {
                    chunk.load();
                }
                player.teleport(spawnLoc, PlayerTeleportEvent.TeleportCause.COMMAND);
                return;
            }
            if (!UsingESS) {
                if (TownyTimerHandler.isTeleportWarmupRunning()) {
                    player.sendMessage(String.format(TownySettings.getLangString("msg_town_spawn_warmup"), TownySettings.getTeleportWarmupTime()));
                    plugin.getTownyUniverse().requestTeleport(player, spawnLoc, travelCost);
                } else {
                    if (player.getVehicle() != null) {
                        player.getVehicle().eject();
                    }
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    player.teleport(spawnLoc, PlayerTeleportEvent.TeleportCause.COMMAND);
                }
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
        catch (EconomyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public void townDelete(Player player, String[] split) {
        Town town = null;
        if (split.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                ConfirmationHandler.addConfirmation(resident, ConfirmationType.TOWNDELETE, null);
                TownyMessaging.sendConfirmationMessage(player, null, null, null, null);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
        }
        try {
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_DELETE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete_town"));
            }
            town = TownyUniverse.getDataSource().getTown(split[0]);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(town));
        TownyUniverse.getDataSource().removeTown(town);
    }

    public static void townKick(Player player, String[] names) {
        Town town;
        Resident resident;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        TownCommand.townKickResidents(player, resident, town, TownyUniverse.getValidatedResidents(player, names));
        plugin.resetCache();
    }

    public static void townAddResidents(Object sender, Town town, List<Resident> invited) {
        String name = sender instanceof Player ? ((Player)sender).getName() : null;
        for (Resident newMember : new ArrayList<Resident>(invited)) {
            try {
                if (plugin.isPermissions()) {
                    if (BukkitTools.matchPlayer(newMember.getName()).isEmpty()) {
                        TownyMessaging.sendErrorMsg(sender, String.format(TownySettings.getLangString("msg_offline_no_join"), newMember.getName()));
                        invited.remove(newMember);
                    } else if (!TownyUniverse.getPermissionSource().has(BukkitTools.getPlayer(newMember.getName()), PermissionNodes.TOWNY_TOWN_RESIDENT.getNode())) {
                        TownyMessaging.sendErrorMsg(sender, String.format(TownySettings.getLangString("msg_not_allowed_join"), newMember.getName()));
                        invited.remove(newMember);
                    } else if (TownySettings.getMaxResidentsPerTown() > 0 && town.getResidents().size() >= TownySettings.getMaxResidentsPerTown()) {
                        TownyMessaging.sendErrorMsg(sender, String.format(TownySettings.getLangString("msg_err_max_residents_per_town_reached"), TownySettings.getMaxResidentsPerTown()));
                        invited.remove(newMember);
                    } else if (TownySettings.getTownInviteCooldown() > 0L && System.currentTimeMillis() / 1000L - newMember.getRegistered() / 1000L < TownySettings.getTownInviteCooldown()) {
                        TownyMessaging.sendErrorMsg(sender, String.format(TownySettings.getLangString("msg_err_resident_doesnt_meet_invite_cooldown"), newMember));
                        invited.remove(newMember);
                    } else {
                        town.addResidentCheck(newMember);
                        TownCommand.townInviteResident(name, town, newMember);
                    }
                } else {
                    town.addResidentCheck(newMember);
                    TownCommand.townInviteResident(name, town, newMember);
                }
            }
            catch (TownyException e) {
                invited.remove(newMember);
                TownyMessaging.sendErrorMsg(sender, e.getMessage());
            }
            if (!town.hasOutlaw(newMember)) continue;
            try {
                town.removeOutlaw(newMember);
            }
            catch (NotRegisteredException e) {}
        }
        if (invited.size() > 0) {
            String msg = "";
            if (name == null) {
                name = "Console";
            }
            for (Resident newMember : invited) {
                msg = msg + newMember.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_invited_join_town"), name, msg);
            TownyMessaging.sendTownMessage(town, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg(sender, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public static void townAddResident(Town town, Resident resident) throws AlreadyRegisteredException {
        town.addResident(resident);
        plugin.deleteCache(resident.getName());
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
        plugin.getTownyUniverse().setChangedNotify(TownyObservableType.TOWN_ADD_RESIDENT);
    }

    private static void townInviteResident(String sender, Town town, Resident newMember) throws TownyException {
        PlayerJoinTownInvite invite = new PlayerJoinTownInvite(sender, town, newMember);
        try {
            if (InviteHandler.getTowntoresidentinvites().containsEntry((Object)town, (Object)newMember)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_player_already_invited"), newMember.getName()));
            }
            newMember.newReceivedInvite(invite);
            town.newSentInvite(invite);
            InviteHandler.addInviteToList(invite);
            TownyMessaging.sendRequestMessage(newMember, invite);
            Bukkit.getPluginManager().callEvent((Event)new TownInvitePlayerEvent(invite));
        }
        catch (TooManyInvitesException e) {
            newMember.deleteReceivedInvite(invite);
            town.deleteSentInvite(invite);
            throw new TownyException(TownySettings.getLangString(e.getMessage()));
        }
    }

    private static void townRevokeInviteResident(Object sender, Town town, List<Resident> residents) {
        block2: for (Resident invited : residents) {
            if (!InviteHandler.getTowntoresidentinvites().containsEntry((Object)town, (Object)invited)) continue;
            InviteHandler.getTowntoresidentinvites().remove((Object)town, (Object)invited);
            for (Invite invite : invited.getReceivedInvites()) {
                if (!invite.getSender().equals(town)) continue;
                try {
                    InviteHandler.declineInvite(invite, true);
                    TownyMessaging.sendMessage(sender, TownySettings.getLangString("town_revoke_invite_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void townRemoveResident(Town town, Resident resident) throws EmptyTownException, NotRegisteredException {
        town.removeResident(resident);
        plugin.deleteCache(resident.getName());
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
        plugin.getTownyUniverse().setChangedNotify(TownyObservableType.TOWN_REMOVE_RESIDENT);
    }

    public static void townKickResidents(Object sender, Resident resident, Town town, List<Resident> kicking) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        for (Resident member : new ArrayList<Resident>(kicking)) {
            if (resident == member || member.isMayor() || town.hasAssistant(member)) {
                TownyMessaging.sendMessage(sender, "You cannot kick yourself, the mayor, or an assistant.");
                kicking.remove(member);
                continue;
            }
            try {
                TownCommand.townRemoveResident(town, member);
            }
            catch (NotRegisteredException e) {
                kicking.remove(member);
            }
            catch (EmptyTownException e) {}
        }
        if (kicking.size() > 0) {
            String msg = "";
            for (Resident member : kicking) {
                msg = msg + member.getName() + ", ";
                Player p = BukkitTools.getPlayer(member.getName());
                if (p == null) continue;
                p.sendMessage(String.format(TownySettings.getLangString("msg_kicked_by"), player != null ? player.getName() : "CONSOLE"));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_kicked"), player != null ? player.getName() : "CONSOLE", msg);
            TownyMessaging.sendTownMessage(town, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg(sender, TownySettings.getLangString("msg_invalid_name"));
        }
        try {
            TownCommand.checkTownResidents(town, resident);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
    }

    public static void checkTownResidents(Town town, Resident removedResident) throws NotRegisteredException {
        if (!town.hasNation()) {
            return;
        }
        if (town.isCapital() && TownySettings.getNumResidentsCreateNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
            for (Town newCapital : town.getNation().getTowns()) {
                if (newCapital.getNumResidents() < TownySettings.getNumResidentsCreateNation()) continue;
                town.getNation().setCapital(newCapital);
                if (TownySettings.getNumResidentsJoinNation() > 0 && removedResident.getTown().getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                    try {
                        town.getNation().removeTown(town);
                        TownyMessaging.sendNationMessage(town.getNation(), String.format(TownySettings.getLangString("msg_capital_not_enough_residents_left_nation"), town.getName()));
                    }
                    catch (EmptyNationException e) {
                        e.printStackTrace();
                    }
                }
                TownyMessaging.sendNationMessage(newCapital.getNation(), String.format(TownySettings.getLangString("msg_not_enough_residents_no_longer_capital"), newCapital.getName()));
                return;
            }
            TownyMessaging.sendNationMessage(town.getNation(), String.format(TownySettings.getLangString("msg_nation_disbanded_town_not_enough_residents"), town.getName()));
            TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(town.getNation()));
            TownyUniverse.getDataSource().removeNation(town.getNation());
            if (TownySettings.isRefundNationDisbandLowResidents()) {
                try {
                    town.pay(TownySettings.getNewNationPrice(), "nation refund");
                }
                catch (EconomyException e) {
                    e.printStackTrace();
                }
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_not_enough_residents_refunded"), TownySettings.getNewNationPrice()));
            }
        } else if (!town.isCapital() && TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
            try {
                TownyMessaging.sendNationMessage(town.getNation(), String.format(TownySettings.getLangString("msg_town_not_enough_residents_left_nation"), town.getName()));
                town.getNation().removeTown(town);
            }
            catch (EmptyNationException e) {
                e.printStackTrace();
            }
        }
    }

    public static void parseTownJoin(CommandSender sender, String[] args) {
        try {
            String contextualResidentName;
            String townName;
            String residentName;
            boolean console = false;
            if (sender instanceof Player) {
                if (args.length < 1) {
                    throw new Exception(String.format("Usage: /town join [town]", new Object[0]));
                }
                Player player = (Player)sender;
                residentName = player.getName();
                townName = args[0];
                contextualResidentName = "You";
            } else {
                if (args.length < 2) {
                    throw new Exception(String.format("Usage: town join [resident] [town]", new Object[0]));
                }
                residentName = args[0];
                townName = args[1];
                contextualResidentName = residentName;
            }
            Resident resident = TownyUniverse.getDataSource().getResident(residentName);
            Town town = TownyUniverse.getDataSource().getTown(townName);
            if (resident.hasTown()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_already_res"), contextualResidentName));
            }
            if (!console) {
                if (!town.isOpen()) {
                    throw new Exception(String.format(TownySettings.getLangString("msg_err_not_open"), town.getFormattedName()));
                }
                if (TownySettings.getMaxResidentsPerTown() > 0 && town.getResidents().size() >= TownySettings.getMaxResidentsPerTown()) {
                    throw new Exception(String.format(TownySettings.getLangString("msg_err_max_residents_per_town_reached"), TownySettings.getMaxResidentsPerTown()));
                }
                if (town.hasOutlaw(resident)) {
                    throw new Exception(TownySettings.getLangString("msg_err_outlaw_in_open_town"));
                }
            }
            TownCommand.townAddResident(town, resident);
            TownyMessaging.sendTownMessage(town, ChatTools.color(String.format(TownySettings.getLangString("msg_join_town"), resident.getName())));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
        }
    }

    public static void townAdd(Object sender, Town specifiedTown, String[] names) {
        Town town;
        String name = sender instanceof Player ? ((Player)sender).getName() : "Console";
        try {
            if (name.equalsIgnoreCase("Console")) {
                town = specifiedTown;
            } else {
                Resident resident = TownyUniverse.getDataSource().getResident(name);
                town = specifiedTown == null ? resident.getTown() : specifiedTown;
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg(sender, x.getMessage());
            return;
        }
        ArrayList<String> reslist = new ArrayList<String>(Arrays.asList(names));
        ArrayList<String> newreslist = new ArrayList<String>();
        ArrayList<String> removeinvites = new ArrayList<String>();
        for (String townname : reslist) {
            if (townname.startsWith("-")) {
                removeinvites.add(townname.substring(1));
                continue;
            }
            newreslist.add(townname);
        }
        names = newreslist.toArray(new String[0]);
        String[] namestoremove = removeinvites.toArray(new String[0]);
        if (namestoremove.length != 0) {
            TownCommand.townRevokeInviteResident(sender, town, TownyUniverse.getValidatedResidents(sender, namestoremove));
        }
        if (names.length != 0) {
            TownCommand.townAddResidents(sender, town, TownyUniverse.getValidatedResidents(sender, names));
        }
        if (!name.equalsIgnoreCase("Console")) {
            plugin.resetCache(BukkitTools.getPlayerExact(name));
        }
    }

    public static void setTownBlockOwnerPermissions(Player player, TownBlockOwner townBlockOwner, String[] split) {
        TownCommand.setTownBlockPermissions(player, townBlockOwner, townBlockOwner.getPermissions(), split, false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void setTownBlockPermissions(Player player, TownBlockOwner townBlockOwner, TownyPermission perm, String[] split, boolean friend) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/... set perm"));
            player.sendMessage(ChatTools.formatCommand("Level", "[resident/ally/outsider]", "", ""));
            player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "reset", ""));
            if (townBlockOwner instanceof Town) {
                player.sendMessage(ChatTools.formatCommand("Eg", "/town set perm", "ally off", ""));
            }
            if (townBlockOwner instanceof Resident) {
                player.sendMessage(ChatTools.formatCommand("Eg", "/resident set perm", "friend build on", ""));
            }
            player.sendMessage(String.format(TownySettings.getLangString("plot_perms"), new Object[]{"'friend'", "'resident'"}));
            player.sendMessage(TownySettings.getLangString("plot_perms_1"));
        } else {
            if (friend && split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            }
            if (split.length == 1) {
                if (split[0].equalsIgnoreCase("reset")) {
                    for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
                        if ((!(townBlockOwner instanceof Town) || townBlock.hasResident()) && (!(townBlockOwner instanceof Resident) || !townBlock.hasResident())) continue;
                        townBlock.setType(townBlock.getType());
                        TownyUniverse.getDataSource().saveTownBlock(townBlock);
                    }
                    if (townBlockOwner instanceof Town) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), new Object[]{"Town owned"}));
                    } else {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), new Object[]{"your"}));
                    }
                    TownCommand.plugin.resetCache();
                    return;
                }
                try {
                    b = TownCommand.plugin.parseOnOff(split[0]);
                    for (String element : new String[]{"residentBuild", "residentDestroy", "residentSwitch", "residentItemUse", "outsiderBuild", "outsiderDestroy", "outsiderSwitch", "outsiderItemUse", "allyBuild", "allyDestroy", "allySwitch", "allyItemUse"}) {
                        perm.set(element, b);
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_town_set_perm_syntax_error"));
                    return;
                }
            }
            if (split.length == 2) {
                if (!(split[0].equalsIgnoreCase("resident") || split[0].equalsIgnoreCase("friend") || split[0].equalsIgnoreCase("ally") || split[0].equalsIgnoreCase("outsider") || split[0].equalsIgnoreCase("build") || split[0].equalsIgnoreCase("destroy") || split[0].equalsIgnoreCase("switch") || split[0].equalsIgnoreCase("itemuse"))) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_town_set_perm_syntax_error"));
                    return;
                }
                try {
                    b = TownCommand.plugin.parseOnOff(split[1]);
                    if (split[0].equalsIgnoreCase("resident") || split[0].equalsIgnoreCase("friend")) {
                        perm.residentBuild = b;
                        perm.residentDestroy = b;
                        perm.residentSwitch = b;
                        perm.residentItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("outsider")) {
                        perm.outsiderBuild = b;
                        perm.outsiderDestroy = b;
                        perm.outsiderSwitch = b;
                        perm.outsiderItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("ally")) {
                        perm.allyBuild = b;
                        perm.allyDestroy = b;
                        perm.allySwitch = b;
                        perm.allyItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("build")) {
                        perm.residentBuild = b;
                        perm.outsiderBuild = b;
                        perm.allyBuild = b;
                    }
                    if (split[0].equalsIgnoreCase("destroy")) {
                        perm.residentDestroy = b;
                        perm.outsiderDestroy = b;
                        perm.allyDestroy = b;
                    }
                    if (split[0].equalsIgnoreCase("switch")) {
                        perm.residentSwitch = b;
                        perm.outsiderSwitch = b;
                        perm.allySwitch = b;
                    }
                    if (!split[0].equalsIgnoreCase("itemuse")) ** GOTO lbl101
                    perm.residentItemUse = b;
                    perm.outsiderItemUse = b;
                    perm.allyItemUse = b;
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_town_set_perm_syntax_error"));
                    return;
                }
            } else if (split.length == 3) {
                if (!((split[0].equalsIgnoreCase("resident") || split[0].equalsIgnoreCase("friend") || split[0].equalsIgnoreCase("ally") || split[0].equalsIgnoreCase("outsider")) && (split[1].equalsIgnoreCase("build") || split[1].equalsIgnoreCase("destroy") || split[1].equalsIgnoreCase("switch") || split[1].equalsIgnoreCase("itemuse")))) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_town_set_perm_syntax_error"));
                    return;
                }
                try {
                    b = TownCommand.plugin.parseOnOff(split[2]);
                    s = "";
                    s = split[0] + split[1];
                    perm.set(s, b);
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_town_set_perm_syntax_error"));
                    return;
                }
            }
lbl101:
            // 14 sources

            for (String[] townBlock : townBlockOwner.getTownBlocks()) {
                if (!(townBlockOwner instanceof Town) || townBlock.hasResident() || townBlock.isChanged()) continue;
                townBlock.setType(townBlock.getType());
                TownyUniverse.getDataSource().saveTownBlock((TownBlock)townBlock);
            }
            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_perms"));
            TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident != false ? perm.getColourString().replace("f", "r") : perm.getColourString()));
            TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp != false ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion != false ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire != false ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs != false ? "\u00a74ON" : "\u00a7aOFF"));
            TownCommand.plugin.resetCache();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseTownClaimCommand(Player player, String[] split) {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/town claim"));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "", TownySettings.getLangString("msg_block_claim")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "outpost", TownySettings.getLangString("mayor_help_3")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "[circle/rect] [radius]", TownySettings.getLangString("mayor_help_4")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "[circle/rect] auto", TownySettings.getLangString("mayor_help_5")));
            return;
        }
        try {
            List<WorldCoord> selection;
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            if (!world.isUsingTowny()) {
                throw new TownyException(TownySettings.getLangString("msg_set_use_towny_off"));
            }
            double blockCost = 0.0;
            boolean attachedToEdge = true;
            boolean outpost = false;
            Coord key = Coord.parseCoord(plugin.getCache(player).getLastLocation());
            if (split.length == 1 && split[0].equalsIgnoreCase("outpost")) {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_OUPTPOST.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (TownySettings.isOutpostsLimitedByLevels() && town.getMaxOutpostSpawn() >= town.getOutpostLimit()) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_enough_outposts_free_to_claim"), town.getMaxOutpostSpawn(), town.getOutpostLimit()));
                }
                if (TownySettings.getAmountOfResidentsForTown() != 0 && town.getResidents().size() < TownySettings.getAmountOfResidentsForTown()) {
                    throw new TownyException(TownySettings.getLangString("msg_err_not_enough_residents"));
                }
                int maxOutposts = TownySettings.getMaxResidentOutposts(resident);
                if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && maxOutposts != -1 && maxOutposts <= resident.getTown().getAllOutpostSpawns().size()) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_max_outposts_own"), maxOutposts));
                }
                if (!TownySettings.isAllowingOutposts()) throw new TownyException(TownySettings.getLangString("msg_outpost_disable"));
                if (world.hasTownBlock(key)) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_already_claimed_1"), key));
                }
                if (world.getMinDistanceFromOtherTowns(key) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                    throw new TownyException(TownySettings.getLangString("msg_too_close"));
                }
                if (world.getMinDistanceFromOtherTownsPlots(key) < TownySettings.getMinDistanceFromTownPlotblocks()) {
                    throw new TownyException(TownySettings.getLangString("msg_too_close"));
                }
                if (world.getMinDistanceFromOtherTownsPlots(key) < TownySettings.getMinDistanceForOutpostsFromPlot()) {
                    throw new TownyException(TownySettings.getLangString("msg_too_close"));
                }
                selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), new String[0]);
                blockCost = TownySettings.getOutpostCost();
                attachedToEdge = false;
                outpost = true;
            } else {
                if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_TOWN.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), split);
                if (selection.size() > 1 && !TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_TOWN_MULTIPLE.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (TownySettings.isUsingEconomy()) {
                    blockCost = TownySettings.getClaimPrice();
                }
            }
            if (world.getMinDistanceFromOtherTownsPlots(key, town) < TownySettings.getMinDistanceFromTownPlotblocks()) {
                throw new TownyException(TownySettings.getLangString("msg_too_close"));
            }
            if (!town.hasHomeBlock() && world.getMinDistanceFromOtherTowns(key) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                throw new TownyException(TownySettings.getLangString("msg_too_close"));
            }
            TownyMessaging.sendDebugMsg("townClaim: Pre-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
            selection = AreaSelectionUtil.filterTownOwnedBlocks(selection);
            selection = AreaSelectionUtil.filterInvalidProximityTownBlocks(selection, town);
            TownyMessaging.sendDebugMsg("townClaim: Post-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
            TownCommand.checkIfSelectionIsValid(town, selection, attachedToEdge, blockCost, false);
            int blockedClaims = 0;
            for (WorldCoord coord : selection) {
                TownPreClaimEvent preClaimEvent = new TownPreClaimEvent(town, new TownBlock(coord.getX(), coord.getZ(), world));
                BukkitTools.getPluginManager().callEvent((Event)preClaimEvent);
                if (!preClaimEvent.isCancelled()) continue;
                ++blockedClaims;
            }
            if (blockedClaims > 0) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_claim_error"), blockedClaims, selection.size()));
            }
            try {
                double cost = blockCost * (double)selection.size();
                double missingAmount = cost - town.getHoldingBalance();
                if (TownySettings.isUsingEconomy() && !town.pay(cost, String.format("Town Claim (%d)", selection.size()))) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_claim2"), selection.size(), TownyEconomyHandler.getFormattedBalance(cost), TownyEconomyHandler.getFormattedBalance(missingAmount), new DecimalFormat("#").format(missingAmount)));
                }
            }
            catch (EconomyException e1) {
                throw new TownyException("Economy Error");
            }
            new TownClaim(plugin, player, town, selection, outpost, true, false).start();
            return;
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
    }

    public static void parseTownUnclaimCommand(Player player, String[] split) {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/town unclaim"));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "", TownySettings.getLangString("mayor_help_6")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "[circle/rect] [radius]", TownySettings.getLangString("mayor_help_7")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "all", TownySettings.getLangString("mayor_help_8")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "outpost", TownySettings.getLangString("mayor_help_9")));
        } else {
            try {
                if (TownyUniverse.isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                if (split.length == 1 && split[0].equalsIgnoreCase("all")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM_ALL.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    new TownClaim(plugin, player, town, null, false, false, false).start();
                } else {
                    List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), Coord.parseCoord(plugin.getCache(player).getLastLocation())), split);
                    selection = AreaSelectionUtil.filterOwnedBlocks(town, selection);
                    new TownClaim(plugin, player, town, selection, false, false, false).start();
                    TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_abandoned_area"), Arrays.toString(selection.toArray(new WorldCoord[0]))));
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
        }
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, List<WorldCoord> worldCoords) {
        for (WorldCoord worldCoord : worldCoords) {
            if (!TownCommand.isEdgeBlock(owner, worldCoord)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, WorldCoord worldCoord) {
        int[][] offset = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        for (int i = 0; i < 4; ++i) {
            try {
                TownBlock edgeTownBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + offset[i][0], worldCoord.getZ() + offset[i][1]));
                if (!edgeTownBlock.isOwner(owner)) continue;
                return true;
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void checkIfSelectionIsValid(TownBlockOwner owner, List<WorldCoord> selection, boolean attachedToEdge, double blockCost, boolean force) throws TownyException {
        if (force) {
            return;
        }
        Town town = (Town)owner;
        if (attachedToEdge && !TownCommand.isEdgeBlock(owner, selection) && !town.getTownBlocks().isEmpty()) {
            if (selection.size() == 0) {
                throw new TownyException(TownySettings.getLangString("msg_already_claimed_2"));
            }
            throw new TownyException(TownySettings.getLangString("msg_err_not_attached_edge"));
        }
        if (owner instanceof Town) {
            int available = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
            TownyMessaging.sendDebugMsg("Claim Check Available: " + available);
            TownyMessaging.sendDebugMsg("Claim Selection Size: " + selection.size());
            if (available - selection.size() < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_enough_blocks"));
            }
        }
        try {
            double cost = blockCost * (double)selection.size();
            double missingAmount = cost - town.getHoldingBalance();
            if (TownySettings.isUsingEconomy() && !owner.canPayFromHoldings(cost)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_cant_afford_blocks2"), selection.size(), TownyEconomyHandler.getFormattedBalance(cost), TownyEconomyHandler.getFormattedBalance(missingAmount), new DecimalFormat("#").format(missingAmount)));
            }
        }
        catch (EconomyException e1) {
            throw new TownyException("Economy Error");
        }
    }

    private void townWithdraw(Player player, int amount) {
        try {
            if (!TownySettings.getTownBankAllowWithdrawls()) {
                throw new TownyException(TownySettings.getLangString("msg_err_withdraw_disabled"));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            town.withdrawFromBank(resident, amount);
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_xx_withdrew_xx"), resident.getName(), amount, "town"));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    private void townDeposit(Player player, int amount) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            double bankcap = TownySettings.getTownBankCap();
            if (bankcap > 0.0 && (double)amount + town.getHoldingBalance() > bankcap) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_deposit_capped"), bankcap));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            if (!resident.payTo(amount, town, "Town Deposit")) {
                throw new TownyException(TownySettings.getLangString("msg_insuf_funds"));
            }
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_xx_deposited_xx"), resident.getName(), amount, "town"));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/town"));
        output.add(ChatTools.formatCommand("", "/town", "", TownySettings.getLangString("town_help_1")));
        output.add(ChatTools.formatCommand("", "/town", "[town]", TownySettings.getLangString("town_help_3")));
        output.add(ChatTools.formatCommand("", "/town", "new [name]", TownySettings.getLangString("town_help_11")));
        output.add(ChatTools.formatCommand("", "/town", "here", TownySettings.getLangString("town_help_4")));
        output.add(ChatTools.formatCommand("", "/town", "list", ""));
        output.add(ChatTools.formatCommand("", "/town", "online", TownySettings.getLangString("town_help_10")));
        output.add(ChatTools.formatCommand("", "/town", "leave", ""));
        output.add(ChatTools.formatCommand("", "/town", "reslist", ""));
        output.add(ChatTools.formatCommand("", "/town", "ranklist", ""));
        output.add(ChatTools.formatCommand("", "/town", "outlawlist", ""));
        output.add(ChatTools.formatCommand("", "/town", "plots", ""));
        output.add(ChatTools.formatCommand("", "/town", "outlaw add/remove [name]", ""));
        output.add(ChatTools.formatCommand("", "/town", "say", "[message]"));
        output.add(ChatTools.formatCommand("", "/town", "spawn", TownySettings.getLangString("town_help_5")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/town", "deposit [$]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/town", "rank add/remove [resident] [rank]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "mayor ?", TownySettings.getLangString("town_help_8")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/town", "new [town] " + TownySettings.getLangString("town_help_2"), TownySettings.getLangString("town_help_7")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/town", "delete [town]", ""));
        invite = new ArrayList<String>();
        invite.add(ChatTools.formatTitle("/town invite"));
        invite.add(ChatTools.formatCommand("", "/town", "invite [player]", TownySettings.getLangString("town_invite_help_1")));
        invite.add(ChatTools.formatCommand("", "/town", "invite -[player]", TownySettings.getLangString("town_invite_help_2")));
        invite.add(ChatTools.formatCommand("", "/town", "invite sent", TownySettings.getLangString("town_invite_help_3")));
        invite.add(ChatTools.formatCommand("", "/town", "invite received", TownySettings.getLangString("town_invite_help_4")));
        invite.add(ChatTools.formatCommand("", "/town", "invite accept [nation]", TownySettings.getLangString("town_invite_help_5")));
        invite.add(ChatTools.formatCommand("", "/town", "invite deny [nation]", TownySettings.getLangString("town_invite_help_6")));
    }
}

