/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.User;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownSpawnLevel;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ResidentCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> output;

    public ResidentCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args == null) {
                for (String line : output) {
                    player.sendMessage(line);
                }
                this.parseResidentCommand(player, args);
            } else {
                this.parseResidentCommand(player, args);
            }
        } else {
            try {
                this.parseResidentCommandForConsole(sender, args);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        return true;
    }

    private void parseResidentCommandForConsole(final CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : output) {
                sender.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listResidents(sender);
        } else {
            try {
                final Resident resident = TownyUniverse.getDataSource().getResident(split[0]);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        Player player = null;
                        TownyMessaging.sendMessage((Object)sender, TownyFormatter.getStatus(resident, player));
                    }
                });
            }
            catch (NotRegisteredException x) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
            }
        }
    }

    public void parseResidentCommand(final Player player, String[] split) {
        block31: {
            try {
                if (split.length == 0) {
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident, player));
                        break block31;
                    }
                    catch (NotRegisteredException x) {
                        throw new TownyException(TownySettings.getLangString("msg_err_not_registered"));
                    }
                }
                if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
                    for (String line : output) {
                        player.sendMessage(line);
                    }
                    break block31;
                }
                if (split[0].equalsIgnoreCase("list")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_LIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.listResidents(player);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("tax")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TAX.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getTaxStatus(resident));
                        break block31;
                    }
                    catch (NotRegisteredException x) {
                        throw new TownyException(TownySettings.getLangString("msg_err_not_registered"));
                    }
                }
                if (split[0].equalsIgnoreCase("jail")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_JAIL.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (!TownySettings.isAllowingBail()) {
                        TownyMessaging.sendErrorMsg((Object)player, "\u00a74Bail is not enabled");
                        return;
                    }
                    if (split.length == 1) {
                        player.sendMessage(ChatTools.formatTitle("/resident jail"));
                        player.sendMessage(ChatTools.formatCommand("", "/resident", "jail paybail", ""));
                        player.sendMessage("\u00a7bBail costs: \u00a72" + TownySettings.getBailAmount());
                        return;
                    }
                    if (!TownyUniverse.getDataSource().getResident(player.getName()).isJailed()) {
                        return;
                    }
                    if (split[1].equalsIgnoreCase("paybail")) {
                        Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                        if (resident.canPayFromHoldings(TownySettings.getBailAmount())) {
                            Town JailTown = TownyUniverse.getDataSource().getTown(resident.getJailTown());
                            resident.payTo(TownySettings.getBailAmount(), JailTown, "Bail");
                            resident.setJailed(false);
                            resident.setJailSpawn(0);
                            resident.setJailTown("");
                            TownyMessaging.sendGlobalMessage("\u00a74" + player.getName() + "has paid bail and is free.");
                            player.teleport(resident.getTown().getSpawn());
                            TownyUniverse.getDataSource().saveResident(resident);
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, "\u00a74Unable to afford bail.");
                        }
                    } else {
                        player.sendMessage(ChatTools.formatTitle("/resident jail"));
                        player.sendMessage(ChatTools.formatCommand("", "/resident", "jail paybail", ""));
                        player.sendMessage("\u00a7bBail costs: \u00a72" + TownySettings.getBailAmount());
                    }
                    break block31;
                }
                if (split[0].equalsIgnoreCase("set")) {
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    this.residentSet(player, newSplit);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("toggle")) {
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    this.residentToggle(player, newSplit);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("friend")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    this.residentFriend(player, newSplit);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("spawn")) {
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SPAWN.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.residentSpawn(player);
                    break block31;
                }
                try {
                    final Resident resident = TownyUniverse.getDataSource().getResident(split[0]);
                    if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_OTHERRESIDENT.getNode()) && !resident.getName().equals(player.getName())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

                        @Override
                        public void run() {
                            TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident, player));
                        }
                    });
                }
                catch (NotRegisteredException x) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
                }
            }
            catch (Exception x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    public void residentSpawn(Player player) {
        boolean isTownyAdmin = TownyUniverse.getPermissionSource().isTownyAdmin(player);
        try {
            double travelCost;
            List<String> disallowedZones;
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            String notAffordMSG = TownySettings.getLangString("msg_err_cant_afford_tp");
            if (resident.isJailed()) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_cannot_spawn_while_jailed"));
                return;
            }
            Location spawnLoc = TownySettings.getBedUse() && player.getBedSpawnLocation() != null ? player.getBedSpawnLocation() : town.getSpawn();
            TownSpawnLevel townSpawnPermission = isTownyAdmin ? TownSpawnLevel.ADMIN : TownSpawnLevel.TOWN_RESIDENT;
            if (!isTownyAdmin && !(disallowedZones = TownySettings.getDisallowedTownSpawnZones()).isEmpty()) {
                String inTown = null;
                try {
                    Location loc = plugin.getCache(player).getLastLocation();
                    inTown = TownyUniverse.getTownName(loc);
                }
                catch (NullPointerException e) {
                    inTown = TownyUniverse.getTownName(player.getLocation());
                }
                if (inTown == null && disallowedZones.contains("unclaimed")) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "the Wilderness"));
                }
                if (inTown != null && resident.hasNation() && TownyUniverse.getDataSource().getTown(inTown).hasNation()) {
                    Nation playerNation;
                    Nation inNation = TownyUniverse.getDataSource().getTown(inTown).getNation();
                    if (inNation.hasEnemy(playerNation = resident.getTown().getNation()) && disallowedZones.contains("enemy")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Enemy areas"));
                    }
                    if (!inNation.hasAlly(playerNation) && !inNation.hasEnemy(playerNation) && disallowedZones.contains("neutral")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Neutral towns"));
                    }
                }
            }
            if ((travelCost = townSpawnPermission.getCost()) > 0.0 && TownySettings.isUsingEconomy() && resident.getHoldingBalance() < travelCost) {
                throw new TownyException(notAffordMSG);
            }
            Chunk chunk = spawnLoc.getChunk();
            boolean UsingESS = plugin.isEssentials();
            if (UsingESS && !isTownyAdmin) {
                try {
                    User essentialsUser = plugin.getEssentials().getUser((Object)player);
                    if (!essentialsUser.isJailed()) {
                        Teleport teleport = essentialsUser.getTeleport();
                        if (!chunk.isLoaded()) {
                            chunk.load();
                        }
                        teleport.cooldown(true);
                        teleport.teleport(spawnLoc, null);
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, "Error: " + e.getMessage());
                    return;
                }
            }
            if (travelCost > 0.0 && TownySettings.isUsingEconomy() && resident.payTo(travelCost, town, String.format("Resident Spawn (%s)", new Object[]{townSpawnPermission}))) {
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_cost_spawn"), TownyEconomyHandler.getFormattedBalance(travelCost)));
            }
            if (isTownyAdmin) {
                if (player.getVehicle() != null) {
                    player.getVehicle().eject();
                }
                if (!chunk.isLoaded()) {
                    chunk.load();
                }
                player.teleport(spawnLoc, PlayerTeleportEvent.TeleportCause.COMMAND);
                return;
            }
            if (!UsingESS) {
                if (TownyTimerHandler.isTeleportWarmupRunning()) {
                    player.sendMessage(String.format(TownySettings.getLangString("msg_town_spawn_warmup"), TownySettings.getTeleportWarmupTime()));
                    plugin.getTownyUniverse().requestTeleport(player, spawnLoc, travelCost);
                } else {
                    if (player.getVehicle() != null) {
                        player.getVehicle().eject();
                    }
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    player.teleport(spawnLoc, PlayerTeleportEvent.TeleportCause.COMMAND);
                }
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
        catch (EconomyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    private void residentToggle(Player player, String[] newSplit) throws TownyException {
        Resident resident;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (NotRegisteredException e) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered"), player.getName()));
        }
        if (newSplit.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/res toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "mobs", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "plotborder", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "spy", ""));
            TownyMessaging.sendMsg(resident, "Modes set: " + StringMgmt.join(resident.getModes(), ","));
            return;
        }
        if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE.getNode(newSplit[0].toLowerCase()))) {
            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
        }
        TownyPermission perm = resident.getPermissions();
        if (newSplit[0].equalsIgnoreCase("spy")) {
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_CHAT_SPY.getNode(newSplit[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            resident.toggleMode(newSplit, true);
            return;
        }
        if (newSplit[0].equalsIgnoreCase("pvp")) {
            perm.pvp = !perm.pvp;
        } else if (newSplit[0].equalsIgnoreCase("fire")) {
            perm.fire = !perm.fire;
        } else if (newSplit[0].equalsIgnoreCase("explosion")) {
            perm.explosion = !perm.explosion;
        } else if (newSplit[0].equalsIgnoreCase("mobs")) {
            perm.mobs = !perm.mobs;
        } else {
            resident.toggleMode(newSplit, true);
            return;
        }
        this.notifyPerms(player, perm);
        TownyUniverse.getDataSource().saveResident(resident);
    }

    private void notifyPerms(Player player, TownyPermission perm) {
        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_perms"));
        TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
    }

    public void listResidents(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("res_list")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Resident resident : plugin.getTownyUniverse().getActiveResidents()) {
            if (!player.canSee(BukkitTools.getPlayerExact(resident.getName()))) continue;
            String colour = resident.isKing() ? "\u00a76" : (resident.isMayor() ? "\u00a7b" : "\u00a7f");
            formatedList.add(colour + resident.getName() + "\u00a7f");
        }
        for (String line : ChatTools.list(formatedList)) {
            player.sendMessage(line);
        }
    }

    public void listResidents(CommandSender sender) {
        sender.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("res_list")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Resident resident : plugin.getTownyUniverse().getActiveResidents()) {
            String colour = resident.isKing() ? "\u00a76" : (resident.isMayor() ? "\u00a7b" : "\u00a7f");
            formatedList.add(colour + resident.getName() + "\u00a7f");
        }
        for (String line : ChatTools.list(formatedList)) {
            sender.sendMessage(line);
        }
    }

    public void residentSet(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "perm ...", "'/resident set perm' " + TownySettings.getLangString("res_5")));
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "mode ...", "'/resident set mode' " + TownySettings.getLangString("res_5")));
        } else {
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (!TownyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SET.getNode(split[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (split[0].equalsIgnoreCase("perm")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                TownCommand.setTownBlockPermissions(player, resident, resident.getPermissions(), newSplit, true);
            } else if (split[0].equalsIgnoreCase("mode")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.setMode(player, newSplit);
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                return;
            }
            TownyUniverse.getDataSource().saveResident(resident);
        }
    }

    private void setMode(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "clear", ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "[mode] ...[mode]", ""));
            player.sendMessage(ChatTools.formatCommand("Mode", "map", "", TownySettings.getLangString("mode_1")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townclaim", "", TownySettings.getLangString("mode_2")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townunclaim", "", TownySettings.getLangString("mode_3")));
            player.sendMessage(ChatTools.formatCommand("Mode", "tc", "", TownySettings.getLangString("mode_4")));
            player.sendMessage(ChatTools.formatCommand("Mode", "nc", "", TownySettings.getLangString("mode_5")));
            player.sendMessage(ChatTools.formatCommand("Eg", "/resident set mode", "map townclaim town nation general", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("reset") || split[0].equalsIgnoreCase("clear")) {
            plugin.removePlayerMode(player);
            return;
        }
        List<String> list = Arrays.asList(split);
        if (list.contains("spy") && plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
            return;
        }
        plugin.setPlayerMode(player, split, true);
    }

    public void residentFriend(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "add " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "remove " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "clear", ""));
        } else {
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("add")) {
                String[] names = StringMgmt.remFirstArg(split);
                this.residentFriendAdd(player, resident, TownyUniverse.getDataSource().getResidents(player, names));
            } else if (split[0].equalsIgnoreCase("remove")) {
                String[] names = StringMgmt.remFirstArg(split);
                this.residentFriendRemove(player, resident, TownyUniverse.getDataSource().getResidents(player, names));
            } else if (split[0].equalsIgnoreCase("clearlist") || split[0].equalsIgnoreCase("clear")) {
                this.residentFriendRemove(player, resident, resident.getFriends());
            }
        }
    }

    public void residentFriendAdd(Player player, Resident resident, List<Resident> invited) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident newFriend : invited) {
            try {
                resident.addFriend(newFriend);
                plugin.deleteCache(newFriend.getName());
            }
            catch (AlreadyRegisteredException e) {
                remove.add(newFriend);
            }
        }
        for (Resident newFriend : remove) {
            invited.remove(newFriend);
        }
        if (invited.size() > 0) {
            String msg = "Added ";
            for (Resident newFriend : invited) {
                msg = msg + newFriend.getName() + ", ";
                Player p = BukkitTools.getPlayer(newFriend.getName());
                if (p == null) continue;
                TownyMessaging.sendMsg((Object)p, String.format(TownySettings.getLangString("msg_friend_add"), player.getName()));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + TownySettings.getLangString("msg_to_list");
            TownyMessaging.sendMsg((Object)player, msg);
            TownyUniverse.getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void residentFriendRemove(Player player, Resident resident, List<Resident> kicking) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        ArrayList<Resident> toKick = new ArrayList<Resident>(kicking);
        for (Resident friend : toKick) {
            try {
                resident.removeFriend(friend);
                plugin.deleteCache(friend.getName());
            }
            catch (NotRegisteredException e) {
                remove.add(friend);
            }
        }
        if (remove.size() > 0) {
            for (Resident friend : remove) {
                toKick.remove(friend);
            }
        }
        if (toKick.size() > 0) {
            String msg = TownySettings.getLangString("msg_removed");
            for (Resident member : toKick) {
                msg = msg + member.getName() + ", ";
                Player p = BukkitTools.getPlayer(member.getName());
                if (p == null) continue;
                TownyMessaging.sendMsg((Object)p, String.format(TownySettings.getLangString("msg_friend_remove"), player.getName()));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + TownySettings.getLangString("msg_from_list");
            TownyMessaging.sendMsg((Object)player, msg);
            TownyUniverse.getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        LinkedList<String> output = new LinkedList<String>();
        String lastArg = "";
        if (args.length > 0) {
            lastArg = args[args.length - 1].toLowerCase();
        }
        if (!lastArg.equalsIgnoreCase("")) {
            for (Resident resident : TownyUniverse.getDataSource().getResidents()) {
                if (!resident.getName().toLowerCase().startsWith(lastArg)) continue;
                output.add(resident.getName());
            }
        }
        return output;
    }

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/resident"));
        output.add(ChatTools.formatCommand("", "/resident", "", TownySettings.getLangString("res_1")));
        output.add(ChatTools.formatCommand("", "/resident", TownySettings.getLangString("res_2"), TownySettings.getLangString("res_3")));
        output.add(ChatTools.formatCommand("", "/resident", "list", TownySettings.getLangString("res_4")));
        output.add(ChatTools.formatCommand("", "/resident", "tax", ""));
        output.add(ChatTools.formatCommand("", "/resident", "jail", ""));
        output.add(ChatTools.formatCommand("", "/resident", "toggle", "[mode]...[mode]"));
        output.add(ChatTools.formatCommand("", "/resident", "set [] .. []", "'/resident set' " + TownySettings.getLangString("res_5")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add/remove] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_6")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add+/remove+] " + TownySettings.getLangString("res_2") + " ", TownySettings.getLangString("res_7")));
        output.add(ChatTools.formatCommand("", "/resident", "spawn", ""));
    }
}

