/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.google.common.collect.ListMultimap;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InviteCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> invite_help;

    public InviteCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (command.getName().equalsIgnoreCase("invite")) {
                this.parseInviteCommand(player, args);
            }
        } else {
            for (String line : invite_help) {
                sender.sendMessage(Colors.strip(line));
            }
        }
        return true;
    }

    private void parseInviteCommand(Player player, String[] split) {
        if (split.length == 0) {
            for (String line : invite_help) {
                player.sendMessage(line);
            }
        } else {
            if (split[0].equalsIgnoreCase("help") || split[0].equalsIgnoreCase("?")) {
                for (String line : invite_help) {
                    player.sendMessage(line);
                }
                return;
            }
            if (split[0].equalsIgnoreCase("list")) {
                InviteCommand.parseInviteList(player, split);
                return;
            }
            if (split[0].equalsIgnoreCase(TownySettings.getAcceptCommand())) {
                InviteCommand.parseAccept(player, StringMgmt.remFirstArg(split));
                return;
            }
            if (split[0].equalsIgnoreCase(TownySettings.getDenyCommand())) {
                InviteCommand.parseDeny(player, StringMgmt.remFirstArg(split));
                return;
            }
        }
    }

    private static void parseInviteList(Player player, String[] split) {
        Resident resident;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        String received = TownySettings.getLangString("player_received_invites").replace("%a", Integer.toString(InviteHandler.getReceivedInvitesAmount(resident))).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident)));
        try {
            int page;
            if (resident.getReceivedInvites().size() > 0) {
                page = 1;
                if (split != null && split.length >= 2) {
                    try {
                        page = Integer.parseInt(split[1]);
                    }
                    catch (NumberFormatException e) {
                        page = 1;
                    }
                }
            } else {
                throw new TownyException(TownySettings.getLangString("msg_err_player_no_invites"));
            }
            InviteCommand.sendInviteList(player, resident.getReceivedInvites(), page, false);
            player.sendMessage(received);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public static void parseDeny(Player player, String[] args) {
        Resident resident;
        Town town = null;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        List<Invite> invites = resident.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_player_no_invites"));
            return;
        }
        if (args.length >= 1) {
            try {
                town = TownyUniverse.getDataSource().getTown(args[0]);
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                return;
            }
        } else if (invites.size() == 1) {
            town = (Town)invites.get(0).getSender();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_player_has_multiple_invites"));
            InviteCommand.parseInviteList(player, null);
            return;
        }
        ListMultimap<Town, Resident> town2residents = InviteHandler.getTowntoresidentinvites();
        if (town2residents.containsKey((Object)town) && town2residents.get((Object)town).contains(resident)) {
            for (Invite invite : resident.getReceivedInvites()) {
                if (!invite.getSender().equals(town)) continue;
                try {
                    InviteHandler.declineInvite(invite, false);
                    return;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
    }

    public static void parseAccept(Player player, String[] args) {
        Resident resident;
        Town town = null;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        List<Invite> invites = resident.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_player_no_invites"));
            return;
        }
        if (args.length >= 1) {
            try {
                town = TownyUniverse.getDataSource().getTown(args[0]);
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                return;
            }
        } else if (invites.size() == 1) {
            town = (Town)invites.get(0).getSender();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_player_has_multiple_invites"));
            InviteCommand.parseInviteList(player, null);
            return;
        }
        ListMultimap<Town, Resident> town2residents = InviteHandler.getTowntoresidentinvites();
        if (town2residents.containsEntry((Object)town, (Object)resident)) {
            for (Invite invite : resident.getReceivedInvites()) {
                if (!invite.getSender().equals(town)) continue;
                try {
                    InviteHandler.acceptInvite(invite);
                    return;
                }
                catch (TownyException e) {
                    e.printStackTrace();
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
    }

    public static void sendInviteList(Player player, List<Invite> list, int page, boolean fromSender) {
        if (page < 0) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative"));
            return;
        }
        if (page == 0) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
            return;
        }
        int total = (int)Math.ceil((double)list.size() / 10.0);
        if (page > total) {
            return;
        }
        ArrayList<String> invitesformatted = new ArrayList<String>();
        int iMax = page * 10;
        if (page * 10 > list.size()) {
            iMax = list.size();
        }
        String object = null;
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Invite invite = list.get(i);
            String name = invite.getDirectSender();
            if (name == null) {
                name = "Console";
            } else {
                try {
                    name = TownyUniverse.getDataSource().getResident(name).getName();
                }
                catch (NotRegisteredException e) {
                    name = "Unknown";
                }
            }
            String output = null;
            if (fromSender) {
                if (invite.getSender() instanceof Town) {
                    output = "\u00a73" + ((Resident)invite.getReceiver()).getName() + "\u00a78" + " - " + "\u00a72" + name;
                    object = TownySettings.getLangString("player_sing");
                }
                if (invite.getSender() instanceof Nation) {
                    if (invite.getReceiver() instanceof Town) {
                        output = "\u00a73" + ((Town)invite.getReceiver()).getName() + "\u00a78" + " - " + "\u00a72" + name;
                        object = TownySettings.getLangString("town_sing");
                    }
                    if (invite.getReceiver() instanceof Nation) {
                        output = "\u00a73" + ((Nation)invite.getReceiver()).getName() + "\u00a78" + " - " + "\u00a72" + name;
                        object = TownySettings.getLangString("nation_sing");
                    }
                }
            } else {
                if (invite.getReceiver() instanceof Resident) {
                    output = "\u00a73" + ((Town)invite.getSender()).getName() + "\u00a78" + " - " + "\u00a72" + name;
                    object = TownySettings.getLangString("town_sing");
                }
                if (invite.getReceiver() instanceof Town) {
                    output = "\u00a73" + ((Nation)invite.getSender()).getName() + "\u00a78" + " - " + "\u00a72" + name;
                    object = TownySettings.getLangString("nation_sing");
                }
                if (invite.getReceiver() instanceof Nation) {
                    output = "\u00a73" + ((Nation)invite.getSender()).getName() + "\u00a78" + " - " + "\u00a72" + name;
                    object = TownySettings.getLangString("nation_sing");
                }
            }
            invitesformatted.add(output);
        }
        player.sendMessage(ChatTools.formatList(TownySettings.getLangString("invite_plu"), "\u00a73" + object + "\u00a78" + " - " + "\u00a7b" + TownySettings.getLangString("invite_sent_by"), invitesformatted, TownySettings.getListPageMsg(page, total)));
    }

    static {
        invite_help = new ArrayList<String>();
        invite_help.add(ChatTools.formatTitle("/invite"));
        invite_help.add(ChatTools.formatCommand("", "/invite", TownySettings.getAcceptCommand() + " [town]", TownySettings.getLangString("invite_help_1")));
        invite_help.add(ChatTools.formatCommand("", "/invite", TownySettings.getDenyCommand() + " [town]", TownySettings.getLangString("invite_help_2")));
        invite_help.add(ChatTools.formatCommand("", "/invite", "list", TownySettings.getLangString("invite_help_3")));
    }
}

