/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyMessaging {
    public static void sendErrorMsg(String msg) {
        TownyLogger.log.warning(ChatTools.stripColour("[Towny] Error: " + msg));
    }

    public static void sendErrorMsg(Object sender, String msg) {
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        if (sender == null) {
            System.out.print("Message called with null sender");
        }
        for (String line : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a7c" + msg)) {
            if (isPlayer) {
                ((Player)sender).sendMessage(line);
                continue;
            }
            ((CommandSender)sender).sendMessage(Colors.strip(line));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendErrorMsg(Object sender, String[] msg) {
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        for (String line : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a7c" + msg)) {
            if (isPlayer) {
                ((Player)sender).sendMessage(line);
                continue;
            }
            ((CommandSender)sender).sendMessage(Colors.strip(line));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMsg(String msg) {
        TownyLogger.log.info("[Towny] " + ChatTools.stripColour(msg));
    }

    public static void sendMsg(Object sender, String msg) {
        for (String line : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a72" + msg)) {
            if (sender instanceof Player) {
                ((Player)sender).sendMessage(line);
                continue;
            }
            if (sender instanceof CommandSender) {
                ((CommandSender)sender).sendMessage(Colors.strip(line));
                continue;
            }
            if (!(sender instanceof Resident)) continue;
            try {
                TownyUniverse.getPlayer((Resident)sender).sendMessage(Colors.strip(line));
            }
            catch (TownyException townyException) {}
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMsg(Player player, String[] msg) {
        for (String line : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a72" + msg)) {
            player.sendMessage(line);
        }
    }

    public static void sendDevMsg(String msg) {
        if (TownySettings.isDevMode()) {
            Player townyDev = BukkitTools.getPlayer(TownySettings.getDevName());
            if (townyDev == null) {
                return;
            }
            for (String line : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + " DevMode: " + "\u00a7c" + msg)) {
                townyDev.sendMessage(line);
            }
        }
    }

    public static void sendDevMsg(String[] msg) {
        if (TownySettings.isDevMode()) {
            Player townyDev = BukkitTools.getPlayer(TownySettings.getDevName());
            if (townyDev == null) {
                return;
            }
            for (String line : ChatTools.color(TownySettings.getLangString("default_towny_prefix") + " DevMode: " + "\u00a7c" + msg)) {
                townyDev.sendMessage(line);
            }
        }
    }

    public static void sendDebugMsg(String msg) {
        if (TownySettings.getDebug()) {
            TownyLogger.debug.info(ChatTools.stripColour("[Towny] Debug: " + msg));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMessage(Object sender, List<String> lines) {
        TownyMessaging.sendMessage(sender, lines.toArray(new String[0]));
    }

    public static void sendMessage(Object sender, String line) {
        if (sender instanceof Player) {
            ((Player)sender).sendMessage(line);
        } else if (sender instanceof CommandSender) {
            ((CommandSender)sender).sendMessage(line);
        } else if (sender instanceof Resident) {
            try {
                TownyUniverse.getPlayer((Resident)sender).sendMessage(Colors.strip(line));
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public static void sendMessage(Object sender, String[] lines) {
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        for (String line : lines) {
            if (isPlayer) {
                ((Player)sender).sendMessage(line);
                continue;
            }
            if (sender instanceof CommandSender) {
                ((CommandSender)sender).sendMessage(line);
                continue;
            }
            if (!(sender instanceof Resident)) continue;
            try {
                TownyUniverse.getPlayer((Resident)sender).sendMessage(Colors.strip(line));
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public static void sendTownMessage(Town town, List<String> lines) {
        TownyMessaging.sendTownMessage(town, lines.toArray(new String[0]));
    }

    public static void sendNationMessage(Nation nation, List<String> lines) {
        TownyMessaging.sendNationMessage(nation, lines.toArray(new String[0]));
    }

    public static void sendGlobalMessage(List<String> lines) {
        TownyMessaging.sendGlobalMessage(lines.toArray(new String[0]));
    }

    public static void sendGlobalMessage(String[] lines) {
        for (String line : lines) {
            TownyLogger.log.info(ChatTools.stripColour("[Global Msg] " + line));
        }
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (String line : lines) {
                player.sendMessage(line);
            }
        }
    }

    public static void sendGlobalMessage(String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Global Message] " + line));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            try {
                if (!TownyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName()).isUsingTowny()) continue;
                player.sendMessage(line);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendResidentMessage(Resident resident, String[] lines) throws TownyException {
        for (String line : lines) {
            TownyLogger.log.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + line));
        }
        Player player = TownyUniverse.getPlayer(resident);
        for (String line : lines) {
            player.sendMessage(line);
        }
    }

    public static void sendResidentMessage(Resident resident, String line) throws TownyException {
        TownyLogger.log.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + line));
        Player player = TownyUniverse.getPlayer(resident);
        player.sendMessage(TownySettings.getLangString("default_towny_prefix") + line);
    }

    public static void sendTownMessage(Town town, String[] lines) {
        for (String line : lines) {
            TownyLogger.log.info(ChatTools.stripColour("[Town Msg] " + town.getName() + ": " + line));
        }
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            for (String line : lines) {
                player.sendMessage(line);
            }
        }
    }

    public static void sendTownMessagePrefixed(Town town, String line) {
        TownyLogger.log.info(ChatTools.stripColour(line));
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendMessage(TownySettings.getLangString("default_towny_prefix") + line);
        }
    }

    public static void sendTownMessage(Town town, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Town Msg] " + town.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendMessage(line);
        }
    }

    public static void sendPrefixedTownMessage(Town town, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Town Msg] " + town.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendMessage(String.format(TownySettings.getLangString("default_town_prefix"), town.getName()) + line);
        }
    }

    public static void sendNationMessage(Nation nation, String[] lines) {
        for (String line : lines) {
            TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + line));
        }
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            for (String line : lines) {
                player.sendMessage(line);
            }
        }
    }

    public static void sendNationMessage(Nation nation, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendMessage(line);
        }
    }

    public static void sendPrefixedNationMessage(Nation nation, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendMessage(String.format(TownySettings.getLangString("default_nation_prefix"), nation.getName()) + line);
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendMessage(TownySettings.getLangString("default_towny_prefix") + line);
        }
    }

    public static void sendTownBoard(Player player, Town town) {
        for (String line : ChatTools.color("\u00a76[" + town.getName() + "] " + "\u00a7e" + town.getTownBoard())) {
            player.sendMessage(line);
        }
    }

    public static void sendNationBoard(Player player, Nation nation) {
        for (String line : ChatTools.color("\u00a76[" + nation.getName() + "] " + "\u00a7e" + nation.getNationBoard())) {
            player.sendMessage(line);
        }
    }

    public static void sendMessageToMode(ResidentList residents, String msg, String modeRequired) {
        for (Resident resident : TownyUniverse.getOnlineResidents(residents)) {
            if (!resident.hasMode(modeRequired)) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendMessageToMode(Town town, String msg, String modeRequired) {
        for (Resident resident : town.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendMessageToMode(Nation nation, String msg, String modeRequired) {
        for (Resident resident : nation.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendTitleMessageToResident(Resident resident, String title, String subtitle) throws TownyException {
        Player player = TownyUniverse.getPlayer(resident);
        player.sendTitle(title, subtitle, 10, 70, 10);
    }

    public static void sendTitleMessageToTown(Town town, String title, String subtitle) {
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendTitle(title, subtitle, 10, 70, 10);
        }
    }

    public static void sendTitleMessageToNation(Nation nation, String title, String subtitle) {
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendTitle(title, subtitle, 10, 70, 10);
        }
    }

    public static void sendConfirmationMessage(Object player, String firstline, String confirmline, String cancelline, String lastline) {
        if (firstline == null) {
            firstline = ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "Confirmation" + ChatColor.DARK_GRAY + "] " + ChatColor.BLUE + TownySettings.getLangString("are_you_sure_you_want_to_continue");
        }
        if (confirmline == null) {
            confirmline = ChatColor.GREEN + "          /" + TownySettings.getConfirmCommand();
        }
        if (cancelline == null) {
            cancelline = ChatColor.GREEN + "          /" + TownySettings.getCancelCommand();
        }
        if (lastline != null && lastline.equals("")) {
            String[] message = new String[]{firstline, confirmline, cancelline};
            TownyMessaging.sendMessage(player, message);
            return;
        }
        if (lastline == null) {
            lastline = ChatColor.BLUE + TownySettings.getLangString("this_message_will_expire");
            String[] message = new String[]{firstline, confirmline, cancelline, lastline};
            TownyMessaging.sendMessage(player, message);
        }
    }

    public static void sendRequestMessage(Object player, Invite invite) {
        String thirdline;
        String secondline;
        String firstline;
        if (invite.getSender() instanceof Town) {
            firstline = ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "Invitation" + ChatColor.DARK_GRAY + "] " + ChatColor.BLUE + String.format(TownySettings.getLangString("you_have_been_invited_to_join2"), invite.getSender().getName());
            secondline = ChatColor.GREEN + "          /" + TownySettings.getAcceptCommand() + " " + invite.getSender().getName();
            thirdline = ChatColor.GREEN + "          /" + TownySettings.getDenyCommand() + " " + invite.getSender().getName();
            TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
        }
        if (invite.getSender() instanceof Nation) {
            if (invite.getReceiver() instanceof Town) {
                firstline = ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "Invitation" + ChatColor.DARK_GRAY + "] " + ChatColor.BLUE + String.format(TownySettings.getLangString("you_have_been_invited_to_join2"), invite.getSender().getName());
                secondline = ChatColor.GREEN + "          /t invite accept " + invite.getSender().getName();
                thirdline = ChatColor.GREEN + "          /t invite deny " + invite.getSender().getName();
                TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
            }
            if (invite.getReceiver() instanceof Nation) {
                firstline = ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "Invitation" + ChatColor.DARK_GRAY + "] " + ChatColor.BLUE + String.format(TownySettings.getLangString("you_have_been_requested_to_ally2"), invite.getSender().getName());
                secondline = ChatColor.GREEN + "          /n ally accept " + invite.getSender().getName();
                thirdline = ChatColor.GREEN + "          /n ally deny " + invite.getSender().getName();
                TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
            }
        }
    }
}

