/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyLogFormatter;
import com.palmergames.bukkit.towny.TownyMoneyLogFormatter;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.util.FileMgmt;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class TownyLogger {
    public static final Logger log = Logger.getLogger("com.palmergames.bukkit.towny.log");
    public static final Logger money = Logger.getLogger("com.palmergames.bukkit.towny.moneylog");
    public static final Logger debug = Logger.getLogger("com.palmergames.bukkit.towny.debug");

    public static void setup(String root, boolean append) {
        String logFolder = root + FileMgmt.fileSeparator() + "logs";
        TownyLogger.setupLogger(log, logFolder, "towny.log", new TownyLogFormatter(), TownySettings.isAppendingToLog());
        TownyLogger.setupLogger(money, logFolder, "money.csv", new TownyMoneyLogFormatter(), TownySettings.isAppendingToLog());
        money.setUseParentHandlers(false);
        TownyLogger.setupLogger(debug, logFolder, "debug.log", new TownyLogFormatter(), TownySettings.isAppendingToLog());
    }

    public static void shutDown() {
        TownyLogger.CloseDownLogger(log);
        TownyLogger.CloseDownLogger(money);
        TownyLogger.CloseDownLogger(debug);
    }

    public static void setupLogger(Logger logger, String logFolder, String filename, Formatter formatter, boolean append) {
        try {
            FileHandler fh = new FileHandler(logFolder + FileMgmt.fileSeparator() + filename, append);
            fh.setFormatter(formatter);
            logger.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void CloseDownLogger(Logger logger) {
        for (Handler fh : logger.getHandlers()) {
            logger.removeHandler(fh);
            fh.close();
        }
    }

    public static void logMoneyTransaction(TownyEconomyObject a, double amount, TownyEconomyObject b, String reason) {
        money.info(String.format("%s,%s,%s,%s", reason == null ? "" : reason, TownyLogger.getObjectName(a), amount, TownyLogger.getObjectName(b)));
    }

    private static String getObjectName(TownyEconomyObject obj) {
        String type = obj == null ? "Server" : (obj instanceof Resident ? "Resident" : (obj instanceof Town ? "Town" : (obj instanceof Nation ? "Nation" : "?")));
        return String.format("[%s] %s", type, obj != null ? obj.getName() : "");
    }
}

