/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.config;

import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class CommentedConfiguration
extends YamlConfiguration {
    private HashMap<String, String> comments;
    private File file;
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);

    public CommentedConfiguration(File file) {
        this.comments = new HashMap();
        this.file = file;
    }

    public boolean load() {
        boolean loaded = true;
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            loaded = false;
        }
        return loaded;
    }

    public void save() {
        boolean saved = true;
        try {
            this.save(this.file);
        }
        catch (Exception e) {
            saved = false;
        }
        if (!this.comments.isEmpty() && saved) {
            String[] yamlContents = FileMgmt.convertFileToString(this.file).split("[" + System.getProperty("line.separator") + "]");
            StringBuilder newContents = new StringBuilder();
            String currentPath = "";
            int depth = 0;
            for (String line : yamlContents) {
                boolean node;
                if (line.contains(": ") || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                    node = true;
                    int index = line.indexOf(": ");
                    if (index < 0) {
                        index = line.length() - 1;
                    }
                    if (currentPath.isEmpty()) {
                        currentPath = line.substring(0, index);
                    } else {
                        int whiteSpace = 0;
                        for (int n = 0; n < line.length() && line.charAt(n) == ' '; ++n) {
                            ++whiteSpace;
                        }
                        if (whiteSpace / 2 > depth) {
                            currentPath = currentPath + "." + line.substring(whiteSpace, index);
                            ++depth;
                        } else if (whiteSpace / 2 < depth) {
                            int newDepth = whiteSpace / 2;
                            for (int i = 0; i < depth - newDepth; ++i) {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                            }
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                                currentPath = currentPath + ".";
                            }
                            currentPath = currentPath + line.substring(whiteSpace, index);
                            depth = newDepth;
                        } else {
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                                currentPath = currentPath + ".";
                            }
                            currentPath = currentPath + line.substring(whiteSpace, index);
                        }
                    }
                } else {
                    node = false;
                }
                if (node) {
                    String comment = this.comments.get(currentPath);
                    line = comment != null ? comment + System.getProperty("line.separator") + line + System.getProperty("line.separator") : line + System.getProperty("line.separator");
                }
                if (!node) {
                    newContents.append(line).append(System.getProperty("line.separator"));
                    continue;
                }
                newContents.append(line);
            }
            while (newContents.toString().startsWith(" " + System.getProperty("line.separator"))) {
                newContents = new StringBuilder(newContents.toString().replaceFirst(" " + System.getProperty("line.separator"), ""));
            }
            FileMgmt.stringToFile(newContents.toString(), this.file);
        }
    }

    public void addComment(String path, String ... commentLines) {
        StringBuilder commentstring = new StringBuilder();
        StringBuilder leadingSpaces = new StringBuilder();
        for (int n = 0; n < path.length(); ++n) {
            if (path.charAt(n) != '.') continue;
            leadingSpaces.append("  ");
        }
        for (String line : commentLines) {
            line = !line.isEmpty() ? leadingSpaces + line : " ";
            if (commentstring.length() > 0) {
                commentstring.append(System.getProperty("line.separator"));
            }
            commentstring.append(line);
        }
        this.comments.put(path, commentstring.toString());
    }

    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlOptions.setWidth(10000);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        String dump = this.yaml.dump((Object)this.getValues(false));
        if (dump.equals("{}\n")) {
            dump = "";
        }
        return dump;
    }
}

