/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Translation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;

public class StringMgmt {
    public static final Pattern hexPattern = Pattern.compile("(?<!\\\\)(#[a-fA-F0-9]{6})");
    public static final Pattern ampersandPattern = Pattern.compile("(?<!\\\\)(&#[a-fA-F0-9]{6})");
    public static final Pattern bracketPattern = Pattern.compile("(?<!\\\\)\\{(#[a-fA-F0-9]{6})}");

    public static String translateHexColors(String str) {
        String hex;
        if (!Towny.is116Plus()) {
            return str;
        }
        Matcher hexMatcher = hexPattern.matcher(str);
        Matcher ampMatcher = ampersandPattern.matcher(str);
        Matcher bracketMatcher = bracketPattern.matcher(str);
        while (hexMatcher.find()) {
            hex = hexMatcher.group();
            str = str.replace(hex, ChatColor.of((String)hex).toString());
        }
        while (ampMatcher.find()) {
            hex = ampMatcher.group().replace("&", "");
            str = str.replace(hex, ChatColor.of((String)hex).toString());
            str = str.replace("&", "");
        }
        while (bracketMatcher.find()) {
            hex = bracketMatcher.group().replace("{", "").replace("}", "");
            str = str.replace(hex, ChatColor.of((String)hex).toString());
            str = str.replace("{", "").replace("}", "");
        }
        return str;
    }

    public static String join(Collection<?> args) {
        return StringMgmt.join(args, " ");
    }

    public static String join(Collection<?> args, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (Object o : args) {
            joiner.add(o.toString());
        }
        return joiner.toString();
    }

    public static String join(Object[] arr) {
        return StringMgmt.join(arr, " ");
    }

    public static String join(Object[] arr, String separator) {
        if (arr.length == 0) {
            return "";
        }
        String out = arr[0].toString();
        for (int i = 1; i < arr.length; ++i) {
            out = out + separator + arr[i];
        }
        return out;
    }

    public static String join(Map<?, ?> map, String keyValSeparator, String tokenSeparator) {
        if (map.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(keyValSeparator).append(entry.getValue().toString()).append(tokenSeparator);
        }
        return sb.toString();
    }

    public static String[] remFirstArg(String[] arr) {
        return StringMgmt.remArgs(arr, 1);
    }

    public static String[] remLastArg(String[] arr) {
        return StringMgmt.subArray(arr, 0, arr.length - 1);
    }

    public static String[] remArgs(String[] arr, int startFromIndex) {
        if (arr.length == 0) {
            return arr;
        }
        if (arr.length < startFromIndex) {
            return new String[0];
        }
        String[] newSplit = new String[arr.length - startFromIndex];
        System.arraycopy(arr, startFromIndex, newSplit, 0, arr.length - startFromIndex);
        return newSplit;
    }

    public static String[] subArray(String[] arr, int start, int end) {
        if (arr.length == 0) {
            return arr;
        }
        if (end < start) {
            return new String[0];
        }
        int length = end - start;
        String[] newSplit = new String[length];
        System.arraycopy(arr, start, newSplit, 0, length);
        return newSplit;
    }

    public static String trimMaxLength(String str, int length) {
        if (str.length() < length) {
            return str;
        }
        if (length > 3) {
            return str.substring(0, length);
        }
        throw new UnsupportedOperationException("Minimum length of 3 characters.");
    }

    public static String maxLength(String str, int length) {
        if (str.length() < length) {
            return str;
        }
        if (length > 3) {
            return str.substring(0, length - 3) + "...";
        }
        throw new UnsupportedOperationException("Minimum length of 3 characters.");
    }

    public static boolean containsIgnoreCase(List<String> arr, String str) {
        for (String s : arr) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static String remUnderscore(String str) {
        return str.replaceAll("_", " ");
    }

    public static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String capitalizeStrings(String string) {
        return Stream.of(string.split("_")).map(str -> str.substring(0, 1).toUpperCase() + str.substring(1)).collect(Collectors.joining("_"));
    }

    public static boolean parseOnOff(String s) throws Exception {
        if (s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("off")) {
            return false;
        }
        throw new Exception(Translation.of("msg_err_invalid_input", " on/off."));
    }
}

