/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class NameValidation {
    private static Pattern namePattern = null;
    private static Pattern stringPattern = null;
    private static Collection<String> bannedNames = new HashSet<String>(Arrays.asList("here", "leave", "list", "online", "new", "plots", "add", "kick", "claim", "unclaim", "withdraw", "delete", "outlawlist", "deposit", "outlaw", "outpost", "ranklist", "rank", "reclaim", "reslist", "say", "set", "toggle", "join", "invite", "buy", "mayor", "bankhistory", "enemy", "ally", "townlist", "allylist", "enemylist", "king", "merge", "jail", "plotgrouplist", "trust", "purge"));

    public static String checkAndFilterName(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        if (NameValidation.isBlacklistName(out)) {
            throw new InvalidNameException(out + " is an invalid name.");
        }
        return out;
    }

    public static String checkAndFilterPlayerName(String name) throws InvalidNameException {
        String out = NameValidation.filterName(name);
        if (!NameValidation.isValidName(out)) {
            throw new InvalidNameException(out + " is an invalid name.");
        }
        return out;
    }

    public static String[] checkAndFilterArray(String[] arr) {
        int count = 0;
        for (String word : arr) {
            arr[count] = NameValidation.filterName(word);
            ++count;
        }
        return arr;
    }

    public static boolean isBlacklistName(String name) {
        if (name.length() > TownySettings.getMaxNameLength()) {
            return true;
        }
        if (name.equalsIgnoreCase(TownySettings.getNationAccountPrefix()) || name.equalsIgnoreCase(TownySettings.getTownAccountPrefix())) {
            return true;
        }
        if (bannedNames.contains(name.toLowerCase())) {
            return true;
        }
        if (NameValidation.isConfigBlacklistedName(name)) {
            return true;
        }
        return !NameValidation.isValidName(name);
    }

    public static boolean isConfigBlacklistedName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        return TownySettings.getBlacklistedNames().stream().anyMatch(name::equalsIgnoreCase);
    }

    public static boolean isValidName(String name) {
        if (name.contains("'") || name.contains("`")) {
            return false;
        }
        try {
            if (namePattern == null) {
                namePattern = Pattern.compile(TownySettings.getNameCheckRegex(), 258);
            }
            return namePattern.matcher(name).find();
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isValidString(String message) {
        if (message.contains("'") || message.contains("`")) {
            return false;
        }
        try {
            if (stringPattern == null) {
                stringPattern = Pattern.compile(TownySettings.getStringCheckRegex(), 258);
            }
            return stringPattern.matcher(message).find();
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String filterName(String input) {
        return input.replaceAll(TownySettings.getNameFilterRegex(), "_").replaceAll(TownySettings.getNameRemoveRegex(), "").replace("&k", "");
    }

    public static String filterCommas(String input) {
        return input.replace(",", "_");
    }
}

