/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.util.Colors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.map.MinecraftFont;

public class ChatTools {
    static final int MAX_FONT_WIDTH = 321;
    static final int SPACE_WIDTH = 4;
    static final int UNDERSCORE_WIDTH = 6;
    static final int WIDGET_WIDTH = 22;
    static final String WIDGET = ".oOo.";
    static final int SUBWIDGET_WIDTH = 22;
    static final String SUBWIDGET = " .]|[. ";

    public static String listArr(String[] args, String prefix) {
        return ChatTools.list(Arrays.asList(args), prefix);
    }

    public static String list(Collection<String> args) {
        return ChatTools.list(args, "");
    }

    public static String list(Collection<String> args, String prefix) {
        if (args.isEmpty()) {
            return "";
        }
        return prefix + String.join((CharSequence)", ", args);
    }

    public static String stripColour(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if (c.equals("\u00a7")) {
                ++i;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String formatTitle(TownyObject object) {
        String title = object.getFormattedName();
        if (title.length() > 51) {
            title = object.getName();
        }
        if (title.length() > 51) {
            title = title.substring(0, 51);
        }
        return ChatTools.formatTitle(title);
    }

    public static String formatTitle(String title) {
        MinecraftFont font = new MinecraftFont();
        title = ".[ " + Translation.of("status_title_secondary_colour") + title + Translation.of("status_title_primary_colour") + " ].";
        if (!font.isValid(title)) {
            return ChatTools.legacyFormatTitle(title);
        }
        int remainder = 277 - font.getWidth(Colors.strip(title)) - 2;
        if (remainder < 14) {
            return Translation.of("status_title_primary_colour") + WIDGET + title + WIDGET;
        }
        if (remainder < 1) {
            return Translation.of("status_title_primary_colour") + title;
        }
        int times = remainder / 12;
        return Translation.of("status_title_primary_colour") + WIDGET + ChatTools.repeatChar(times, "_") + title + ChatTools.repeatChar(times, "_") + WIDGET;
    }

    private static String legacyFormatTitle(String title) {
        String line = ".oOo.__________________________________________________.oOo.";
        int pivot = line.length() / 2;
        String center = title;
        String out = Translation.of("status_title_primary_colour") + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = out + center + line.substring(pivot + center.length() / 2);
        return out;
    }

    public static String formatSubTitle(String subtitle) {
        MinecraftFont font = new MinecraftFont();
        if (!font.isValid(subtitle)) {
            return ChatTools.legacyFormatSubtitle(subtitle);
        }
        int remainder = 277 - font.getWidth(Colors.strip(subtitle)) - 2;
        if (remainder < 10) {
            return Translation.of("status_title_primary_colour") + SUBWIDGET + subtitle + Translation.of("status_title_primary_colour") + SUBWIDGET;
        }
        if (remainder < 1) {
            return Translation.of("status_title_primary_colour") + subtitle;
        }
        int times = remainder / 8;
        return Translation.of("status_title_primary_colour") + SUBWIDGET + ChatTools.repeatChar(times, " ") + subtitle + ChatTools.repeatChar(times, " ") + Translation.of("status_title_primary_colour") + SUBWIDGET;
    }

    private static String legacyFormatSubtitle(String subtitle) {
        String line = " .]|[.                                                                     .]|[.";
        int pivot = line.length() / 2;
        String center = subtitle + Translation.of("status_title_primary_colour");
        String out = Translation.of("status_title_primary_colour") + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = out + center + line.substring(pivot + center.length() / 2);
        return out;
    }

    private static String repeatChar(int num, String character) {
        String output = "";
        for (int i = 0; i < num; ++i) {
            output = output + character;
        }
        return output;
    }

    public static String formatCommand(String command, String subCommand, String help) {
        return ChatTools.formatCommand("", command, subCommand, help);
    }

    public static String formatCommand(String requirement, String command, String subCommand, String help) {
        String out = "  ";
        if (requirement.length() > 0) {
            out = out + "\u00a7c" + requirement + ": ";
        }
        out = out + "\u00a73" + command;
        if (subCommand.length() > 0) {
            out = out + " \u00a7b" + subCommand;
        }
        if (help.length() > 0) {
            out = out + " \u00a77 : " + help;
        }
        return out;
    }

    public static String[] formatList(String title, String subject, List<String> list, String page) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(0, ChatTools.formatTitle(title));
        output.add(1, subject);
        output.addAll(list);
        output.add(page);
        return output.toArray(new String[0]);
    }
}

