/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.google.common.base.Charsets;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class BukkitTools {
    private static Towny plugin = null;
    private static Server server = null;

    public static void initialize(Towny plugin) {
        BukkitTools.plugin = plugin;
        server = plugin.getServer();
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return BukkitTools.getServer().getOnlinePlayers();
    }

    public static List<Player> matchPlayer(String name) {
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : Bukkit.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)iterPlayer)) continue;
            if (name.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(name.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public static UUID getUUIDSafely(String name) {
        if (BukkitTools.hasPlayedBefore(name)) {
            return BukkitTools.getOfflinePlayer(name).getUniqueId();
        }
        return null;
    }

    public static Player getPlayerExact(String name) {
        return BukkitTools.getServer().getPlayerExact(name);
    }

    public static Player getPlayer(String playerId) {
        return BukkitTools.getServer().getPlayer(playerId);
    }

    public static Player getPlayer(UUID playerUUID) {
        return server.getPlayer(playerUUID);
    }

    public static boolean isOnline(String name) {
        return Bukkit.getPlayer((String)name) != null;
    }

    public static List<World> getWorlds() {
        return BukkitTools.getServer().getWorlds();
    }

    public static World getWorld(String name) {
        return BukkitTools.getServer().getWorld(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getServer() {
        Server server = BukkitTools.server;
        synchronized (server) {
            return BukkitTools.server;
        }
    }

    public static PluginManager getPluginManager() {
        return BukkitTools.getServer().getPluginManager();
    }

    public static BukkitScheduler getScheduler() {
        return BukkitTools.getServer().getScheduler();
    }

    public static int scheduleSyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, task, delay);
    }

    public static int scheduleAsyncDelayedTask(Runnable task, long delay) {
        return BukkitTools.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, task, delay).getTaskId();
    }

    public static int scheduleSyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, task, delay, repeat);
    }

    public static int scheduleAsyncRepeatingTask(Runnable task, long delay, long repeat) {
        return BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, task, delay, repeat).getTaskId();
    }

    public static HashMap<String, Integer> getPlayersPerWorld() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (World world : BukkitTools.getServer().getWorlds()) {
            m.put(world.getName(), 0);
        }
        for (Player player : BukkitTools.getServer().getOnlinePlayers()) {
            m.put(player.getWorld().getName(), m.get(player.getWorld().getName()) + 1);
        }
        return m;
    }

    public static int calcChunk(int value) {
        return value * TownySettings.getTownBlockSize() / 16;
    }

    public static boolean hasPlayedBefore(String name) {
        return BukkitTools.getServer().getOfflinePlayer(name).hasPlayedBefore();
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        return Bukkit.getOfflinePlayer((String)name);
    }

    public static OfflinePlayer getOfflinePlayerForVault(String name) {
        return Bukkit.getOfflinePlayer((UUID)UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)));
    }

    public static String convertCoordtoXYZ(Location loc) {
        return loc.getWorld().getName() + " " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static List<String> getWorldNames() {
        return BukkitTools.getWorlds().stream().map(World::getName).collect(Collectors.toList());
    }

    public static List<String> getWorldNames(boolean lowercased) {
        return lowercased ? BukkitTools.getWorlds().stream().map(world -> world.getName().toLowerCase()).collect(Collectors.toList()) : BukkitTools.getWorldNames();
    }
}

