/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ShopPlotUtil {
    public static boolean doesPlayerOwnShopPlot(Player player, Location location) {
        Resident resident;
        boolean owner = false;
        if (TownyAPI.getInstance().isWilderness(location)) {
            return false;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(location);
        if (townBlock.hasResident() && (resident = TownyUniverse.getInstance().getResident(player.getUniqueId())) != null) {
            owner = townBlock.getResidentOrNull().equals(resident);
        }
        return owner && ShopPlotUtil.isShopPlot(location);
    }

    public static boolean doesPlayerHaveAbilityToEditShopPlot(Player player, Location location) {
        return TownyActionEventExecutor.canBuild(player, location, Material.DIRT) && ShopPlotUtil.isShopPlot(location);
    }

    public static boolean isShopPlot(Location location) {
        if (!TownyAPI.getInstance().isWilderness(location)) {
            TownBlock townblock = TownyAPI.getInstance().getTownBlock(location);
            return ShopPlotUtil.isShopPlot(townblock);
        }
        return false;
    }

    public static boolean isShopPlot(TownBlock townblock) {
        if (townblock != null) {
            return townblock.getType().equals((Object)TownBlockType.COMMERCIAL);
        }
        return false;
    }
}

