/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.player.PlayerCacheGetTownBlockStatusEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerCacheUtil {
    static Towny plugin = null;

    public static void initialize(Towny plugin) {
        PlayerCacheUtil.plugin = plugin;
    }

    public static PlayerCache getCache(Player player) {
        return plugin.getCache(player);
    }

    public static boolean getCachePermission(Player player, Location location, Material material, TownyPermission.ActionType action) {
        try {
            WorldCoord worldCoord = location.getWorld().equals(player.getWorld()) ? new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location)) : new WorldCoord(location.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("Cache permissions for " + action.toString() + " : " + cache.getCachePermission(material, action));
            return cache.getCachePermission(material, action);
        }
        catch (NullPointerException e) {
            WorldCoord worldCoord = location.getWorld().equals(player.getWorld()) ? new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location)) : new WorldCoord(location.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache.TownBlockStatus status = PlayerCacheUtil.cacheStatus(player, worldCoord, PlayerCacheUtil.fetchTownBlockStatus(player, worldCoord));
            PlayerCacheUtil.triggerCacheCreate(player, location, worldCoord, status, material, action);
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("New Cache Created and updated!");
            TownyMessaging.sendDebugMsg("New Cache permissions for " + material + ":" + action.toString() + ":" + status.name() + " = " + cache.getCachePermission(material, action));
            return cache.getCachePermission(material, action);
        }
    }

    private static void triggerCacheCreate(Player player, Location location, WorldCoord worldCoord, PlayerCache.TownBlockStatus status, Material material, TownyPermission.ActionType action) {
        switch (action) {
            case BUILD: {
                PlayerCacheUtil.cacheBuild(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
            case DESTROY: {
                PlayerCacheUtil.cacheDestroy(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
            case SWITCH: {
                PlayerCacheUtil.cacheSwitch(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
            case ITEM_USE: {
                PlayerCacheUtil.cacheItemUse(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
        }
    }

    public static PlayerCache.TownBlockStatus cacheStatus(Player player, WorldCoord worldCoord, PlayerCache.TownBlockStatus townBlockStatus) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setStatus(townBlockStatus);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Status: " + (Object)((Object)townBlockStatus));
        return townBlockStatus;
    }

    private static void cacheBuild(Player player, WorldCoord worldCoord, Material material, Boolean buildRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setBuildPermission(material, buildRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Build: " + buildRight);
    }

    private static void cacheDestroy(Player player, WorldCoord worldCoord, Material material, Boolean destroyRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setDestroyPermission(material, destroyRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Destroy: " + destroyRight);
    }

    private static void cacheSwitch(Player player, WorldCoord worldCoord, Material material, Boolean switchRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setSwitchPermission(material, switchRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Switch: " + switchRight);
    }

    private static void cacheItemUse(Player player, WorldCoord worldCoord, Material material, Boolean itemUseRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setItemUsePermission(material, itemUseRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Item Use: " + itemUseRight);
    }

    public static void cacheBlockErrMsg(Player player, String msg) {
        PlayerCache cache = plugin.getCache(player);
        cache.setBlockErrMsg(msg);
    }

    public static PlayerCache.TownBlockStatus fetchTownBlockStatus(Player player, WorldCoord worldCoord) {
        PlayerCache.TownBlockStatus status = PlayerCacheUtil.getTownBlockStatus(player, worldCoord);
        PlayerCacheGetTownBlockStatusEvent event = new PlayerCacheGetTownBlockStatusEvent(player, worldCoord, status);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getTownBlockStatus();
    }

    public static PlayerCache.TownBlockStatus getTownBlockStatus(Player player, WorldCoord worldCoord) {
        Resident resident;
        if (!TownyAPI.getInstance().isTownyWorld(worldCoord.getBukkitWorld())) {
            return PlayerCache.TownBlockStatus.OFF_WORLD;
        }
        if (!worldCoord.hasTownBlock()) {
            return TownySettings.getNationZonesEnabled() ? TownyAPI.getInstance().hasNationZone(worldCoord) : PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        TownBlock townBlock = worldCoord.getTownBlockOrNull();
        Town town = worldCoord.getTownOrNull();
        if (townBlock.isLocked()) {
            if (townBlock.getWorld().isUsingPlotManagementRevert() && TownySettings.getPlotManagementSpeed() > 0L) {
                TownyRegenAPI.addWorldCoord(townBlock.getWorldCoord());
                return PlayerCache.TownBlockStatus.LOCKED;
            }
            townBlock.setLocked(false);
        }
        if ((resident = TownyUniverse.getInstance().getResident(player.getUniqueId())) == null) {
            if (plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)player)) {
                return PlayerCache.TownBlockStatus.NOT_REGISTERED;
            }
            resident = TownyUniverse.getInstance().getResident(player.getName());
            if (resident == null) {
                plugin.getLogger().warning("Failed to fetch resident: " + player.getName());
                return PlayerCache.TownBlockStatus.NOT_REGISTERED;
            }
        }
        try {
            if (town.isMayor(resident)) {
                return PlayerCache.TownBlockStatus.TOWN_OWNER;
            }
            if (town.hasTrustedResident(resident)) {
                return PlayerCache.TownBlockStatus.TOWN_TRUSTED;
            }
            if (townBlock.hasTrustedResident(resident) && !townBlock.hasResident(resident)) {
                return PlayerCache.TownBlockStatus.PLOT_TRUSTED;
            }
            if (townBlock.hasResident()) {
                Resident owner = townBlock.getResidentOrNull();
                if (resident == owner) {
                    return PlayerCache.TownBlockStatus.PLOT_OWNER;
                }
                if (owner.hasFriend(resident)) {
                    return PlayerCache.TownBlockStatus.PLOT_FRIEND;
                }
                if (resident.hasTown() && CombatUtil.isSameTown(owner.getTown(), resident.getTown())) {
                    return PlayerCache.TownBlockStatus.PLOT_TOWN;
                }
                if (resident.hasTown() && CombatUtil.isAlly(owner.getTown(), resident.getTown())) {
                    return PlayerCache.TownBlockStatus.PLOT_ALLY;
                }
                return PlayerCache.TownBlockStatus.OUTSIDER;
            }
            if (!resident.hasTown()) {
                return PlayerCache.TownBlockStatus.OUTSIDER;
            }
            if (town.hasResident(resident)) {
                return PlayerCache.TownBlockStatus.TOWN_RESIDENT;
            }
            if (CombatUtil.isSameNation(town, resident.getTown())) {
                return PlayerCache.TownBlockStatus.TOWN_NATION;
            }
            if (CombatUtil.isAlly(town, resident.getTown())) {
                return PlayerCache.TownBlockStatus.TOWN_ALLY;
            }
            if (CombatUtil.isEnemy(resident.getTown(), town)) {
                return PlayerCache.TownBlockStatus.ENEMY;
            }
            return PlayerCache.TownBlockStatus.OUTSIDER;
        }
        catch (TownyException e) {
            return PlayerCache.TownBlockStatus.OUTSIDER;
        }
    }

    private static boolean getPermission(Player player, PlayerCache.TownBlockStatus status, WorldCoord pos, Material material, TownyPermission.ActionType action) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (townyUniverse.getPermissionSource().isTownyAdmin(player)) {
            return true;
        }
        Town targetTown = pos.getTownOrNull();
        if (targetTown != null && TownySettings.isTownBankruptcyEnabled() && action == TownyPermission.ActionType.BUILD && targetTown.isBankrupt() && !targetTown.isRuined()) {
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_err_bankrupt_town_cannot_build").forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.OFF_WORLD || status == PlayerCache.TownBlockStatus.PLOT_OWNER || status == PlayerCache.TownBlockStatus.TOWN_OWNER) {
            return true;
        }
        Resident res = townyUniverse.getResident(player.getUniqueId());
        if (res == null) {
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_err_not_registered").forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.NOT_REGISTERED) {
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error").forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.LOCKED) {
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_locked").forLocale((CommandSender)player));
            return false;
        }
        if (TownyAPI.getInstance().isWilderness(pos)) {
            boolean hasWildOverride = townyUniverse.getPermissionSource().hasWildOverride(pos.getTownyWorldOrNull(), player, material, action);
            if (status == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) {
                if (hasWildOverride) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_wild", Translatable.of(action.toString())).forLocale((CommandSender)player));
                return false;
            }
            if (TownySettings.getNationZonesEnabled() && status == PlayerCache.TownBlockStatus.NATION_ZONE) {
                if (townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_ADMIN_NATION_ZONE.getNode())) {
                    return true;
                }
                if (!hasWildOverride) {
                    PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_wild", Translatable.of(action.toString())).forLocale((CommandSender)player));
                    return false;
                }
                Nation nearestNation = TownyAPI.getInstance().getTownNationOrNull(pos.getTownyWorldOrNull().getClosestTownWithNationFromCoord(pos.getCoord(), null));
                if (res.hasNation() && res.getNationOrNull().getUUID().equals(nearestNation.getUUID())) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("nation_zone_this_area_under_protection_of", pos.getTownyWorldOrNull().getUnclaimedZoneName(), nearestNation.getName()).forLocale((CommandSender)player));
                return false;
            }
        }
        TownBlock townBlock = pos.getTownBlockOrNull();
        if (townyUniverse.getPermissionSource().hasAllTownOverride(player, material, action)) {
            return true;
        }
        if (targetTown.equals(TownyAPI.getInstance().getResidentTownOrNull(res))) {
            if (townyUniverse.getPermissionSource().hasOwnTownOverride(player, material, action)) {
                return true;
            }
            if (!townBlock.hasResident() && townyUniverse.getPermissionSource().hasTownOwnedOverride(player, material, action)) {
                return true;
            }
        }
        if (townBlock.getPermissionOverrides().containsKey(res) && townBlock.getPermissionOverrides().get(res).getPermissionTypes()[action.getIndex()] != PermissionGUIUtil.SetPermissionType.UNSET) {
            PermissionGUIUtil.SetPermissionType type = townBlock.getPermissionOverrides().get(res).getPermissionTypes()[action.getIndex()];
            if (type == PermissionGUIUtil.SetPermissionType.NEGATED) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_err", Translatable.of(action.toString())).forLocale((CommandSender)player));
            }
            return type.equals((Object)PermissionGUIUtil.SetPermissionType.SET);
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_TRUSTED || status == PlayerCache.TownBlockStatus.TOWN_TRUSTED) {
            return true;
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_FRIEND) {
            if (townBlock.getPermissions().getResidentPerm(action) && PlayerCacheUtil.testSpecialPlots(pos.getTownyWorldOrNull(), townBlock.getType(), material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_friends"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_TOWN) {
            if (townBlock.getPermissions().getNationPerm(action) && PlayerCacheUtil.testSpecialPlots(pos.getTownyWorldOrNull(), townBlock.getType(), material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_town_members"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_RESIDENT) {
            if (townBlock.getPermissions().getResidentPerm(action) && PlayerCacheUtil.testSpecialPlots(pos.getTownyWorldOrNull(), townBlock.getType(), material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_resident", Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_NATION) {
            if (townBlock.getPermissions().getNationPerm(action) && PlayerCacheUtil.testSpecialPlots(pos.getTownyWorldOrNull(), townBlock.getType(), material, action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_nation", Translatable.of(action.toString())).forLocale((CommandSender)player));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.PLOT_ALLY || status == PlayerCache.TownBlockStatus.TOWN_ALLY) {
            if (townBlock.getPermissions().getAllyPerm(action) && PlayerCacheUtil.testSpecialPlots(pos.getTownyWorldOrNull(), townBlock.getType(), material, action)) {
                return true;
            }
            if (status == PlayerCache.TownBlockStatus.PLOT_ALLY) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_allies"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            } else {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_allies", Translatable.of(action.toString())).forLocale((CommandSender)player));
            }
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.OUTSIDER || status == PlayerCache.TownBlockStatus.ENEMY) {
            if (townBlock.getPermissions().getOutsiderPerm(action) && PlayerCacheUtil.testSpecialPlots(pos.getTownyWorldOrNull(), townBlock.getType(), material, action)) {
                return true;
            }
            if (townBlock.hasResident()) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_plot", Translatable.of("msg_cache_block_error_plot_outsiders"), Translatable.of(action.toString())).forLocale((CommandSender)player));
            } else {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translatable.of("msg_cache_block_error_town_outsider", Translatable.of(action.toString())).forLocale((CommandSender)player));
            }
            return false;
        }
        TownyMessaging.sendErrorMsg((Object)player, "Error updating " + action.toString() + " permission.");
        return false;
    }

    private static boolean testSpecialPlots(TownyWorld world, TownBlockType type, Material material, TownyPermission.ActionType action) {
        if (type == TownBlockType.WILDS) {
            return TownyUniverse.getInstance().getPermissionSource().unclaimedZoneAction(world, material, action);
        }
        if (type == TownBlockType.FARM && (action.equals((Object)TownyPermission.ActionType.BUILD) || action.equals((Object)TownyPermission.ActionType.DESTROY))) {
            return TownySettings.getFarmPlotBlocks().contains(material.toString());
        }
        return true;
    }
}

