/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.metadata.DecimalDataField;
import com.palmergames.bukkit.towny.object.metadata.IntegerDataField;
import com.palmergames.bukkit.towny.object.metadata.LongDataField;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;

public class MetaDataUtil {
    public static boolean hasMeta(TownyObject townyObject, StringDataField sdf) {
        return townyObject.hasMeta(sdf.getKey());
    }

    public static boolean hasMeta(TownyObject townyObject, BooleanDataField bdf) {
        return townyObject.hasMeta(bdf.getKey());
    }

    public static boolean hasMeta(TownyObject townyObject, LongDataField ldf) {
        return townyObject.hasMeta(ldf.getKey());
    }

    public static boolean hasMeta(TownyObject townyObject, IntegerDataField idf) {
        return townyObject.hasMeta(idf.getKey());
    }

    public static boolean hasMeta(TownyObject townyObject, DecimalDataField ddf) {
        return townyObject.hasMeta(ddf.getKey());
    }

    public static String getString(TownyObject townyObject, StringDataField sdf) {
        CustomDataField<?> cdf = townyObject.getMetadata(sdf.getKey());
        if (cdf instanceof StringDataField) {
            return (String)((StringDataField)cdf).getValue();
        }
        return "";
    }

    public static boolean getBoolean(TownyObject townyObject, BooleanDataField bdf) {
        CustomDataField<?> cdf = townyObject.getMetadata(bdf.getKey());
        if (cdf instanceof BooleanDataField) {
            return (Boolean)((BooleanDataField)cdf).getValue();
        }
        return false;
    }

    public static long getLong(TownyObject townyObject, LongDataField ldf) {
        CustomDataField<?> cdf = townyObject.getMetadata(ldf.getKey());
        if (cdf instanceof LongDataField) {
            return (Long)((LongDataField)cdf).getValue();
        }
        return 0L;
    }

    public static int getInt(TownyObject townyObject, IntegerDataField idf) {
        CustomDataField<?> cdf = townyObject.getMetadata(idf.getKey());
        if (cdf instanceof IntegerDataField) {
            return (Integer)((IntegerDataField)cdf).getValue();
        }
        return 0;
    }

    public static double getDouble(TownyObject townyObject, DecimalDataField ddf) {
        CustomDataField<?> cdf = townyObject.getMetadata(ddf.getKey());
        if (cdf instanceof DecimalDataField) {
            return (Double)((DecimalDataField)cdf).getValue();
        }
        return 0.0;
    }

    public static void addNewMeta(TownyObject townyObject, StringDataField sdf, boolean save) {
        townyObject.addMetaData(sdf, save);
    }

    public static void addNewMeta(TownyObject townyObject, BooleanDataField bdf, boolean save) {
        townyObject.addMetaData(bdf, save);
    }

    public static void addNewMeta(TownyObject townyObject, LongDataField ldf, boolean save) {
        townyObject.addMetaData(ldf, save);
    }

    public static void addNewMeta(TownyObject townyObject, IntegerDataField idf, boolean save) {
        townyObject.addMetaData(idf, save);
    }

    public static void addNewMeta(TownyObject townyObject, DecimalDataField ddf, boolean save) {
        townyObject.addMetaData(ddf, save);
    }

    public static void addNewStringMeta(TownyObject townyObject, String key, String value, boolean save) {
        MetaDataUtil.addNewMeta(townyObject, new StringDataField(key, value), save);
    }

    public static void addNewBooleanMeta(TownyObject townyObject, String key, boolean value, boolean save) {
        MetaDataUtil.addNewMeta(townyObject, new BooleanDataField(key, value), save);
    }

    public static void addNewLongMeta(TownyObject townyObject, String key, long value, boolean save) {
        MetaDataUtil.addNewMeta(townyObject, new LongDataField(key, value), save);
    }

    public static void addNewIntegerMeta(TownyObject townyObject, String key, int value, boolean save) {
        MetaDataUtil.addNewMeta(townyObject, new IntegerDataField(key, value), save);
    }

    public static void addNewDoubleMeta(TownyObject townyObject, String key, double value, boolean save) {
        MetaDataUtil.addNewMeta(townyObject, new DecimalDataField(key, value), save);
    }

    public static void setString(TownyObject townyObject, StringDataField sdf, String string, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(sdf.getKey());
        if (cdf instanceof StringDataField) {
            StringDataField value = (StringDataField)cdf;
            value.setValue(string);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setBoolean(TownyObject townyObject, BooleanDataField bdf, boolean bool, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(bdf.getKey());
        if (cdf instanceof BooleanDataField) {
            BooleanDataField value = (BooleanDataField)cdf;
            value.setValue(bool);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setLong(TownyObject townyObject, LongDataField ldf, long num, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(ldf.getKey());
        if (cdf instanceof LongDataField) {
            LongDataField value = (LongDataField)cdf;
            value.setValue(num);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setInt(TownyObject townyObject, IntegerDataField idf, int num, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(idf.getKey());
        if (cdf instanceof IntegerDataField) {
            IntegerDataField value = (IntegerDataField)cdf;
            value.setValue(num);
            if (save) {
                townyObject.save();
            }
        }
    }

    public static void setDouble(TownyObject townyObject, DecimalDataField ddf, double num, boolean save) {
        CustomDataField<?> cdf = townyObject.getMetadata(ddf.getKey());
        if (cdf instanceof DecimalDataField) {
            DecimalDataField value = (DecimalDataField)cdf;
            value.setValue(num);
            if (save) {
                townyObject.save();
            }
        }
    }
}

