/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AreaSelectionUtil {
    private static final int MAX_RECT_RADIUS = 15;
    private static final int MAX_CIRC_RADIUS = 18;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<WorldCoord> selectWorldCoordArea(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        List<WorldCoord> out = new ArrayList<WorldCoord>();
        if (args.length == 0) {
            out.add(pos);
            return out;
        } else {
            int available = 0;
            if (owner instanceof Town) {
                Town town = (Town)owner;
                available = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
            } else if (owner instanceof Resident) {
                available = TownySettings.getMaxResidentPlots((Resident)owner);
            }
            if (args.length > 1) {
                if (args[0].equalsIgnoreCase("rect")) {
                    return AreaSelectionUtil.selectWorldCoordAreaRect(available, pos, StringMgmt.remFirstArg(args));
                }
                if (args[0].equalsIgnoreCase("circle")) {
                    return AreaSelectionUtil.selectWorldCoordAreaCircle(available, pos, StringMgmt.remFirstArg(args));
                }
                if (args.length != 3 || !args[1].startsWith("x") || !args[2].startsWith("z")) throw new TownyException(Translatable.of("msg_err_invalid_property", StringMgmt.join(args, " ")));
                out.add(new WorldCoord(args[0], Integer.parseInt(args[1].replace("x", "")), Integer.parseInt(args[2].replace("z", ""))));
                return out;
            } else {
                if (args[0].equalsIgnoreCase("auto")) {
                    return AreaSelectionUtil.selectWorldCoordAreaRect(available, pos, args);
                }
                try {
                    Integer.parseInt(args[0]);
                    return AreaSelectionUtil.selectWorldCoordAreaRect(available, pos, args);
                }
                catch (NumberFormatException e) {
                    throw new TownyException(Translatable.of("msg_err_invalid_property", args[0]));
                }
            }
        }
    }

    private static List<WorldCoord> selectWorldCoordAreaRect(int available, WorldCoord pos, String[] args) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (args.length > 0) {
            int r = 15;
            if (args[0].equalsIgnoreCase("auto")) {
                if (TownySettings.getMaxClaimRadiusValue() > 0) {
                    r = Math.min(r, TownySettings.getMaxClaimRadiusValue());
                }
            } else {
                int claimRadius;
                try {
                    r = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius"));
                }
                if (TownySettings.getMaxClaimRadiusValue() > 0 && r > TownySettings.getMaxClaimRadiusValue()) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius_number", TownySettings.getMaxClaimRadiusValue()));
                }
                int needed = pos.getTownBlock().hasTown() ? 0 : 1;
                for (claimRadius = 1; claimRadius <= r && needed < available; needed += claimRadius * 8, ++claimRadius) {
                }
                r = claimRadius - 1;
            }
            int halfSideLength = (r * 2 + 1) / 2;
            int x = 0;
            int z = 0;
            int dx = 0;
            int dz = -1;
            for (int i = 0; i <= available; ++i) {
                if (-halfSideLength <= x && x <= halfSideLength && -halfSideLength <= z && z <= halfSideLength) {
                    out.add(pos.add(x, z));
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int swap = dx;
                    dx = -dz;
                    dz = swap;
                }
                x += dx;
                z += dz;
            }
        } else {
            throw new TownyException(Translatable.of("msg_err_invalid_radius"));
        }
        out.remove(0);
        return out;
    }

    private static List<WorldCoord> selectWorldCoordAreaCircle(int available, WorldCoord pos, String[] args) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (args.length > 0) {
            int r = 18;
            if (args[0].equalsIgnoreCase("auto")) {
                if (available > 0) {
                    while ((double)available - Math.ceil(Math.PI * (double)r * (double)r) >= 0.0) {
                        ++r;
                    }
                }
                if (TownySettings.getMaxClaimRadiusValue() > 0) {
                    r = Math.min(r, TownySettings.getMaxClaimRadiusValue());
                }
            } else {
                try {
                    r = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius"));
                }
                if (TownySettings.getMaxClaimRadiusValue() > 0 && r > TownySettings.getMaxClaimRadiusValue()) {
                    throw new TownyException(Translatable.of("msg_err_invalid_radius_number", TownySettings.getMaxClaimRadiusValue()));
                }
                int radius = 0;
                if (available > 0) {
                    while ((double)available - Math.ceil(Math.PI * (double)radius * (double)radius) >= 0.0) {
                        ++radius;
                    }
                }
                r = Math.min(r, --radius);
            }
            int halfSideLength = (r * 2 + 1) / 2;
            int x = 0;
            int z = 0;
            int dx = 0;
            int dz = -1;
            for (int i = 0; i <= available; ++i) {
                if (-halfSideLength <= x && x <= halfSideLength && -halfSideLength <= z && z <= halfSideLength && MathUtil.distanceSquared(x, z) <= MathUtil.sqr(r) && out.size() <= available) {
                    out.add(pos.add(x, z));
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int swap = dx;
                    dx = -dz;
                    dz = swap;
                }
                x += dx;
                z += dz;
            }
        } else {
            throw new TownyException(Translatable.of("msg_err_invalid_radius"));
        }
        return out;
    }

    public static List<WorldCoord> filterInvalidProximityTownBlocks(List<WorldCoord> selection, Town town) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownyWorld().getMinDistanceFromOtherTownsPlots(worldCoord, town) >= TownySettings.getMinDistanceFromTownPlotblocks()) {
                    out.add(worldCoord);
                    continue;
                }
                TownyMessaging.sendDebugMsg("AreaSelectionUtil:filterInvalidProximity - Coord: " + worldCoord + " too close to another town.");
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterInvalidProximityToHomeblock(List<WorldCoord> selection, Town town) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownyWorld().getMinDistanceFromOtherTowns(worldCoord, town) >= TownySettings.getMinDistanceFromTownHomeblocks()) {
                    out.add(worldCoord);
                    continue;
                }
                TownyMessaging.sendDebugMsg("AreaSelectionUtil:filterInvalidProximity - Coord: " + worldCoord + " too close to another town's homeblock.");
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterOutTownOwnedBlocks(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownBlock().hasTown()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException e) {
                out.add(worldCoord);
            }
        }
        return out;
    }

    public static List<WorldCoord> filterOutWildernessBlocks(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().hasTown()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterOwnedBlocks(TownBlockOwner owner, List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().isOwner(owner)) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterUnownedBlocks(TownBlockOwner owner, List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownBlock().isOwner(owner)) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static boolean filterHomeBlock(Town town, List<WorldCoord> selection) {
        WorldCoord homeCoord;
        try {
            homeCoord = town.getHomeBlock().getWorldCoord();
        }
        catch (TownyException ignore) {
            return false;
        }
        return selection.removeIf(worldCoord -> worldCoord.equals(homeCoord));
    }

    public static List<WorldCoord> filterPlotsByGroup(PlotGroup group, List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                if (!townBlock.hasPlotObjectGroup() || !townBlock.getPlotObjectGroup().equals(group)) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static HashSet<PlotGroup> getPlotGroupsFromSelection(List<WorldCoord> selection) {
        HashSet<PlotGroup> seenGroups = new HashSet<PlotGroup>();
        for (WorldCoord coord : selection) {
            PlotGroup group = null;
            try {
                group = coord.getTownBlock().getPlotObjectGroup();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            if (seenGroups.contains(group)) continue;
            seenGroups.add(group);
        }
        return seenGroups;
    }

    public static List<WorldCoord> filterPlotsForSale(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownBlock().hasPlotObjectGroup() && worldCoord.getTownBlock().getPlotObjectGroup().getPrice() != -1.0) {
                    out.clear();
                    out.add(worldCoord);
                    return out;
                }
                if (!worldCoord.getTownBlock().isForSale()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterPlotsNotForSale(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownBlock().isForSale()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static List<WorldCoord> filterOutResidentBlocks(Resident resident, List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownBlock().hasResident() && (!worldCoord.getTownBlock().hasResident() || !worldCoord.getTownBlock().getResidentOrNull().equals(resident))) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return out;
    }

    public static int getAreaSelectPivot(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("within")) continue;
            return i;
        }
        return -1;
    }

    public static boolean isOnEdgeOfOwnership(TownBlockOwner owner, WorldCoord worldCoord) {
        int[][] offset = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        for (int i = 0; i < 4; ++i) {
            try {
                TownBlock edgeTownBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + offset[i][0], worldCoord.getZ() + offset[i][1]));
                if (edgeTownBlock.isOwner(owner)) continue;
                return true;
            }
            catch (NotRegisteredException e) {
                return true;
            }
        }
        return false;
    }
}

