/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.TownClaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TownClaim
extends Thread {
    Towny plugin;
    private final Player player;
    private Location outpostLocation;
    private volatile Town town;
    private final List<WorldCoord> selection;
    private boolean outpost;
    private final boolean claim;
    private final boolean forced;

    public TownClaim(Towny plugin, Player player, Town town, List<WorldCoord> selection, boolean isOutpost, boolean claim, boolean forced) {
        this.plugin = plugin;
        this.player = player;
        if (this.player != null) {
            this.outpostLocation = player.getLocation();
        }
        this.town = town;
        this.selection = selection;
        this.outpost = isOutpost;
        this.claim = claim;
        this.forced = forced;
        this.setPriority(1);
    }

    @Override
    public void run() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<TownyWorld> worlds = new ArrayList<TownyWorld>();
        ArrayList<Town> towns = new ArrayList<Town>();
        TownyWorld world = null;
        if (this.player != null) {
            if (this.claim) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_process_town_claim"));
            } else {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_process_town_unclaim"));
            }
        }
        if (this.selection != null) {
            for (WorldCoord worldCoord : this.selection) {
                try {
                    world = worldCoord.getTownyWorld();
                    if (!worlds.contains(world)) {
                        worlds.add(world);
                    }
                    if (this.claim) {
                        this.townClaim(this.town, worldCoord, this.outpost, this.player);
                        this.outpost = false;
                    } else {
                        this.town = worldCoord.getTownBlock().getTown();
                        this.townUnclaim(this.town, worldCoord, this.forced);
                    }
                    if (towns.contains(this.town)) continue;
                    towns.add(this.town);
                }
                catch (NotRegisteredException e) {
                    TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_err_not_configured"));
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)this.player, x.getMessage());
                }
            }
            if (!this.claim && TownySettings.getClaimRefundPrice() > 0.0) {
                this.town.getAccount().deposit(TownySettings.getClaimRefundPrice() * (double)this.selection.size(), "Town Unclaim Refund");
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("refund_message", TownySettings.getClaimRefundPrice() * (double)this.selection.size(), this.selection.size()));
            }
        } else if (!this.claim) {
            Resident resident;
            if (this.town == null) {
                TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_err_nothing_to_unclaim"));
                return;
            }
            Resident resident2 = resident = this.player != null ? townyUniverse.getResident(this.player.getUniqueId()) : null;
            if (resident == null) {
                return;
            }
            int townSize = this.town.getTownBlocks().size() - 1;
            double refund = TownySettings.getClaimRefundPrice() * (double)townSize;
            Confirmation.runOnAccept(() -> {
                TownClaim.townUnclaimAll(this.plugin, this.town);
                if (TownyEconomyHandler.isActive() && refund > 0.0) {
                    this.town.getAccount().deposit(TownySettings.getClaimRefundPrice() * (double)townSize - 1.0, "Town Unclaim Refund");
                    TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("refund_message", TownySettings.getClaimRefundPrice() * (double)townSize, townSize));
                }
            }).sendTo((CommandSender)this.player);
        }
        if (!towns.isEmpty()) {
            for (Town test : towns) {
                test.save();
            }
        }
        if (!worlds.isEmpty()) {
            for (TownyWorld test : worlds) {
                test.save();
            }
        }
        this.plugin.resetCache();
        if (this.player != null) {
            if (this.claim) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_annexed_area", this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                if (world != null && world.isUsingPlotManagementRevert()) {
                    TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_wait_locked"));
                }
            } else if (this.forced) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_admin_unclaim_area", this.selection.size() > 5 ? "Total TownBlocks: " + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                if (this.town != null && world != null && world.isUsingPlotManagementRevert()) {
                    TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_wait_locked"));
                }
            }
        }
    }

    private void townClaim(Town town, WorldCoord worldCoord, boolean isOutpost, Player player) throws TownyException {
        if (TownyUniverse.getInstance().hasTownBlock(worldCoord)) {
            throw new AlreadyRegisteredException(Translatable.of("msg_already_claimed", "some town").forLocale((CommandSender)player));
        }
        TownBlock townBlock = new TownBlock(worldCoord.getX(), worldCoord.getZ(), worldCoord.getTownyWorld());
        townBlock.setTown(town);
        townBlock.setType(townBlock.getType());
        if (isOutpost) {
            townBlock.setOutpost(true);
            town.addOutpostSpawn(this.outpostLocation);
        }
        if (worldCoord.getTownyWorld().isUsingPlotManagementRevert() && TownySettings.getPlotManagementSpeed() > 0L) {
            if (TownyRegenAPI.getRegenQueueList().contains(townBlock.getWorldCoord())) {
                PlotBlockData plotChunk = TownyRegenAPI.getPlotChunk(townBlock);
                if (plotChunk != null) {
                    TownyRegenAPI.removeFromActiveRegeneration(plotChunk);
                    townBlock.setLocked(false);
                }
                TownyRegenAPI.removeFromRegenQueueList(worldCoord);
            }
            TownyRegenAPI.addWorldCoord(townBlock.getWorldCoord());
            townBlock.setLocked(true);
        }
        townBlock.save();
        BukkitTools.getPluginManager().callEvent((Event)new TownClaimEvent(townBlock, player));
    }

    private void townUnclaim(Town town, WorldCoord worldCoord, boolean force) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            if (town != townBlock.getTown() && !force) {
                throw new TownyException(Translatable.of("msg_area_not_own"));
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> townyUniverse.getDataSource().removeTownBlock(townBlock), 1L);
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
    }

    public static void townUnclaimAll(Towny plugin, Town town) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
            ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>(town.getTownBlocks());
            for (TownBlock townBlock : townBlocks) {
                try {
                    if (town.hasHomeBlock() && townBlock.equals(town.getHomeBlock())) continue;
                    TownyUniverse.getInstance().getDataSource().removeTownBlock(townBlock);
                }
                catch (TownyException townyException) {}
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_abandoned_area_1"));
        }, 1L);
    }
}

