/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

public class ResidentPurge
extends Thread {
    final Towny plugin;
    private final CommandSender sender;
    final long deleteTime;
    final boolean townless;
    final Town town;

    public ResidentPurge(Towny plugin, CommandSender sender, long deleteTime, boolean townless, @Nullable Town town) {
        this.plugin = plugin;
        this.deleteTime = deleteTime;
        this.setPriority(5);
        this.townless = townless;
        this.sender = sender;
        this.town = town;
    }

    @Override
    public void run() {
        int count = 0;
        this.message(Translatable.of("msg_scanning_for_old_residents"));
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Resident> residentList = this.town != null ? new ArrayList(this.town.getResidents()) : new ArrayList<Resident>(townyUniverse.getResidents());
        for (Resident resident : residentList) {
            if (resident.isNPC() || System.currentTimeMillis() - resident.getLastOnline() <= this.deleteTime || BukkitTools.isOnline(resident.getName()) || this.townless && resident.hasTown()) continue;
            ++count;
            this.message(Translatable.of("msg_deleting_resident", resident.getName()));
            townyUniverse.getDataSource().removeResident(resident);
        }
        this.message(Translatable.of("msg_purge_complete", count));
    }

    private void message(Translatable msg) {
        if (this.sender != null) {
            TownyMessaging.sendMsg(this.sender, msg);
        } else {
            TownyMessaging.sendMsg(msg);
        }
    }
}

