/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.util.ArrayList;

public class RepeatingTimerTask
extends TownyTimerTask {
    private Long timerCounter = 0L;

    public RepeatingTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        if (TownyRegenAPI.hasActiveRegenerations()) {
            this.revertAnotherBlockToWilderness();
        }
        if (TownyRegenAPI.getPlotChunks().size() < 20 && TownyRegenAPI.regenQueueHasAvailable()) {
            this.getWorldCoordFromQueueForRegeneration();
        }
        if (TownyRegenAPI.hasWorldCoords()) {
            this.makeNextPlotSnapshot();
        }
        if (TownyRegenAPI.hasDeleteTownBlockIdQueue()) {
            TownyRegenAPI.doDeleteTownBlockIds(TownyRegenAPI.getDeleteTownBlockIdQueue());
        }
    }

    private void revertAnotherBlockToWilderness() {
        this.timerCounter = this.timerCounter + 1L;
        if (Math.max(1L, TownySettings.getPlotManagementSpeed()) > this.timerCounter) {
            return;
        }
        for (PlotBlockData plotBlockData : TownyRegenAPI.getActivePlotBlockDatas()) {
            if (plotBlockData == null || plotBlockData.restoreNextBlock()) continue;
            TownyRegenAPI.finishPlotBlockData(plotBlockData);
        }
        this.timerCounter = 0L;
    }

    private void getWorldCoordFromQueueForRegeneration() {
        for (WorldCoord wc : new ArrayList<WorldCoord>(TownyRegenAPI.getRegenQueueList())) {
            if (TownyRegenAPI.getPlotChunks().size() >= 20) break;
            if (TownyRegenAPI.hasActiveRegeneration(wc)) continue;
            PlotBlockData plotData = TownyRegenAPI.getPlotChunkSnapshot(new TownBlock(wc.getX(), wc.getZ(), wc.getTownyWorldOrNull()));
            if (plotData != null) {
                TownyRegenAPI.addToActiveRegeneration(plotData);
                TownyMessaging.sendDebugMsg("Revert on unclaim beginning for " + plotData.getWorldName() + " " + plotData.getX() + "," + plotData.getZ());
                continue;
            }
            TownyRegenAPI.removeFromRegenQueueList(wc);
        }
    }

    private void makeNextPlotSnapshot() {
        WorldCoord wc = TownyRegenAPI.getWorldCoord();
        TownBlock townBlock = wc.getTownBlockOrNull();
        if (townBlock == null) {
            return;
        }
        PlotBlockData plotChunk = new PlotBlockData(townBlock);
        plotChunk.initialize();
        if (!plotChunk.getBlockList().isEmpty() && plotChunk.getBlockList() != null) {
            TownyRegenAPI.addPlotChunkSnapshot(plotChunk);
        }
        plotChunk = null;
        townBlock.setLocked(false);
        townBlock.save();
        this.plugin.updateCache(townBlock.getWorldCoord());
        if (!TownyRegenAPI.hasWorldCoords()) {
            TownyMessaging.sendDebugMsg("Plot snapshots completed.");
        }
    }
}

