/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.earth2me.essentials.Essentials;
import com.palmergames.adventure.audience.Audience;
import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.TownyUpdateChecker;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OnPlayerLogin
implements Runnable {
    Towny plugin;
    TownyUniverse universe;
    volatile Player player;

    public OnPlayerLogin(Towny plugin, Player player) {
        this.plugin = plugin;
        this.universe = TownyUniverse.getInstance();
        this.player = player;
    }

    @Override
    public void run() {
        Resident resident = null;
        if (!this.universe.hasResident(this.player.getUniqueId())) {
            resident = this.universe.getResident(this.player.getName());
            if (resident != null && !resident.hasUUID()) {
                this.loginExistingResident(resident);
            } else if (resident != null && !resident.getUUID().equals(this.player.getUniqueId())) {
                try {
                    this.universe.unregisterResident(resident);
                    resident.setUUID(this.player.getUniqueId());
                    this.universe.registerResident(resident);
                }
                catch (AlreadyRegisteredException | NotRegisteredException townyException) {
                    // empty catch block
                }
                this.loginExistingResident(resident);
            } else {
                try {
                    Town town;
                    this.universe.getDataSource().newResident(this.player.getName(), this.player.getUniqueId());
                    TownySettings.incrementUUIDCount();
                    resident = this.universe.getResident(this.player.getUniqueId());
                    if (TownySettings.isShowingRegistrationMessage()) {
                        TownyMessaging.sendGlobalMessage(Translatable.of("msg_registration", this.player.getName()));
                    }
                    long registered = System.currentTimeMillis();
                    if (this.universe.hasHibernatedResdient(this.player.getUniqueId())) {
                        registered = this.universe.getHibernatedResidentRegistered(this.player.getUniqueId());
                        this.universe.getDataSource().removeHibernatedResident(this.player.getUniqueId());
                    }
                    resident.setRegistered(registered);
                    resident.setLastOnline(System.currentTimeMillis());
                    if (!TownySettings.getDefaultTownName().equals("") && (town = TownyUniverse.getInstance().getTown(TownySettings.getDefaultTownName())) != null) {
                        try {
                            resident.setTown(town);
                            town.save();
                        }
                        catch (AlreadyRegisteredException alreadyRegisteredException) {
                            // empty catch block
                        }
                    }
                    resident.save();
                }
                catch (AlreadyRegisteredException | NotRegisteredException registered) {}
            }
        } else {
            resident = this.universe.getResident(this.player.getUniqueId());
            if (!resident.getName().equals(this.player.getName())) {
                try {
                    this.universe.getDataSource().renamePlayer(resident, this.player.getName());
                }
                catch (AlreadyRegisteredException e) {
                    e.printStackTrace();
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
            }
            resident = this.universe.getResident(this.player.getUniqueId());
            this.loginExistingResident(resident);
        }
        if (resident != null) {
            TownyPerms.assignPermissions(resident, this.player);
            if (resident.hasTown()) {
                Town town = resident.getTownOrNull();
                Nation nation = resident.getNationOrNull();
                if (TownySettings.getShowTownBoardOnLogin() && !town.getBoard().isEmpty()) {
                    TownyMessaging.sendTownBoard(this.player, town);
                }
                if (TownySettings.getShowNationBoardOnLogin() && nation != null && !nation.getBoard().isEmpty()) {
                    TownyMessaging.sendNationBoard((CommandSender)this.player, nation);
                }
                if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
                    this.warningMessage(resident, town, nation);
                }
                if (town.isRuined()) {
                    TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_your_town_is_ruined_for_x_more_hours", TownySettings.getTownRuinsMaxDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
                }
            }
            if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.player.getName(), false), 1L) == -1) {
                TownyMessaging.sendErrorMsg("Could not set default modes for " + this.player.getName() + ".");
            }
            if (TownyUpdateChecker.shouldShowNotification() && this.player.hasPermission(PermissionNodes.TOWNY_ADMIN_UPDATEALERTS.getNode())) {
                Audience audience = Towny.getAdventure().player(this.player);
                ClickEvent clickEvent = ClickEvent.openUrl(TownyUpdateChecker.getUpdateURL());
                audience.sendMessage(Component.text(Translatable.of("default_towny_prefix").forLocale((CommandSender)this.player) + Translatable.of("msg_new_update_available", TownyUpdateChecker.getNewVersion(), Towny.getPlugin().getVersion()).forLocale((CommandSender)this.player)).clickEvent(clickEvent));
                audience.sendMessage(Component.text(Translatable.of("default_towny_prefix").forLocale((CommandSender)this.player) + Translatable.of("msg_click_to_download").forLocale((CommandSender)this.player)).clickEvent(clickEvent));
            }
        }
    }

    private void loginExistingResident(Resident resident) {
        if (TownySettings.isUsingEssentials()) {
            Essentials ess = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
            if (!ess.getUser(this.player).isVanished()) {
                resident.setLastOnline(System.currentTimeMillis());
            }
        } else {
            resident.setLastOnline(System.currentTimeMillis());
        }
        if (!resident.hasUUID()) {
            resident.setUUID(this.player.getUniqueId());
            try {
                TownyUniverse.getInstance().registerResidentUUID(resident);
            }
            catch (AlreadyRegisteredException e) {
                e.printStackTrace();
            }
            TownySettings.incrementUUIDCount();
        }
        resident.save();
    }

    private void warningMessage(Resident resident, Town town, Nation nation) {
        double upkeep;
        if (town.hasUpkeep() && (upkeep = TownySettings.getTownUpkeepCost(town)) > 0.0 && !town.getAccount().canPayFromHoldings(upkeep)) {
            if (TownySettings.isTownBankruptcyEnabled()) {
                if (!town.isBankrupt()) {
                    TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_bankrupt", town.getName()));
                }
            } else {
                TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_delete", town.getName()));
            }
        }
        if (nation != null && (upkeep = TownySettings.getNationUpkeepCost(nation)) > 0.0 && !nation.getAccount().canPayFromHoldings(upkeep)) {
            TownyMessaging.sendMsg(resident, Translatable.of("msg_warning_delete", nation.getName()));
        }
    }
}

