/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.tasks.DailyTimerTask;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.Calendar;
import java.util.TimeZone;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class NewDayScheduler
extends TownyTimerTask {
    private static int scheduleTask = -1;

    public NewDayScheduler(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        long secondsUntilNextNewDay = NewDayScheduler.townyTime();
        this.plugin.getLogger().info("Time until a New Day: " + TimeMgmt.formatCountdownTime(secondsUntilNextNewDay));
        if (secondsUntilNextNewDay < TimeTools.secondsFromDhms("2m")) {
            TownyMessaging.sendDebugMsg("New Day time finalized for: " + TimeMgmt.formatCountdownTime(secondsUntilNextNewDay) + " from now.");
            this.scheduleUpComingNewDay(secondsUntilNextNewDay);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)new NewDayScheduler(this.plugin), secondsUntilNextNewDay / 2L * 20L);
            TownyMessaging.sendDebugMsg("Re-evaluation of New Day time scheduled for: " + TimeMgmt.formatCountdownTime(secondsUntilNextNewDay / 2L) + " from now.");
        }
    }

    private void scheduleUpComingNewDay(long secondsUntilNextNewDay) {
        scheduleTask = TownySettings.isEconomyAsync() ? Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)new DailyTimerTask(this.plugin), secondsUntilNextNewDay * 20L).getTaskId() : Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new DailyTimerTask(this.plugin), secondsUntilNextNewDay * 20L).getTaskId();
        if (scheduleTask == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule DailyTimerTask.");
        }
    }

    public static boolean isNewDaySchedulerRunning() {
        return scheduleTask != -1;
    }

    public static void cancelScheduledNewDay() {
        if (scheduleTask != -1) {
            Bukkit.getScheduler().cancelTask(scheduleTask);
        }
    }

    public static void newDay() {
        if (TownySettings.isEconomyAsync()) {
            if (BukkitTools.scheduleAsyncDelayedTask(new DailyTimerTask(Towny.getPlugin()), 0L) == -1) {
                TownyMessaging.sendErrorMsg("Could not run newDay.");
            }
        } else if (BukkitTools.scheduleSyncDelayedTask(new DailyTimerTask(Towny.getPlugin()), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not run newDay.");
        }
    }

    public static Long townyTime() {
        long secondsInDay = TownySettings.getDayInterval();
        Calendar now = Calendar.getInstance();
        TimeZone timeZone = now.getTimeZone();
        long timeMilli = System.currentTimeMillis();
        int timeOffset = timeZone.getOffset(timeMilli) / 1000;
        return Math.floorMod(secondsInDay + (TownySettings.getNewDayTime() - timeMilli / 1000L % secondsInDay - (long)timeOffset), secondsInDay);
    }
}

