/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyPerms {
    protected static LinkedHashMap<String, Permission> registeredPermissions = new LinkedHashMap();
    protected static HashMap<String, PermissionAttachment> attachments = new HashMap();
    private static HashMap<String, List<String>> groupPermsMap = new HashMap();
    private static CommentedConfiguration perms;
    private static Towny plugin;
    private static List<String> vitalGroups;
    private static Field permissions;

    public static void initialize(Towny plugin) {
        TownyPerms.plugin = plugin;
    }

    public static void loadPerms(@NotNull Path permsYMLPath) {
        try {
            InputStream resource = Towny.class.getResourceAsStream("/townyperms.yml");
            if (resource == null) {
                throw new TownyInitException("Could not find 'townyperms.yml' in the JAR.", TownyInitException.TownyError.PERMISSIONS);
            }
            Files.copy(resource, permsYMLPath, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException resource) {
        }
        catch (IOException e) {
            throw new TownyInitException("Could not copy townyperms.yml from JAR to '" + permsYMLPath + "'.", TownyInitException.TownyError.PERMISSIONS, e);
        }
        perms = new CommentedConfiguration(permsYMLPath);
        if (!perms.load()) {
            throw new TownyInitException("Could not read townyperms.yml", TownyInitException.TownyError.PERMISSIONS);
        }
        groupPermsMap.clear();
        TownyPerms.buildGroupPermsMap();
        TownyPerms.checkForVitalGroups();
        TownyPerms.buildComments();
        perms.save();
        TownyPerms.collectPermissions();
    }

    private static void checkForVitalGroups() {
        for (String group : vitalGroups) {
            if (groupPermsMap.containsKey(group)) continue;
            throw new TownyInitException(TownyPerms.getErrorMessageForGroup(group), TownyInitException.TownyError.PERMISSIONS);
        }
    }

    @NotNull
    private static String getErrorMessageForGroup(String group) {
        if (!group.contains(".")) {
            return "Your townyperms.yml is missing the " + group + " group. Maybe you renamed it?";
        }
        String[] split = group.split(".");
        return "Your townyperms.yml's " + split[0] + " section is missing the " + split[1] + " group. Maybe you renamed it?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignPermissions(Resident resident, Player player) {
        PermissionAttachment playersAttachment;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (resident == null) {
            if (player != null) {
                resident = townyUniverse.getResident(player.getUniqueId());
            }
            if (resident == null) {
                return;
            }
        } else {
            player = BukkitTools.getPlayer(resident.getName());
        }
        if (player == null || !player.isOnline()) {
            attachments.remove(resident.getName());
            return;
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld().getName());
        if (world == null) {
            return;
        }
        if (attachments.containsKey(resident.getName())) {
            playersAttachment = attachments.get(resident.getName());
        } else {
            try {
                playersAttachment = BukkitTools.getPlayer(resident.getName()).addAttachment((Plugin)plugin);
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            PermissionAttachment e = playersAttachment;
            synchronized (e) {
                Map orig = (Map)permissions.get(playersAttachment);
                orig.clear();
                if (world.isUsingTowny()) {
                    orig.putAll(TownyPerms.getResidentPerms(resident));
                }
                playersAttachment.getPermissible().recalculatePermissions();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        attachments.put(resident.getName(), playersAttachment);
    }

    public static void removeAttachment(String name) {
        attachments.remove(name);
    }

    public static void updateOnlinePerms() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            TownyPerms.assignPermissions(null, player);
        }
    }

    public static void updateTownPerms(Town town) {
        for (Resident resident : town.getResidents()) {
            TownyPerms.assignPermissions(resident, null);
        }
    }

    public static void updateNationPerms(Nation nation) {
        for (Town town : nation.getTowns()) {
            TownyPerms.updateTownPerms(town);
        }
    }

    private static List<String> getList(String path) {
        if (perms.contains(path)) {
            return perms.getStringList(path);
        }
        return null;
    }

    public static LinkedHashMap<String, Boolean> getResidentPerms(Resident resident) {
        HashSet<String> permList = new HashSet<String>(TownyPerms.getDefault());
        if (resident.hasTown()) {
            permList.addAll(TownyPerms.getTownDefault(resident.getTownOrNull()));
            if (resident.isMayor()) {
                permList.addAll(TownyPerms.getTownMayor());
            }
            for (String rank : resident.getTownRanks()) {
                permList.addAll(TownyPerms.getTownRank(rank));
            }
            if (resident.hasNation()) {
                permList.addAll(TownyPerms.getNationDefault());
                if (resident.isKing()) {
                    permList.addAll(TownyPerms.getNationKing());
                }
                for (String rank : resident.getNationRanks()) {
                    permList.addAll(TownyPerms.getNationRank(rank));
                }
            }
        } else {
            permList.add("towny.townless");
        }
        List<String> playerPermArray = TownyPerms.sort(new ArrayList<String>(permList));
        LinkedHashMap<String, Boolean> newPerms = new LinkedHashMap<String, Boolean>();
        Boolean value = false;
        for (String permission : playerPermArray) {
            String placeholderPerm;
            if (permission.contains("{townname}")) {
                if (!resident.hasTown()) continue;
                placeholderPerm = permission.replace("{townname}", resident.getTownOrNull().getName().toLowerCase());
                newPerms.put(placeholderPerm, true);
                continue;
            }
            if (permission.contains("{nationname}")) {
                if (!resident.hasNation()) continue;
                placeholderPerm = permission.replace("{nationname}", resident.getTownOrNull().getNationOrNull().getName().toLowerCase());
                newPerms.put(placeholderPerm, true);
                continue;
            }
            value = !permission.startsWith("-");
            newPerms.put(value != false ? permission : permission.substring(1), value);
        }
        return newPerms;
    }

    public static void registerPermissionNodes() {
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                Permission perm;
                for (String rank : TownyPerms.getTownRanks()) {
                    perm = new Permission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(rank), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                    perm.addParent(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(), true);
                }
                for (String rank : TownyPerms.getNationRanks()) {
                    perm = new Permission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                    perm.addParent(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(), true);
                }
            }
        }, 1L);
    }

    public static List<String> getDefault() {
        ArrayList permsList = TownyPerms.getList("nomad");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getTownRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("towns.ranks")).getKeys(false));
    }

    public static List<String> getTownDefault(Town town) {
        List<String> permsList = TownyPerms.getList("towns.default");
        if (permsList == null) {
            ArrayList<String> emptyPermsList = new ArrayList<String>();
            emptyPermsList.add("towny.town." + town.getName().toLowerCase());
            return emptyPermsList;
        }
        permsList.add("towny.town." + town.getName().toLowerCase());
        return permsList;
    }

    public static List<String> getTownMayor() {
        ArrayList permsList = TownyPerms.getList("towns.mayor");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getTownRank(String rank) {
        ArrayList permsList = TownyPerms.getList("towns.ranks." + rank);
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getNationRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("nations.ranks")).getKeys(false));
    }

    public static List<String> getNationDefault() {
        ArrayList permsList = TownyPerms.getList("nations.default");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getNationKing() {
        ArrayList permsList = TownyPerms.getList("nations.king");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getNationRank(String rank) {
        ArrayList permsList = TownyPerms.getList("nations.ranks." + rank);
        return permsList == null ? new ArrayList() : permsList;
    }

    @Nullable
    public static String matchNationRank(String rank) {
        for (String nationRank : TownyPerms.getNationRanks()) {
            if (!nationRank.equalsIgnoreCase(rank)) continue;
            return nationRank;
        }
        return null;
    }

    @Nullable
    public static String matchTownRank(String rank) {
        for (String townRank : TownyPerms.getTownRanks()) {
            if (!townRank.equalsIgnoreCase(rank)) continue;
            return townRank;
        }
        return null;
    }

    public static void collectPermissions() {
        registeredPermissions.clear();
        for (Permission perm : BukkitTools.getPluginManager().getPermissions()) {
            registeredPermissions.put(perm.getName().toLowerCase(), perm);
        }
    }

    private static List<String> sort(List<String> permList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : permList) {
            String a = key.charAt(0) == '-' ? key.substring(1) : key;
            Map<String, Boolean> allchildren = TownyPerms.getAllChildren(a, new HashSet<String>());
            if (allchildren != null) {
                ListIterator<String> itr = result.listIterator();
                while (itr.hasNext()) {
                    String node = (String)itr.next();
                    String b = node.charAt(0) == '-' ? node.substring(1) : node;
                    if (!allchildren.containsKey(b)) continue;
                    itr.set(key);
                    itr.add(node);
                    break;
                }
            }
            if (result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public List<String> getAllRegisteredPermissions(boolean includeChildren) {
        ArrayList<String> perms = new ArrayList<String>();
        for (String key : registeredPermissions.keySet()) {
            Map<String, Boolean> children;
            if (perms.contains(key)) continue;
            perms.add(key);
            if (!includeChildren || (children = TownyPerms.getAllChildren(key, new HashSet<String>())) == null) continue;
            for (String node : children.keySet()) {
                if (perms.contains(node)) continue;
                perms.add(node);
            }
        }
        return perms;
    }

    public static Map<String, Boolean> getAllChildren(String node, Set<String> playerPermArray) {
        LinkedList<String> stack = new LinkedList<String>();
        HashMap<String, Boolean> alreadyVisited = new HashMap<String, Boolean>();
        stack.push(node);
        alreadyVisited.put(node, true);
        while (!stack.isEmpty()) {
            String now = (String)stack.pop();
            Map<String, Boolean> children = TownyPerms.getChildren(now);
            if (children == null || playerPermArray.contains("-" + now)) continue;
            for (String childName : children.keySet()) {
                if (alreadyVisited.containsKey(childName)) continue;
                stack.push(childName);
                alreadyVisited.put(childName, children.get(childName));
            }
        }
        alreadyVisited.remove(node);
        if (!alreadyVisited.isEmpty()) {
            return alreadyVisited;
        }
        return null;
    }

    public static Map<String, Boolean> getChildren(String node) {
        Permission perm = registeredPermissions.get(node.toLowerCase());
        if (perm == null) {
            return null;
        }
        return perm.getChildren();
    }

    public static List<String> getGroupList() {
        return new ArrayList<String>(groupPermsMap.keySet());
    }

    public static boolean mapHasGroup(String group) {
        return groupPermsMap.containsKey(group);
    }

    public static List<String> getPermsOfGroup(String group) {
        return TownyPerms.mapHasGroup(group) ? (groupPermsMap.get(group) != null ? groupPermsMap.get(group) : new ArrayList()) : new ArrayList();
    }

    private static void buildGroupPermsMap() {
        for (String key : perms.getKeys(true)) {
            List nodes = perms.getList(key);
            groupPermsMap.put(key, nodes);
        }
    }

    private static void buildComments() {
        perms.addComment("nomad", "#############################################################################################", "# This file contains custom permission sets which will be assigned to your players", "# depending on their current status.", "#", "# This is all managed by towny and pushed directly to CraftBukkits SuperPerms.", "# These will be in addition to any you manually assign in your specific permission plugin.", "#", "# You may assign any Permission nodes here, including those from other plugins.", "# You may also create any custom ranks you require.", "# You may change the names of any of the ranks except: nomad, default, mayor, king.", "#############################################################################################", "", "", "# The 'nomad' permissions are given to all players in all Towny worlds, townless and players who are part of a town.");
        perms.addComment("towns", "", "# This section of permissions covers players who are members of a town.");
        perms.addComment("towns.default", "", "# 'default' is the permission set which is auto assigned to any normal town member.");
        perms.addComment("towns.mayor", "", "# Mayors get these permissions in addition to the default set.");
        perms.addComment("towns.ranks", "", "# Ranks contain additional permissions residents will be", "# granted if they are assigned that specific rank.");
        if (perms.getKeys(true).contains("towns.ranks.assistant")) {
            perms.addComment("towns.ranks.assistant", "", "# assistants are able to grant VIP and helper rank.");
        }
        if (perms.getKeys(true).contains("towns.ranks.donator")) {
            perms.addComment("towns.ranks.donator", "", "# Currently only an example rank holder with no extra permissions.");
        }
        if (perms.getKeys(true).contains("towns.ranks.vip")) {
            perms.addComment("towns.ranks.vip", "", "# Currently only an example rank holder with no extra permissions.");
        }
        if (perms.getKeys(true).contains("towns.ranks.sheriff")) {
            perms.addComment("towns.ranks.sheriff", "", "# Sheriff rank is able to jail other town members.");
        }
        perms.addComment("nations", "", "# This section of permissions covers players who are members of any town in a nation.");
        perms.addComment("nations.default", "", "# All nation members get these permissions.");
        perms.addComment("nations.king", "", "# Kings get these permissions in addition to the default set.");
    }

    public static CommentedConfiguration getTownyPermsFile() {
        return perms;
    }

    static {
        vitalGroups = new ArrayList<String>(Arrays.asList("nomad", "towns.default", "towns.mayor", "nations.default", "nations.king"));
        try {
            permissions = PermissionAttachment.class.getDeclaredField("permissions");
            permissions.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

