/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.statusscreens;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatusScreen {
    Map<String, Component> components = new LinkedHashMap<String, Component>();
    static final int MAX_WIDTH = 65;

    public void addComponentOf(String name, String text) {
        this.components.put(name, Component.text(text));
    }

    public void addComponentOf(String name, Component component) {
        this.components.put(name, component);
    }

    public void addComponentOf(String name, String text, ClickEvent click) {
        this.components.put(name, Component.text(text).clickEvent(click));
    }

    public void addComponentOf(String name, String text, HoverEvent hover) {
        this.components.put(name, Component.text(text).hoverEvent(hover));
    }

    public void addComponentOf(String name, String text, HoverEvent hover, ClickEvent click) {
        this.components.put(name, ((TextComponent)Component.text(text).hoverEvent(hover)).clickEvent(click));
    }

    public void removeStatusComponent(String name) {
        this.components.remove(name);
    }

    public Collection<Component> getComponents() {
        return Collections.unmodifiableCollection(this.components.values());
    }

    public boolean hasComponent(String name) {
        return this.components.containsKey(name);
    }

    public Component getComponentOrNull(String name) {
        return this.components.get(name);
    }

    public boolean replaceComponent(String name, TextComponent component) {
        return this.components.replace(name, component) != null;
    }

    public List<Component> getFormattedStatusScreen() {
        ArrayList<Component> lines = new ArrayList<Component>();
        Component currentLine = Component.empty();
        ArrayList<Component> components = new ArrayList<Component>(this.components.values());
        String string = "";
        for (int i = 0; i < components.size(); ++i) {
            Component nextComp = (Component)components.get(i);
            if (nextComp.equals(Component.newline()) && nextComp.children().isEmpty()) {
                lines.add(currentLine);
                currentLine = Component.empty();
                string = "";
                continue;
            }
            if (currentLine.equals(Component.empty()) && nextComp.children().isEmpty()) {
                currentLine = nextComp;
                string = this.getContent(currentLine);
                continue;
            }
            if (!nextComp.children().isEmpty()) {
                if (nextComp.equals(Component.newline())) {
                    lines.add(currentLine);
                    currentLine = Component.empty();
                    string = "";
                }
                for (Component child : nextComp.children()) {
                    if (child.equals(Component.newline())) {
                        lines.add(currentLine);
                        currentLine = Component.empty();
                        string = "";
                        continue;
                    }
                    if (currentLine.equals(Component.empty())) {
                        currentLine = child;
                        string = this.getContent(currentLine);
                        continue;
                    }
                    if (this.lineWouldBeTooLong(string, child)) {
                        lines.add(currentLine);
                        currentLine = child;
                        string = this.getContent(currentLine);
                        continue;
                    }
                    currentLine = currentLine.append(Component.space().append(child));
                    string = string + " " + this.getContent(child);
                }
                if (currentLine.equals(Component.empty())) continue;
                lines.add(currentLine);
                currentLine = Component.empty();
                string = "";
                continue;
            }
            if (this.lineWouldBeTooLong(string, nextComp)) {
                lines.add(currentLine);
                currentLine = nextComp;
                string = this.getContent(currentLine);
                continue;
            }
            currentLine = currentLine.append(Component.space().append(nextComp));
            string = string + " " + this.getContent(nextComp);
        }
        if (!currentLine.equals(Component.empty())) {
            lines.add(currentLine);
        }
        return lines;
    }

    private String getContent(Component comp) {
        if (comp.children().isEmpty()) {
            return ((TextComponent)comp).content();
        }
        ArrayList<String> content = new ArrayList<String>();
        if (!comp.children().isEmpty()) {
            for (Component child : comp.children()) {
                content.add(((TextComponent)child).content());
            }
        }
        return StringMgmt.join(content, " ");
    }

    private boolean lineWouldBeTooLong(String string, Component comp) {
        return Colors.strip(string).length() + Colors.strip(this.getContent(comp)).length() + 1 > 65;
    }
}

