/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.object.metadata.CustomDataField;

public class IntegerDataField
extends CustomDataField<Integer> {
    public IntegerDataField(String key) {
        super(key);
    }

    public IntegerDataField(String key, Integer value, String label) {
        super(key, value, label);
    }

    public IntegerDataField(String key, Integer value) {
        super(key, value);
    }

    @Override
    public String getTypeID() {
        return IntegerDataField.typeID();
    }

    public static String typeID() {
        return "towny_intdf";
    }

    @Override
    public void setValueFromString(String strValue) {
        this.setValue(Integer.parseInt(strValue));
    }

    @Override
    public boolean canParseFromString(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public String displayFormattedValue() {
        int val = (Integer)this.getValue();
        return (val <= 0 ? "\u00a74" : "\u00a7a") + val;
    }

    @Override
    public CustomDataField<Integer> clone() {
        return new IntegerDataField(this.getKey(), (Integer)this.getValue(), this.label);
    }
}

