/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.economy.Account;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class BankAccount
extends Account {
    private double balanceCap;
    private double debtCap;

    public BankAccount(String name, World world, double balanceCap) {
        super(name, world);
        this.balanceCap = balanceCap;
    }

    public void setBalanceCap(double balanceCap) {
        this.balanceCap = balanceCap;
    }

    public double getBalanceCap() {
        return this.balanceCap;
    }

    public double getDebtCap() {
        if (TownySettings.isDebtCapDeterminedByTownLevel()) {
            String townName = this.getName().replace(TownySettings.getTownAccountPrefix(), "");
            Town town = this.getTown();
            if (town == null) {
                TownyMessaging.sendErrorMsg(String.format("Error fetching debt cap for town %s because town is not registered!", townName));
            }
            return Double.parseDouble(TownySettings.getTownLevel(town).get((Object)TownySettings.TownLevel.DEBT_CAP_MODIFIER).toString()) * TownySettings.getDebtCapOverride();
        }
        if (TownySettings.getDebtCapOverride() != 0.0) {
            return TownySettings.getDebtCapOverride();
        }
        if (TownySettings.getDebtCapMaximum() != 0.0) {
            return Math.min(this.debtCap, TownySettings.getDebtCapMaximum());
        }
        return this.debtCap;
    }

    public void setDebtCap(double debtCap) {
        this.debtCap = debtCap;
    }

    @Override
    protected boolean subtractMoney(double amount) {
        if (this.isBankrupt() && this.getTownDebt() + amount > this.getDebtCap()) {
            return false;
        }
        if (this.isBankrupt()) {
            return this.addDebt(amount);
        }
        if (!this.canPayFromHoldings(amount)) {
            double amountInDebt = amount - this.getHoldingBalance();
            if (amountInDebt <= this.getDebtCap()) {
                boolean success = TownyEconomyHandler.setBalance(this.getName(), 0.0, this.world);
                return success &= this.addDebt(amountInDebt);
            }
            return false;
        }
        return TownyEconomyHandler.subtract(this.getName(), amount, this.world);
    }

    @Override
    protected boolean addMoney(double amount) {
        if (this.balanceCap != 0.0 && this.getHoldingBalance() + amount > this.balanceCap) {
            return false;
        }
        if (this.isBankrupt()) {
            return this.removeDebt(amount);
        }
        return TownyEconomyHandler.add(this.getName(), amount, this.world);
    }

    public boolean isBankrupt() {
        if (this.isTownAccount()) {
            Town town = this.getTown();
            return town != null && town.isBankrupt();
        }
        return false;
    }

    private boolean addDebt(double amount) {
        if (this.isTownAccount()) {
            this.setTownDebt(this.getTownDebt() + amount);
            return true;
        }
        return false;
    }

    private boolean removeDebt(double amount) {
        if (this.getTownDebt() < amount) {
            double netMoney = amount - this.getTownDebt();
            this.setTownDebt(0.0);
            double bankBalance = TownyEconomyHandler.getBalance(this.getName(), this.getBukkitWorld());
            TownyEconomyHandler.setBalance(this.getName(), bankBalance + netMoney, this.world);
            return true;
        }
        this.setTownDebt(this.getTownDebt() - amount);
        return true;
    }

    @Override
    public double getHoldingBalance(boolean setCache) {
        double balance;
        double d = balance = this.isBankrupt() ? (balance = this.getTownDebt() * -1.0) : TownyEconomyHandler.getBalance(this.getName(), this.getBukkitWorld());
        if (setCache) {
            this.cachedBalance.setBalance(balance);
        }
        return balance;
    }

    @Override
    public String getHoldingFormattedBalance() {
        if (this.isBankrupt()) {
            return "-" + TownyEconomyHandler.getFormattedBalance(this.getTownDebt());
        }
        return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
    }

    @Override
    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getName());
    }

    private boolean isTownAccount() {
        return this.getName().startsWith(TownySettings.getTownAccountPrefix());
    }

    @Nullable
    private Town getTown() {
        Town town = null;
        if (this.isTownAccount()) {
            town = TownyUniverse.getInstance().getTown(this.getName().replace(TownySettings.getTownAccountPrefix(), ""));
        }
        return town;
    }

    private double getTownDebt() {
        return this.getTown().getDebtBalance();
    }

    private void setTownDebt(double amount) {
        this.getTown().setDebtBalance(amount);
        this.getTown().save();
    }
}

