/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.event.TranslationLoadEvent;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.compress.utils.FileNameUtils;
import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class Translation {
    private static final Map<String, String> oldLangFileNames = Translation.createLegacyLangMap();
    private static final Set<String> langFiles = Translation.createValidLang();
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    private static Locale defaultLocale;
    private static final Path langFolder;

    private Translation() {
    }

    public static void loadTranslationRegistry() {
        translations.clear();
        Translation.updateLegacyLangFileName(TownySettings.getString(ConfigNodes.LANGUAGE));
        Map globalOverrides = new HashMap();
        Path globalYMLPath = langFolder.resolve("global.yml");
        if (!FileMgmt.checkOrCreateFile(globalYMLPath.toString())) {
            throw new TownyInitException("Failed to touch '" + globalYMLPath + "'.", TownyInitException.TownyError.LOCALIZATION);
        }
        try {
            InputStream resource = Towny.class.getResourceAsStream("/global.yml");
            if (resource == null) {
                throw new TownyInitException("Could not find global.yml in the JAR", TownyInitException.TownyError.LOCALIZATION);
            }
            Files.copy(resource, globalYMLPath, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException resource) {
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to copy global.yml from the JAR to '" + globalYMLPath + "'", TownyInitException.TownyError.LOCALIZATION, e);
        }
        try (InputStream is = Files.newInputStream(globalYMLPath, new OpenOption[0]);){
            globalOverrides = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Files.createDirectories(langFolder.resolve("reference"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to create language reference folder.", TownyInitException.TownyError.LOCALIZATION, e);
        }
        for (String lang : langFiles) {
            try {
                InputStream is = Translation.class.getResourceAsStream("/lang/" + lang + ".yml");
                try {
                    if (is == null) {
                        throw new TownyInitException("Could not find '/lang/" + lang + ".yml' in the JAR", TownyInitException.TownyError.LOCALIZATION);
                    }
                    Map map = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load(is);
                    Translation.saveReferenceFile(map.get("version"), lang);
                    lang = lang.replace("-", "_");
                    translations.put(lang, new HashMap());
                    for (Map.Entry entry : map.entrySet()) {
                        translations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                Towny.getPlugin().getLogger().log(Level.WARNING, "Failed to load/save '" + lang + ".yml'.", e);
            }
        }
        TranslationLoadEvent translationLoadEvent = new TranslationLoadEvent();
        Bukkit.getPluginManager().callEvent((Event)translationLoadEvent);
        Translation.addTranslations(translationLoadEvent.getAddedTranslations());
        File[] overrideFiles = new File(langFolder + File.separator + "override").listFiles();
        if (overrideFiles != null) {
            for (File file : overrideFiles) {
                if (!file.isFile() || !FileNameUtils.getExtension(file.getName()).equalsIgnoreCase("yml") || file.getName().equalsIgnoreCase("global.yml")) continue;
                try (FileInputStream is = new FileInputStream(file);){
                    Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load((InputStream)is);
                    String lang = FileNameUtils.getBaseName(file.getName());
                    if (values == null) continue;
                    translations.computeIfAbsent(lang, k -> new HashMap());
                    for (Map.Entry entry : values.entrySet()) {
                        translations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (globalOverrides != null) {
            for (Map.Entry entry : globalOverrides.entrySet()) {
                for (String lang : translations.keySet()) {
                    translations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                }
            }
        }
        defaultLocale = Translation.loadDefaultLocale();
        Towny.getPlugin().getLogger().info(String.format("Successfully loaded translations for %d languages.", translations.keySet().size()));
        HelpMenu.loadMenus();
    }

    private static void saveReferenceFile(@Nullable Object currentVersion, String lang) {
        if (currentVersion == null) {
            return;
        }
        Path langPath = langFolder.resolve("reference").resolve(lang + ".yml");
        try (InputStream resource = Towny.class.getResourceAsStream("/lang/" + lang + ".yml");){
            if (resource == null) {
                throw new TownyInitException("Could not find '/lang/" + lang + ".yml' in the JAR.", TownyInitException.TownyError.LOCALIZATION);
            }
            try (InputStream is = Files.newInputStream(langPath, new OpenOption[0]);){
                Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load(is);
                if (values == null || ((Double)currentVersion).doubleValue() != ((Double)values.get("version")).doubleValue()) {
                    is.close();
                    langPath.toFile().delete();
                    Files.copy(resource, langPath, new CopyOption[0]);
                }
            }
            catch (NoSuchFileException e) {
                Files.copy(resource, langPath, new CopyOption[0]);
            }
            resource.close();
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to copy '/lang/" + lang + ".yml' from the JAR to '" + langPath + " during a langauge file update.'", TownyInitException.TownyError.LOCALIZATION, e);
        }
    }

    public static Set<String> createValidLang() {
        HashSet<String> lang = new HashSet<String>();
        try {
            URI uri = Towny.class.getResource("").toURI();
            FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            Files.list(fs.getRootDirectories().iterator().next().resolve("/lang")).forEach(p -> lang.add(FileNameUtils.getBaseName(p.toString())));
            fs.close();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return lang;
    }

    public static String of(String key) {
        if (defaultLocale == null) {
            Towny.getPlugin().getLogger().warning("Error: Tried to translate before a locale could be loaded!");
            return key;
        }
        String data = translations.get(defaultLocale.toString()).get(key.toLowerCase(Locale.ROOT));
        if (data == null) {
            TownySettings.sendError(key.toLowerCase() + " from " + TownySettings.getString(ConfigNodes.LANGUAGE));
            return key;
        }
        return Colors.translateColorCodes(data);
    }

    public static String of(String key, Object ... args) {
        return String.format(Translation.of(key), args);
    }

    public static String of(String key, Locale locale) {
        String data = translations.get(Translation.validateLocale(locale.toString())).get(key.toLowerCase(Locale.ROOT));
        if (data == null) {
            TownySettings.sendError(key.toLowerCase() + " from " + TownySettings.getString(ConfigNodes.LANGUAGE));
            return key;
        }
        return Colors.translateColorCodes(data);
    }

    public static String of(String key, Locale locale, Object ... args) {
        return String.format(Translation.of(key, locale), args);
    }

    public static String of(String key, CommandSender sender) {
        return Translation.of(key, Translation.getLocale(sender));
    }

    public static String of(String key, CommandSender sender, Object ... args) {
        return String.format(Translation.of(key, Translation.getLocale(sender)), args);
    }

    public static String of(String key, Resident resident) {
        return Translation.of(key, Translation.getLocale(resident));
    }

    public static String of(String key, Resident resident, Object ... args) {
        return String.format(Translation.of(key, Translation.getLocale(resident)), args);
    }

    private static void updateLegacyLangFileName(String lang) {
        File newFile;
        if (!oldLangFileNames.containsKey(lang)) {
            return;
        }
        String path = Towny.getPlugin().getDataFolder().getPath() + File.separator + "settings" + File.separator;
        File oldFile = new File(path + lang);
        boolean rename = oldFile.renameTo(newFile = new File(path + oldLangFileNames.get(lang)));
        if (rename) {
            Towny.getPlugin().getLogger().info("Language file name updated.");
            TownySettings.setLanguage(oldLangFileNames.get(lang));
        } else {
            Towny.getPlugin().getLogger().warning("Language file was not updated.");
        }
    }

    private static Map<String, String> createLegacyLangMap() {
        HashMap<String, String> oldLangFileNames = new HashMap<String, String>();
        oldLangFileNames.put("danish.yml", "da-DK.yml");
        oldLangFileNames.put("german.yml", "de-DE.yml");
        oldLangFileNames.put("english.yml", "en-US.yml");
        oldLangFileNames.put("spanish.yml", "es-ES.yml");
        oldLangFileNames.put("french.yml", "fr-FR.yml");
        oldLangFileNames.put("italian.yml", "it-IT.yml");
        oldLangFileNames.put("korean.yml", "ko-KR.yml");
        oldLangFileNames.put("norwegian.yml", "no-NO.yml");
        oldLangFileNames.put("polish.yml", "pl-PL.yml");
        oldLangFileNames.put("pt-br.yml", "pt-BR.yml");
        oldLangFileNames.put("russian.yml", "ru-RU.yml");
        oldLangFileNames.put("sv-SE.yml", "sv-SE.yml");
        oldLangFileNames.put("chinese.yml", "zh-CN.yml");
        return oldLangFileNames;
    }

    public static Locale toLocale(String fileName, boolean shouldWarn) {
        int lastIndex = fileName.lastIndexOf(".") == -1 ? fileName.length() : fileName.lastIndexOf(".");
        try {
            String[] locale = fileName.substring(0, lastIndex).split("[-_]");
            return new Locale(locale[0], locale[1]);
        }
        catch (Exception e) {
            if (shouldWarn) {
                Towny.getPlugin().getLogger().warning(String.format("Could not convert '%s' into a locale, falling back to en_US.", fileName));
            }
            return new Locale("en", "US");
        }
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    private static String validateLocale(String locale) {
        return translations.containsKey(locale) ? locale : defaultLocale.toString();
    }

    public static String translateTranslatables(CommandSender sender, Translatable ... translatables) {
        return Translation.translateTranslatables(sender, " ", translatables);
    }

    public static String translateTranslatables(CommandSender sender, String delimiter, Translatable ... translatables) {
        Locale locale = Translation.getLocale(sender);
        return Arrays.stream(translatables).map(translatable -> translatable.translate(locale)).collect(Collectors.joining(delimiter));
    }

    public static Locale getLocale(CommandSender sender) {
        return sender instanceof Player ? Translation.toLocale(((Player)sender).getLocale(), false) : defaultLocale;
    }

    public static Locale getLocale(Resident resident) {
        return BukkitTools.isOnline(resident.getName()) ? Translation.getLocale((CommandSender)resident.getPlayer()) : defaultLocale;
    }

    private static Locale loadDefaultLocale() {
        Locale locale = Translation.toLocale(TownySettings.getString(ConfigNodes.LANGUAGE), true);
        String stringLocale = locale.toString();
        if (!translations.containsKey(stringLocale)) {
            locale = new Locale("en", "US");
            Towny.getPlugin().getLogger().warning(String.format("The locale '%s' is currently not loaded, falling back to en_US. (Is it being loaded correctly?)", stringLocale));
        }
        return locale;
    }

    public static void addTranslations(Map<String, Map<String, String>> addedTranslations) {
        if (addedTranslations != null && !addedTranslations.isEmpty()) {
            for (String language : addedTranslations.keySet()) {
                if (addedTranslations.get(language) == null || addedTranslations.get(language).isEmpty()) continue;
                for (Map.Entry<String, String> entry : addedTranslations.get(language).entrySet()) {
                    translations.computeIfAbsent(language, k -> new HashMap());
                    translations.get(language).put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
                }
            }
        }
    }

    static {
        langFolder = Paths.get(TownyUniverse.getInstance().getRootFolder(), new String[0]).resolve("settings").resolve("lang");
    }
}

