/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.SpawnPointLocation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.plugin.Plugin;

public class SpawnPoint {
    private final Location location;
    private final WorldCoord wc;
    private final SpawnPointType type;
    private final SpawnPointLocation spawnLocation;
    private static final ArrayList<RingCoord> RING_PATTERN = SpawnPoint.createRing();

    public SpawnPoint(Location loc, SpawnPointType type) {
        this.location = loc;
        this.type = type;
        this.wc = WorldCoord.parseWorldCoord(loc);
        this.spawnLocation = new SpawnPointLocation(loc);
    }

    public WorldCoord getWorldCoord() {
        return this.wc;
    }

    public SpawnPointType getType() {
        return this.type;
    }

    public Location getBukkitLocation() {
        return this.location;
    }

    public SpawnPointLocation getSpawnPointLocation() {
        return this.spawnLocation;
    }

    public void drawParticle() {
        Location origin = this.centreLocation(this.location);
        int i = 0;
        for (RingCoord ringPosition : RING_PATTERN) {
            Location point = origin.clone().add(ringPosition.getX(), 0.0, ringPosition.getZ());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Towny.getPlugin(), () -> Bukkit.getWorld((String)this.location.getWorld().getName()).spawnParticle(Particle.CRIT_MAGIC, point, 1, 0.0, 0.0, 0.0, 0.0), (long)(i * 4));
            ++i;
        }
    }

    private Location centreLocation(Location loc) {
        loc.setX(Math.floor(loc.getX()) + 0.5);
        loc.setY(Math.floor(loc.getY()) + 0.1);
        loc.setZ(Math.floor(loc.getZ()) + 0.5);
        return loc;
    }

    private static ArrayList<RingCoord> createRing() {
        ArrayList<RingCoord> ring = new ArrayList<RingCoord>();
        ring.add(RingCoord.of(0.0, 0.45));
        ring.add(RingCoord.of(0.225, 0.3897));
        ring.add(RingCoord.of(0.3897, 0.225));
        ring.add(RingCoord.of(0.45, 0.0));
        ring.add(RingCoord.of(0.3897, -0.225));
        ring.add(RingCoord.of(0.225, -0.3897));
        ring.add(RingCoord.of(0.0, -0.45));
        ring.add(RingCoord.of(-0.225, -0.3897));
        ring.add(RingCoord.of(-0.3897, -0.225));
        ring.add(RingCoord.of(-0.45, 0.0));
        ring.add(RingCoord.of(-0.3897, 0.225));
        ring.add(RingCoord.of(-0.225, 0.3897));
        return ring;
    }

    public static enum SpawnPointType {
        TOWN_SPAWN,
        NATION_SPAWN,
        OUTPOST_SPAWN,
        JAIL_SPAWN;

    }

    private static class RingCoord {
        private double x;
        private double z;

        private RingCoord(double x, double z) {
            this.x = x;
            this.z = z;
        }

        private double getX() {
            return this.x;
        }

        private double getZ() {
            return this.z;
        }

        private static RingCoord of(double a, double b) {
            return new RingCoord(a, b);
        }
    }
}

