/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentRankEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentRankEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.InviteReceiver;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Identifiable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Resident
extends TownyObject
implements InviteReceiver,
EconomyHandler,
TownBlockOwner,
Identifiable {
    private List<Resident> friends = new ArrayList<Resident>();
    private UUID uuid = null;
    private Town town = null;
    private long lastOnline;
    private long registered;
    private long joinedTownAt;
    private boolean isNPC = false;
    private String title = "";
    private String surname = "";
    private long teleportRequestTime = -1L;
    private Location teleportDestination;
    private double teleportCost = 0.0;
    private final List<String> modes = new ArrayList<String>();
    private transient Confirmation confirmation;
    private final transient List<Invite> receivedInvites = new ArrayList<Invite>();
    private transient EconomyAccount account;
    private Jail jail = null;
    private int jailCell;
    private int jailHours;
    private final List<String> townRanks = new ArrayList<String>();
    private final List<String> nationRanks = new ArrayList<String>();
    private List<TownBlock> townBlocks = new ArrayList<TownBlock>();
    private final TownyPermission permissions = new TownyPermission();
    private ArrayList<Inventory> guiPages;
    private int guiPageNum = 0;
    private int spawnProtectionTaskID = 0;

    public Resident(String name) {
        super(name);
        this.permissions.loadDefault(this);
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setNPC(boolean isNPC) {
        this.isNPC = isNPC;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean hasUUID() {
        return this.uuid != null;
    }

    public Jail getJail() {
        return this.jail;
    }

    public void setJail(Jail jail) {
        this.jail = jail;
    }

    public boolean isJailed() {
        return this.jail != null;
    }

    public int getJailCell() {
        return this.jailCell;
    }

    public void setJailCell(int i) {
        this.jailCell = this.jail.hasJailCell(i) ? i : 0;
    }

    public Town getJailTown() {
        return this.jail.getTown();
    }

    public boolean hasJailTown(String jailtown) {
        return this.getJailTown().getName().equalsIgnoreCase(jailtown);
    }

    public int getJailHours() {
        return this.jailHours;
    }

    public void setJailHours(Integer hours) {
        this.jailHours = hours;
    }

    public boolean hasJailTime() {
        return this.jailHours > 0;
    }

    public Location getJailSpawn() {
        return this.getJail().getJailCellLocations().get(this.getJailCell());
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    public void setSurname(String surname) {
        this.surname = surname.trim();
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasSurname() {
        return !this.surname.isEmpty();
    }

    public boolean isKing() {
        return this.hasNation() && this.town.getNationOrNull().isKing(this);
    }

    public boolean isMayor() {
        return this.hasTown() && this.town.isMayor(this);
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean hasNation() {
        return this.hasTown() && this.town.hasNation();
    }

    public Town getTown() throws NotRegisteredException {
        if (this.hasTown()) {
            return this.town;
        }
        throw new NotRegisteredException(Translation.of("msg_err_resident_doesnt_belong_to_any_town"));
    }

    @Nullable
    public Town getTownOrNull() {
        return this.town;
    }

    public void setTown(Town town) throws AlreadyRegisteredException {
        this.setTown(town, true);
    }

    public void setTown(Town town, boolean updateJoinedAt) throws AlreadyRegisteredException {
        if (this.town == town) {
            return;
        }
        Towny.getPlugin().deleteCache(this.getName());
        this.setTitle("");
        this.setSurname("");
        if (town == null) {
            this.town = null;
            this.updatePerms();
            return;
        }
        if (this.hasTown()) {
            town.addResidentCheck(this);
        }
        this.town = town;
        this.updatePerms();
        town.addResident(this);
        if (updateJoinedAt) {
            this.setJoinedTownAt(System.currentTimeMillis());
            BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentEvent(this, town));
        }
    }

    public void removeTown() {
        if (!this.hasTown()) {
            return;
        }
        Town town = this.town;
        BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentEvent(this, town));
        try {
            town.removeResident(this);
        }
        catch (NotRegisteredException e1) {
            e1.printStackTrace();
        }
        catch (EmptyTownException e1) {
            // empty catch block
        }
        Iterator<TownBlock> townBlockIterator = this.townBlocks.iterator();
        while (townBlockIterator.hasNext()) {
            TownBlock townBlock = townBlockIterator.next();
            if (townBlock.getType() == TownBlockType.EMBASSY) continue;
            townBlockIterator.remove();
            townBlock.setResident(null);
            townBlock.setPlotPrice(townBlock.getTownOrNull().getPlotPrice());
            townBlock.setType(townBlock.getType());
            townBlock.save();
        }
        try {
            this.setTown(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.save();
        Towny.getPlugin().resetCache();
    }

    public void setFriends(List<Resident> newFriends) {
        this.friends = newFriends;
    }

    public List<Resident> getFriends() {
        return Collections.unmodifiableList(this.friends);
    }

    public void removeFriend(Resident resident) {
        if (this.hasFriend(resident)) {
            this.friends.remove(resident);
        }
    }

    public boolean hasFriend(Resident resident) {
        return this.friends.contains(resident);
    }

    public void addFriend(Resident resident) throws AlreadyRegisteredException {
        if (this.hasFriend(resident) || this.equals(resident) || resident.isNPC()) {
            throw new AlreadyRegisteredException();
        }
        this.friends.add(resident);
    }

    public void removeAllFriends() {
        this.friends.clear();
    }

    public void updatePerms() {
        this.townRanks.clear();
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void updatePermsForNationRemoval() {
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public long getRegistered() {
        return this.registered;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Resident (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Registered: " + this.getRegistered());
        out.add(this.getTreeDepth(depth + 1) + "Last Online: " + this.getLastOnline());
        if (this.getFriends().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Friends (" + this.getFriends().size() + "): " + Arrays.toString(this.getFriends().toArray(new Resident[0])));
        }
        return out;
    }

    public void clearTeleportRequest() {
        this.teleportRequestTime = -1L;
    }

    public void setTeleportRequestTime() {
        this.teleportRequestTime = System.currentTimeMillis();
    }

    public long getTeleportRequestTime() {
        return this.teleportRequestTime;
    }

    public void setTeleportDestination(Location spawnLoc) {
        this.teleportDestination = spawnLoc;
    }

    public Location getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean hasRequestedTeleport() {
        return this.teleportRequestTime != -1L;
    }

    public void setTeleportCost(double cost) {
        this.teleportCost = cost;
    }

    public double getTeleportCost() {
        return this.teleportCost;
    }

    public List<String> getModes() {
        return Collections.unmodifiableList(this.modes);
    }

    public boolean hasMode(String mode) {
        return this.modes.contains(mode.toLowerCase());
    }

    public void toggleMode(String[] newModes, boolean notify) {
        for (int i = 0; i < newModes.length; ++i) {
            boolean modeEnabled;
            String bool;
            String mode = newModes[i].toLowerCase();
            Optional<Boolean> choice = Optional.empty();
            if (i + 1 < newModes.length && BaseCommand.setOnOffCompletes.contains(bool = newModes[i + 1].toLowerCase())) {
                choice = Optional.of(bool.equals("on"));
                ++i;
            }
            if (choice.orElse(!(modeEnabled = this.modes.contains(mode))).booleanValue()) {
                if (modeEnabled) continue;
                this.modes.add(mode);
                continue;
            }
            this.modes.remove(mode);
        }
        if (this.modes.isEmpty()) {
            this.clearModes();
            return;
        }
        if (notify) {
            TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set").append(StringMgmt.join(this.getModes(), ",")));
        }
    }

    public void setModes(String[] modes, boolean notify) {
        this.modes.clear();
        this.toggleMode(modes, false);
        if (notify) {
            TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set").append(StringMgmt.join(this.getModes(), ",")));
        }
    }

    public void clearModes() {
        this.modes.clear();
        TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set"));
        if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.getName(), true), 1L) == -1) {
            TownyMessaging.sendErrorMsg(Translation.of("msg_err_could_not_set_default_modes_for") + this.getName() + ".");
        }
    }

    public void resetModes(String[] modes, boolean notify) {
        if (modes.length > 0) {
            this.toggleMode(modes, false);
        }
        if (notify) {
            TownyMessaging.sendMsg(this, Translatable.of("msg_modes_set").append(StringMgmt.join(this.getModes(), ",")));
        }
    }

    @Nullable
    public Player getPlayer() {
        return BukkitTools.getPlayer(this.getName());
    }

    public boolean addTownRank(String rank) {
        if (!this.hasTownRank(rank)) {
            this.townRanks.add(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentRankEvent(this, rank, this.town));
            return true;
        }
        return false;
    }

    public void setTownRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchTownRank(rank)) == null || this.hasTownRank(rank)) continue;
            this.townRanks.add(rank);
        }
    }

    public boolean hasTownRank(String rank) {
        if ((rank = TownyPerms.matchTownRank(rank)) != null) {
            for (String ownedRank : this.townRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTownRanks() {
        return Collections.unmodifiableList(this.townRanks);
    }

    public boolean removeTownRank(String rank) {
        if (this.hasTownRank(rank)) {
            this.townRanks.remove(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentRankEvent(this, rank, this.town));
            return true;
        }
        return false;
    }

    public boolean addNationRank(String rank) {
        if (!this.hasNationRank(rank)) {
            this.nationRanks.add(rank);
            if (this.isOnline()) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public void setNationRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchNationRank(rank)) == null || this.hasNationRank(rank)) continue;
            this.nationRanks.add(rank);
        }
    }

    public boolean hasNationRank(String rank) {
        if ((rank = TownyPerms.matchNationRank(rank)) != null) {
            for (String ownedRank : this.nationRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getNationRanks() {
        return Collections.unmodifiableList(this.nationRanks);
    }

    public boolean removeNationRank(String rank) {
        if (this.hasNationRank(rank)) {
            this.nationRanks.remove(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public boolean isAlliedWith(Resident otherresident) {
        if (this.hasNation() && this.hasTown() && otherresident.hasTown() && otherresident.hasNation()) {
            try {
                if (this.getTown().getNation().hasAlly(otherresident.getTown().getNation())) {
                    return true;
                }
                return this.getTown().getNation().equals(otherresident.getTown().getNation());
            }
            catch (NotRegisteredException e) {
                return false;
            }
        }
        return false;
    }

    public List<Invite> getReceivedInvites() {
        return Collections.unmodifiableList(this.receivedInvites);
    }

    @Override
    public void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedInvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(Translation.of("msg_err_player_has_too_many_invites", this.getName()));
        }
        this.receivedInvites.add(invite);
    }

    @Override
    public void deleteReceivedInvite(Invite invite) {
        this.receivedInvites.remove(invite);
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    @Override
    public Account getAccount() {
        if (this.account == null) {
            String accountName = StringMgmt.trimMaxLength(this.getName(), 32);
            Player player = this.getPlayer();
            World world = player != null ? player.getWorld() : BukkitTools.getWorlds().get(0);
            this.account = new EconomyAccount(accountName, world);
        }
        return this.account;
    }

    @Override
    public String getFormattedName() {
        String prefix = Colors.translateColorCodes(this.hasTitle() ? this.getTitle() + " " : (this.isKing() && !TownySettings.getKingPrefix(this).isEmpty() ? TownySettings.getKingPrefix(this) : (this.isMayor() && !TownySettings.getMayorPrefix(this).isEmpty() ? TownySettings.getMayorPrefix(this) : "")));
        String postfix = Colors.translateColorCodes(this.hasSurname() ? " " + this.getSurname() : (this.isKing() && !TownySettings.getKingPostfix(this).isEmpty() ? TownySettings.getKingPostfix(this) : (this.isMayor() && !TownySettings.getMayorPostfix(this).isEmpty() ? TownySettings.getMayorPostfix(this) : "")));
        return prefix + this.getName() + postfix;
    }

    public String getNamePrefix() {
        if (this.isKing()) {
            return TownySettings.getKingPrefix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPrefix(this);
        }
        return "";
    }

    public String getNamePostfix() {
        if (this.isKing()) {
            return TownySettings.getKingPostfix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPostfix(this);
        }
        return "";
    }

    public String getFormattedTitleName() {
        if (!this.hasTitle()) {
            return this.getFormattedName();
        }
        return this.getTitle() + " " + this.getName();
    }

    public void setTownblocks(Collection<TownBlock> townBlocks) {
        this.townBlocks = new ArrayList<TownBlock>(townBlocks);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks);
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.townBlocks.contains(townBlock);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.add(townBlock);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        this.townBlocks.remove(townBlock);
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public Confirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
    }

    public Inventory getGUIPage() {
        return this.guiPages.get(this.guiPageNum);
    }

    public ArrayList<Inventory> getGUIPages() {
        return this.guiPages;
    }

    public void setGUIPages(ArrayList<Inventory> inventory) {
        this.guiPages = inventory;
    }

    public int getGUIPageNum() {
        return this.guiPageNum;
    }

    public void setGUIPageNum(int currentInventoryPage) {
        this.guiPageNum = currentInventoryPage;
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveResident(this);
    }

    public long getJoinedTownAt() {
        return this.joinedTownAt;
    }

    public void setJoinedTownAt(long joinedTownAt) {
        this.joinedTownAt = joinedTownAt;
    }

    public Nation getNation() throws TownyException {
        return this.getTown().getNation();
    }

    @Nullable
    public Nation getNationOrNull() {
        if (this.hasNation()) {
            return this.getTownOrNull().getNationOrNull();
        }
        return null;
    }

    public boolean isOnline() {
        return BukkitTools.isOnline(this.getName());
    }

    public int getSpawnProtectionTaskID() {
        return this.spawnProtectionTaskID;
    }

    public void setSpawnProtectionTaskID(int spawnProtectionTaskID) {
        this.spawnProtectionTaskID = spawnProtectionTaskID;
    }

    public void removeSpawnProtection() {
        Bukkit.getScheduler().cancelTask(this.getSpawnProtectionTaskID());
        this.setSpawnProtectionTaskID(0);
        TownyMessaging.sendMsg(this, Translatable.of("msg_you_have_lost_your_invulnerability"));
    }

    @Deprecated
    public World getBukkitWorld() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getWorld();
        }
        return BukkitTools.getWorlds().get(0);
    }
}

