/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnPoint;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Nation
extends Government {
    private static final String ECONOMY_ACCOUNT_PREFIX = TownySettings.getNationAccountPrefix();
    private final List<Town> towns = new ArrayList<Town>();
    private List<Nation> allies = new ArrayList<Nation>();
    private List<Nation> enemies = new ArrayList<Nation>();
    private Town capital;
    private final transient List<Invite> sentAllyInvites = new ArrayList<Invite>();

    public Nation(String name) {
        super(name);
        this.setBoard(TownySettings.getNationDefaultBoard());
        this.setOpen(TownySettings.getNationDefaultOpen());
    }

    public void addAlly(Nation nation) throws AlreadyRegisteredException {
        if (this.hasAlly(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeEnemy(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getAllies().add(nation);
    }

    public boolean removeAlly(Nation nation) throws NotRegisteredException {
        if (!this.hasAlly(nation)) {
            throw new NotRegisteredException();
        }
        return this.getAllies().remove(nation);
    }

    public boolean removeAllAllies() {
        for (Nation ally : new ArrayList<Nation>(this.getAllies())) {
            try {
                this.removeAlly(ally);
                ally.removeAlly(this);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return this.getAllies().size() == 0;
    }

    public boolean hasAlly(Nation nation) {
        return this.getAllies().contains(nation);
    }

    public boolean hasMutualAlly(Nation nation) {
        return this.getAllies().contains(nation) && nation.getAllies().contains(this);
    }

    public boolean IsAlliedWith(Nation nation) {
        return this.getAllies().contains(nation);
    }

    public void addEnemy(Nation nation) throws AlreadyRegisteredException {
        if (this.hasEnemy(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeAlly(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getEnemies().add(nation);
    }

    public boolean removeEnemy(Nation nation) throws NotRegisteredException {
        if (!this.hasEnemy(nation)) {
            throw new NotRegisteredException();
        }
        return this.getEnemies().remove(nation);
    }

    public boolean removeAllEnemies() {
        for (Nation enemy : new ArrayList<Nation>(this.getEnemies())) {
            try {
                this.removeEnemy(enemy);
                enemy.removeEnemy(this);
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        return this.getEnemies().size() == 0;
    }

    public boolean hasEnemy(Nation nation) {
        return this.getEnemies().contains(nation);
    }

    public List<Town> getTowns() {
        return Collections.unmodifiableList(this.towns);
    }

    public boolean isKing(Resident resident) {
        return this.hasCapital() && this.getCapital().isMayor(resident);
    }

    public boolean hasCapital() {
        return this.getCapital() != null;
    }

    public boolean hasAssistant(Resident resident) {
        return this.getAssistants().contains(resident);
    }

    public boolean isCapital(Town town) {
        return town == this.getCapital();
    }

    public boolean hasTown(String name) {
        for (Town town : this.towns) {
            if (!town.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTown(Town town) {
        return this.towns.contains(town);
    }

    public void addTown(Town town) {
        this.towns.add(town);
    }

    public void forceSetCapital(Town capital) throws EmptyNationException {
        if (this.towns.isEmpty()) {
            throw new EmptyNationException(this);
        }
        try {
            if (capital.getNation().equals(this)) {
                this.setCapital(capital);
                return;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (!this.findNewCapital()) {
            throw new EmptyNationException(this);
        }
    }

    public void setCapital(Town capital) {
        TownyMessaging.sendDebugMsg("Nation " + this.getName() + " has set a capital city of " + capital.getName());
        this.capital = capital;
        if (this.spawn != null && TownySettings.isNationSpawnOnlyAllowedInCapital() && !capital.isInsideTown(this.spawn)) {
            this.spawn = null;
        }
        try {
            TownyPerms.assignPermissions(capital.getMayor(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Town getCapital() {
        return this.capital;
    }

    public boolean findNewCapital() {
        int numResidents = 0;
        Town tempCapital = null;
        for (Town newCapital : this.getTowns()) {
            if (newCapital.getNumResidents() <= numResidents) continue;
            tempCapital = newCapital;
            numResidents = newCapital.getNumResidents();
        }
        if (tempCapital != null) {
            this.setCapital(tempCapital);
            return true;
        }
        return false;
    }

    @Override
    public Location getSpawn() throws TownyException {
        if (this.spawn == null) {
            throw new TownyException(Translation.of("msg_err_nation_has_not_set_a_spawn_location"));
        }
        return this.spawn;
    }

    @Override
    @Nullable
    public Location getSpawnOrNull() {
        return this.spawn;
    }

    @Override
    public void setSpawn(Location spawn) {
        if (spawn != null) {
            TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.NATION_SPAWN));
        } else if (this.spawn != null) {
            TownyUniverse.getInstance().removeSpawnPoint(this.spawn);
        }
        this.spawn = spawn;
    }

    public List<Resident> getAssistants() {
        ArrayList<Resident> assistants = new ArrayList<Resident>();
        for (Town town : this.towns) {
            for (Resident assistant : town.getResidents()) {
                if (!assistant.hasNationRank("assistant")) continue;
                assistants.add(assistant);
            }
        }
        return assistants;
    }

    public void setEnemies(List<Nation> enemies) {
        this.enemies = enemies;
    }

    public List<Nation> getEnemies() {
        return this.enemies;
    }

    public void setAllies(List<Nation> allies) {
        this.allies = allies;
    }

    public List<Nation> getAllies() {
        return this.allies;
    }

    public List<Nation> getMutualAllies() {
        ArrayList<Nation> result = new ArrayList<Nation>();
        for (Nation ally : this.getAllies()) {
            if (!ally.hasAlly(this)) continue;
            result.add(ally);
        }
        return result;
    }

    public int getNumTowns() {
        return this.towns.size();
    }

    public int getNumResidents() {
        int numResidents = 0;
        for (Town town : this.getTowns()) {
            numResidents += town.getNumResidents();
        }
        return numResidents;
    }

    protected void removeTown(Town town) throws EmptyNationException {
        boolean isCapital = town.isCapital();
        this.remove(town);
        if (this.getNumTowns() == 0) {
            throw new EmptyNationException(this);
        }
        if (isCapital) {
            this.findNewCapital();
        }
        this.save();
    }

    private void remove(Town town) {
        this.towns.remove(town);
    }

    private void removeAllTowns() {
        this.towns.clear();
    }

    @Override
    public void setTaxes(double taxes) {
        this.taxes = Math.min(taxes, TownySettings.getMaxNationTax());
    }

    public void clear() {
        this.removeAllAllies();
        this.removeAllEnemies();
        this.removeAllTowns();
        this.capital = null;
    }

    public void removeOutOfRangeTowns() {
        List<Town> toRemove;
        if (this.capital != null && TownySettings.getNationRequiresProximity() > 0.0 && !(toRemove = this.gatherOutOfRangeTowns(new ArrayList<Town>(this.getTowns()), this.capital)).isEmpty()) {
            toRemove.stream().forEach(town -> {
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_left_nation", this.getName()));
                TownyMessaging.sendPrefixedNationMessage(this, Translatable.of("msg_nation_town_left", town.getName()));
                town.removeNation();
                town.save();
            });
        }
    }

    public List<Town> gatherOutOfRangeTowns(List<Town> towns, Town capital) {
        ArrayList<Town> removedTowns = new ArrayList<Town>();
        if (capital != null && capital.hasHomeBlock() && TownySettings.getNationRequiresProximity() > 0.0) {
            Coord capitalCoord = capital.getHomeBlockOrNull().getCoord();
            for (Town town : towns) {
                double distance;
                if (!town.hasHomeBlock()) continue;
                Coord townCoord = town.getHomeBlockOrNull().getCoord();
                if (!capital.getHomeblockWorld().equals(town.getHomeblockWorld()) || !((distance = MathUtil.distance(capitalCoord.getX(), townCoord.getX(), capitalCoord.getZ(), townCoord.getZ())) > TownySettings.getNationRequiresProximity())) continue;
                removedTowns.add(town);
            }
        }
        return removedTowns;
    }

    public void setKing(Resident king) throws TownyException {
        if (!this.hasResident(king)) {
            throw new TownyException(Translation.of("msg_err_king_not_in_nation"));
        }
        if (!king.isMayor()) {
            throw new TownyException(Translation.of("msg_err_new_king_notmayor"));
        }
        this.setCapital(king.getTown());
        this.save();
    }

    public boolean hasResident(Resident resident) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(resident)) continue;
            return true;
        }
        return false;
    }

    public void collect(double amount) {
        if (TownyEconomyHandler.isActive()) {
            double bankcap = TownySettings.getNationBankCap();
            if (bankcap > 0.0 && amount + this.getAccount().getHoldingBalance() > bankcap) {
                TownyMessaging.sendPrefixedNationMessage(this, Translatable.of("msg_err_deposit_capped", bankcap));
                return;
            }
            this.getAccount().deposit(amount, null);
        }
    }

    public List<Resident> getResidents() {
        ArrayList<Resident> out = new ArrayList<Resident>();
        for (Town town : this.getTowns()) {
            out.addAll(town.getResidents());
        }
        return out;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Nation (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Capital: " + this.getCapital().getName());
        List<Resident> assistants = this.getAssistants();
        if (assistants.size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Assistants (" + assistants.size() + "): " + Arrays.toString(assistants.toArray(new Resident[0])));
        }
        if (this.getAllies().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Allies (" + this.getAllies().size() + "): " + Arrays.toString(this.getAllies().toArray(new Nation[0])));
        }
        if (this.getEnemies().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Enemies (" + this.getEnemies().size() + "): " + Arrays.toString(this.getEnemies().toArray(new Nation[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Towns (" + this.getTowns().size() + "):");
        for (Town town : this.getTowns()) {
            out.addAll(town.getTreeString(depth + 2));
        }
        return out;
    }

    @Override
    public boolean hasResident(String name) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Resident> getOutlaws() {
        ArrayList<Resident> out = new ArrayList<Resident>();
        for (Town town : this.getTowns()) {
            out.addAll(town.getOutlaws());
        }
        return Collections.unmodifiableList(out);
    }

    public boolean hasValidUUID() {
        return this.uuid != null;
    }

    public void newSentAllyInvite(Invite invite) throws TooManyInvitesException {
        if (this.sentAllyInvites.size() > InviteHandler.getSentAllyRequestsMaxAmount(this) - 1) {
            throw new TooManyInvitesException(Translation.of("msg_err_nation_sent_too_many_requests"));
        }
        this.sentAllyInvites.add(invite);
    }

    public void deleteSentAllyInvite(Invite invite) {
        this.sentAllyInvites.remove(invite);
    }

    public List<Invite> getSentAllyInvites() {
        return Collections.unmodifiableList(this.sentAllyInvites);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>();
        for (Town town : this.getTowns()) {
            townBlocks.addAll(town.getTownBlocks());
        }
        return Collections.unmodifiableCollection(townBlocks);
    }

    public int getNumTownblocks() {
        return this.getTownBlocks().size();
    }

    public Resident getKing() {
        return this.capital.getMayor();
    }

    public boolean hasKing() {
        if (this.capital == null) {
            return false;
        }
        return this.capital.getMayor() != null;
    }

    @Override
    public String getFormattedName() {
        return TownySettings.getNationPrefix(this) + this.getName().replaceAll("_", " ") + TownySettings.getNationPostfix(this);
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    @Override
    public World getWorld() {
        if (this.hasCapital() && this.getCapital().hasWorld()) {
            return BukkitTools.getWorld(this.getCapital().getHomeblockWorld().getName());
        }
        return BukkitTools.getWorlds().get(0);
    }

    @Override
    public String getBankAccountPrefix() {
        return ECONOMY_ACCOUNT_PREFIX;
    }

    @Override
    public double getBankCap() {
        return TownySettings.getNationBankCap();
    }

    public boolean isAlliedWith(Nation nation) {
        return this.allies.contains(nation);
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveNation(this);
    }

    @Override
    public int getNationZoneSize() {
        if (!TownySettings.getNationZonesEnabled()) {
            return 0;
        }
        return Integer.parseInt(TownySettings.getNationLevel(this).get((Object)TownySettings.NationLevel.NATIONZONES_SIZE).toString());
    }

    @Deprecated
    public World getBukkitWorld() {
        if (this.hasCapital() && this.getCapital().hasWorld()) {
            return BukkitTools.getWorld(this.getCapital().getHomeblockWorld().getName());
        }
        return BukkitTools.getWorlds().get(0);
    }

    @Deprecated
    public String getEconomyName() {
        return StringMgmt.trimMaxLength(ECONOMY_ACCOUNT_PREFIX + this.getName(), 32);
    }

    @Deprecated
    public Location getNationSpawn() throws TownyException {
        return this.getSpawn();
    }

    @Deprecated
    public String getNationBoard() {
        return this.getBoard();
    }

    @Deprecated
    public void toggleNeutral(boolean neutral) {
        this.setNeutral(neutral);
    }

    @Deprecated
    public UUID getUuid() {
        return this.getUUID();
    }

    @Deprecated
    public void setUuid(UUID uuid) {
        this.setUUID(uuid);
    }
}

