/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.GovernmentTagChangeEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Identifiable;
import com.palmergames.bukkit.towny.object.Inviteable;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.SpawnLocation;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.economy.AccountAuditor;
import com.palmergames.bukkit.towny.object.economy.BankAccount;
import com.palmergames.bukkit.towny.object.economy.BankEconomyHandler;
import com.palmergames.bukkit.towny.object.economy.GovernmentAccountAuditor;
import com.palmergames.bukkit.util.BookFactory;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class Government
extends TownyObject
implements BankEconomyHandler,
ResidentList,
Inviteable,
Identifiable,
SpawnLocation {
    protected UUID uuid;
    protected BankAccount account;
    protected Location spawn;
    protected String tag = "";
    protected String board = null;
    private final transient List<Invite> receivedInvites = new ArrayList<Invite>();
    private final transient List<Invite> sentInvites = new ArrayList<Invite>();
    private boolean isPublic = false;
    private boolean isOpen = false;
    protected boolean isNeutral = false;
    private long registered;
    private double spawnCost = TownySettings.getSpawnTravelCost();
    protected double taxes;
    protected String mapColorHexCode = "";
    private final AccountAuditor accountAuditor = new GovernmentAccountAuditor();
    private boolean hasActiveWar = false;

    protected Government(String name) {
        super(name);
    }

    public final List<Invite> getReceivedInvites() {
        return Collections.unmodifiableList(this.receivedInvites);
    }

    @Override
    public final void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedInvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(String.format(Translation.of("msg_err_town_has_too_many_invites", this.getName()), new Object[0]));
        }
        this.receivedInvites.add(invite);
    }

    @Override
    public final void deleteReceivedInvite(Invite invite) {
        this.receivedInvites.remove(invite);
    }

    public final List<Invite> getSentInvites() {
        return Collections.unmodifiableList(this.sentInvites);
    }

    @Override
    public final void newSentInvite(Invite invite) throws TooManyInvitesException {
        if (this.sentInvites.size() > InviteHandler.getSentInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(Translation.of("msg_err_town_sent_too_many_invites"));
        }
        this.sentInvites.add(invite);
    }

    @Override
    public final void deleteSentInvite(Invite invite) {
        this.sentInvites.remove(invite);
    }

    public final void setBoard(String board) {
        this.board = board;
    }

    public String getBoard() {
        return this.board;
    }

    public final void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    public final void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public final boolean isOpen() {
        return this.isOpen;
    }

    public final void setNeutral(boolean neutral) {
        this.isNeutral = neutral;
    }

    public boolean isNeutral() {
        return this.isNeutral;
    }

    public final void setRegistered(long registered) {
        this.registered = registered;
    }

    public final long getRegistered() {
        return this.registered;
    }

    public final void setSpawnCost(double spawnCost) {
        this.spawnCost = spawnCost;
    }

    public final double getSpawnCost() {
        return this.spawnCost;
    }

    public final void setTag(String text) {
        this.tag = text.toUpperCase();
        if (this.tag.matches(" ")) {
            this.tag = "";
        }
        Bukkit.getPluginManager().callEvent((Event)new GovernmentTagChangeEvent(this.tag, this));
    }

    public final String getTag() {
        return this.tag;
    }

    public final boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public final void withdrawFromBank(Resident resident, int amount) throws TownyException {
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translation.of("msg_err_no_economy"));
        }
        if (!this.getAccount().payTo((double)amount, resident, "Withdraw by " + resident.getName())) {
            throw new TownyException(Translation.of("msg_err_no_money"));
        }
    }

    public final void depositToBank(Resident resident, int amount) throws TownyException {
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translation.of("msg_err_no_economy"));
        }
        if (!resident.getAccount().payTo((double)amount, this.getAccount(), "Deposit from " + resident.getName())) {
            throw new TownyException(Translation.of("msg_insuf_funds"));
        }
    }

    @Override
    public BankAccount getAccount() {
        if (this.account == null) {
            String accountName = StringMgmt.trimMaxLength(this.getBankAccountPrefix() + this.getName(), 32);
            World world = this.getWorld();
            this.account = new BankAccount(accountName, world, this.getBankCap());
            this.account.setAuditor(this.accountAuditor);
        }
        return this.account;
    }

    public abstract void setTaxes(double var1);

    public double getTaxes() {
        this.setTaxes(this.taxes);
        return this.taxes;
    }

    public abstract World getWorld();

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getMapColorHexCode() {
        return this.mapColorHexCode;
    }

    public void setMapColorHexCode(String mapColorHexCode) {
        this.mapColorHexCode = mapColorHexCode;
    }

    public abstract Collection<TownBlock> getTownBlocks();

    public boolean hasActiveWar() {
        return this.hasActiveWar;
    }

    public void setActiveWar(boolean active) {
        this.hasActiveWar = active;
    }

    public abstract int getNationZoneSize();

    public void generateBankHistoryBook(Player player, int desiredPages) {
        int size = this.getAccount().getAuditor().getAuditHistory().size();
        if (size < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "No pages to display!");
            return;
        }
        if (desiredPages < 1) {
            desiredPages = 1;
        }
        desiredPages = Math.min(desiredPages, size);
        ArrayList<String> pages = new ArrayList<String>(desiredPages);
        for (int i = 1; i <= desiredPages; ++i) {
            pages.add(this.getAccount().getAuditor().getAuditHistory().get(size - i));
        }
        player.openBook(BookFactory.makeBook("Bank History", this.getName(), pages));
    }
}

