/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.deathprice.NationPaysDeathPriceEvent;
import com.palmergames.bukkit.towny.event.deathprice.PlayerPaysDeathPriceEvent;
import com.palmergames.bukkit.towny.event.deathprice.TownPaysDeathPriceEvent;
import com.palmergames.bukkit.towny.event.player.PlayerKilledPlayerEvent;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.jail.JailReason;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.util.BukkitTools;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class TownyEntityMonitorListener
implements Listener {
    private final Towny plugin;

    public TownyEntityMonitorListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTakesDamage(EntityDamageEvent event) {
        if (!TownySettings.isDamageCancellingSpawnWarmup() || !event.getEntityType().equals((Object)EntityType.PLAYER) || !TownyTimerHandler.isTeleportWarmupRunning() || this.plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getEntity().getUniqueId());
        if (resident != null && resident.getTeleportRequestTime() > 0L) {
            TeleportWarmupTimerTask.abortTeleportRequest(resident);
            TownyMessaging.sendErrorMsg((CommandSender)event.getEntity(), Translatable.of("msg_err_teleport_cancelled_damage"));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Player defenderPlayer = event.getEntity();
        Resident defenderResident = TownyUniverse.getInstance().getResident(defenderPlayer.getUniqueId());
        if (defenderResident == null) {
            return;
        }
        if (defenderPlayer.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)defenderPlayer.getLastDamageCause();
            Entity attackerEntity = damageEvent.getDamager();
            Player attackerPlayer = null;
            Resident attackerResident = null;
            if (attackerEntity instanceof Projectile) {
                Projectile projectile = (Projectile)attackerEntity;
                if (projectile.getShooter() instanceof Player) {
                    attackerPlayer = (Player)projectile.getShooter();
                    attackerResident = townyUniverse.getResident(attackerPlayer.getUniqueId());
                } else {
                    try {
                        attackerEntity = (Entity)projectile.getShooter();
                    }
                    catch (Exception exception) {}
                }
            } else if (attackerEntity instanceof Player && (attackerResident = townyUniverse.getResident((attackerPlayer = (Player)attackerEntity).getUniqueId())) == null) {
                return;
            }
            if (attackerPlayer != null && attackerPlayer == defenderPlayer) {
                return;
            }
            if (attackerPlayer != null && attackerResident != null) {
                PlayerKilledPlayerEvent deathEvent = new PlayerKilledPlayerEvent(attackerPlayer, defenderPlayer, attackerResident, defenderResident, defenderPlayer.getLocation(), event);
                BukkitTools.getPluginManager().callEvent((Event)deathEvent);
                this.deathPayment(attackerPlayer, defenderPlayer, attackerResident, defenderResident);
                this.isJailingAttackers(attackerPlayer, defenderPlayer, attackerResident, defenderResident);
            } else if (!TownySettings.isDeathPricePVPOnly() && TownySettings.isChargingDeath()) {
                this.deathPayment(defenderPlayer, defenderResident);
            }
        } else if (!TownySettings.isDeathPricePVPOnly() && TownySettings.isChargingDeath()) {
            this.deathPayment(defenderPlayer, defenderResident);
        }
    }

    public void deathPayment(Player defenderPlayer, Resident defenderResident) {
        double price;
        if (!TownyEconomyHandler.isActive()) {
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(defenderPlayer);
        if (townBlock != null && (townBlock.getType().equals((Object)TownBlockType.ARENA) || townBlock.getType().equals((Object)TownBlockType.JAIL))) {
            return;
        }
        if (defenderPlayer != null && TownyUniverse.getInstance().getPermissionSource().testPermission(defenderPlayer, PermissionNodes.TOWNY_BYPASS_DEATH_COSTS.getNode())) {
            return;
        }
        if (defenderResident.isJailed()) {
            return;
        }
        if (TownySettings.getDeathPrice() > 0.0) {
            double price2 = TownySettings.getDeathPrice();
            if (!TownySettings.isDeathPriceType()) {
                price2 = defenderResident.getAccount().getHoldingBalance() * price2;
                if (TownySettings.isDeathPricePercentageCapped() && price2 > TownySettings.getDeathPricePercentageCap()) {
                    price2 = TownySettings.getDeathPricePercentageCap();
                }
            }
            if (!defenderResident.getAccount().canPayFromHoldings(price2)) {
                price2 = defenderResident.getAccount().getHoldingBalance();
            }
            PlayerPaysDeathPriceEvent ppdpe = new PlayerPaysDeathPriceEvent(defenderResident.getAccount(), price2, defenderResident, null);
            Bukkit.getPluginManager().callEvent((Event)ppdpe);
            if (!ppdpe.isCancelled()) {
                price2 = ppdpe.getAmount();
                defenderResident.getAccount().withdraw(price2, "Death Payment");
                TownyMessaging.sendMsg((CommandSender)defenderPlayer, Translatable.of("msg_you_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price2)));
            }
        }
        if (TownySettings.getDeathPriceTown() > 0.0 && defenderResident.hasTown()) {
            Town town = defenderResident.getTownOrNull();
            price = TownySettings.getDeathPriceTown();
            if (!TownySettings.isDeathPriceType()) {
                price = town.getAccount().getHoldingBalance() * price;
            }
            if (!town.getAccount().canPayFromHoldings(price)) {
                price = town.getAccount().getHoldingBalance();
            }
            TownPaysDeathPriceEvent tpdpe = new TownPaysDeathPriceEvent(defenderResident.getAccount(), price, defenderResident, null, town);
            Bukkit.getPluginManager().callEvent((Event)tpdpe);
            if (!tpdpe.isCancelled()) {
                price = tpdpe.getAmount();
                town.getAccount().withdraw(price, "Death Payment Town");
                TownyMessaging.sendTownMessagePrefixed(town, Translatable.of("msg_your_town_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price)));
            }
        }
        if (TownySettings.getDeathPriceNation() > 0.0 && defenderResident.hasNation()) {
            Nation nation = defenderResident.getNationOrNull();
            price = TownySettings.getDeathPriceNation();
            if (!TownySettings.isDeathPriceType()) {
                price = nation.getAccount().getHoldingBalance() * price;
            }
            if (!nation.getAccount().canPayFromHoldings(price)) {
                price = nation.getAccount().getHoldingBalance();
            }
            NationPaysDeathPriceEvent npdpe = new NationPaysDeathPriceEvent(defenderResident.getAccount(), price, defenderResident, null, nation);
            Bukkit.getPluginManager().callEvent((Event)npdpe);
            if (!npdpe.isCancelled()) {
                price = npdpe.getAmount();
                nation.getAccount().withdraw(price, "Death Payment Nation");
                TownyMessaging.sendNationMessagePrefixed(nation, Translatable.of("msg_your_nation_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price)));
            }
        }
    }

    public void deathPayment(Player attackerPlayer, Player defenderPlayer, Resident attackerResident, Resident defenderResident) {
        if (!TownyEconomyHandler.isActive()) {
            return;
        }
        if (defenderResident.isJailed()) {
            return;
        }
        if (CombatUtil.isAlly(attackerResident.getName(), defenderResident.getName())) {
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(defenderPlayer);
        if (townBlock != null && (townBlock.getType().equals((Object)TownBlockType.ARENA) || townBlock.getType().equals((Object)TownBlockType.JAIL))) {
            return;
        }
        if (defenderPlayer != null && TownyUniverse.getInstance().getPermissionSource().testPermission(defenderPlayer, PermissionNodes.TOWNY_BYPASS_DEATH_COSTS.getNode())) {
            return;
        }
        if (TownySettings.isChargingDeath() && attackerPlayer != null) {
            double price;
            double total = 0.0;
            if (TownySettings.getDeathPrice() > 0.0) {
                double price2 = TownySettings.getDeathPrice();
                if (!TownySettings.isDeathPriceType()) {
                    price2 = defenderResident.getAccount().getHoldingBalance() * price2;
                    if (TownySettings.isDeathPricePercentageCapped() && price2 > TownySettings.getDeathPricePercentageCap()) {
                        price2 = TownySettings.getDeathPricePercentageCap();
                    }
                }
                if (!defenderResident.getAccount().canPayFromHoldings(price2)) {
                    price2 = defenderResident.getAccount().getHoldingBalance();
                }
                PlayerPaysDeathPriceEvent ppdpe = new PlayerPaysDeathPriceEvent(defenderResident.getAccount(), price2, defenderResident, defenderPlayer);
                Bukkit.getPluginManager().callEvent((Event)ppdpe);
                if (!ppdpe.isCancelled()) {
                    price2 = ppdpe.getAmount();
                    defenderResident.getAccount().payTo(price2, attackerResident, "Death Payment");
                    total += price2;
                    TownyMessaging.sendMsg((CommandSender)defenderPlayer, Translatable.of("msg_you_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price2)));
                }
            }
            if (TownySettings.getDeathPriceTown() > 0.0 && defenderResident.hasTown()) {
                Town town = defenderResident.getTownOrNull();
                price = TownySettings.getDeathPriceTown();
                if (!TownySettings.isDeathPriceType()) {
                    price = town.getAccount().getHoldingBalance() * price;
                }
                if (!town.getAccount().canPayFromHoldings(price)) {
                    price = town.getAccount().getHoldingBalance();
                }
                TownPaysDeathPriceEvent tpdpe = new TownPaysDeathPriceEvent(town.getAccount(), price, defenderResident, defenderPlayer, town);
                Bukkit.getPluginManager().callEvent((Event)tpdpe);
                if (!tpdpe.isCancelled()) {
                    price = tpdpe.getAmount();
                    town.getAccount().payTo(price, attackerResident, "Death Payment Town");
                    total += price;
                    TownyMessaging.sendTownMessagePrefixed(town, Translatable.of("msg_your_town_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price)));
                }
            }
            if (TownySettings.getDeathPriceNation() > 0.0 && defenderResident.hasNation()) {
                Nation nation = defenderResident.getNationOrNull();
                price = TownySettings.getDeathPriceNation();
                if (!TownySettings.isDeathPriceType()) {
                    price = nation.getAccount().getHoldingBalance() * price;
                }
                if (!nation.getAccount().canPayFromHoldings(price)) {
                    price = nation.getAccount().getHoldingBalance();
                }
                NationPaysDeathPriceEvent npdpe = new NationPaysDeathPriceEvent(nation.getAccount(), price, defenderResident, defenderPlayer, nation);
                Bukkit.getPluginManager().callEvent((Event)npdpe);
                if (!npdpe.isCancelled()) {
                    price = npdpe.getAmount();
                    nation.getAccount().payTo(price, attackerResident, "Death Payment Nation");
                    total += price;
                    TownyMessaging.sendNationMessagePrefixed(nation, Translatable.of("msg_your_nation_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price)));
                }
            }
            if (attackerResident != null) {
                TownyMessaging.sendMsg(attackerResident, Translatable.of("msg_you_gained_money_for_killing", TownyEconomyHandler.getFormattedBalance(total), defenderPlayer.getName()));
            }
        }
    }

    public void isJailingAttackers(Player attackerPlayer, Player defenderPlayer, Resident attackerResident, Resident defenderResident) {
        if (TownySettings.isJailingAttackingOutlaws()) {
            Location loc = defenderPlayer.getLocation();
            if (!TownyAPI.getInstance().isTownyWorld(loc.getWorld())) {
                return;
            }
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(loc);
            if (townBlock == null) {
                return;
            }
            if (townBlock.getType() == TownBlockType.ARENA) {
                return;
            }
            if (defenderResident.isJailed()) {
                if (!townBlock.isJail()) {
                    TownyMessaging.sendGlobalMessage(Translatable.of("msg_killed_attempting_to_escape_jail", defenderPlayer.getName()));
                }
                return;
            }
            if (!attackerResident.hasTown()) {
                return;
            }
            Town attackerTown = attackerResident.getTownOrNull();
            if (!TownyAPI.getInstance().getTown(loc).getUUID().equals(attackerTown.getUUID())) {
                return;
            }
            if (!attackerTown.hasJails()) {
                return;
            }
            if (attackerTown.hasOutlaw(defenderResident)) {
                if (!TownyUniverse.getInstance().getPermissionSource().testPermission(attackerPlayer, PermissionNodes.TOWNY_OUTLAW_JAILER.getNode())) {
                    return;
                }
                JailUtil.jailResident(defenderResident, attackerTown.getPrimaryJail(), 0, JailReason.OUTLAW_DEATH.getHours(), JailReason.OUTLAW_DEATH, (CommandSender)attackerResident.getPlayer());
                return;
            }
        }
    }
}

