/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.adventure.bossbar.BossBar;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.event.BedExplodeEvent;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.damage.TownyPlayerDamagePlayerEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownLeaveEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.util.DrawSmokeTaskFactory;
import com.palmergames.util.TimeMgmt;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TownyCustomListener
implements Listener {
    private final Towny plugin;
    private final Map<Player, Integer> playerActionTasks = new HashMap<Player, Integer>();
    private final Map<Player, BossBar> playerBossBarMap = new HashMap<Player, BossBar>();

    public TownyCustomListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        Player player = event.getPlayer();
        WorldCoord from = event.getFrom();
        WorldCoord to = event.getTo();
        if (!TownyAPI.getInstance().isTownyWorld(to.getBukkitWorld())) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            return;
        }
        if (resident.hasMode("townclaim")) {
            TownCommand.parseTownClaimCommand(player, new String[0]);
        }
        if (resident.hasMode("townunclaim")) {
            TownCommand.parseTownUnclaimCommand(player, new String[0]);
        }
        if (resident.hasMode("map")) {
            TownyCommand.showMap(player);
        }
        if (resident.hasMode("plotborder")) {
            BorderUtil.getPlotBorder(to).runBorderedOnSurface(1, 2, DrawSmokeTaskFactory.sendToPlayer(player));
        }
        if (TownySettings.getShowTownNotifications()) {
            String msg = null;
            try {
                ChunkNotification chunkNotifier = new ChunkNotification(from, to);
                msg = chunkNotifier.getNotificationString(resident);
            }
            catch (NullPointerException e) {
                this.plugin.getLogger().info("ChunkNotifier generated an NPE, this is harmless but if you'd like to report it the following information will be useful:");
                this.plugin.getLogger().info("  Player: " + player.getName() + "  To: " + to.getWorldName() + "," + to.getX() + "," + to.getZ() + "  From: " + from.getWorldName() + "," + from.getX() + "," + from.getZ());
                e.printStackTrace();
            }
            if (msg == null) {
                return;
            }
            this.sendChunkNoticiation(player, msg);
        }
    }

    private void sendChunkNoticiation(Player player, String msg) {
        if (TownySettings.isNotificationsAppearingInActionBar() && !TownySettings.isNotificationsAppearingOnBossbar()) {
            this.sendActionBarChunkNotification(player, LegacyComponentSerializer.builder().build().deserialize(msg));
        } else if (TownySettings.isNotificationsAppearingOnBossbar()) {
            this.sendBossBarChunkNotification(player, BossBar.bossBar(LegacyComponentSerializer.builder().build().deserialize(msg), 1.0f, BossBar.Color.WHITE, BossBar.Overlay.PROGRESS));
        } else {
            TownyMessaging.sendMessage((Object)player, msg);
        }
    }

    private void sendActionBarChunkNotification(Player player, TextComponent msgComponent) {
        int seconds = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION);
        if (seconds > 3) {
            if (this.playerActionTasks.get(player) != null) {
                this.removePlayerActionTasks(player);
            }
            AtomicInteger remainingSeconds = new AtomicInteger(seconds);
            int taskID = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                TownyMessaging.sendActionBarMessageToPlayer(player, msgComponent);
                remainingSeconds.getAndDecrement();
                if (remainingSeconds.get() == 0 && this.playerActionTasks.containsKey(player)) {
                    this.removePlayerActionTasks(player);
                }
            }, 0L, 20L).getTaskId();
            this.playerActionTasks.put(player, taskID);
        } else {
            TownyMessaging.sendActionBarMessageToPlayer(player, msgComponent);
        }
    }

    private void sendBossBarChunkNotification(Player player, BossBar bossBar) {
        int seconds = TownySettings.getInt(ConfigNodes.NOTIFICATION_DURATION) * 20;
        if (this.playerBossBarMap.containsKey(player)) {
            this.removePlayerActionTasks(player);
            this.removePlayerBossBar(player);
        }
        TownyMessaging.sendBossBarMessageToPlayer(player, bossBar);
        int taskID = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.playerActionTasks.remove(player);
            this.removePlayerBossBar(player);
        }, (long)seconds).getTaskId();
        this.playerBossBarMap.put(player, bossBar);
        this.playerActionTasks.put(player, taskID);
    }

    private void removePlayerActionTasks(Player player) {
        Bukkit.getScheduler().cancelTask(this.playerActionTasks.get(player).intValue());
        this.playerActionTasks.remove(player);
    }

    private void removePlayerBossBar(Player player) {
        Towny.getAdventure().player(player).hideBossBar(this.playerBossBarMap.get(player));
        this.playerBossBarMap.remove(player);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerCreateTown(NewTownEvent event) {
        Town town = event.getTown();
        double upkeep = TownySettings.getTownUpkeepCost(town);
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily() && upkeep > 0.0) {
            String cost = TownyEconomyHandler.getFormattedBalance(upkeep);
            String time = TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime());
            TownyMessaging.sendTownMessagePrefixed(town, Translatable.of("msg_new_town_advice", cost, time));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBedExplodeEvent(final BedExplodeEvent event) {
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(event.getLocation().getWorld().getName());
        world.addBedExplosionAtBlock(event.getLocation(), event.getMaterial());
        if (event.getLocation2() != null) {
            // empty if block
        }
        world.addBedExplosionAtBlock(event.getLocation2(), event.getMaterial());
        final TownyWorld finalWorld = world;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                finalWorld.removeBedExplosionAtBlock(event.getLocation());
                finalWorld.removeBedExplosionAtBlock(event.getLocation2());
            }
        }, 20L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTownLeaveNation(NationPreTownLeaveEvent event) {
        if (event.getTown().isConquered()) {
            event.setCancelMessage(Translation.of("msg_err_your_conquered_town_cannot_leave_the_nation_yet"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDamagePlayerEvent(TownyPlayerDamagePlayerEvent event) {
        Resident victim = event.getVictimResident();
        Resident attacker = event.getAttackingResident();
        if (victim.getSpawnProtectionTaskID() != 0) {
            event.setCancelled(true);
            event.setMessage(Translatable.of("msg_err_player_cannot_be_harmed", victim.getName()).forLocale(attacker));
        }
        if (attacker.getSpawnProtectionTaskID() != 0) {
            event.setCancelled(true);
            attacker.removeSpawnProtection();
        }
    }
}

