/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.invites;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteReceiver;
import com.palmergames.bukkit.towny.invites.InviteSender;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InviteHandler {
    private static Towny plugin;
    private static final Set<Invite> activeInvites;
    private static final Map<Invite, Long> invitesTimes;

    public static void initialize(Towny plugin) {
        InviteHandler.plugin = plugin;
    }

    public static void acceptInvite(Invite invite) throws InvalidObjectException, TownyException {
        if (activeInvites.contains(invite)) {
            invite.accept();
            InviteHandler.removeInvite(invite);
            return;
        }
        throw new InvalidObjectException("Invite not valid!");
    }

    public static void declineInvite(Invite invite, boolean fromSender) throws InvalidObjectException {
        if (activeInvites.contains(invite)) {
            invite.decline(fromSender);
            InviteHandler.removeInvite(invite);
            return;
        }
        throw new InvalidObjectException("Invite not valid!");
    }

    public static void addInvite(Invite invite) {
        activeInvites.add(invite);
        invitesTimes.put(invite, System.currentTimeMillis());
    }

    public static void removeInvite(Invite invite) {
        activeInvites.remove(invite);
        invitesTimes.remove(invite);
    }

    private static long getInviteTime(Invite invite) {
        return invitesTimes.get(invite);
    }

    public static void searchForExpiredInvites() {
        long time = TownySettings.getInviteExpirationTime() * 1000L;
        for (Invite activeInvite : new ArrayList<Invite>(InviteHandler.getActiveInvites())) {
            if (InviteHandler.getInviteTime(activeInvite) + time >= System.currentTimeMillis()) continue;
            activeInvite.getReceiver().deleteReceivedInvite(activeInvite);
            activeInvite.getSender().deleteSentInvite(activeInvite);
            InviteHandler.removeInvite(activeInvite);
        }
    }

    public static Collection<Invite> getActiveInvites() {
        return Collections.unmodifiableSet(activeInvites);
    }

    public static boolean inviteIsActive(Invite invite) {
        for (Invite activeInvite : activeInvites) {
            if (!activeInvite.getReceiver().equals(invite.getReceiver()) || !activeInvite.getSender().equals(invite.getSender())) continue;
            return true;
        }
        return false;
    }

    public static boolean inviteIsActive(InviteSender sender, InviteReceiver receiver) {
        for (Invite activeInvite : activeInvites) {
            if (!activeInvite.getReceiver().equals(receiver) || !activeInvite.getSender().equals(sender)) continue;
            return true;
        }
        return false;
    }

    public static int getSentAllyRequestsMaxAmount(Nation sender) {
        int amount = 0;
        if (sender != null) {
            amount = TownySettings.getMaximumRequestsSentNation() == 0 ? 100 : TownySettings.getMaximumRequestsSentNation();
        }
        return amount;
    }

    public static int getReceivedInvitesMaxAmount(InviteReceiver receiver) {
        int amount = 0;
        if (receiver instanceof Resident) {
            amount = TownySettings.getMaximumInvitesReceivedResident() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedResident();
        }
        if (receiver instanceof Town) {
            amount = TownySettings.getMaximumInvitesReceivedTown() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedTown();
        }
        if (receiver instanceof Nation) {
            amount = TownySettings.getMaximumRequestsReceivedNation() == 0 ? 100 : TownySettings.getMaximumRequestsReceivedNation();
        }
        return amount;
    }

    public static int getSentInvitesMaxAmount(InviteSender sender) {
        int amount = 0;
        if (sender instanceof Town) {
            amount = TownySettings.getMaximumInvitesSentTown() == 0 ? 100 : TownySettings.getMaximumInvitesSentTown();
        }
        if (sender instanceof Nation) {
            amount = TownySettings.getMaximumInvitesSentNation() == 0 ? 100 : TownySettings.getMaximumInvitesSentNation();
        }
        return amount;
    }

    static {
        activeInvites = new HashSet<Invite>();
        invitesTimes = new HashMap<Invite, Long>();
    }
}

