/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.huds;

import com.palmergames.adventure.text.TextComponent;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.asciimap.WildernessMapEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.map.TownyMapData;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class MapHUD {
    private static int lineWidth = 19;
    private static int lineHeight = 10;
    private static final int townBlockSize = TownySettings.getTownBlockSize();

    public static void toggleOn(Player player) {
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective objective = board.registerNewObjective("MAP_HUD_OBJ", "dummy", "maphud");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        int score = lineHeight + 2;
        ChatColor[] colors = ChatColor.values();
        for (int i = 0; i < lineHeight; ++i) {
            board.registerNewTeam("mapTeam" + i).addEntry(colors[i].toString());
            objective.getScore(colors[i].toString()).setScore(score);
            --score;
        }
        String townEntry = ChatColor.DARK_GREEN + Translatable.of("town_sing").forLocale((CommandSender)player) + ": ";
        String ownerEntry = ChatColor.DARK_GREEN + Translatable.of("owner_status").forLocale((CommandSender)player) + ": ";
        board.registerNewTeam("townTeam").addEntry(townEntry);
        objective.getScore(townEntry).setScore(2);
        board.registerNewTeam("ownerTeam").addEntry(ownerEntry);
        objective.getScore(ownerEntry).setScore(1);
        player.setScoreboard(board);
        MapHUD.updateMap(player);
    }

    public static void updateMap(Player player) {
        MapHUD.updateMap(player, WorldCoord.parseWorldCoord((Entity)player));
    }

    public static void updateMap(Player player, WorldCoord wc) {
        Scoreboard board = player.getScoreboard();
        if (board == null) {
            MapHUD.toggleOn(player);
            return;
        }
        if (board.getObjective("MAP_HUD_OBJ") == null) {
            HUDManager.toggleOff(player);
            return;
        }
        Objective objective = board.getObjective("MAP_HUD_OBJ");
        objective.setDisplayName(ChatColor.GOLD + "Towny Map " + ChatColor.WHITE + "(" + wc.getX() + ", " + wc.getZ() + ")");
        TownyWorld world = wc.getTownyWorldOrNull();
        if (world == null || !world.isUsingTowny()) {
            HUDManager.toggleOff(player);
            return;
        }
        Resident resident = TownyAPI.getInstance().getResident(player.getName());
        boolean hasTown = resident.hasTown();
        int halfLineWidth = lineWidth / 2;
        int halfLineHeight = lineHeight / 2;
        String[][] map = new String[lineWidth][lineHeight];
        int y = 0;
        for (int tby = wc.getX() + (lineWidth - halfLineWidth - 1); tby >= wc.getX() - halfLineWidth; --tby) {
            int x = 0;
            for (int tbx = wc.getZ() - halfLineHeight; tbx <= wc.getZ() + (lineHeight - halfLineHeight - 1); ++tbx) {
                map[y][x] = "\u00a7f";
                try {
                    TownBlock townblock = world.getTownBlock(tby, tbx);
                    if (!townblock.hasTown()) {
                        throw new TownyException();
                    }
                    if (x == halfLineHeight && y == halfLineWidth) {
                        map[y][x] = "\u00a76";
                    } else if (hasTown) {
                        if (resident.getTown() == townblock.getTown()) {
                            map[y][x] = "\u00a7a";
                            try {
                                if (resident == townblock.getResident()) {
                                    map[y][x] = "\u00a7e";
                                }
                            }
                            catch (NotRegisteredException notRegisteredException) {}
                        } else if (resident.hasNation()) {
                            if (resident.getTown().getNation().hasTown(townblock.getTown())) {
                                map[y][x] = "\u00a72";
                            } else if (townblock.getTown().hasNation()) {
                                Nation nation = resident.getTown().getNation();
                                if (nation.hasAlly(townblock.getTown().getNation())) {
                                    map[y][x] = "\u00a72";
                                } else if (nation.hasEnemy(townblock.getTown().getNation())) {
                                    map[y][x] = "\u00a74";
                                }
                            }
                        }
                    }
                    if (townblock.getPlotPrice() != -1.0 || townblock.hasPlotObjectGroup() && townblock.getPlotObjectGroup().getPrice() != -1.0) {
                        if (townblock.getType().equals((Object)TownBlockType.COMMERCIAL)) {
                            map[y][x] = "\u00a73";
                        }
                        String[] stringArray = map[y];
                        int n = x;
                        stringArray[n] = stringArray[n] + "$";
                    } else if (townblock.isHomeBlock()) {
                        String[] stringArray = map[y];
                        int n = x;
                        stringArray[n] = stringArray[n] + "H";
                    } else {
                        String[] stringArray = map[y];
                        int n = x;
                        stringArray[n] = stringArray[n] + townblock.getType().getAsciiMapKey();
                    }
                }
                catch (TownyException e) {
                    String clickCommand;
                    TextComponent hoverText;
                    String symbol;
                    map[y][x] = x == halfLineHeight && y == halfLineWidth ? "\u00a76" : "\u00a78";
                    WorldCoord worldcoord = WorldCoord.parseWorldCoord(world.getName(), tby * townBlockSize, tbx * townBlockSize);
                    if (MapHUD.getWildernessMapDataMap().containsKey(worldcoord) && !MapHUD.getWildernessMapDataMap().get(worldcoord).isOld()) {
                        TownyMapData mapData = MapHUD.getWildernessMapDataMap().get(worldcoord);
                        symbol = mapData.getSymbol();
                        hoverText = mapData.getHoverText();
                        clickCommand = mapData.getClickCommand();
                    } else {
                        if (MapHUD.getWildernessMapDataMap().containsKey(worldcoord)) {
                            MapHUD.getWildernessMapDataMap().remove(worldcoord);
                        }
                        WildernessMapEvent wildMapEvent = new WildernessMapEvent(worldcoord);
                        Bukkit.getPluginManager().callEvent((Event)wildMapEvent);
                        symbol = wildMapEvent.getMapSymbol();
                        hoverText = wildMapEvent.getHoverText();
                        clickCommand = wildMapEvent.getClickCommand();
                        MapHUD.getWildernessMapDataMap().put(worldcoord, new TownyMapData(worldcoord, symbol, hoverText, clickCommand));
                        Bukkit.getScheduler().runTaskLater((Plugin)Towny.getPlugin(), () -> {
                            if (MapHUD.getWildernessMapDataMap().containsKey(worldcoord) && MapHUD.getWildernessMapDataMap().get(worldcoord).isOld()) {
                                MapHUD.getWildernessMapDataMap().remove(worldcoord);
                            }
                        }, 700L);
                    }
                    String[] stringArray = map[y];
                    int n = x;
                    stringArray[n] = stringArray[n] + symbol;
                }
                ++x;
            }
            ++y;
        }
        for (int my = 0; my < lineHeight; ++my) {
            String line = "";
            for (int mx = lineWidth - 1; mx >= 0; --mx) {
                line = line + map[mx][my];
            }
            board.getTeam("mapTeam" + my).setSuffix(line);
        }
        TownBlock tb = wc.getTownBlockOrNull();
        board.getTeam("townTeam").setSuffix(ChatColor.GREEN + (tb != null && tb.hasTown() ? tb.getTownOrNull().getName() : Translatable.of("status_no_town").forLocale((CommandSender)player)));
        board.getTeam("ownerTeam").setSuffix(ChatColor.GREEN + (tb != null && tb.hasResident() ? tb.getResidentOrNull().getName() : Translatable.of("status_no_town").forLocale((CommandSender)player)));
    }

    private static Map<WorldCoord, TownyMapData> getWildernessMapDataMap() {
        return TownyUniverse.getInstance().getWildernessMapDataMap();
    }
}

