/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.huds;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.huds.MapHUD;
import com.palmergames.bukkit.towny.huds.PermHUD;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class HUDManager
implements Listener {
    static List<Player> permUsers;
    static List<Player> mapUsers;

    public HUDManager(Towny plugin) {
        permUsers = new ArrayList<Player>();
        mapUsers = new ArrayList<Player>();
    }

    public static void togglePermHUD(Player p) {
        if (!permUsers.contains(p)) {
            HUDManager.toggleAllOff(p);
            permUsers.add(p);
            PermHUD.toggleOn(p);
        } else {
            HUDManager.toggleAllOff(p);
        }
    }

    public static void toggleMapHud(Player player) {
        if (!mapUsers.contains(player)) {
            HUDManager.toggleAllOff(player);
            mapUsers.add(player);
            MapHUD.toggleOn(player);
        } else {
            HUDManager.toggleAllOff(player);
        }
    }

    public static void toggleAllOff(Player p) {
        permUsers.remove(p);
        mapUsers.remove(p);
        if (p.isOnline()) {
            HUDManager.toggleOff(p);
        }
    }

    public static void toggleOff(Player p) {
        p.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        permUsers.remove(event.getPlayer());
        mapUsers.remove(event.getPlayer());
    }

    @EventHandler
    public void onPlayerMovePlotsEvent(PlayerChangePlotEvent event) throws NotRegisteredException {
        Player p = event.getPlayer();
        if (permUsers.contains(p)) {
            if (!HUDManager.isPermHUDActive(p)) {
                permUsers.remove(p);
            } else if (event.getTo().getTownyWorld().isUsingTowny()) {
                PermHUD.updatePerms(p, event.getTo());
            } else {
                HUDManager.toggleAllOff(p);
            }
        } else if (mapUsers.contains(p)) {
            if (!HUDManager.isMapHudActive(p)) {
                mapUsers.remove(p);
            } else if (event.getTo().getTownyWorld().isUsingTowny()) {
                MapHUD.updateMap(p, event.getTo());
            } else {
                HUDManager.toggleAllOff(p);
            }
        }
    }

    @EventHandler
    public void onTownBlockSettingsChanged(TownBlockSettingsChangedEvent e) {
        block8: {
            block9: {
                block7: {
                    if (e.getTownyWorld() == null) break block7;
                    for (Player p : permUsers) {
                        PermHUD.updatePerms(p);
                    }
                    break block8;
                }
                if (e.getTown() == null) break block9;
                for (Player p : permUsers) {
                    try {
                        if (new WorldCoord(p.getWorld().getName(), Coord.parseCoord((Entity)p)).getTownBlock().getTown() != e.getTown()) continue;
                        PermHUD.updatePerms(p);
                    }
                    catch (Exception exception) {}
                }
                break block8;
            }
            if (e.getTownBlock() == null) break block8;
            for (Player p : permUsers) {
                try {
                    if (new WorldCoord(p.getWorld().getName(), Coord.parseCoord((Entity)p)).getTownBlock() != e.getTownBlock()) continue;
                    PermHUD.updatePerms(p);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String check(String string) {
        return string.length() > 64 ? string.substring(0, 64) : string;
    }

    public static boolean isUsingTownyHUD(Player player) {
        return permUsers.contains(player) || mapUsers.contains(player);
    }

    public static List<Player> getPermHUDUsers() {
        return permUsers;
    }

    public static List<Player> getMapHUDUsers() {
        return mapUsers;
    }

    public static void removePermHUDUser(Player player) {
        if (permUsers.remove(player)) {
            HUDManager.toggleOff(player);
        }
    }

    public static void removeMapHUDUser(Player player) {
        if (mapUsers.remove(player)) {
            HUDManager.toggleOff(player);
        }
    }

    public static boolean isPermHUDActive(Player player) {
        return player.getScoreboard().getTeam("plot") != null;
    }

    public static boolean isMapHudActive(Player player) {
        return player.getScoreboard().getTeam("mapTeam1") != null;
    }
}

