/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.town.toggle;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Nullable;

public abstract class TownToggleEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Town town;
    private final CommandSender sender;
    private final boolean isAdminAction;
    private boolean isCancelled = false;
    private String cancellationMsg = Translation.of("msg_err_command_disable");

    public TownToggleEvent(CommandSender sender, Town town, boolean admin) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.sender = sender;
        this.town = town;
        this.isAdminAction = admin;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    @Nullable
    public Resident getResident() {
        Player player = this.getPlayer();
        if (player != null) {
            return TownyUniverse.getInstance().getResident(player.getUniqueId());
        }
        return null;
    }

    @Nullable
    public Player getPlayer() {
        return this.sender instanceof Player ? (Player)this.sender : null;
    }

    public Town getTown() {
        return this.town;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public String getCancellationMsg() {
        return this.cancellationMsg;
    }

    public void setCancellationMsg(String cancellationMsg) {
        this.cancellationMsg = cancellationMsg;
    }

    public boolean isAdminAction() {
        return this.isAdminAction;
    }
}

