/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.nation;

import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Translation;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NationSetSpawnEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Nation nation;
    private final Player player;
    private final Location oldSpawn;
    private Location newSpawn;
    private boolean cancelled = false;
    private String cancelMessage = Translation.of("msg_err_command_disable");

    public NationSetSpawnEvent(Nation nation, Player player, Location newSpawn) {
        this.nation = nation;
        this.player = player;
        this.oldSpawn = nation.getSpawnOrNull();
        this.newSpawn = newSpawn;
    }

    @NotNull
    public Nation getNation() {
        return this.nation;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Location getOldSpawn() {
        return this.oldSpawn;
    }

    @NotNull
    public Location getNewSpawn() {
        return this.newSpawn;
    }

    public void setNewSpawn(@NotNull Location newSpawn) {
        this.newSpawn = newSpawn;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelMessage(String cancelMessage) {
        this.cancelMessage = cancelMessage;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }
}

