/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.google.gson.Gson;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.SQL_Schema;
import com.palmergames.bukkit.towny.db.SQL_Task;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.MetadataLoader;
import com.palmergames.bukkit.towny.utils.MapUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.hikaricp.HikariConfig;
import com.palmergames.hikaricp.HikariDataSource;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class TownySQLSource
extends TownyDatabaseHandler {
    private final Queue<SQL_Task> queryQueue = new ConcurrentLinkedQueue<SQL_Task>();
    private BukkitTask task = null;
    private final String dsn;
    private final String db_name;
    private final String username;
    private final String password;
    private final String tb_prefix;
    private Connection cntx = null;
    private final HikariConfig config;
    private final HikariDataSource hikariDataSource;

    public TownySQLSource(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        if (!FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.dataFolderPath, this.dataFolderPath + File.separator + "plot-block-data") || !FileMgmt.checkOrCreateFiles(this.dataFolderPath + File.separator + "regen.txt", this.dataFolderPath + File.separator + "snapshot_queue.txt")) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
        this.db_name = TownySettings.getSQLDBName();
        this.tb_prefix = TownySettings.getSQLTablePrefix().toUpperCase();
        this.dsn = "jdbc:mysql://" + TownySettings.getSQLHostName() + ":" + TownySettings.getSQLPort() + "/" + this.db_name + TownySettings.getSQLFlags();
        this.config = new HikariConfig();
        this.config.setPoolName("Towny MySQL");
        this.config.setJdbcUrl(this.dsn);
        this.username = TownySettings.getSQLUsername();
        this.password = TownySettings.getSQLPassword();
        this.config.setUsername(this.username);
        this.config.setPassword(this.password);
        this.config.addDataSourceProperty("cachePrepStmts", "true");
        this.config.addDataSourceProperty("prepStmtCacheSize", "250");
        this.config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.config.addDataSourceProperty("useServerPrepStmts", "true");
        this.config.addDataSourceProperty("useLocalSessionState", "true");
        this.config.addDataSourceProperty("rewriteBatchedStatements", "true");
        this.config.addDataSourceProperty("cacheResultSetMetadata", "true");
        this.config.addDataSourceProperty("cacheServerConfiguration", "true");
        this.config.addDataSourceProperty("elideSetAutoCommits", "true");
        this.config.addDataSourceProperty("maintainTimeStats", "false");
        this.config.addDataSourceProperty("cacheCallableStmts", "true");
        this.config.setMaximumPoolSize(TownySettings.getMaxPoolSize());
        this.config.setMaxLifetime(TownySettings.getMaxLifetime());
        this.config.setConnectionTimeout(TownySettings.getConnectionTimeout());
        this.hikariDataSource = new HikariDataSource(this.config);
        try {
            Driver driver;
            try {
                driver = (Driver)Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                driver = (Driver)Class.forName("com.mysql.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            DriverManager.registerDriver(driver);
        }
        catch (Exception e) {
            plugin.getLogger().severe("Driver error: " + e);
        }
        if (!this.getContext()) {
            TownyMessaging.sendErrorMsg("Failed when connecting to Database");
            return;
        }
        TownyMessaging.sendDebugMsg("Connected to Database");
        SQL_Schema.initTables(this.cntx, this.db_name);
        this.task = BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            while (!this.queryQueue.isEmpty()) {
                SQL_Task query = this.queryQueue.poll();
                if (query.update) {
                    this.QueueUpdateDB(query.tb_name, query.args, query.keys);
                    continue;
                }
                this.QueueDeleteDB(query.tb_name, query.args);
            }
        }, 5L, 5L);
    }

    @Override
    public void finishTasks() {
        this.task.cancel();
        while (!this.queryQueue.isEmpty()) {
            SQL_Task query = this.queryQueue.poll();
            if (query.update) {
                this.QueueUpdateDB(query.tb_name, query.args, query.keys);
                continue;
            }
            this.QueueDeleteDB(query.tb_name, query.args);
        }
        this.hikariDataSource.close();
    }

    public boolean getContext() {
        try {
            if (this.cntx == null || this.cntx.isClosed() || !this.cntx.isValid(1)) {
                if (this.cntx != null && !this.cntx.isClosed()) {
                    try {
                        this.cntx.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.cntx = null;
                }
                this.cntx = this.hikariDataSource.getConnection();
                return this.cntx != null && !this.cntx.isClosed();
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error could not Connect to db " + this.dsn + ": " + e.getMessage());
            return false;
        }
    }

    public boolean UpdateDB(String tb_name, HashMap<String, Object> args, List<String> keys) {
        this.queryQueue.add(new SQL_Task(tb_name, args, keys));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean QueueUpdateDB(String tb_name, HashMap<String, Object> args, List<String> keys) {
        if (!this.getContext()) {
            return false;
        }
        Statement stmt = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        int rs = 0;
        try {
            StringBuilder code;
            String[] aKeys;
            if (keys == null) {
                parameters.addAll(args.values());
                aKeys = args.keySet().toArray(new String[0]);
                code = new StringBuilder("REPLACE INTO " + this.tb_prefix + tb_name.toUpperCase() + " ");
                StringBuilder keycode = new StringBuilder("(");
                StringBuilder valuecode = new StringBuilder(" VALUES (");
                for (int count = 0; count < args.size(); ++count) {
                    keycode.append("`").append(aKeys[count]).append("`");
                    valuecode.append("?");
                    if (count < args.size() - 1) {
                        keycode.append(", ");
                        valuecode.append(",");
                        continue;
                    }
                    keycode.append(")");
                    valuecode.append(")");
                }
                code.append((CharSequence)keycode);
                code.append((CharSequence)valuecode);
            } else {
                int count;
                aKeys = args.keySet().toArray(new String[0]);
                code = new StringBuilder("UPDATE " + this.tb_prefix + tb_name.toUpperCase() + " SET ");
                for (count = 0; count < args.size(); ++count) {
                    code.append("`").append(aKeys[count]).append("` = ?");
                    parameters.add(args.get(aKeys[count]));
                    if (count >= args.size() - 1) continue;
                    code.append(",");
                }
                code.append(" WHERE ");
                for (count = 0; count < keys.size(); ++count) {
                    code.append("`").append(keys.get(count)).append("` = ?");
                    parameters.add(args.get(keys.get(count)));
                    if (count >= keys.size() - 1) continue;
                    code.append(" AND ");
                }
            }
            stmt = this.cntx.prepareStatement(code.toString());
            for (int count = 0; count < parameters.size(); ++count) {
                Object element = parameters.get(count);
                if (element instanceof String) {
                    stmt.setString(count + 1, (String)element);
                    continue;
                }
                if (element instanceof Boolean) {
                    stmt.setString(count + 1, (Boolean)element != false ? "1" : "0");
                    continue;
                }
                stmt.setObject(count + 1, element.toString());
            }
            rs = stmt.executeUpdate();
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: " + e.getMessage() + " --> " + stmt.toString());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs == 0) {
                    return this.UpdateDB(tb_name, args, null);
                }
            }
            catch (SQLException e) {
                TownyMessaging.sendErrorMsg("SQL closing: " + e.getMessage() + " --> " + stmt.toString());
            }
        }
        return rs != 0;
    }

    public boolean DeleteDB(String tb_name, HashMap<String, Object> args) {
        this.queryQueue.add(new SQL_Task(tb_name, args));
        return true;
    }

    public boolean QueueDeleteDB(String tb_name, HashMap<String, Object> args) {
        if (!this.getContext()) {
            return false;
        }
        try {
            int rs;
            StringBuilder wherecode = new StringBuilder("DELETE FROM " + this.tb_prefix + tb_name.toUpperCase() + " WHERE ");
            Set<Map.Entry<String, Object>> set = args.entrySet();
            Iterator<Map.Entry<String, Object>> i = set.iterator();
            while (i.hasNext()) {
                Map.Entry<String, Object> me = i.next();
                wherecode.append("`").append(me.getKey()).append("` = ");
                if (me.getValue() instanceof String) {
                    wherecode.append("'").append(((String)me.getValue()).replace("'", "''")).append("'");
                } else if (me.getValue() instanceof Boolean) {
                    wherecode.append("'").append((Boolean)me.getValue() != false ? "1" : "0").append("'");
                } else {
                    wherecode.append("'").append(me.getValue()).append("'");
                }
                wherecode.append(i.hasNext() ? " AND " : "");
            }
            try (Statement statement = this.cntx.createStatement();){
                rs = statement.executeUpdate(wherecode.toString());
            }
            if (rs == 0) {
                TownyMessaging.sendDebugMsg("SQL: delete returned 0: " + wherecode);
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Error delete : " + e.getMessage());
        }
        return false;
    }

    @Override
    public boolean cleanup() {
        if (!this.getContext()) {
            return false;
        }
        SQL_Schema.cleanup(this.cntx, this.db_name);
        return true;
    }

    @Override
    public boolean loadTownBlockList() {
        TownyMessaging.sendDebugMsg("Loading TownBlock List");
        if (!this.getContext()) {
            return false;
        }
        try {
            try (Statement s = this.cntx.createStatement();){
                int total = 0;
                ResultSet rs = s.executeQuery("SELECT world,x,z FROM " + this.tb_prefix + "TOWNBLOCKS");
                while (rs.next()) {
                    TownyWorld world = this.getWorld(rs.getString("world"));
                    int x = Integer.parseInt(rs.getString("x"));
                    int z = Integer.parseInt(rs.getString("z"));
                    TownBlock townBlock = new TownBlock(x, z, world);
                    TownyUniverse.getInstance().addTownBlock(townBlock);
                    ++total;
                }
                TownyMessaging.sendDebugMsg("Loaded " + total + " townblocks.");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg("Loading Resident List");
        if (!this.getContext()) {
            return false;
        }
        try {
            try (Statement s = this.cntx.createStatement();){
                ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "RESIDENTS");
                while (rs.next()) {
                    try {
                        this.newResident(rs.getString("name"));
                    }
                    catch (AlreadyRegisteredException alreadyRegisteredException) {}
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadHibernatedResidents() {
        TownyMessaging.sendDebugMsg("Loading Hibernated Resident List");
        if (!this.getContext()) {
            return false;
        }
        try {
            try (Statement s = this.cntx.createStatement();){
                ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "HIBERNATEDRESIDENTS");
                while (rs.next()) {
                    UUID uuid = null;
                    long registered = 0L;
                    if (rs.getString("uuid") != null && !rs.getString("uuid").isEmpty()) {
                        uuid = UUID.fromString(rs.getString("uuid"));
                    }
                    if (rs.getString("registered") != null && !rs.getString("registered").isEmpty()) {
                        registered = Long.parseLong(rs.getString("registered"));
                    }
                    if (uuid == null || registered <= 0L) continue;
                    this.universe.registerHibernatedResident(uuid, registered);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg("Loading Town List");
        if (!this.getContext()) {
            return false;
        }
        try {
            try (Statement s = this.cntx.createStatement();){
                ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "TOWNS");
                while (rs.next()) {
                    try {
                        TownyUniverse.getInstance().newTownInternal(rs.getString("name"));
                    }
                    catch (AlreadyRegisteredException alreadyRegisteredException) {}
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: town list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: town list unknown error: ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg("Loading Nation List");
        if (!this.getContext()) {
            return false;
        }
        try {
            try (Statement s = this.cntx.createStatement();){
                ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "NATIONS");
                while (rs.next()) {
                    try {
                        this.newNation(rs.getString("name"));
                    }
                    catch (AlreadyRegisteredException alreadyRegisteredException) {}
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: nation list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: nation list unknown error : ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadWorldList() {
        TownyMessaging.sendDebugMsg("Loading World List");
        if (!this.getContext()) {
            return false;
        }
        try (Statement s = this.cntx.createStatement();){
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "WORLDS");
            while (rs.next()) {
                try {
                    this.newWorld(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: world list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: world list unknown error : ");
            e.printStackTrace();
        }
        if (this.plugin != null) {
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
        }
        return true;
    }

    @Override
    public boolean loadPlotGroupList() {
        TownyMessaging.sendDebugMsg("Loading PlotGroup List");
        if (!this.getContext()) {
            return false;
        }
        try {
            try (Statement s = this.cntx.createStatement();){
                ResultSet rs = s.executeQuery("SELECT groupID FROM " + this.tb_prefix + "PLOTGROUPS");
                while (rs.next()) {
                    TownyUniverse.getInstance().newPlotGroupInternal(rs.getString("groupID"));
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadJailList() {
        TownyMessaging.sendDebugMsg("Loading Jail List");
        if (!this.getContext()) {
            return false;
        }
        try {
            try (Statement s = this.cntx.createStatement();){
                ResultSet rs = s.executeQuery("SELECT uuid FROM " + this.tb_prefix + "JAILS");
                while (rs.next()) {
                    TownyUniverse.getInstance().newJailInternal(rs.getString("uuid"));
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: jail list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: jail list unknown error : ");
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadResidents() {
        TownyMessaging.sendDebugMsg("Loading Residents");
        TownySettings.setUUIDCount(0);
        if (!this.getContext()) {
            return false;
        }
        try (Statement s = this.cntx.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "RESIDENTS");){
            while (rs.next()) {
                String residentName;
                try {
                    residentName = rs.getString("name");
                }
                catch (SQLException ex) {
                    this.plugin.getLogger().severe("Loading Error: Error fetching a resident name from SQL Database. Skipping loading resident..");
                    ex.printStackTrace();
                    continue;
                }
                Resident resident = this.universe.getResident(residentName);
                if (resident == null) {
                    this.plugin.getLogger().severe(String.format("Loading Error: Could not fetch resident '%s' from Towny universe while loading from SQL DB.", residentName));
                    continue;
                }
                if (!this.loadResident(resident, rs)) {
                    this.plugin.getLogger().severe("Loading Error: Could not read resident data '" + resident.getName() + "'.");
                    boolean bl = false;
                    return bl;
                }
                if (!resident.hasUUID()) continue;
                TownySettings.incrementUUIDCount();
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident sql error : " + e.getMessage());
        }
        return true;
    }

    @Override
    public boolean loadResident(Resident resident) {
        return true;
    }

    private boolean loadResident(Resident resident, ResultSet rs) {
        try {
            String search;
            String line;
            UUID uuid;
            block56: {
                try {
                    if (rs.getString("uuid") == null || rs.getString("uuid").isEmpty()) break block56;
                    uuid = UUID.fromString(rs.getString("uuid"));
                    if (TownyUniverse.getInstance().hasResident(uuid)) {
                        Resident olderRes = TownyUniverse.getInstance().getResident(uuid);
                        if (resident.getLastOnline() > olderRes.getLastOnline()) {
                            TownyMessaging.sendDebugMsg("Deleting : " + olderRes.getName() + " which is a dupe of " + resident.getName());
                            try {
                                TownyUniverse.getInstance().unregisterResident(olderRes);
                            }
                            catch (NotRegisteredException notRegisteredException) {
                                // empty catch block
                            }
                            if (olderRes.hasTown()) {
                                try {
                                    olderRes.getTown().removeResident(olderRes);
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                    // empty catch block
                                }
                            }
                            this.deleteResident(olderRes);
                        } else {
                            TownyMessaging.sendDebugMsg("Deleting resident : " + resident.getName() + " which is a dupe of " + olderRes.getName());
                            try {
                                TownyUniverse.getInstance().unregisterResident(resident);
                            }
                            catch (NotRegisteredException notRegisteredException) {
                                // empty catch block
                            }
                            this.deleteResident(resident);
                            return true;
                        }
                    }
                    resident.setUUID(uuid);
                    this.universe.registerResidentUUID(resident);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                resident.setLastOnline(rs.getLong("lastOnline"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                resident.setRegistered(rs.getLong("registered"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                resident.setJoinedTownAt(rs.getLong("joinedTownAt"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                resident.setNPC(rs.getBoolean("isNPC"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rs.getString("jailUUID") != null && !rs.getString("jailUUID").isEmpty()) {
                uuid = UUID.fromString(rs.getString("jailUUID"));
                if (TownyUniverse.getInstance().hasJail(uuid)) {
                    resident.setJail(TownyUniverse.getInstance().getJail(uuid));
                }
            }
            if (resident.isJailed()) {
                try {
                    if (rs.getString("jailCell") != null && !rs.getString("jailCell").isEmpty()) {
                        resident.setJailCell(rs.getInt("jailCell"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (rs.getString("jailHours") != null && !rs.getString("jailHours").isEmpty()) {
                        resident.setJailHours(rs.getInt("jailHours"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                line = rs.getString("friends");
                if (line != null) {
                    search = line.contains("#") ? "#" : ",";
                    List<Resident> friends = this.getResidents(line.split(search));
                    for (Resident friend : friends) {
                        try {
                            resident.addFriend(friend);
                        }
                        catch (AlreadyRegisteredException alreadyRegisteredException) {}
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                resident.setPermissions(rs.getString("protectionStatus").replaceAll("#", ","));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(resident, line);
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            line = rs.getString("town");
            if (line != null && !line.isEmpty()) {
                Town town = this.universe.getTown(line);
                if (town == null) {
                    TownyMessaging.sendErrorMsg("Loading Error: " + resident.getName() + " tried to load the town " + line + " which is invalid, removing town from the resident.");
                    resident.setTown(null, false);
                } else {
                    resident.setTown(town, false);
                    try {
                        resident.setTitle(rs.getString("title"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        resident.setSurname(rs.getString("surname"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        line = rs.getString("town-ranks");
                        if (line != null && !line.isEmpty()) {
                            search = line.contains("#") ? "#" : ",";
                            resident.setTownRanks(Arrays.asList(line.split(search)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        line = rs.getString("nation-ranks");
                        if (line != null && !line.isEmpty()) {
                            search = line.contains("#") ? "#" : ",";
                            resident.setNationRanks(Arrays.asList(line.split(search)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident unknown error");
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadTowns() {
        TownyMessaging.sendDebugMsg("Loading Towns");
        if (!this.getContext()) {
            return false;
        }
        try (Statement s = this.cntx.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNS ");){
            do {
                if (!rs.next()) return true;
            } while (this.loadTown(rs));
            this.plugin.getLogger().warning("Loading Error: Could not read town data properly.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town sql Error - " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean loadTown(Town town) {
        return true;
    }

    private boolean loadTown(ResultSet rs) {
        String name = null;
        try {
            Location loc;
            double z;
            double y;
            double x;
            String spawn;
            int z2;
            TownyWorld world;
            String search;
            String[] tokens;
            Town town = this.universe.getTown(rs.getString("name"));
            if (town == null) {
                TownyMessaging.sendErrorMsg("SQL: Load Town " + rs.getString("name") + ". Town was not registered properly on load!");
                return false;
            }
            name = town.getName();
            TownyMessaging.sendDebugMsg("Loading town " + name);
            try {
                Resident res = this.universe.getResident(rs.getString("mayor"));
                if (res == null) {
                    throw new TownyException();
                }
                town.forceSetMayor(res);
            }
            catch (TownyException e1) {
                e1.getMessage();
                if (town.getResidents().size() == 0) {
                    this.deleteTown(town);
                    return true;
                }
                town.findNewMayor();
            }
            town.setBoard(rs.getString("townBoard"));
            String line = rs.getString("tag");
            if (line != null) {
                town.setTag(line);
            }
            town.setPermissions(rs.getString("protectionStatus").replaceAll("#", ","));
            town.setBonusBlocks(rs.getInt("bonus"));
            town.setTaxPercentage(rs.getBoolean("taxpercent"));
            town.setTaxes(rs.getFloat("taxes"));
            town.setMaxPercentTaxAmount(rs.getFloat("maxPercentTaxAmount"));
            town.setHasUpkeep(rs.getBoolean("hasUpkeep"));
            town.setPlotPrice(rs.getFloat("plotPrice"));
            town.setPlotTax(rs.getFloat("plotTax"));
            town.setEmbassyPlotPrice(rs.getFloat("embassyPlotPrice"));
            town.setEmbassyPlotTax(rs.getFloat("embassyPlotTax"));
            town.setCommercialPlotPrice(rs.getFloat("commercialPlotPrice"));
            town.setCommercialPlotTax(rs.getFloat("commercialPlotTax"));
            town.setSpawnCost(rs.getFloat("spawnCost"));
            town.setOpen(rs.getBoolean("open"));
            town.setPublic(rs.getBoolean("public"));
            town.setConquered(rs.getBoolean("conquered"));
            town.setAdminDisabledPVP(rs.getBoolean("admindisabledpvp"));
            town.setAdminEnabledPVP(rs.getBoolean("adminenabledpvp"));
            town.setJoinedNationAt(rs.getLong("joinedNationAt"));
            town.setMovedHomeBlockAt(rs.getLong("movedHomeBlockAt"));
            town.setPurchasedBlocks(rs.getInt("purchased"));
            town.setNationZoneOverride(rs.getInt("nationZoneOverride"));
            town.setNationZoneEnabled(rs.getBoolean("nationZoneEnabled"));
            line = rs.getString("maxPercentTaxAmount");
            if (line != null) {
                town.setMaxPercentTaxAmount(Double.parseDouble(line));
            } else {
                town.setMaxPercentTaxAmount(TownySettings.getMaxTownTaxPercentAmount());
            }
            line = rs.getString("homeBlock");
            if (line != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length == 3) {
                try {
                    world = this.getWorld(tokens[0]);
                    try {
                        int x2 = Integer.parseInt(tokens[1]);
                        z2 = Integer.parseInt(tokens[2]);
                        TownBlock homeBlock = TownyUniverse.getInstance().getTownBlock(new WorldCoord(world.getName(), x2, z2));
                        town.forceSetHomeBlock(homeBlock);
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                    }
                }
                catch (NotRegisteredException e) {
                    TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                }
            }
            if ((line = rs.getString("spawn")) != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length >= 4) {
                try {
                    world = this.plugin.getServerWorld(tokens[0]);
                    double x3 = Double.parseDouble(tokens[1]);
                    double y2 = Double.parseDouble(tokens[2]);
                    double z3 = Double.parseDouble(tokens[3]);
                    Location loc2 = new Location((World)world, x3, y2, z3);
                    if (tokens.length == 6) {
                        loc2.setPitch(Float.parseFloat(tokens[4]));
                        loc2.setYaw(Float.parseFloat(tokens[5]));
                    }
                    town.setSpawn(loc2);
                }
                catch (NotRegisteredException | NullPointerException | NumberFormatException world2) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("outpostSpawns")) != null) {
                String[] outposts;
                String[] x3 = outposts = line.split(";");
                z2 = x3.length;
                for (int y2 = 0; y2 < z2; ++y2) {
                    spawn = x3[y2];
                    search = line.contains("#") ? "#" : ",";
                    tokens = spawn.split(search);
                    if (tokens.length < 4) continue;
                    try {
                        World world3 = this.plugin.getServerWorld(tokens[0]);
                        x = Double.parseDouble(tokens[1]);
                        y = Double.parseDouble(tokens[2]);
                        z = Double.parseDouble(tokens[3]);
                        loc = new Location(world3, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        town.forceAddOutpostSpawn(loc);
                        continue;
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException world3) {
                        // empty catch block
                    }
                }
            }
            if ((line = rs.getString("jailSpawns")) != null) {
                String[] jails;
                String[] x3 = jails = line.split(";");
                z2 = x3.length;
                for (int y2 = 0; y2 < z2; ++y2) {
                    spawn = x3[y2];
                    search = line.contains("#") ? "#" : ",";
                    tokens = spawn.split(search);
                    if (tokens.length < 4) continue;
                    try {
                        TownBlock tb;
                        World world4 = this.plugin.getServerWorld(tokens[0]);
                        x = Double.parseDouble(tokens[1]);
                        y = Double.parseDouble(tokens[2]);
                        z = Double.parseDouble(tokens[3]);
                        loc = new Location(world4, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        if ((tb = TownyUniverse.getInstance().getTownBlock(WorldCoord.parseWorldCoord(loc))) == null) continue;
                        Jail jail = new Jail(UUID.randomUUID(), town, tb, new ArrayList<Location>(Collections.singleton(loc)));
                        TownyUniverse.getInstance().registerJail(jail);
                        town.addJail(jail);
                        tb.setJail(jail);
                        jail.save();
                        continue;
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                        // empty catch block
                    }
                }
            }
            if ((line = rs.getString("outlaws")) != null) {
                search = line.contains("#") ? "#" : ",";
                for (String token : tokens = line.split(search)) {
                    if (token.isEmpty()) continue;
                    Resident resident = this.universe.getResident(token);
                    if (resident != null) {
                        town.addOutlaw(resident);
                        continue;
                    }
                    this.plugin.getLogger().warning(String.format("Loading Error: Cannot load outlaw with name '%s' for town '%s'! Skipping adding outlaw to town...", token, town.getName()));
                }
            }
            try {
                town.setUUID(UUID.fromString(rs.getString("uuid")));
            }
            catch (IllegalArgumentException | NullPointerException ee) {
                town.setUUID(UUID.randomUUID());
            }
            TownyUniverse.getInstance().registerTownUUID(town);
            int conqueredDays = rs.getInt("conqueredDays");
            town.setConqueredDays(conqueredDays);
            try {
                long registered = rs.getLong("registered");
                town.setRegistered(registered);
            }
            catch (Exception ignored) {
                town.setRegistered(0L);
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(town, line);
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            try {
                Nation nation;
                line = rs.getString("nation");
                if (line != null && !line.isEmpty() && (nation = this.universe.getNation(line)) != null) {
                    town.setNation(nation, false);
                }
            }
            catch (SQLException nation) {
                // empty catch block
            }
            town.setRuined(rs.getBoolean("ruined"));
            town.setRuinedTime(rs.getLong("ruinedTime"));
            town.setNeutral(rs.getBoolean("neutral"));
            town.setDebtBalance(rs.getFloat("debtBalance"));
            line = rs.getString("primaryJail");
            if (line != null && !line.isEmpty()) {
                UUID uuid2 = UUID.fromString(line);
                if (TownyUniverse.getInstance().hasJail(uuid2)) {
                    town.setPrimaryJail(TownyUniverse.getInstance().getJail(uuid2));
                }
            }
            if ((line = rs.getString("trustedResidents")) != null && !line.isEmpty()) {
                search = line.contains("#") ? "#" : ",";
                for (Resident resident : this.getResidents(this.toUUIDArray(line.split(search)))) {
                    town.addTrustedResident(resident);
                }
            }
            if ((line = rs.getString("mapColorHexCode")) != null) {
                town.setMapColorHexCode(line);
            } else {
                town.setMapColorHexCode(MapUtil.generateRandomTownColourAsHexCode());
            }
            line = rs.getString("allies");
            if (line != null && !line.isEmpty()) {
                search = line.contains("#") ? "#" : ",";
                List<UUID> uuids = Arrays.stream(line.split(search)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toList());
                town.loadAllies(this.getTowns(uuids));
            }
            if ((line = rs.getString("enemies")) != null && !line.isEmpty()) {
                search = line.contains("#") ? "#" : ",";
                List<UUID> uuids = Arrays.stream(line.split(search)).map(uuid -> UUID.fromString(uuid)).collect(Collectors.toList());
                town.loadEnemies(this.getTowns(uuids));
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town " + name + " sql Error - " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town " + name + " unknown Error - ");
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadNations() {
        if (!this.getContext()) {
            return false;
        }
        try (Statement s = this.cntx.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "NATIONS");){
            do {
                if (!rs.next()) return true;
            } while (this.loadNation(rs));
            this.plugin.getLogger().warning("Loading Error: Could not properly read nation data.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation sql error " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean loadNation(Nation nation) {
        return true;
    }

    private boolean loadNation(ResultSet rs) {
        String name = null;
        try {
            String[] tokens;
            String search;
            Nation nation = this.universe.getNation(rs.getString("name"));
            if (nation == null) {
                this.plugin.getLogger().warning(String.format("Error: The nation with the name '%s' was not registered and cannot be loaded!", rs.getString("name")));
                return false;
            }
            name = nation.getName();
            TownyMessaging.sendDebugMsg("Loading nation " + nation.getName());
            Town town = this.universe.getTown(rs.getString("capital"));
            if (town != null) {
                try {
                    nation.forceSetCapital(town);
                }
                catch (EmptyNationException e1) {
                    this.plugin.getLogger().warning("The nation " + nation.getName() + " could not load a capital city and is being disbanded.");
                    this.removeNation(nation);
                    return true;
                }
            } else {
                TownyMessaging.sendDebugMsg("Nation " + name + " could not set capital to " + rs.getString("capital") + ", selecting a new capital...");
                if (!nation.findNewCapital()) {
                    this.plugin.getLogger().warning("The nation " + nation.getName() + " could not load a capital city and is being disbanded.");
                    this.removeNation(nation);
                    return true;
                }
            }
            String line = rs.getString("nationBoard");
            if (line != null) {
                nation.setBoard(rs.getString("nationBoard"));
            } else {
                nation.setBoard("");
            }
            line = rs.getString("mapColorHexCode");
            if (line != null) {
                nation.setMapColorHexCode(line);
            } else {
                nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
            }
            nation.setTag(rs.getString("tag"));
            line = rs.getString("allies");
            if (line != null) {
                search = line.contains("#") ? "#" : ",";
                List<Nation> allies = this.getNations(line.split(search));
                for (Nation ally : allies) {
                    nation.addAlly(ally);
                }
            }
            if ((line = rs.getString("enemies")) != null) {
                search = line.contains("#") ? "#" : ",";
                List<Nation> enemies = this.getNations(line.split(search));
                for (Nation enemy : enemies) {
                    nation.addEnemy(enemy);
                }
            }
            nation.setTaxes(rs.getDouble("taxes"));
            nation.setSpawnCost(rs.getFloat("spawnCost"));
            nation.setNeutral(rs.getBoolean("neutral"));
            try {
                nation.setUUID(UUID.fromString(rs.getString("uuid")));
            }
            catch (IllegalArgumentException | NullPointerException ee) {
                nation.setUUID(UUID.randomUUID());
            }
            this.universe.registerNationUUID(nation);
            line = rs.getString("nationSpawn");
            if (line != null && (tokens = line.split(search = line.contains("#") ? "#" : ",")).length >= 4) {
                try {
                    World world = this.plugin.getServerWorld(tokens[0]);
                    double x = Double.parseDouble(tokens[1]);
                    double y = Double.parseDouble(tokens[2]);
                    double z = Double.parseDouble(tokens[3]);
                    Location loc = new Location(world, x, y, z);
                    if (tokens.length == 6) {
                        loc.setPitch(Float.parseFloat(tokens[4]));
                        loc.setYaw(Float.parseFloat(tokens[5]));
                    }
                    nation.setSpawn(loc);
                }
                catch (NotRegisteredException | NullPointerException | NumberFormatException world) {
                    // empty catch block
                }
            }
            nation.setPublic(rs.getBoolean("isPublic"));
            nation.setOpen(rs.getBoolean("isOpen"));
            try {
                line = rs.getString("registered");
                if (line != null) {
                    nation.setRegistered(Long.parseLong(line));
                } else {
                    nation.setRegistered(0L);
                }
            }
            catch (SQLException world) {
            }
            catch (NullPointerException | NumberFormatException e) {
                nation.setRegistered(0L);
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(nation, line);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation " + name + " SQL Error - " + e.getMessage());
        }
        catch (TownyException ex) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation " + name + " unknown Error - ");
            ex.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadWorlds() {
        if (!this.getContext()) {
            return false;
        }
        try (Statement s = this.cntx.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "WORLDS");){
            do {
                if (!rs.next()) return true;
            } while (this.loadWorld(rs));
            this.plugin.getLogger().warning("Loading Error: Could not read properly world data.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Error reading worlds from SQL database!");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadWorld(TownyWorld world) {
        if (!this.getContext()) {
            return false;
        }
        try (PreparedStatement ps = this.cntx.prepareStatement("SELECT * FROM " + this.tb_prefix + "WORLDS WHERE name=?");){
            ps.setString(1, world.getName());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = this.loadWorld(rs);
                return bl;
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load world sql error (" + world.getName() + ")" + e.getMessage());
        }
        return false;
    }

    private boolean loadWorld(ResultSet rs) {
        String worldName = null;
        try {
            ArrayList<String> materials2;
            String search;
            ArrayList<String> mats2;
            worldName = rs.getString("name");
            TownyWorld world = this.getWorld(worldName);
            TownyMessaging.sendDebugMsg("Loading world " + world.getName());
            boolean result = rs.getBoolean("claimable");
            try {
                world.setClaimable(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("pvp");
            try {
                world.setPVP(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("forcepvp");
            try {
                world.setForcePVP(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("friendlyFire");
            try {
                world.setFriendlyFire(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("forcetownmobs");
            try {
                world.setForceTownMobs(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("wildernessmobs");
            try {
                world.setWildernessMobs(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("worldmobs");
            try {
                world.setWorldMobs(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("firespread");
            try {
                world.setFire(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("forcefirespread");
            try {
                world.setForceFire(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("explosions");
            try {
                world.setExpl(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("forceexplosions");
            try {
                world.setForceExpl(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("endermanprotect");
            try {
                world.setEndermanProtect(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("disableplayertrample");
            try {
                world.setDisablePlayerTrample(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("disablecreaturetrample");
            try {
                world.setDisableCreatureTrample(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneBuild");
            try {
                world.setUnclaimedZoneBuild(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneDestroy");
            try {
                world.setUnclaimedZoneDestroy(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneSwitch");
            try {
                world.setUnclaimedZoneSwitch(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("unclaimedZoneItemUse");
            try {
                world.setUnclaimedZoneItemUse(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String line = rs.getString("unclaimedZoneName");
            try {
                world.setUnclaimedZoneName(line);
            }
            catch (Exception exception) {
                // empty catch block
            }
            line = rs.getString("unclaimedZoneIgnoreIds");
            if (line != null) {
                try {
                    mats2 = new ArrayList<String>();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        mats2.add(split);
                    }
                    world.setUnclaimedZoneIgnore(mats2);
                }
                catch (Exception mats2) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementDelete");
            try {
                world.setUsingPlotManagementDelete(result);
            }
            catch (Exception mats2) {
                // empty catch block
            }
            line = rs.getString("plotManagementDeleteIds");
            if (line != null) {
                try {
                    mats2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        mats2.add(split);
                    }
                    world.setPlotManagementDeleteIds(mats2);
                }
                catch (Exception mats3) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementMayorDelete");
            try {
                world.setUsingPlotManagementMayorDelete(result);
            }
            catch (Exception mats3) {
                // empty catch block
            }
            line = rs.getString("plotManagementMayorDelete");
            if (line != null) {
                try {
                    materials2 = new ArrayList<String>();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.toUpperCase().trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementMayorDelete(materials2);
                }
                catch (Exception materials2) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementRevert");
            try {
                world.setUsingPlotManagementRevert(result);
            }
            catch (Exception materials2) {
                // empty catch block
            }
            line = rs.getString("plotManagementIgnoreIds");
            if (line != null) {
                try {
                    mats2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        mats2.add(split);
                    }
                    world.setPlotManagementIgnoreIds(mats2);
                }
                catch (Exception mats4) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingPlotManagementWildRegen");
            try {
                world.setUsingPlotManagementWildEntityRevert(result);
            }
            catch (Exception mats4) {
                // empty catch block
            }
            line = rs.getString("plotManagementWildRegenEntities");
            if (line != null) {
                try {
                    ArrayList<String> entities = new ArrayList<String>();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            entities.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementWildRevertEntities(entities);
                }
                catch (Exception entities) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("plotManagementWildRegenBlockWhitelist")) != null) {
                try {
                    materials2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementWildRevertBlockWhitelist(materials2);
                }
                catch (Exception materials3) {
                    // empty catch block
                }
            }
            long resultLong = rs.getLong("plotManagementWildRegenSpeed");
            try {
                world.setPlotManagementWildRevertDelay(resultLong);
            }
            catch (Exception materials3) {
                // empty catch block
            }
            result = rs.getBoolean("usingPlotManagementWildRegenBlocks");
            try {
                world.setUsingPlotManagementWildBlockRevert(result);
            }
            catch (Exception materials3) {
                // empty catch block
            }
            line = rs.getString("plotManagementWildRegenBlocks");
            if (line != null) {
                try {
                    materials2 = new ArrayList();
                    search = line.contains("#") ? "#" : ",";
                    for (String split : line.split(search)) {
                        if (split.isEmpty()) continue;
                        try {
                            materials2.add(split.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    world.setPlotManagementWildRevertMaterials(materials2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result = rs.getBoolean("usingTowny");
            try {
                world.setUsingTowny(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = rs.getBoolean("warAllowed");
            try {
                world.setWarAllowed(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                line = rs.getString("metadata");
                if (line != null && !line.isEmpty()) {
                    MetadataLoader.getInstance().deserializeMetadata(world, line);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load world sql error (" + (worldName != null ? worldName : "NULL") + ")" + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load world unknown error - ");
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadTownBlocks() {
        String line = "";
        TownyMessaging.sendDebugMsg("Loading Town Blocks.");
        if (!this.getContext()) {
            return false;
        }
        Object townBlock = null;
        try {
            Statement s = this.cntx.createStatement();
            try (ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "TOWNBLOCKS");){
                while (rs.next()) {
                    block64: {
                        String worldName = rs.getString("world");
                        int x = rs.getInt("x");
                        int z = rs.getInt("z");
                        try {
                            townBlock = TownyUniverse.getInstance().getTownBlock(new WorldCoord(worldName, x, z));
                        }
                        catch (NotRegisteredException ex) {
                            TownyMessaging.sendErrorMsg("Loading Error: Exception while fetching townblock: " + worldName + " " + x + " " + z + " from memory!");
                            boolean bl = false;
                            if (rs != null) {
                                rs.close();
                            }
                            if (s == null) return bl;
                            s.close();
                            return bl;
                        }
                        line = rs.getString("name");
                        if (line != null) {
                            try {
                                ((TownBlock)townBlock).setName(line.trim());
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if ((line = rs.getString("price")) != null) {
                            try {
                                ((TownBlock)townBlock).setPlotPrice(Float.parseFloat(line.trim()));
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if ((line = rs.getString("town")) != null) {
                            Town town = this.universe.getTown(line.trim());
                            if (town == null) {
                                TownyMessaging.sendErrorMsg("TownBlock file contains unregistered Town: " + line + " , deleting " + ((TownBlock)townBlock).getWorld().getName() + "," + ((TownBlock)townBlock).getX() + "," + ((TownBlock)townBlock).getZ());
                                TownyUniverse.getInstance().removeTownBlock((TownBlock)townBlock);
                                this.deleteTownBlock((TownBlock)townBlock);
                                continue;
                            }
                            ((TownBlock)townBlock).setTown(town, false);
                            try {
                                town.addTownBlock((TownBlock)townBlock);
                                TownyWorld townyWorld = ((TownBlock)townBlock).getWorld();
                                if (townyWorld != null && !townyWorld.hasTown(town)) {
                                    townyWorld.addTown(town);
                                }
                            }
                            catch (AlreadyRegisteredException townyWorld) {
                                // empty catch block
                            }
                        }
                        if ((line = rs.getString("resident")) != null && !line.isEmpty()) {
                            Resident res = this.universe.getResident(line.trim());
                            if (res != null) {
                                ((TownBlock)townBlock).setResident(res, false);
                            } else {
                                TownyMessaging.sendErrorMsg(String.format("Error fetching resident '%s' for townblock '%s'!", line.trim(), ((TownBlock)townBlock).toString()));
                            }
                        }
                        if ((line = rs.getString("type")) != null) {
                            try {
                                ((TownBlock)townBlock).setType(Integer.parseInt(line));
                            }
                            catch (Exception res) {
                                // empty catch block
                            }
                        }
                        boolean outpost = rs.getBoolean("outpost");
                        if (line != null && !line.isEmpty()) {
                            try {
                                ((TownBlock)townBlock).setOutpost(outpost);
                            }
                            catch (Exception townyWorld) {
                                // empty catch block
                            }
                        }
                        if ((line = rs.getString("permissions")) != null && !line.isEmpty()) {
                            try {
                                ((TownBlock)townBlock).setPermissions(line.trim().replaceAll("#", ","));
                            }
                            catch (Exception townyWorld) {
                                // empty catch block
                            }
                        }
                        boolean result = rs.getBoolean("changed");
                        try {
                            ((TownBlock)townBlock).setChanged(result);
                        }
                        catch (Exception townyWorld) {
                            // empty catch block
                        }
                        result = rs.getBoolean("locked");
                        try {
                            ((TownBlock)townBlock).setLocked(result);
                        }
                        catch (Exception townyWorld) {
                            // empty catch block
                        }
                        ((TownBlock)townBlock).setClaimedAt(rs.getLong("claimedAt"));
                        try {
                            line = rs.getString("metadata");
                            if (line != null && !line.isEmpty()) {
                                MetadataLoader.getInstance().deserializeMetadata((TownyObject)townBlock, line);
                            }
                        }
                        catch (SQLException townyWorld) {
                            // empty catch block
                        }
                        try {
                            line = rs.getString("groupID");
                            if (line == null || line.isEmpty()) break block64;
                            try {
                                UUID groupID = UUID.fromString(line.trim());
                                PlotGroup group = this.getPlotObjectGroup(groupID);
                                if (group != null) {
                                    ((TownBlock)townBlock).setPlotObjectGroup(group);
                                    if (group.getPermissions() == null && ((TownBlock)townBlock).getPermissions() != null) {
                                        group.setPermissions(((TownBlock)townBlock).getPermissions());
                                    }
                                    if (((TownBlock)townBlock).hasResident()) {
                                        group.setResident(((TownBlock)townBlock).getResidentOrNull());
                                    }
                                }
                            }
                            catch (Exception groupID) {}
                        }
                        catch (SQLException groupID) {
                            // empty catch block
                        }
                    }
                    if ((line = rs.getString("trustedResidents")) != null && !line.isEmpty() && ((TownBlock)townBlock).getTrustedResidents().isEmpty()) {
                        String search = line.contains("#") ? "#" : ",";
                        for (Resident resident : this.getResidents(this.toUUIDArray(line.split(search)))) {
                            ((TownBlock)townBlock).addTrustedResident(resident);
                        }
                        if (((TownBlock)townBlock).hasPlotObjectGroup() && ((TownBlock)townBlock).getPlotObjectGroup().getTrustedResidents().isEmpty() && ((TownBlock)townBlock).getTrustedResidents().size() > 0) {
                            ((TownBlock)townBlock).getPlotObjectGroup().setTrustedResidents(((TownBlock)townBlock).getTrustedResidents());
                        }
                    }
                    if ((line = rs.getString("customPermissionData")) == null || line.isEmpty() || !((TownBlock)townBlock).getPermissionOverrides().isEmpty()) continue;
                    Map map = (Map)new Gson().fromJson(line, Map.class);
                    for (Map.Entry entry : map.entrySet()) {
                        Resident resident;
                        try {
                            resident = TownyAPI.getInstance().getResident(UUID.fromString((String)entry.getKey()));
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        if (resident == null) continue;
                        ((TownBlock)townBlock).getPermissionOverrides().put(resident, new PermissionData((String)entry.getValue()));
                    }
                    if (!((TownBlock)townBlock).hasPlotObjectGroup() || !((TownBlock)townBlock).getPlotObjectGroup().getPermissionOverrides().isEmpty() || ((TownBlock)townBlock).getPermissionOverrides().size() <= 0) continue;
                    ((TownBlock)townBlock).getPlotObjectGroup().setPermissionOverrides(((TownBlock)townBlock).getPermissionOverrides());
                }
                return true;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException ex) {
            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlock: " + (townBlock != null ? townBlock : "NULL") + " at line: " + line + " in the sql database");
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadPlotGroups() {
        TownyMessaging.sendDebugMsg("Loading plot groups.");
        if (!this.getContext()) {
            return false;
        }
        try (Statement s = this.cntx.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "PLOTGROUPS ");){
            do {
                if (!rs.next()) return true;
            } while (this.loadPlotGroup(rs));
            this.plugin.getLogger().warning("Loading Error: Could not read plotgroup data properly.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load PlotGroup sql Error - " + e.getMessage());
            return false;
        }
    }

    private boolean loadPlotGroup(ResultSet rs) {
        String line = null;
        String uuid = null;
        try {
            PlotGroup group = this.universe.getGroup(UUID.fromString(rs.getString("groupID")));
            if (group == null) {
                TownyMessaging.sendErrorMsg("SQL: A plot group was not registered properly on load!");
                return true;
            }
            uuid = group.getID().toString();
            line = rs.getString("groupName");
            if (line != null) {
                try {
                    group.setName(line.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((line = rs.getString("town")) != null) {
                Town town = this.universe.getTown(line.trim());
                if (town != null) {
                    group.setTown(town);
                } else {
                    this.deletePlotGroup(group);
                    return true;
                }
            }
            if ((line = rs.getString("groupPrice")) != null) {
                try {
                    group.setPrice(Float.parseFloat(line.trim()));
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading plot group: " + uuid + " at line: " + line + " in the sql database");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean loadPlotGroup(PlotGroup group) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadJails() {
        TownyMessaging.sendDebugMsg("Loading Jails");
        if (!this.getContext()) {
            return false;
        }
        try (Statement s = this.cntx.createStatement();
             ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "JAILS ");){
            do {
                if (!rs.next()) return true;
            } while (this.loadJail(rs));
            this.plugin.getLogger().warning("Loading Error: Could not read jail data properly.");
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Jail sql Error - " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean loadJail(Jail jail) {
        return true;
    }

    private boolean loadJail(ResultSet rs) {
        String uuid = null;
        try {
            String[] tokens;
            Jail jail = this.universe.getJail(UUID.fromString(rs.getString("uuid")));
            if (jail == null) {
                TownyMessaging.sendErrorMsg("SQL: A jail was not registered properly on load!");
                return true;
            }
            uuid = jail.getUUID().toString();
            String line = rs.getString("townBlock");
            if (line != null) {
                tokens = line.split("#");
                TownBlock tb = null;
                try {
                    tb = TownyUniverse.getInstance().getTownBlock(new WorldCoord(tokens[0], Integer.parseInt(tokens[1].trim()), Integer.parseInt(tokens[2].trim())));
                    jail.setTownBlock(tb);
                    jail.setTown(tb.getTown());
                    tb.setJail(jail);
                    tb.getTown().addJail(jail);
                }
                catch (NotRegisteredException | NumberFormatException e) {
                    TownyMessaging.sendErrorMsg("Jail " + jail.getUUID() + " tried to load invalid townblock " + line + " deleting jail.");
                    this.removeJail(jail);
                    this.deleteJail(jail);
                    return true;
                }
            }
            if ((line = rs.getString("spawns")) != null) {
                String[] jails;
                for (String spawn : jails = line.split(";")) {
                    tokens = spawn.split("#");
                    if (tokens.length < 4) continue;
                    try {
                        World world = this.plugin.getServerWorld(tokens[0]);
                        double x = Double.parseDouble(tokens[1]);
                        double y = Double.parseDouble(tokens[2]);
                        double z = Double.parseDouble(tokens[3]);
                        Location loc = new Location(world, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        jail.addJailCell(loc);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException e) {
                        TownyMessaging.sendErrorMsg("Jail " + jail.getUUID() + " tried to load invalid spawn " + line + " skipping.");
                    }
                }
                if (jail.getJailCellLocations().size() < 1) {
                    TownyMessaging.sendErrorMsg("Jail " + jail.getUUID() + " loaded with zero spawns " + line + " deleting jail.");
                    this.removeJail(jail);
                    this.deleteJail(jail);
                    return true;
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Jail " + uuid + " sql Error - " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load Jail " + uuid + " unknown Error - ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public synchronized boolean saveResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Saving Resident " + resident.getName());
        try {
            HashMap<String, Object> res_hm = new HashMap<String, Object>();
            res_hm.put("name", resident.getName());
            res_hm.put("uuid", resident.hasUUID() ? resident.getUUID().toString() : "");
            res_hm.put("lastOnline", resident.getLastOnline());
            res_hm.put("registered", resident.getRegistered());
            res_hm.put("joinedTownAt", resident.getJoinedTownAt());
            res_hm.put("isNPC", resident.isNPC());
            res_hm.put("jailUUID", resident.isJailed() ? resident.getJail().getUUID() : "");
            res_hm.put("jailCell", resident.getJailCell());
            res_hm.put("jailHours", resident.getJailHours());
            res_hm.put("title", resident.getTitle());
            res_hm.put("surname", resident.getSurname());
            res_hm.put("town", resident.hasTown() ? resident.getTown().getName() : "");
            res_hm.put("town-ranks", resident.hasTown() ? StringMgmt.join(resident.getTownRanks(), "#") : "");
            res_hm.put("nation-ranks", resident.hasTown() ? StringMgmt.join(resident.getNationRanks(), "#") : "");
            res_hm.put("friends", StringMgmt.join(resident.getFriends(), "#"));
            res_hm.put("protectionStatus", resident.getPermissions().toString().replaceAll(",", "#"));
            if (resident.hasMeta()) {
                res_hm.put("metadata", this.serializeMetadata(resident));
            } else {
                res_hm.put("metadata", "");
            }
            this.UpdateDB("RESIDENTS", res_hm, Collections.singletonList("name"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Resident unknown error " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean saveHibernatedResident(UUID uuid) {
        TownyMessaging.sendDebugMsg("Saving Hibernated Resident " + uuid);
        try {
            HashMap<String, Object> res_hm = new HashMap<String, Object>();
            res_hm.put("uuid", uuid);
            res_hm.put("registered", this.universe.getHibernatedResidentRegistered(uuid));
            this.UpdateDB("HIBERNATEDRESIDENTS", res_hm, Collections.singletonList("uuid"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Hibernated Resident unknown error " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean saveTown(Town town) {
        TownyMessaging.sendDebugMsg("Saving town " + town.getName());
        try {
            HashMap<String, Object> twn_hm = new HashMap<String, Object>();
            twn_hm.put("name", town.getName());
            twn_hm.put("outlaws", StringMgmt.join(town.getOutlaws(), "#"));
            twn_hm.put("mayor", town.hasMayor() ? town.getMayor().getName() : "");
            twn_hm.put("nation", town.hasNation() ? town.getNation().getName() : "");
            twn_hm.put("assistants", StringMgmt.join(town.getRank("assistant"), "#"));
            twn_hm.put("townBoard", town.getBoard());
            twn_hm.put("tag", town.getTag());
            twn_hm.put("protectionStatus", town.getPermissions().toString().replaceAll(",", "#"));
            twn_hm.put("bonus", town.getBonusBlocks());
            twn_hm.put("purchased", town.getPurchasedBlocks());
            twn_hm.put("nationZoneOverride", town.getNationZoneOverride());
            twn_hm.put("nationZoneEnabled", town.isNationZoneEnabled());
            twn_hm.put("commercialPlotPrice", town.getCommercialPlotPrice());
            twn_hm.put("commercialPlotTax", town.getCommercialPlotTax());
            twn_hm.put("embassyPlotPrice", town.getEmbassyPlotPrice());
            twn_hm.put("embassyPlotTax", town.getEmbassyPlotTax());
            twn_hm.put("spawnCost", town.getSpawnCost());
            twn_hm.put("plotPrice", town.getPlotPrice());
            twn_hm.put("plotTax", town.getPlotTax());
            twn_hm.put("taxes", town.getTaxes());
            twn_hm.put("hasUpkeep", town.hasUpkeep());
            twn_hm.put("taxpercent", town.isTaxPercentage());
            twn_hm.put("maxPercentTaxAmount", town.getMaxPercentTaxAmount());
            twn_hm.put("open", town.isOpen());
            twn_hm.put("public", town.isPublic());
            twn_hm.put("conquered", town.isConquered());
            twn_hm.put("conqueredDays", town.getConqueredDays());
            twn_hm.put("admindisabledpvp", town.isAdminDisabledPVP());
            twn_hm.put("adminenabledpvp", town.isAdminEnabledPVP());
            twn_hm.put("joinedNationAt", town.getJoinedNationAt());
            twn_hm.put("mapColorHexCode", town.getMapColorHexCode());
            twn_hm.put("movedHomeBlockAt", town.getMovedHomeBlockAt());
            if (town.hasMeta()) {
                twn_hm.put("metadata", this.serializeMetadata(town));
            } else {
                twn_hm.put("metadata", "");
            }
            twn_hm.put("homeblock", town.hasHomeBlock() ? town.getHomeBlock().getWorld().getName() + "#" + town.getHomeBlock().getX() + "#" + town.getHomeBlock().getZ() : "");
            twn_hm.put("spawn", town.hasSpawn() ? town.getSpawn().getWorld().getName() + "#" + town.getSpawn().getX() + "#" + town.getSpawn().getY() + "#" + town.getSpawn().getZ() + "#" + town.getSpawn().getPitch() + "#" + town.getSpawn().getYaw() : "");
            StringBuilder outpostArray = new StringBuilder();
            if (town.hasOutpostSpawn()) {
                for (Location spawn : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                    outpostArray.append(spawn.getWorld().getName()).append("#").append(spawn.getX()).append("#").append(spawn.getY()).append("#").append(spawn.getZ()).append("#").append(spawn.getPitch()).append("#").append(spawn.getYaw()).append(";");
                }
            }
            twn_hm.put("outpostSpawns", outpostArray.toString());
            if (town.hasValidUUID()) {
                twn_hm.put("uuid", town.getUUID());
            } else {
                twn_hm.put("uuid", UUID.randomUUID());
            }
            twn_hm.put("registered", town.getRegistered());
            twn_hm.put("ruined", town.isRuined());
            twn_hm.put("ruinedTime", town.getRuinedTime());
            twn_hm.put("neutral", town.isNeutral());
            twn_hm.put("debtBalance", town.getDebtBalance());
            if (town.getPrimaryJail() != null) {
                twn_hm.put("primaryJail", town.getPrimaryJail().getUUID());
            }
            twn_hm.put("trustedResidents", StringMgmt.join(this.toUUIDList(town.getTrustedResidents()), "#"));
            twn_hm.put("allies", StringMgmt.join(town.getAlliesUUIDs(), "#"));
            twn_hm.put("enemies", StringMgmt.join(town.getEnemiesUUIDs(), "#"));
            this.UpdateDB("TOWNS", twn_hm, Collections.singletonList("name"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Town unknown error");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public synchronized boolean savePlotGroup(PlotGroup group) {
        TownyMessaging.sendDebugMsg("Saving group " + group.getName());
        try {
            HashMap<String, Object> pltgrp_hm = new HashMap<String, Object>();
            pltgrp_hm.put("groupID", group.getID());
            pltgrp_hm.put("groupName", group.getName());
            pltgrp_hm.put("groupPrice", group.getPrice());
            pltgrp_hm.put("town", group.getTown().toString());
            this.UpdateDB("PLOTGROUPS", pltgrp_hm, Collections.singletonList("groupID"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Plot groups unknown error");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public synchronized boolean saveNation(Nation nation) {
        TownyMessaging.sendDebugMsg("Saving nation " + nation.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", nation.getName());
            nat_hm.put("capital", nation.hasCapital() ? nation.getCapital().getName() : "");
            nat_hm.put("nationBoard", nation.getBoard());
            nat_hm.put("mapColorHexCode", nation.getMapColorHexCode());
            nat_hm.put("tag", nation.hasTag() ? nation.getTag() : "");
            nat_hm.put("allies", StringMgmt.join(nation.getAllies(), "#"));
            nat_hm.put("enemies", StringMgmt.join(nation.getEnemies(), "#"));
            nat_hm.put("taxes", nation.getTaxes());
            nat_hm.put("spawnCost", nation.getSpawnCost());
            nat_hm.put("neutral", nation.isNeutral());
            nat_hm.put("nationSpawn", nation.hasSpawn() ? nation.getSpawn().getWorld().getName() + "#" + nation.getSpawn().getX() + "#" + nation.getSpawn().getY() + "#" + nation.getSpawn().getZ() + "#" + nation.getSpawn().getPitch() + "#" + nation.getSpawn().getYaw() : "");
            if (nation.hasValidUUID()) {
                nat_hm.put("uuid", nation.getUUID());
            } else {
                nat_hm.put("uuid", UUID.randomUUID());
            }
            nat_hm.put("registered", nation.getRegistered());
            nat_hm.put("isPublic", nation.isPublic());
            nat_hm.put("isOpen", nation.isOpen());
            if (nation.hasMeta()) {
                nat_hm.put("metadata", this.serializeMetadata(nation));
            } else {
                nat_hm.put("metadata", "");
            }
            this.UpdateDB("NATIONS", nat_hm, Collections.singletonList("name"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Nation unknown error");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public synchronized boolean saveWorld(TownyWorld world) {
        TownyMessaging.sendDebugMsg("Saving world " + world.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", world.getName());
            nat_hm.put("pvp", world.isPVP());
            nat_hm.put("forcepvp", world.isForcePVP());
            nat_hm.put("friendlyFire", world.isFriendlyFireEnabled());
            nat_hm.put("claimable", world.isClaimable());
            nat_hm.put("worldmobs", world.hasWorldMobs());
            nat_hm.put("wildernessmobs", world.hasWildernessMobs());
            nat_hm.put("forcetownmobs", world.isForceTownMobs());
            nat_hm.put("firespread", world.isFire());
            nat_hm.put("forcefirespread", world.isForceFire());
            nat_hm.put("explosions", world.isExpl());
            nat_hm.put("forceexplosions", world.isForceExpl());
            nat_hm.put("endermanprotect", world.isEndermanProtect());
            nat_hm.put("disableplayertrample", world.isDisablePlayerTrample());
            nat_hm.put("disablecreaturetrample", world.isDisableCreatureTrample());
            nat_hm.put("unclaimedZoneBuild", world.getUnclaimedZoneBuild());
            nat_hm.put("unclaimedZoneDestroy", world.getUnclaimedZoneDestroy());
            nat_hm.put("unclaimedZoneSwitch", world.getUnclaimedZoneSwitch());
            nat_hm.put("unclaimedZoneItemUse", world.getUnclaimedZoneItemUse());
            if (world.getUnclaimedZoneName() != null) {
                nat_hm.put("unclaimedZoneName", world.getUnclaimedZoneName());
            }
            if (world.getUnclaimedZoneIgnoreMaterials() != null) {
                nat_hm.put("unclaimedZoneIgnoreIds", StringMgmt.join(world.getUnclaimedZoneIgnoreMaterials(), "#"));
            }
            nat_hm.put("usingPlotManagementDelete", world.isUsingPlotManagementDelete());
            if (world.getPlotManagementDeleteIds() != null) {
                nat_hm.put("plotManagementDeleteIds", StringMgmt.join(world.getPlotManagementDeleteIds(), "#"));
            }
            nat_hm.put("usingPlotManagementMayorDelete", world.isUsingPlotManagementMayorDelete());
            if (world.getPlotManagementMayorDelete() != null) {
                nat_hm.put("plotManagementMayorDelete", StringMgmt.join(world.getPlotManagementMayorDelete(), "#"));
            }
            nat_hm.put("usingPlotManagementRevert", world.isUsingPlotManagementRevert());
            if (world.getPlotManagementIgnoreIds() != null) {
                nat_hm.put("plotManagementIgnoreIds", StringMgmt.join(world.getPlotManagementIgnoreIds(), "#"));
            }
            nat_hm.put("usingPlotManagementWildRegen", world.isUsingPlotManagementWildEntityRevert());
            if (world.getPlotManagementWildRevertEntities() != null) {
                nat_hm.put("PlotManagementWildRegenEntities", StringMgmt.join(world.getPlotManagementWildRevertEntities(), "#"));
            }
            if (world.getPlotManagementWildRevertBlockWhitelist() != null) {
                nat_hm.put("PlotManagementWildRegenBlockWhitelist", StringMgmt.join(world.getPlotManagementWildRevertBlockWhitelist(), "#"));
            }
            nat_hm.put("plotManagementWildRegenSpeed", world.getPlotManagementWildRevertDelay());
            nat_hm.put("usingPlotManagementWildRegenBlocks", world.isUsingPlotManagementWildBlockRevert());
            if (world.getPlotManagementWildRevertBlocks() != null) {
                nat_hm.put("PlotManagementWildRegenBlocks", StringMgmt.join(world.getPlotManagementWildRevertBlocks(), "#"));
            }
            nat_hm.put("usingTowny", world.isUsingTowny());
            nat_hm.put("warAllowed", world.isWarAllowed());
            if (world.hasMeta()) {
                nat_hm.put("metadata", this.serializeMetadata(world));
            } else {
                nat_hm.put("metadata", "");
            }
            this.UpdateDB("WORLDS", nat_hm, Collections.singletonList("name"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save world unknown error (" + world.getName() + ")");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean saveTownBlock(TownBlock townBlock) {
        TownyMessaging.sendDebugMsg("Saving town block " + townBlock.getWorld().getName() + ":" + townBlock.getX() + "x" + townBlock.getZ());
        try {
            HashMap<String, Object> tb_hm = new HashMap<String, Object>();
            tb_hm.put("world", townBlock.getWorld().getName());
            tb_hm.put("x", townBlock.getX());
            tb_hm.put("z", townBlock.getZ());
            tb_hm.put("name", townBlock.getName());
            tb_hm.put("price", townBlock.getPlotPrice());
            tb_hm.put("town", townBlock.getTown().getName());
            tb_hm.put("resident", townBlock.hasResident() ? townBlock.getResidentOrNull().getName() : "");
            tb_hm.put("type", townBlock.getType().getId());
            tb_hm.put("outpost", townBlock.isOutpost());
            tb_hm.put("permissions", townBlock.isChanged() ? townBlock.getPermissions().toString().replaceAll(",", "#") : "");
            tb_hm.put("locked", townBlock.isLocked());
            tb_hm.put("changed", townBlock.isChanged());
            tb_hm.put("claimedAt", townBlock.getClaimedAt());
            if (townBlock.hasPlotObjectGroup()) {
                tb_hm.put("groupID", townBlock.getPlotObjectGroup().getID().toString());
            } else {
                tb_hm.put("groupID", "");
            }
            if (townBlock.hasMeta()) {
                tb_hm.put("metadata", this.serializeMetadata(townBlock));
            } else {
                tb_hm.put("metadata", "");
            }
            tb_hm.put("trustedResidents", StringMgmt.join(this.toUUIDList(townBlock.getTrustedResidents()), "#"));
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (Map.Entry<Resident, PermissionData> entry : townBlock.getPermissionOverrides().entrySet()) {
                stringMap.put(entry.getKey().getUUID().toString(), entry.getValue().toString());
            }
            tb_hm.put("customPermissionData", new Gson().toJson(stringMap));
            this.UpdateDB("TOWNBLOCKS", tb_hm, Arrays.asList("world", "x", "z"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save TownBlock unknown error");
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public synchronized boolean saveJail(Jail jail) {
        TownyMessaging.sendDebugMsg("Saving jail " + jail.getUUID());
        try {
            HashMap<String, Object> jail_hm = new HashMap<String, Object>();
            jail_hm.put("uuid", jail.getUUID());
            jail_hm.put("townBlock", jail.getTownBlock().getWorld().getName() + "#" + jail.getTownBlock().getX() + "#" + jail.getTownBlock().getZ());
            StringBuilder jailCellArray = new StringBuilder();
            if (jail.hasCells()) {
                for (Location cell : new ArrayList<Location>(jail.getJailCellLocations())) {
                    jailCellArray.append(cell.getWorld().getName()).append("#").append(cell.getX()).append("#").append(cell.getY()).append("#").append(cell.getZ()).append("#").append(cell.getPitch()).append("#").append(cell.getYaw()).append(";");
                }
            }
            jail_hm.put("spawns", jailCellArray);
            this.UpdateDB("JAILS", jail_hm, Collections.singletonList("uuid"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save jail unknown error");
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void deleteResident(Resident resident) {
        HashMap<String, Object> res_hm = new HashMap<String, Object>();
        res_hm.put("name", resident.getName());
        this.DeleteDB("RESIDENTS", res_hm);
    }

    @Override
    public void deleteHibernatedResident(UUID uuid) {
        HashMap<String, Object> res_hm = new HashMap<String, Object>();
        res_hm.put("uuid", uuid);
        this.DeleteDB("HIBERNATEDRESIDENTS", res_hm);
    }

    @Override
    public void deleteTown(Town town) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("name", town.getName());
        this.DeleteDB("TOWNS", twn_hm);
    }

    @Override
    public void deleteNation(Nation nation) {
        HashMap<String, Object> nat_hm = new HashMap<String, Object>();
        nat_hm.put("name", nation.getName());
        this.DeleteDB("NATIONS", nat_hm);
    }

    @Override
    public void deleteWorld(TownyWorld world) {
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("world", townBlock.getWorld().getName());
        twn_hm.put("x", townBlock.getX());
        twn_hm.put("z", townBlock.getZ());
        this.DeleteDB("TOWNBLOCKS", twn_hm);
    }

    @Override
    public void deletePlotGroup(PlotGroup group) {
        HashMap<String, Object> pltgrp_hm = new HashMap<String, Object>();
        pltgrp_hm.put("groupID", group.getID());
        this.DeleteDB("PLOTGROUPS", pltgrp_hm);
    }

    @Override
    public void deleteJail(Jail jail) {
        HashMap<String, Object> jail_hm = new HashMap<String, Object>();
        jail_hm.put("uuid", jail.getUUID());
        this.DeleteDB("JAILS", jail_hm);
    }

    @Override
    public boolean saveWorldList() {
        return true;
    }

    public HikariDataSource getHikariDataSource() {
        return this.hikariDataSource;
    }
}

