/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.entity.Player;

public abstract class TownyDataSource {
    final Lock lock = new ReentrantLock();
    protected final Towny plugin;
    protected final TownyUniverse universe;

    TownyDataSource(Towny plugin, TownyUniverse universe) {
        this.plugin = plugin;
        this.universe = universe;
    }

    public abstract boolean backup() throws IOException;

    public boolean loadAll() {
        return this.loadWorldList() && this.loadNationList() && this.loadTownList() && this.loadPlotGroupList() && this.loadJailList() && this.loadResidentList() && this.loadTownBlockList() && this.loadWorlds() && this.loadResidents() && this.loadTowns() && this.loadNations() && this.loadTownBlocks() && this.loadPlotGroups() && this.loadJails() && this.loadRegenList() && this.loadSnapshotList() && this.loadHibernatedResidents();
    }

    public boolean saveAll() {
        return this.saveWorldList() && this.saveWorlds() && this.saveNations() && this.saveTowns() && this.saveResidents() && this.savePlotGroups() && this.saveTownBlocks() && this.saveJails() && this.saveRegenList() && this.saveSnapshotList() && this.saveHibernatedResidents();
    }

    public boolean saveAllWorlds() {
        return this.saveWorldList() && this.saveWorlds();
    }

    public boolean saveQueues() {
        return this.saveRegenList() && this.saveSnapshotList();
    }

    public abstract void finishTasks();

    public abstract boolean loadTownBlockList();

    public abstract boolean loadResidentList();

    public abstract boolean loadHibernatedResidents();

    public abstract boolean loadTownList();

    public abstract boolean loadNationList();

    public abstract boolean loadWorldList();

    public abstract boolean loadRegenList();

    public abstract boolean loadSnapshotList();

    public abstract boolean loadTownBlocks();

    public abstract boolean loadJailList();

    public abstract boolean loadResident(Resident var1);

    public abstract boolean loadTown(Town var1);

    public abstract boolean loadNation(Nation var1);

    public abstract boolean loadWorld(TownyWorld var1);

    public abstract boolean loadJail(Jail var1);

    public abstract boolean loadPlotGroupList();

    public abstract boolean loadPlotGroup(PlotGroup var1);

    public abstract boolean saveWorldList();

    public abstract boolean saveRegenList();

    public abstract boolean saveSnapshotList();

    public abstract boolean saveResident(Resident var1);

    public abstract boolean saveHibernatedResident(UUID var1);

    public abstract boolean saveTown(Town var1);

    public abstract boolean savePlotGroup(PlotGroup var1);

    public abstract boolean saveJail(Jail var1);

    public abstract boolean saveNation(Nation var1);

    public abstract boolean saveWorld(TownyWorld var1);

    public abstract boolean saveTownBlock(TownBlock var1);

    public abstract boolean savePlotData(PlotBlockData var1);

    public abstract PlotBlockData loadPlotData(String var1, int var2, int var3);

    public abstract PlotBlockData loadPlotData(TownBlock var1);

    public abstract void deletePlotData(PlotBlockData var1);

    public abstract void deleteResident(Resident var1);

    public abstract void deleteHibernatedResident(UUID var1);

    public abstract void deleteTown(Town var1);

    public abstract void deleteNation(Nation var1);

    public abstract void deleteWorld(TownyWorld var1);

    public abstract void deleteTownBlock(TownBlock var1);

    public abstract void deleteFile(String var1);

    public abstract void deletePlotGroup(PlotGroup var1);

    public abstract void deleteJail(Jail var1);

    public boolean cleanup() {
        return true;
    }

    public boolean loadResidents() {
        TownyMessaging.sendDebugMsg("Loading Residents");
        TownySettings.setUUIDCount(0);
        for (Resident resident : this.universe.getResidents()) {
            if (!this.loadResident(resident)) {
                this.plugin.getLogger().severe("Loading Error: Could not read resident data '" + resident.getName() + "'.");
                return false;
            }
            if (!resident.hasUUID()) continue;
            TownySettings.incrementUUIDCount();
        }
        return true;
    }

    public boolean loadTowns() {
        TownyMessaging.sendDebugMsg("Loading Towns");
        for (Town town : this.getTowns()) {
            if (this.loadTown(town)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read town data '" + town.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadNations() {
        TownyMessaging.sendDebugMsg("Loading Nations");
        for (Nation nation : this.universe.getNations()) {
            if (this.loadNation(nation)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read nation data '" + nation.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadWorlds() {
        TownyMessaging.sendDebugMsg("Loading Worlds");
        for (TownyWorld world : this.getWorlds()) {
            if (this.loadWorld(world)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read world data '" + world.getName() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadJails() {
        TownyMessaging.sendDebugMsg("Loading Jails");
        for (Jail jail : this.getAllJails()) {
            if (this.loadJail(jail)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read jail data '" + jail.getUUID() + "'.");
            return false;
        }
        return true;
    }

    public boolean loadPlotGroups() {
        TownyMessaging.sendDebugMsg("Loading PlotGroups");
        for (PlotGroup group : this.getAllPlotGroups()) {
            if (this.loadPlotGroup(group)) continue;
            this.plugin.getLogger().severe("Loading Error: Could not read PlotGroup data: '" + group.getID() + "'.");
            return false;
        }
        return true;
    }

    public boolean saveResidents() {
        TownyMessaging.sendDebugMsg("Saving Residents");
        for (Resident resident : this.universe.getResidents()) {
            this.saveResident(resident);
        }
        return true;
    }

    public boolean saveHibernatedResidents() {
        for (UUID uuid : this.universe.getHibernatedResidents()) {
            this.saveHibernatedResident(uuid);
        }
        return true;
    }

    public boolean savePlotGroups() {
        TownyMessaging.sendDebugMsg("Saving PlotGroups");
        for (PlotGroup plotGroup : this.getAllPlotGroups()) {
            if (plotGroup.hasTownBlocks()) {
                this.savePlotGroup(plotGroup);
                continue;
            }
            this.deletePlotGroup(plotGroup);
        }
        return true;
    }

    public boolean saveJails() {
        TownyMessaging.sendDebugMsg("Saving Jails");
        for (Jail jail : this.getAllJails()) {
            this.saveJail(jail);
        }
        return true;
    }

    public boolean saveTowns() {
        TownyMessaging.sendDebugMsg("Saving Towns");
        for (Town town : this.getTowns()) {
            this.saveTown(town);
        }
        return true;
    }

    public boolean saveNations() {
        TownyMessaging.sendDebugMsg("Saving Nations");
        for (Nation nation : this.universe.getNations()) {
            this.saveNation(nation);
        }
        return true;
    }

    public boolean saveWorlds() {
        TownyMessaging.sendDebugMsg("Saving Worlds");
        for (TownyWorld world : this.getWorlds()) {
            this.saveWorld(world);
        }
        return true;
    }

    public boolean saveTownBlocks() {
        TownyMessaging.sendDebugMsg("Saving Townblocks");
        for (Town town : this.getTowns()) {
            for (TownBlock townBlock : town.getTownBlocks()) {
                this.saveTownBlock(townBlock);
            }
        }
        return true;
    }

    public abstract List<Resident> getResidents(Player var1, String[] var2);

    public abstract List<Resident> getResidents();

    public abstract List<PlotGroup> getAllPlotGroups();

    public abstract List<Jail> getAllJails();

    public abstract List<Resident> getResidents(String[] var1);

    public abstract List<Resident> getResidents(UUID[] var1);

    @Deprecated
    public abstract Resident getResident(String var1) throws NotRegisteredException;

    public abstract void removeNation(Nation var1);

    @Deprecated
    public abstract boolean hasResident(String var1);

    public abstract boolean hasTown(String var1);

    public abstract boolean hasNation(String var1);

    public abstract List<Town> getTowns(String[] var1);

    public abstract List<Town> getTowns(List<UUID> var1);

    public abstract List<Town> getTowns();

    public abstract Town getTown(String var1) throws NotRegisteredException;

    public abstract Town getTown(UUID var1) throws NotRegisteredException;

    public abstract List<Nation> getNations(String[] var1);

    public abstract List<Nation> getNations();

    public abstract Nation getNation(String var1) throws NotRegisteredException;

    public abstract Nation getNation(UUID var1) throws NotRegisteredException;

    public abstract TownyWorld getWorld(String var1) throws NotRegisteredException;

    public abstract List<TownyWorld> getWorlds();

    @Deprecated
    public TownyWorld getTownWorld(String townName) {
        for (TownyWorld world : this.universe.getWorldMap().values()) {
            if (!world.hasTown(townName)) continue;
            return world;
        }
        return this.universe.getDataSource().getWorlds().get(0);
    }

    public abstract void removeResident(Resident var1);

    public abstract void removeHibernatedResident(UUID var1);

    public abstract void removeTownBlock(TownBlock var1);

    public abstract void removeTownBlocks(Town var1);

    public abstract Collection<TownBlock> getAllTownBlocks();

    public abstract void newResident(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newResident(String var1, UUID var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newTown(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newNation(String var1) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newNation(String var1, UUID var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void newWorld(String var1) throws AlreadyRegisteredException;

    public abstract void removeTown(Town var1);

    public abstract void removeTown(Town var1, boolean var2);

    public abstract void removeWorld(TownyWorld var1) throws UnsupportedOperationException;

    public abstract void removeJail(Jail var1);

    public abstract void removePlotGroup(PlotGroup var1);

    @Deprecated
    public abstract Set<String> getResidentKeys();

    @Deprecated
    public abstract Set<String> getTownsKeys();

    @Deprecated
    public abstract Set<String> getNationsKeys();

    public abstract List<Town> getTownsWithoutNation();

    public abstract List<Resident> getResidentsWithoutTown();

    public abstract void renameTown(Town var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void renameNation(Nation var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void mergeNation(Nation var1, Nation var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void mergeTown(Town var1, Town var2);

    public abstract void renamePlayer(Resident var1, String var2) throws AlreadyRegisteredException, NotRegisteredException;

    public abstract void renameGroup(PlotGroup var1, String var2) throws AlreadyRegisteredException;
}

