/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.object.Translatable;
import org.bukkit.command.CommandSender;

public class ConfirmationBuilder {
    Runnable acceptHandler;
    Runnable cancelHandler;
    Translatable title = Translatable.of("are_you_sure_you_want_to_continue");
    String confirmCommand = TownySettings.getConfirmCommand();
    String cancelCommand = TownySettings.getCancelCommand();
    String pluginPrefix = "towny";
    int duration = TownySettings.getConfirmationTimeoutSeconds();
    boolean runAsync;

    public ConfirmationBuilder runOnCancel(Runnable cancelHandler) {
        this.cancelHandler = cancelHandler;
        return this;
    }

    @Deprecated
    public ConfirmationBuilder setTitle(String title) {
        this.title = Translatable.of(title);
        return this;
    }

    public ConfirmationBuilder setTitle(Translatable title) {
        this.title = title;
        return this;
    }

    public ConfirmationBuilder setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public ConfirmationBuilder setAsync(boolean runAsync) {
        this.runAsync = runAsync;
        return this;
    }

    public ConfirmationBuilder setConfirmText(String confirm) {
        this.confirmCommand = confirm;
        return this;
    }

    public ConfirmationBuilder setCancelText(String cancel) {
        this.cancelCommand = cancel;
        return this;
    }

    public ConfirmationBuilder setPluginCommandPrefix(String prefix) {
        this.pluginPrefix = prefix;
        return this;
    }

    public Confirmation build() {
        return new Confirmation(this);
    }

    public void sendTo(CommandSender sender) {
        Confirmation confirmation = this.build();
        ConfirmationHandler.sendConfirmation(sender, confirmation);
    }
}

