/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.confirmations.ConfirmationBuilder;
import com.palmergames.bukkit.towny.object.Translatable;

public class Confirmation {
    private final Runnable acceptHandler;
    private final Runnable cancelHandler;
    private final Translatable title;
    private final int duration;
    private final String confirmCommand;
    private final String cancelCommand;
    private final boolean isAsync;
    private String pluginPrefix;

    public static ConfirmationBuilder runOnAccept(Runnable acceptHandler) {
        ConfirmationBuilder builder = new ConfirmationBuilder();
        builder.acceptHandler = acceptHandler;
        return builder;
    }

    public static ConfirmationBuilder runOnAcceptAsync(Runnable acceptHandler) {
        ConfirmationBuilder builder = new ConfirmationBuilder();
        builder.acceptHandler = acceptHandler;
        builder.runAsync = true;
        return builder;
    }

    protected Confirmation(ConfirmationBuilder builder) {
        this.acceptHandler = builder.acceptHandler;
        this.cancelHandler = builder.cancelHandler;
        this.title = builder.title;
        this.duration = builder.duration;
        this.isAsync = builder.runAsync;
        this.confirmCommand = builder.confirmCommand;
        this.cancelCommand = builder.cancelCommand;
        this.pluginPrefix = builder.pluginPrefix;
    }

    public Runnable getAcceptHandler() {
        return this.acceptHandler;
    }

    public Runnable getCancelHandler() {
        return this.cancelHandler;
    }

    public Translatable getTitle() {
        return this.title;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getConfirmCommand() {
        return this.confirmCommand;
    }

    public String getCancelCommand() {
        return this.cancelCommand;
    }

    public String getPluginPrefix() {
        return this.pluginPrefix;
    }

    public boolean isAsync() {
        return this.isAsync;
    }
}

