/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.event.NationAcceptAllyRequestEvent;
import com.palmergames.bukkit.towny.event.NationAddEnemyEvent;
import com.palmergames.bukkit.towny.event.NationDenyAllyRequestEvent;
import com.palmergames.bukkit.towny.event.NationInviteTownEvent;
import com.palmergames.bukkit.towny.event.NationPreAddEnemyEvent;
import com.palmergames.bukkit.towny.event.NationPreAddTownEvent;
import com.palmergames.bukkit.towny.event.NationPreRemoveEnemyEvent;
import com.palmergames.bukkit.towny.event.NationPreRenameEvent;
import com.palmergames.bukkit.towny.event.NationRemoveAllyEvent;
import com.palmergames.bukkit.towny.event.NationRemoveEnemyEvent;
import com.palmergames.bukkit.towny.event.NationRequestAllyNationEvent;
import com.palmergames.bukkit.towny.event.NewNationEvent;
import com.palmergames.bukkit.towny.event.nation.NationKingChangeEvent;
import com.palmergames.bukkit.towny.event.nation.NationMergeEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreMergeEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownKickEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownLeaveEvent;
import com.palmergames.bukkit.towny.event.nation.NationRankAddEvent;
import com.palmergames.bukkit.towny.event.nation.NationRankRemoveEvent;
import com.palmergames.bukkit.towny.event.nation.NationSetSpawnEvent;
import com.palmergames.bukkit.towny.event.nation.NationTownLeaveEvent;
import com.palmergames.bukkit.towny.event.nation.PreNewNationEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleNeutralEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleOpenEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationTogglePublicEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.comparators.ComparatorCaches;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.towny.object.inviteobjects.NationAllyNationInvite;
import com.palmergames.bukkit.towny.object.inviteobjects.TownJoinNationInvite;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.MapUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BookFactory;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class NationCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> nationTabCompletes;
    private static final List<String> nationSetTabCompletes;
    private static final List<String> nationListTabCompletes;
    static final List<String> nationToggleTabCompletes;
    private static final List<String> nationEnemyTabCompletes;
    private static final List<String> nationAllyTabCompletes;
    private static final List<String> nationKingTabCompletes;
    private static final List<String> nationConsoleTabCompletes;

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        block99: {
            block98: {
                if (!(sender instanceof Player)) break block98;
                Player player = (Player)sender;
                switch (args[0].toLowerCase()) {
                    case "toggle": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, nationToggleTabCompletes), args[1]);
                        }
                        if (args.length == 3) {
                            return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                        }
                        break block99;
                    }
                    case "king": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationKingTabCompletes, args[1]);
                        }
                        break block99;
                    }
                    case "townlist": 
                    case "allylist": 
                    case "enemylist": 
                    case "ranklist": 
                    case "online": 
                    case "join": 
                    case "delete": 
                    case "merge": 
                    case "baltop": {
                        if (args.length == 2) {
                            return NationCommand.getTownyStartingWith(args[1], "n");
                        }
                        break block99;
                    }
                    case "spawn": {
                        if (args.length == 2) {
                            List<String> nationOrIgnore = NationCommand.getTownyStartingWith(args[1], "n");
                            nationOrIgnore.add("-ignore");
                            return NameUtil.filterByStart(nationOrIgnore, args[1]);
                        }
                        if (args.length == 3) {
                            List<String> ignore = Collections.singletonList("-ignore");
                            return ignore;
                        }
                    }
                    case "add": {
                        return NationCommand.getTownyStartingWith(args[args.length - 1], "t");
                    }
                    case "kick": {
                        try {
                            Object res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                            if (res != null) {
                                return NameUtil.filterByStart(NameUtil.getNames(((Resident)res).getTown().getNation().getTowns()), args[args.length - 1]);
                            }
                        }
                        catch (TownyException res) {
                            // empty catch block
                        }
                    }
                    case "ally": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationAllyTabCompletes, args[1]);
                        }
                        if (args.length > 2) {
                            switch (args[1].toLowerCase()) {
                                case "add": {
                                    if (args[args.length - 1].startsWith("-")) {
                                        try {
                                            return NameUtil.filterByStart(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getSentAllyInvites().stream().map(Invite::getReceiver).map(Nameable::getName).collect(Collectors.toList()), args[args.length - 1].substring(1)).stream().map(e -> "-" + e).collect(Collectors.toList());
                                        }
                                        catch (TownyException townyException) {
                                        }
                                    } else {
                                        return NationCommand.getTownyStartingWith(args[args.length - 1], "n");
                                    }
                                }
                                case "remove": {
                                    try {
                                        return NameUtil.filterByStart(NameUtil.getNames(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getAllies()), args[args.length - 1]);
                                    }
                                    catch (TownyException townyException) {
                                        // empty catch block
                                    }
                                }
                                case "accept": 
                                case "deny": {
                                    try {
                                        return NameUtil.filterByStart(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getReceivedInvites().stream().map(Invite::getSender).map(Nameable::getName).collect(Collectors.toList()), args[args.length - 1]);
                                    }
                                    catch (TownyException townyException) {
                                        // empty catch block
                                    }
                                }
                            }
                            return Collections.emptyList();
                        }
                        break block99;
                    }
                    case "rank": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationEnemyTabCompletes, args[1]);
                        }
                        if (args.length > 2) {
                            switch (args[1].toLowerCase()) {
                                case "add": 
                                case "remove": {
                                    if (args.length == 3) {
                                        try {
                                            return NameUtil.filterByStart(NameUtil.getNames(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getResidents()), args[2]);
                                        }
                                        catch (NotRegisteredException e2) {
                                            return Collections.emptyList();
                                        }
                                    }
                                    if (args.length != 4) break;
                                    return NameUtil.filterByStart(TownyPerms.getNationRanks(), args[3]);
                                }
                            }
                            return Collections.emptyList();
                        }
                        break block99;
                    }
                    case "enemy": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationEnemyTabCompletes, args[1]);
                        }
                        if (args.length >= 3) {
                            switch (args[1].toLowerCase()) {
                                case "add": {
                                    return NationCommand.getTownyStartingWith(args[2], "n");
                                }
                                case "remove": {
                                    try {
                                        return NameUtil.filterByStart(NameUtil.getNames(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getEnemies()), args[2]);
                                    }
                                    catch (TownyException townyException) {
                                        // empty catch block
                                    }
                                }
                            }
                            return Collections.emptyList();
                        }
                        break block99;
                    }
                    case "set": {
                        try {
                            return NationCommand.nationSetTabComplete(sender, NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation(), args);
                        }
                        catch (NotRegisteredException e3) {
                            return Collections.emptyList();
                        }
                    }
                    case "list": {
                        switch (args.length) {
                            case 2: {
                                return Collections.singletonList("by");
                            }
                            case 3: {
                                return NameUtil.filterByStart(nationListTabCompletes, args[2]);
                            }
                        }
                        return Collections.emptyList();
                    }
                    default: {
                        if (args.length == 1) {
                            List<String> nationNames = NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.NATION, nationTabCompletes), args[0]);
                            if (nationNames.size() > 0) {
                                return nationNames;
                            }
                            return NationCommand.getTownyStartingWith(args[0], "n");
                        }
                        if (args.length > 1 && TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION, args[0])) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                        }
                        break block99;
                    }
                }
            }
            if (args.length == 1) {
                return NationCommand.filterByStartOrGetTownyStartingWith(nationConsoleTabCompletes, args[0], "n");
            }
        }
        return Collections.emptyList();
    }

    static List<String> nationSetTabComplete(CommandSender sender, Nation nation, String[] args) {
        if (args.length == 2) {
            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.NATION_SET, nationSetTabCompletes), args[1]);
        }
        if (args.length > 2) {
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_SET, args[1])) {
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
            }
            switch (args[1].toLowerCase()) {
                case "king": 
                case "title": 
                case "surname": {
                    return NameUtil.filterByStart(NameUtil.getNames(nation.getResidents()), args[2]);
                }
                case "capital": {
                    return NameUtil.filterByStart(NameUtil.getNames(nation.getTowns()), args[2]);
                }
                case "tag": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(Collections.singletonList("clear"), args[2]);
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public NationCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            try {
                this.parseNationCommand(player, args);
            }
            catch (TownyException te) {
                TownyMessaging.sendErrorMsg((Object)player, te.getMessage((CommandSender)player));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        } else {
            this.parseNationCommandForConsole(sender, args);
        }
        return true;
    }

    private static Nation getNationOrThrow(String nationName) throws NotRegisteredException {
        Nation nation = TownyUniverse.getInstance().getNation(nationName);
        if (nation == null) {
            throw new NotRegisteredException(Translation.of("msg_err_not_registered_1", nationName));
        }
        return nation;
    }

    private static Nation getNationFromPlayerOrThrow(Player player) throws TownyException {
        return NationCommand.getNationFromResidentOrThrow(NationCommand.getResidentOrThrow(player.getUniqueId()));
    }

    private static Nation getNationFromResidentOrThrow(Resident resident) throws TownyException {
        if (!resident.hasNation()) {
            throw new TownyException(Translatable.of("msg_err_dont_belong_nation"));
        }
        return resident.getNationOrNull();
    }

    private static Nation getPlayerNationOrNationFromArg(Player player, String[] args) throws TownyException {
        return args.length == 0 ? NationCommand.getNationFromPlayerOrThrow(player) : NationCommand.getNationOrThrow(args[0]);
    }

    private void parseNationCommandForConsole(CommandSender sender, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_HELP_CONSOLE.send(sender);
        } else if (split[0].equalsIgnoreCase("list")) {
            try {
                this.listNations(sender, split);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        } else {
            Nation nation = TownyUniverse.getInstance().getNation(split[0]);
            if (nation != null) {
                this.nationStatusScreen(sender, nation);
            } else {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_registered_1", split[0]));
            }
        }
    }

    public void parseNationCommand(Player player, String[] split) throws TownyException, Exception {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0) {
            this.nationStatusScreen((CommandSender)player, NationCommand.getNationFromPlayerOrThrow(player));
            return;
        }
        if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_HELP.send((CommandSender)player);
            return;
        }
        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION.getNode(split[0].toLowerCase()))) {
            if (NationCommand.tryNationAddonCommand(player, split)) {
                return;
            }
            if (this.tryNationStatusScreen(player, split)) {
                return;
            }
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        switch (split[0].toLowerCase()) {
            case "list": {
                this.listNations((CommandSender)player, split);
                break;
            }
            case "townlist": {
                this.nationTownList(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            case "allylist": {
                this.nationAllyList(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            case "enemylist": {
                this.nationEnemyList(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            case "new": {
                this.newNation(player, split);
                break;
            }
            case "join": {
                this.parseNationJoin(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "merge": {
                this.mergeNation(player, split);
                break;
            }
            case "withdraw": {
                NationCommand.nationTransaction(player, split, true);
                break;
            }
            case "leave": {
                this.nationLeave(player);
                break;
            }
            case "spawn": {
                boolean ignoreWarning = split.length > 1 && split[1].equals("-ignore") || split.length > 2 && split[2].equals("-ignore");
                NationCommand.nationSpawn(player, StringMgmt.remFirstArg(split), ignoreWarning);
                break;
            }
            case "deposit": {
                NationCommand.nationTransaction(player, split, false);
                break;
            }
            case "rank": {
                this.nationRank(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "ranklist": {
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getRanksForNation(NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)), Translation.getLocale((CommandSender)player)));
                break;
            }
            case "king": {
                this.nationKing(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "add": {
                this.nationAdd(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "invite": 
            case "invites": {
                this.parseInviteCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "kick": {
                this.nationKick(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "set": {
                NationCommand.nationSet((CommandSender)player, StringMgmt.remFirstArg(split), false, null);
                break;
            }
            case "toggle": {
                NationCommand.nationToggle((CommandSender)player, StringMgmt.remFirstArg(split), false, null);
                break;
            }
            case "ally": {
                this.nationAlly(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "enemy": {
                this.nationEnemy(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "delete": {
                this.nationDelete(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "online": {
                this.parseNationOnlineCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "say": {
                this.nationSay(NationCommand.getNationFromPlayerOrThrow(player), StringMgmt.remFirstArg(split));
                break;
            }
            case "bankhistory": {
                this.nationBankHistory(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "baltop": {
                NationCommand.parseNationBaltop(player, NationCommand.getPlayerNationOrNationFromArg(player, StringMgmt.remFirstArg(split)));
                break;
            }
            default: {
                if (NationCommand.tryNationAddonCommand(player, split)) {
                    return;
                }
                if (!this.tryNationStatusScreen(player, split)) break;
                return;
            }
        }
    }

    private boolean tryNationStatusScreen(Player player, String[] split) throws TownyException {
        Nation nation = TownyUniverse.getInstance().getNation(split[0]);
        if (nation != null) {
            if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_OTHERNATION.getNode()) && !nation.hasResident(player.getName())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            this.nationStatusScreen((CommandSender)player, nation);
            return true;
        }
        return false;
    }

    private static boolean tryNationAddonCommand(Player player, String[] split) {
        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION, split[0]).execute((CommandSender)player, "nation", split);
            return true;
        }
        return false;
    }

    private void nationSay(Nation nation, String[] split) throws TownyException {
        if (split.length == 0) {
            throw new TownyException("ex: /n say [message here]");
        }
        TownyMessaging.sendPrefixedNationMessage(nation, StringMgmt.join(split));
    }

    private void nationBankHistory(Player player, String[] split) throws TownyException {
        int pages = 10;
        if (split.length > 0) {
            try {
                pages = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_must_be_int"));
                return;
            }
        }
        NationCommand.getNationFromPlayerOrThrow(player).generateBankHistoryBook(player, pages);
    }

    private void nationTownList(Player player, Nation nation) {
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getName() + " " + Translatable.of("town_plu").forLocale((CommandSender)player)));
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_towns").forLocale((CommandSender)player), new ArrayList<TownyObject>(nation.getTowns())));
    }

    private void nationAllyList(Player player, Nation nation) throws TownyException {
        if (nation.getAllies().isEmpty()) {
            throw new TownyException(Translatable.of("msg_error_nation_has_no_allies"));
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getName() + " " + Translatable.of("status_nation_allies").forLocale((CommandSender)player)));
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_allies").forLocale((CommandSender)player), new ArrayList<TownyObject>(nation.getAllies())));
    }

    private void nationEnemyList(Player player, Nation nation) throws TownyException {
        if (nation.getEnemies().isEmpty()) {
            throw new TownyException(Translatable.of("msg_error_nation_has_no_enemies"));
        }
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getName() + " " + Translatable.of("status_nation_enemies").forLocale((CommandSender)player)));
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_enemies").forLocale((CommandSender)player), new ArrayList<TownyObject>(nation.getEnemies())));
    }

    private void parseNationJoin(Player player, String[] args) {
        try {
            if (args.length < 1) {
                throw new TownyException("Usage: /nation join [nation]");
            }
            String nationName = args[0];
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            Town town = resident.getTown();
            Nation nation = NationCommand.getNationOrThrow(nationName);
            if (town.hasNation()) {
                throw new TownyException(Translatable.of("msg_err_already_in_a_nation"));
            }
            if (!nation.isOpen()) {
                throw new TownyException(Translatable.of("msg_err_nation_not_open", nation.getFormattedName()));
            }
            if (TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                throw new TownyException(Translatable.of("msg_err_not_enough_residents_join_nation", town.getName()));
            }
            if (TownySettings.getMaxTownsPerNation() > 0 && nation.getTowns().size() >= TownySettings.getMaxTownsPerNation()) {
                throw new TownyException(Translatable.of("msg_err_nation_over_town_limit", TownySettings.getMaxTownsPerNation()));
            }
            if (TownySettings.getNationRequiresProximity() > 0.0) {
                Coord capitalCoord = nation.getCapital().getHomeBlock().getCoord();
                Coord townCoord = town.getHomeBlock().getCoord();
                if (!nation.getCapital().getHomeBlock().getWorld().getName().equals(town.getHomeBlock().getWorld().getName())) {
                    throw new TownyException(Translatable.of("msg_err_nation_homeblock_in_another_world"));
                }
                double distance = Math.sqrt(Math.pow((double)capitalCoord.getX() - (double)townCoord.getX(), 2.0) + Math.pow((double)capitalCoord.getZ() - (double)townCoord.getZ(), 2.0));
                if (distance > TownySettings.getNationRequiresProximity()) {
                    throw new TownyException(Translatable.of("msg_err_town_not_close_enough_to_nation", town.getName()));
                }
            }
            NationPreAddTownEvent preEvent = new NationPreAddTownEvent(nation, town);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                return;
            }
            ArrayList<Town> towns = new ArrayList<Town>();
            towns.add(town);
            NationCommand.nationAdd(nation, towns);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
        }
    }

    private void parseInviteCommand(Player player, String[] newSplit) throws TownyException {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
        String sent = Translatable.of("nation_sent_invites").forLocale((CommandSender)player).replace("%a", Integer.toString(resident.getTown().getNation().getSentInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentInvitesMaxAmount(resident.getTown().getNation())));
        if (newSplit.length == 0) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_SEE_HOME.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            HelpMenu.NATION_INVITE.send((CommandSender)player);
            TownyMessaging.sendMessage((Object)player, sent);
            return;
        }
        if (newSplit.length >= 1) {
            if (newSplit[0].equalsIgnoreCase("help") || newSplit[0].equalsIgnoreCase("?")) {
                HelpMenu.NATION_INVITE.send((CommandSender)player);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("sent")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_LIST_SENT.getNode())) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                Collection sentinvites = resident.getTown().getNation().getSentInvites();
                InviteCommand.sendInviteList(player, (List<Invite>)sentinvites, this.getPage(newSplit, 1), true);
                TownyMessaging.sendMessage((Object)player, sent);
                return;
            }
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_ADD.getNode())) {
                throw new TownyException(Translatable.of("msg_err_command_disable"));
            }
            this.nationAdd(player, newSplit);
        }
    }

    private void parseNationOnlineCommand(Player player, String[] split) throws TownyException {
        if (split.length > 0) {
            Nation nation = NationCommand.getNationOrThrow(split[0]);
            List<Resident> onlineResidents = ResidentUtil.getOnlineResidentsViewable(player, nation);
            if (onlineResidents.size() > 0) {
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(Translatable.of("msg_nation_online").forLocale((CommandSender)player), nation, player));
            } else {
                TownyMessaging.sendMessage((Object)player, "\u00a7f0 " + Translatable.of("res_list").forLocale((CommandSender)player) + " " + Translatable.of("msg_nation_online").forLocale((CommandSender)player) + ": " + nation);
            }
        } else {
            Nation nation = NationCommand.getNationFromPlayerOrThrow(player);
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(Translatable.of("msg_nation_online").forLocale((CommandSender)player), nation, player));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nationRank(Player player, String[] split) throws TownyException {
        Resident target;
        if (split.length == 0) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle("/nation rank"));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/nation rank", "add/remove [resident] rank", ""));
            return;
        }
        Town town = null;
        Town targetTown = null;
        if (split.length < 3) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation rank add/remove [resident] [rank]");
            return;
        }
        try {
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            target = NationCommand.getResidentOrThrow(split[1]);
            town = resident.getTown();
            targetTown = target.getTown();
            if (town.getNation() != targetTown.getNation()) {
                throw new TownyException("This resident is not a member of your Nation!");
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage((CommandSender)player));
            return;
        }
        String rank = TownyPerms.matchNationRank(split[2]);
        if (rank == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_unknown_rank_available_ranks", split[2], StringMgmt.join(TownyPerms.getNationRanks(), ", ")));
            return;
        }
        if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank.toLowerCase()))) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_no_permission_to_give_rank"));
            return;
        }
        if (split[0].equalsIgnoreCase("add")) {
            NationRankAddEvent nationRankAddEvent = new NationRankAddEvent(town.getNation(), rank, target);
            BukkitTools.getPluginManager().callEvent((Event)nationRankAddEvent);
            if (nationRankAddEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, nationRankAddEvent.getCancelMessage());
                return;
            }
            if (!target.addNationRank(rank)) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_resident_already_has_rank", target.getName(), "Nation"));
                return;
            }
            if (BukkitTools.isOnline(target.getName())) {
                TownyMessaging.sendMsg((CommandSender)target.getPlayer(), Translatable.of("msg_you_have_been_given_rank", "Nation", rank));
                plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_given_rank", "Nation", rank, target.getName()));
        } else {
            if (!split[0].equalsIgnoreCase("remove")) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", split[0]));
                return;
            }
            NationRankRemoveEvent nationRankRemoveEvent = new NationRankRemoveEvent(town.getNation(), rank, target);
            BukkitTools.getPluginManager().callEvent((Event)nationRankRemoveEvent);
            if (nationRankRemoveEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, nationRankRemoveEvent.getCancelMessage());
                return;
            }
            if (!target.removeNationRank(rank)) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_resident_doesnt_have_rank", target.getName(), "Nation"));
                return;
            }
            if (BukkitTools.isOnline(target.getName())) {
                TownyMessaging.sendMsg((CommandSender)target.getPlayer(), Translatable.of("msg_you_have_had_rank_taken", "Nation", rank));
                plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_taken_rank_from", "Nation", rank, target.getName()));
        }
        target.save();
    }

    public void listNations(CommandSender sender, String[] split) throws TownyException {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        boolean console = true;
        Player player = null;
        if (split.length == 2 && split[1].equals("?")) {
            HelpMenu.NATION_LIST.send(sender);
            return;
        }
        if (sender instanceof Player) {
            console = false;
            player = (Player)sender;
        }
        if (split.length < 2 && !console && !permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LIST_RESIDENTS.getNode())) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        ArrayList<Nation> nationsToSort = new ArrayList<Nation>(TownyUniverse.getInstance().getNations());
        int page = 1;
        boolean pageSet = false;
        boolean comparatorSet = false;
        ComparatorType type = ComparatorType.RESIDENTS;
        int total = (int)Math.ceil((double)nationsToSort.size() / 10.0);
        for (int i = 1; i < split.length; ++i) {
            if (split[i].equalsIgnoreCase("by")) {
                if (comparatorSet) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_multiple_comparators_nation"));
                    return;
                }
                if (++i < split.length) {
                    comparatorSet = true;
                    if (split[i].equalsIgnoreCase("resident")) {
                        split[i] = "residents";
                    }
                    if (!console && !permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LIST.getNode(split[i]))) {
                        throw new TownyException(Translatable.of("msg_err_command_disable"));
                    }
                    if (!nationListTabCompletes.contains(split[i].toLowerCase())) {
                        throw new TownyException(Translatable.of("msg_error_invalid_comparator_nation"));
                    }
                } else {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_missing_comparator"));
                    return;
                }
                type = ComparatorType.valueOf(split[i].toUpperCase());
                comparatorSet = true;
                continue;
            }
            if (pageSet) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_too_many_pages"));
                return;
            }
            try {
                page = Integer.parseInt(split[i]);
                if (page < 0) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_negative"));
                    return;
                }
                if (page == 0) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_must_be_int"));
                    return;
                }
                pageSet = true;
                continue;
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_must_be_int"));
                return;
            }
        }
        if (page > total) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
            return;
        }
        ComparatorType finalType = type;
        int pageNumber = page;
        try {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendNationList(sender, ComparatorCaches.getNationListCache(finalType), finalType, pageNumber, total));
        }
        catch (RuntimeException e) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_comparator_failed"));
        }
    }

    private void newNation(Player player, String[] split) throws TownyException {
        Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
        if (TownySettings.getNumResidentsCreateNation() > 0 && resident.getTown().getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
            throw new TownyException(Translatable.of("msg_err_not_enough_residents_new_nation"));
        }
        if (split.length == 1) {
            throw new TownyException(Translatable.of("msg_specify_nation_name"));
        }
        if (!resident.isMayor() && !resident.getTown().hasResidentWithRank(resident, "assistant")) {
            throw new TownyException(Translatable.of("msg_peasant_right"));
        }
        boolean noCharge = TownySettings.getNewNationPrice() == 0.0 || !TownyEconomyHandler.isActive();
        String nationName = String.join((CharSequence)"_", StringMgmt.remFirstArg(split));
        NationCommand.newNation(player, nationName, resident.getTown(), noCharge);
    }

    public static void newNation(Player player, String name, Town capitalTown, boolean noCharge) {
        try {
            String filteredName;
            if (capitalTown.hasNation()) {
                throw new TownyException(Translatable.of("msg_err_already_nation"));
            }
            if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
                name = StringMgmt.capitalizeStrings(name);
            }
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                filteredName = null;
            }
            if (filteredName == null || TownyUniverse.getInstance().hasNation(filteredName)) {
                throw new TownyException(Translatable.of("msg_err_invalid_name", filteredName));
            }
            PreNewNationEvent preEvent = new PreNewNationEvent(capitalTown, filteredName);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                return;
            }
            if (!noCharge && TownyEconomyHandler.isActive()) {
                if (!capitalTown.getAccount().canPayFromHoldings(TownySettings.getNewNationPrice())) {
                    throw new TownyException(Translatable.of("msg_no_funds_new_nation2", TownySettings.getNewNationPrice()));
                }
                String finalName = filteredName;
                Confirmation.runOnAccept(() -> {
                    if (!capitalTown.getAccount().withdraw(TownySettings.getNewNationPrice(), "New Nation Cost")) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_no_funds_new_nation2", TownySettings.getNewNationPrice()));
                        return;
                    }
                    try {
                        NationCommand.newNation(finalName, capitalTown);
                    }
                    catch (AlreadyRegisteredException | NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
                    }
                    TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_nation", player.getName(), StringMgmt.remUnderscore(finalName)));
                }).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getNewNationPrice()))).sendTo((CommandSender)player);
            } else {
                NationCommand.newNation(filteredName, capitalTown);
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_nation", player.getName(), StringMgmt.remUnderscore(filteredName)));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage((CommandSender)player));
        }
    }

    public static Nation newNation(String name, Town town) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        UUID nationUUID = UUID.randomUUID();
        townyUniverse.getDataSource().newNation(name, nationUUID);
        Nation nation = townyUniverse.getNation(nationUUID);
        if (nation == null) {
            TownyMessaging.sendErrorMsg(String.format("Error fetching new nation with name %s; it was not properly registered!", name));
            throw new NotRegisteredException(Translatable.of("msg_err_not_registered_1", name));
        }
        nation.setRegistered(System.currentTimeMillis());
        nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
        town.setNation(nation);
        nation.setCapital(town);
        nation.setSpawn(town.getSpawnOrNull());
        if (TownyEconomyHandler.isActive()) {
            nation.getAccount().setBalance(0.0, "New Nation Account");
        }
        if (TownySettings.isNationTagSetAutomatically()) {
            nation.setTag(name.substring(0, Math.min(name.length(), TownySettings.getMaxTagLength())).replace("_", "").replace("-", ""));
        }
        town.save();
        nation.save();
        BukkitTools.getPluginManager().callEvent((Event)new NewNationEvent(nation));
        return nation;
    }

    public void mergeNation(Player player, String[] split) throws TownyException {
        if (split.length <= 1) {
            throw new TownyException(Translatable.of("msg_specify_nation_name"));
        }
        String name = split[1];
        Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
        if (!resident.isKing()) {
            throw new TownyException(Translatable.of("msg_err_merging_for_kings_only"));
        }
        Nation remainingNation = resident.getNationOrNull();
        Nation nation = TownyUniverse.getInstance().getNation(name);
        if (nation == null || remainingNation.getName().equalsIgnoreCase(name)) {
            throw new TownyException(Translatable.of("msg_err_invalid_name", name));
        }
        Resident king = nation.getKing();
        if (!BukkitTools.isOnline(king.getName())) {
            throw new TownyException(Translatable.of("msg_err_king_of_that_nation_is_not_online", name, king.getName()));
        }
        TownyMessaging.sendMsg((CommandSender)BukkitTools.getPlayer(king.getName()), Translatable.of("msg_would_you_merge_your_nation_into_other_nation", nation, remainingNation, remainingNation));
        if (TownySettings.getNationRequiresProximity() > 0.0) {
            ArrayList<Town> towns = new ArrayList<Town>(nation.getTowns());
            towns.addAll(remainingNation.getTowns());
            List<Town> removedTowns = remainingNation.gatherOutOfRangeTowns(towns, remainingNation.getCapital());
            if (!removedTowns.isEmpty()) {
                TownyMessaging.sendMsg(nation.getKing(), Translatable.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", ")));
                TownyMessaging.sendMsg(remainingNation.getKing(), Translatable.of("msg_warn_the_following_towns_will_be_removed_from_the_merged_nation", StringMgmt.join(removedTowns, ", ")));
            }
        }
        Confirmation.runOnAccept(() -> {
            NationPreMergeEvent preEvent = new NationPreMergeEvent(nation, remainingNation);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)nation, preEvent.getCancelMessage());
                return;
            }
            try {
                BukkitTools.getPluginManager().callEvent((Event)new NationMergeEvent(nation, remainingNation));
                TownyUniverse.getInstance().getDataSource().mergeNation(nation, remainingNation);
                TownyMessaging.sendGlobalMessage(Translatable.of("nation1_has_merged_with_nation2", nation, remainingNation));
                if (TownySettings.getNationRequiresProximity() > 0.0) {
                    remainingNation.removeOutOfRangeTowns();
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
            }
        }).sendTo((CommandSender)BukkitTools.getPlayerExact(king.getName()));
    }

    public void nationLeave(Player player) {
        Town town = null;
        try {
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            town = resident.getTown();
            NationPreTownLeaveEvent event = new NationPreTownLeaveEvent(town.getNation(), town);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                throw new TownyException(event.getCancelMessage());
            }
            boolean tooManyResidents = false;
            if (town.isCapital()) {
                boolean bl = tooManyResidents = TownySettings.getMaxResidentsPerTown() > 0 && TownySettings.getMaxResidentsPerTownCapitalOverride() > 0 && town.getNumResidents() > TownySettings.getMaxResidentsPerTown();
                if (tooManyResidents) {
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_deleting_nation_will_result_in_losing_residents", TownySettings.getMaxResidentsPerTown(), town.getNumResidents() - TownySettings.getMaxResidentsPerTown()));
                }
            }
            Town finalTown = town;
            Nation nation = town.getNation();
            boolean finalTooManyResidents = tooManyResidents;
            Confirmation.runOnAccept(() -> {
                Bukkit.getPluginManager().callEvent((Event)new NationTownLeaveEvent(nation, finalTown));
                finalTown.removeNation();
                if (finalTooManyResidents) {
                    ResidentUtil.reduceResidentCountToFitTownMaxPop(finalTown);
                }
                plugin.resetCache();
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_town_left", StringMgmt.remUnderscore(finalTown.getName())));
                TownyMessaging.sendPrefixedTownMessage(finalTown, Translatable.of("msg_town_left_nation", StringMgmt.remUnderscore(nation.getName())));
                nation.removeOutOfRangeTowns();
            }).sendTo((CommandSender)player);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage((CommandSender)player));
            return;
        }
    }

    public void nationDelete(Player player, String[] split) {
        if (split.length == 0) {
            try {
                boolean tooManyResidents;
                Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                Town town = resident.getTown();
                Nation nation = resident.getTown().getNation();
                boolean bl = tooManyResidents = TownySettings.getMaxResidentsPerTown() > 0 && TownySettings.getMaxResidentsPerTownCapitalOverride() > 0 && town.getNumResidents() > TownySettings.getMaxResidentsPerTown();
                if (tooManyResidents) {
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_deleting_nation_will_result_in_losing_residents", TownySettings.getMaxResidentsPerTown(), town.getNumResidents() - TownySettings.getMaxResidentsPerTown()));
                }
                Confirmation.runOnAccept(() -> {
                    TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", nation.getName()));
                    TownyUniverse.getInstance().getDataSource().removeNation(nation);
                    if (tooManyResidents) {
                        ResidentUtil.reduceResidentCountToFitTownMaxPop(town);
                    }
                }).sendTo((CommandSender)player);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage((CommandSender)player));
            }
        } else {
            try {
                if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION_DELETE.getNode())) {
                    throw new TownyException(Translatable.of("msg_err_admin_only_delete_nation"));
                }
                Nation nation = NationCommand.getNationOrThrow(split[0]);
                Confirmation.runOnAccept(() -> {
                    TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", nation.getName()));
                    TownyUniverse.getInstance().getDataSource().removeNation(nation);
                }).sendTo((CommandSender)player);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage((CommandSender)player));
            }
        }
    }

    public void nationKing(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.KING_HELP.send((CommandSender)player);
        }
    }

    public void nationAdd(Player player, String[] names) throws TownyException {
        TownyDataSource dataSource = TownyUniverse.getInstance().getDataSource();
        if (names.length < 1) {
            throw new TownyException("Eg: /nation add [names]");
        }
        Nation nation = NationCommand.getNationFromPlayerOrThrow(player);
        if (TownySettings.getMaxTownsPerNation() > 0 && nation.getTowns().size() >= TownySettings.getMaxTownsPerNation()) {
            throw new TownyException(Translatable.of("msg_err_nation_over_town_limit", TownySettings.getMaxTownsPerNation()));
        }
        ArrayList<String> newtownlist = new ArrayList<String>();
        ArrayList<String> removeinvites = new ArrayList<String>();
        for (String townname : new ArrayList<String>(Arrays.asList(names))) {
            if (townname.startsWith("-")) {
                removeinvites.add(townname.substring(1));
                continue;
            }
            if (nation.hasTown(townname)) {
                removeinvites.add(townname);
                continue;
            }
            newtownlist.add(townname);
        }
        names = newtownlist.toArray(new String[0]);
        String[] namestoremove = removeinvites.toArray(new String[0]);
        if (namestoremove.length >= 1) {
            NationCommand.nationRevokeInviteTown((CommandSender)player, nation, dataSource.getTowns(namestoremove));
        }
        if (names.length >= 1) {
            NationCommand.nationAdd(player, nation, dataSource.getTowns(names));
        }
    }

    public static void nationAdd(Player player, Nation nation, List<Town> invited) throws TownyException {
        StringBuilder sb;
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : invited) {
            if (town.hasNation()) {
                remove.add(town);
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_already_nation"));
                continue;
            }
            if (TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                remove.add(town);
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_enough_residents_join_nation", town.getName()));
                continue;
            }
            if (TownySettings.getNationRequiresProximity() > 0.0) {
                if (!nation.getCapital().hasHomeBlock() || !town.hasHomeBlock()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_homeblock_has_not_been_set"));
                }
                WorldCoord capitalCoord = nation.getCapital().getHomeBlockOrNull().getWorldCoord();
                WorldCoord townCoord = town.getHomeBlockOrNull().getWorldCoord();
                if (!capitalCoord.getWorldName().equalsIgnoreCase(townCoord.getWorldName())) {
                    remove.add(town);
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_homeblock_in_another_world"));
                    continue;
                }
                if (MathUtil.distance(capitalCoord, townCoord) > TownySettings.getNationRequiresProximity()) {
                    remove.add(town);
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_town_not_close_enough_to_nation", town.getName()));
                    continue;
                }
            }
            NationPreAddTownEvent preEvent = new NationPreAddTownEvent(nation, town);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                return;
            }
            NationCommand.nationInviteTown(player, nation, town);
        }
        for (Town town : remove) {
            invited.remove(town);
        }
        if (invited.size() > 0) {
            sb = new StringBuilder();
            for (Town town : invited) {
                sb.append(town.getName()).append(", ");
            }
        } else {
            throw new TownyException(Translatable.of("msg_invalid_name"));
        }
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_invited_join_nation", player.getName(), sb.substring(0, sb.length() - 2)));
    }

    public static void nationAdd(Nation nation, List<Town> towns) throws AlreadyRegisteredException {
        for (Town town : towns) {
            if (town.hasNation()) continue;
            town.setNation(nation);
            town.save();
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_join_nation", town.getName()));
        }
        plugin.resetCache();
        nation.save();
    }

    private static void nationRevokeInviteTown(CommandSender sender, Nation nation, List<Town> towns) {
        block2: for (Town town : towns) {
            if (!InviteHandler.inviteIsActive(nation, town)) continue;
            for (Invite invite : town.getReceivedInvites()) {
                if (!invite.getSender().equals(nation)) continue;
                try {
                    InviteHandler.declineInvite(invite, true);
                    TownyMessaging.sendMsg(sender, Translatable.of("nation_revoke_invite_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void nationInviteTown(Player player, Nation nation, Town town) throws TownyException {
        TownJoinNationInvite invite = new TownJoinNationInvite((CommandSender)player, town, nation);
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                town.newReceivedInvite(invite);
                nation.newSentInvite(invite);
                InviteHandler.addInvite(invite);
                Player mayor = TownyAPI.getInstance().getPlayer(town.getMayor());
                if (mayor != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)mayor, invite);
                }
            } else {
                throw new TownyException(Translatable.of("msg_err_town_already_invited", town.getName()));
            }
            Bukkit.getPluginManager().callEvent((Event)new NationInviteTownEvent(invite));
        }
        catch (TooManyInvitesException e) {
            town.deleteReceivedInvite(invite);
            nation.deleteSentInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    public void nationKick(Player player, String[] names) throws TownyException {
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation kick [names]");
            return;
        }
        Nation nation = NationCommand.getNationFromPlayerOrThrow(player);
        NationCommand.nationKick((CommandSender)player, nation, TownyUniverse.getInstance().getDataSource().getTowns(names));
    }

    public static void nationKick(CommandSender sender, Nation nation, List<Town> kicking) {
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : kicking) {
            if (town.isCapital() || !nation.hasTown(town)) {
                remove.add(town);
                continue;
            }
            NationPreTownKickEvent event = new NationPreTownKickEvent(nation, town);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)sender, event.getCancelMessage());
                remove.add(town);
                continue;
            }
            town.removeNation();
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_nation_kicked_by", sender.getName()));
        }
        for (Town town : remove) {
            kicking.remove(town);
        }
        if (kicking.size() > 0) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_kicked", sender.getName(), StringMgmt.join(kicking, ", ")));
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_invalid_name"));
        }
    }

    private void nationAlly(Player player, String[] split) throws TownyException {
        if (split.length <= 0) {
            HelpMenu.ALLIES_STRING.send((CommandSender)player);
            return;
        }
        if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY.getNode(split[0].toLowerCase()))) {
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
        Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
        switch (split[0].toLowerCase()) {
            case "add": {
                this.nationAllyAdd(player, resident, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "remove": {
                this.nationAllyRemove(player, resident, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "sent": {
                this.nationAllySent(player, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "received": {
                this.nationAllyReceived(player, nation, StringMgmt.remFirstArg(split));
                break;
            }
            case "accept": {
                this.nationAllyAccept(player, nation, split);
                break;
            }
            case "deny": {
                this.nationAllyDeny(player, nation, split);
                break;
            }
            default: {
                HelpMenu.ALLIES_STRING.send((CommandSender)player);
            }
        }
    }

    private void nationAllyAdd(Player player, Resident resident, Nation nation, String[] names) throws TownyException {
        if (names.length == 0) {
            throw new TownyException("ex: /n ally add [names]");
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Nation> list = new ArrayList<Nation>();
        ArrayList<Nation> remlist = new ArrayList<Nation>();
        for (String name : names) {
            Nation ally = townyUniverse.getNation(name);
            if (ally != null) {
                if (nation.equals(ally)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                    continue;
                }
                if (nation.isAlliedWith(ally)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_already_ally", ally));
                    continue;
                }
                list.add(ally);
                continue;
            }
            if (name.startsWith("-")) {
                ally = townyUniverse.getNation(name.substring(1));
                if (ally != null) {
                    if (nation.equals(ally)) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                        continue;
                    }
                    remlist.add(ally);
                    continue;
                }
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_name", name));
                continue;
            }
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_name", name));
        }
        if (!list.isEmpty()) {
            this.nationAddOrRemoveAlly(resident, nation, list, true);
        }
        if (!remlist.isEmpty()) {
            this.nationRemoveAllyRequest((CommandSender)player, nation, remlist);
        }
    }

    private void nationAllyRemove(Player player, Resident resident, Nation nation, String[] names) throws TownyException {
        if (names.length == 0) {
            throw new TownyException("ex: /n ally add [names]");
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        for (String name : names) {
            Nation ally = TownyUniverse.getInstance().getNation(name);
            if (ally == null) continue;
            if (nation.equals(ally)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                continue;
            }
            if (!nation.isAlliedWith(ally)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_not_allied_with", ally.getName()));
                continue;
            }
            list.add(ally);
        }
        if (!list.isEmpty()) {
            this.nationAddOrRemoveAlly(resident, nation, list, false);
        }
    }

    private void nationAllySent(Player player, Nation nation, String[] split) {
        String sent = Translatable.of("nation_sent_ally_requests").forLocale((CommandSender)player).replace("%a", Integer.toString(nation.getSentAllyInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentAllyRequestsMaxAmount(nation)));
        InviteCommand.sendInviteList(player, nation.getSentAllyInvites(), this.getPage(split, 0), true);
        TownyMessaging.sendMessage((Object)player, sent);
    }

    private void nationAllyReceived(Player player, Nation nation, String[] split) {
        String received = Translatable.of("nation_received_requests").forLocale((CommandSender)player).replace("%a", Integer.toString(nation.getReceivedInvites().size())).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(nation)));
        InviteCommand.sendInviteList(player, (List<Invite>)nation.getReceivedInvites(), this.getPage(split, 0), false);
        TownyMessaging.sendMessage((Object)player, received);
    }

    private void nationAllyAccept(Player player, Nation nation, String[] split) throws TownyException {
        Nation sendernation;
        Collection invites = nation.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_no_requests"));
            return;
        }
        if (split.length >= 2) {
            sendernation = TownyUniverse.getInstance().getNation(split[1]);
            if (sendernation == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                return;
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_specify_invite"));
            InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
            return;
        }
        Invite toAccept = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
            toAccept = invite;
            break;
        }
        if (toAccept != null) {
            if (TownySettings.getMaxNationAllies() >= 0 && nation.getAllies().size() >= TownySettings.getMaxNationAllies()) {
                toAccept.getReceiver().deleteReceivedInvite(toAccept);
                toAccept.getSender().deleteSentInvite(toAccept);
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_ally_limit_reached"));
                return;
            }
            try {
                NationAcceptAllyRequestEvent acceptAllyRequestEvent = new NationAcceptAllyRequestEvent((Nation)toAccept.getSender(), (Nation)toAccept.getReceiver());
                Bukkit.getPluginManager().callEvent((Event)acceptAllyRequestEvent);
                if (acceptAllyRequestEvent.isCancelled()) {
                    toAccept.getReceiver().deleteReceivedInvite(toAccept);
                    toAccept.getSender().deleteSentInvite(toAccept);
                    TownyMessaging.sendErrorMsg((Object)player, acceptAllyRequestEvent.getCancelMessage());
                    return;
                }
                InviteHandler.acceptInvite(toAccept);
                return;
            }
            catch (InvalidObjectException e) {
                e.printStackTrace();
            }
        }
    }

    private void nationAllyDeny(Player player, Nation nation, String[] split) {
        Nation sendernation;
        Collection invites = nation.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_no_requests"));
            return;
        }
        if (split.length >= 2) {
            sendernation = TownyUniverse.getInstance().getNation(split[1]);
            if (sendernation == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                return;
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_specify_invite"));
            InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
            return;
        }
        Invite toDecline = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
            toDecline = invite;
            break;
        }
        if (toDecline != null) {
            try {
                NationDenyAllyRequestEvent denyAllyRequestEvent = new NationDenyAllyRequestEvent(nation, sendernation);
                Bukkit.getPluginManager().callEvent((Event)denyAllyRequestEvent);
                if (denyAllyRequestEvent.isCancelled()) {
                    sendernation.deleteSentAllyInvite(toDecline);
                    nation.deleteReceivedInvite(toDecline);
                    TownyMessaging.sendErrorMsg((Object)player, denyAllyRequestEvent.getCancelMessage());
                    return;
                }
                InviteHandler.declineInvite(toDecline, false);
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("successful_deny_request"));
            }
            catch (InvalidObjectException e) {
                e.printStackTrace();
            }
        }
    }

    private void nationRemoveAllyRequest(CommandSender sender, Nation invitingNation, ArrayList<Nation> remlist) {
        block2: for (Nation invitedNation : remlist) {
            if (!InviteHandler.inviteIsActive(invitingNation, invitedNation)) continue;
            for (Invite receivedInvite : invitedNation.getReceivedInvites()) {
                if (!receivedInvite.getSender().equals(invitingNation)) continue;
                try {
                    InviteHandler.declineInvite(receivedInvite, true);
                    TownyMessaging.sendMsg(sender, Translatable.of("nation_revoke_ally_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void nationAddOrRemoveAlly(Resident resident, Nation nation, List<Nation> targetNations, boolean add) throws TownyException {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : targetNations) {
            if (add) {
                try {
                    this.nationAddAlly(resident, nation, targetNation);
                }
                catch (TownyException e) {
                    remove.add(targetNation);
                }
                continue;
            }
            try {
                this.nationRemoveAlly(resident, nation, targetNation);
            }
            catch (TownyException e) {
                remove.add(targetNation);
            }
        }
        for (Nation removedNation : remove) {
            targetNations.remove(removedNation);
        }
        if (targetNations.size() <= 0) {
            throw new TownyException(Translatable.of("msg_invalid_name"));
        }
        TownyUniverse.getInstance().getDataSource().saveNations();
        plugin.resetCache();
    }

    private void nationAddAlly(Resident resident, Nation nation, Nation targetNation) throws TownyException {
        Player player = resident.getPlayer();
        if (player == null) {
            throw new TownyException("Could not add " + targetNation + " as Ally because your Player is null! This shouldn't be possible!");
        }
        if (!targetNation.hasEnemy(nation)) {
            if (!targetNation.getCapital().getMayor().isNPC()) {
                this.nationCreateAllyRequest((CommandSender)player, nation, targetNation);
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_ally_req_sent", targetNation));
            } else {
                this.nationAddNPCNationAsAlly(player, resident, nation, targetNation);
            }
        } else {
            throw new TownyException(Translatable.of("msg_unable_ally_enemy", targetNation));
        }
    }

    private void nationCreateAllyRequest(CommandSender sender, Nation sendingNation, Nation receivingNation) throws TownyException {
        NationAllyNationInvite invite = new NationAllyNationInvite(sender, receivingNation, sendingNation);
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                receivingNation.newReceivedInvite(invite);
                sendingNation.newSentAllyInvite(invite);
                InviteHandler.addInvite(invite);
                Player king = receivingNation.getKing().getPlayer();
                if (king != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)king, invite);
                }
            } else {
                throw new TownyException(Translatable.of("msg_err_ally_already_requested", receivingNation));
            }
            Bukkit.getPluginManager().callEvent((Event)new NationRequestAllyNationEvent(invite));
        }
        catch (TooManyInvitesException e) {
            receivingNation.deleteReceivedInvite(invite);
            sendingNation.deleteSentAllyInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    private void nationAddNPCNationAsAlly(Player player, Resident resident, Nation nation, Nation targetNation) throws TownyException {
        if (TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(player)) {
            try {
                targetNation.addAlly(nation);
                nation.addAlly(targetNation);
            }
            catch (AlreadyRegisteredException e) {
                e.printStackTrace();
            }
        } else {
            throw new TownyException(Translatable.of("msg_unable_ally_npc", nation.getName()));
        }
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_allied_nations", resident, targetNation));
        TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_added_ally", nation));
    }

    private void nationRemoveAlly(Resident resident, Nation nation, Nation targetNation) throws TownyException {
        if (nation.hasAlly(targetNation)) {
            NationRemoveAllyEvent removeAllyEvent = new NationRemoveAllyEvent(nation, targetNation);
            Bukkit.getPluginManager().callEvent((Event)removeAllyEvent);
            if (removeAllyEvent.isCancelled()) {
                throw new TownyException(removeAllyEvent.getCancelMessage());
            }
            nation.removeAlly(targetNation);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_removed_ally", targetNation));
            TownyMessaging.sendMsg(resident, Translatable.of("msg_ally_removed_successfully"));
            if (targetNation.hasAlly(nation)) {
                NationRemoveAllyEvent reciprocalRemoveAllyEvent = new NationRemoveAllyEvent(targetNation, nation);
                Bukkit.getPluginManager().callEvent((Event)reciprocalRemoveAllyEvent);
                if (reciprocalRemoveAllyEvent.isCancelled()) {
                    throw new TownyException(reciprocalRemoveAllyEvent.getCancelMessage());
                }
                targetNation.removeAlly(nation);
                TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_removed_ally", nation.getName()));
            }
        }
    }

    public void nationEnemy(Player player, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation enemy [add/remove] [name]");
            return;
        }
        Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
        Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
        ArrayList<Nation> list = new ArrayList<Nation>();
        String test = split[0];
        String[] newSplit = StringMgmt.remFirstArg(split);
        boolean add = test.equalsIgnoreCase("add");
        if ((test.equalsIgnoreCase("remove") || test.equalsIgnoreCase("add")) && newSplit.length > 0) {
            for (String name : newSplit) {
                Nation enemy = townyUniverse.getNation(name);
                if (enemy == null) {
                    throw new TownyException(Translatable.of("msg_err_no_nation_with_that_name", name));
                }
                if (nation.equals(enemy)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_own_nation_disallow"));
                    continue;
                }
                if (add && nation.hasEnemy(enemy)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_already_enemies_with", enemy.getName()));
                    continue;
                }
                if (!add && !nation.hasEnemy(enemy)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_nation_not_enemies_with", enemy.getName()));
                    continue;
                }
                list.add(enemy);
            }
            if (!list.isEmpty()) {
                this.nationEnemy(resident, nation, list, add);
            }
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", "[add/remove]"));
        }
    }

    public void nationEnemy(Resident resident, Nation nation, List<Nation> enemies, boolean add) {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : enemies) {
            try {
                if (add && !nation.getEnemies().contains(targetNation)) {
                    NationPreAddEnemyEvent npaee = new NationPreAddEnemyEvent(nation, targetNation);
                    Bukkit.getPluginManager().callEvent((Event)npaee);
                    if (!npaee.isCancelled()) {
                        nation.addEnemy(targetNation);
                        NationAddEnemyEvent naee = new NationAddEnemyEvent(nation, targetNation);
                        Bukkit.getPluginManager().callEvent((Event)naee);
                        if (nation.hasAlly(targetNation)) {
                            nation.removeAlly(targetNation);
                            Bukkit.getPluginManager().callEvent((Event)new NationRemoveAllyEvent(nation, targetNation));
                            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_removed_ally", targetNation));
                            TownyMessaging.sendMsg(resident, Translatable.of("msg_ally_removed_successfully"));
                        }
                        if (targetNation.hasAlly(nation)) {
                            targetNation.removeAlly(nation);
                            Bukkit.getPluginManager().callEvent((Event)new NationRemoveAllyEvent(targetNation, nation));
                            TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_removed_ally", nation));
                            TownyMessaging.sendMsg(resident, Translatable.of("msg_ally_removed_successfully"));
                        }
                        TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_added_enemy", nation));
                        continue;
                    }
                    TownyMessaging.sendErrorMsg((Object)resident, npaee.getCancelMessage());
                    remove.add(targetNation);
                    continue;
                }
                if (!nation.getEnemies().contains(targetNation)) continue;
                NationPreRemoveEnemyEvent npree = new NationPreRemoveEnemyEvent(nation, targetNation);
                Bukkit.getPluginManager().callEvent((Event)npree);
                if (!npree.isCancelled()) {
                    nation.removeEnemy(targetNation);
                    NationRemoveEnemyEvent nree = new NationRemoveEnemyEvent(nation, targetNation);
                    Bukkit.getPluginManager().callEvent((Event)nree);
                    TownyMessaging.sendPrefixedNationMessage(targetNation, Translatable.of("msg_removed_enemy", nation));
                    continue;
                }
                TownyMessaging.sendErrorMsg((Object)resident, npree.getCancelMessage());
                remove.add(targetNation);
            }
            catch (AlreadyRegisteredException | NotRegisteredException e) {
                remove.add(targetNation);
            }
        }
        for (Nation newEnemy : remove) {
            enemies.remove(newEnemy);
        }
        if (enemies.size() > 0) {
            String msg = "";
            for (Nation newEnemy : enemies) {
                msg = msg + newEnemy.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            if (add) {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_enemy_nations", resident.getName(), msg));
            } else {
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_enemy_to_neutral", resident.getName(), msg));
            }
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((CommandSender)resident.getPlayer(), Translatable.of("msg_invalid_name"));
        }
    }

    public static void nationSet(CommandSender sender, String[] split, boolean admin, Nation nation) throws TownyException {
        Resident resident;
        Player player;
        if (split.length == 0) {
            HelpMenu.NATION_SET.send(sender);
            return;
        }
        if (!admin && !TownyUniverse.getInstance().getPermissionSource().testPermission((Permissible)sender, PermissionNodes.TOWNY_COMMAND_NATION_SET.getNode(split[0].toLowerCase()))) {
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_SET, split[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_SET, split[0]).execute(sender, "nation", split);
                return;
            }
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        try {
            if (!admin && sender instanceof Player) {
                player = (Player)sender;
                resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                nation = NationCommand.getNationFromResidentOrThrow(resident);
            } else {
                resident = nation.getKing();
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)sender, x.getMessage(sender));
            return;
        }
        switch (split[0].toLowerCase()) {
            case "king": {
                NationCommand.nationSetKing(sender, nation, split, admin);
                break;
            }
            case "capital": {
                NationCommand.nationSetCapital(sender, nation, split, admin);
                break;
            }
            case "spawn": {
                if (sender instanceof Player) {
                    player = (Player)sender;
                    NationCommand.parseNationSetSpawnCommand(player, nation, admin);
                    break;
                }
                throw new TownyException("Not meant for console!");
            }
            case "taxes": {
                NationCommand.nationSetTaxes(sender, nation, split, admin);
                break;
            }
            case "spawncost": {
                NationCommand.nationSetSpawnCost(sender, nation, split, admin);
                break;
            }
            case "name": {
                NationCommand.nationSetName(sender, nation, split, admin);
                break;
            }
            case "tag": {
                NationCommand.nationSetTag(sender, nation, split, admin);
                break;
            }
            case "title": {
                NationCommand.nationSetTitle(sender, nation, resident, split, admin);
                break;
            }
            case "surname": {
                NationCommand.nationSetSurname(sender, nation, resident, split, admin);
                break;
            }
            case "board": {
                NationCommand.nationSetBoard(sender, nation, split);
                break;
            }
            case "mapcolor": {
                NationCommand.nationSetMapColor(sender, nation, split, admin);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_SET, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_SET, split[0]).execute(sender, "nation", split);
                    return;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", split[0]));
                return;
            }
        }
        nation.save();
    }

    private static void nationSetMapColor(CommandSender sender, Nation nation, String[] split, boolean admin) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set mapcolor brown.");
            return;
        }
        String line = StringMgmt.join(StringMgmt.remFirstArg(split), " ");
        if (!TownySettings.getNationColorsMap().containsKey(line.toLowerCase())) {
            String allowedColorsListAsString = TownySettings.getNationColorsMap().keySet().toString();
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_nation_map_color", allowedColorsListAsString));
            return;
        }
        nation.setMapColorHexCode(TownySettings.getNationColorsMap().get(line.toLowerCase()));
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_map_color_changed", line.toLowerCase()));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_nation_map_color_changed", line.toLowerCase()));
        }
    }

    private static void nationSetBoard(CommandSender sender, Nation nation, String[] split) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set board " + Translatable.of("town_help_9").forLocale(sender));
            return;
        }
        String line = StringMgmt.join(StringMgmt.remFirstArg(split), " ");
        if (!line.equals("none")) {
            if (!NameValidation.isValidString(line)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_string_nationboard_not_set"));
                return;
            }
            if (line.length() > 159) {
                line = line.substring(0, 159);
            }
        } else {
            line = "";
        }
        nation.setBoard(line);
        TownyMessaging.sendNationBoard(sender, nation);
    }

    private static void nationSetSurname(CommandSender sender, Nation nation, Resident resident, String[] split, boolean admin) throws NotRegisteredException {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set surname bilbo the dwarf ");
        } else {
            resident = NationCommand.getResidentOrThrow(split[1]);
        }
        if (!nation.hasResident(resident)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_same_nation", resident.getName()));
            return;
        }
        String surname = StringMgmt.join(NameValidation.checkAndFilterArray(StringMgmt.remArgs(split, 2)));
        if (surname.length() > TownySettings.getMaxTitleLength()) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_input_too_long"));
            return;
        }
        if (NameValidation.isConfigBlacklistedName(surname)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_invalid_name"));
            return;
        }
        resident.setSurname(surname);
        resident.save();
        if (resident.hasSurname()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())));
            }
        } else {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_clear_title_surname", "Surname", resident.getName()));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_clear_title_surname", "Surname", resident.getName()));
            }
        }
    }

    private static void nationSetTitle(CommandSender sender, Nation nation, Resident resident, String[] split, boolean admin) throws NotRegisteredException {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set title bilbo Jester ");
        } else {
            resident = NationCommand.getResidentOrThrow(split[1]);
        }
        if (!nation.hasResident(resident)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_same_nation", resident.getName()));
            return;
        }
        String title = StringMgmt.join(NameValidation.checkAndFilterArray(StringMgmt.remArgs(split, 2)));
        if (title.length() > TownySettings.getMaxTitleLength()) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_input_too_long"));
            return;
        }
        if (NameValidation.isConfigBlacklistedName(title)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_invalid_name"));
            return;
        }
        resident.setTitle(title);
        resident.save();
        if (resident.hasTitle()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())));
            }
        } else {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_clear_title_surname", "Title", resident.getName()));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_clear_title_surname", "Title", resident.getName()));
            }
        }
    }

    private static void nationSetTag(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        String name;
        String string = name = sender instanceof Player ? ((Player)sender).getName() : "Console";
        if (split.length < 2) {
            throw new TownyException("Eg: /nation set tag PLT");
        }
        if (split[1].equalsIgnoreCase("clear")) {
            nation.setTag(" ");
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_reset_nation_tag", name));
        } else {
            if (split[1].length() > TownySettings.getMaxTagLength()) {
                throw new TownyException(Translatable.of("msg_err_tag_too_long"));
            }
            nation.setTag(NameValidation.checkAndFilterName(split[1]));
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_set_nation_tag", name, nation.getTag()));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_nation_tag", name, nation.getTag()));
            }
        }
    }

    private static void nationSetName(CommandSender sender, Nation nation, String[] split, boolean admin) throws TownyException {
        if (admin || !(sender instanceof Player)) {
            throw new TownyException("Use /ta nation [nation] rename");
        }
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set name Plutoria");
        } else {
            String name = split[1];
            if (NameValidation.isBlacklistName(name) || TownyUniverse.getInstance().hasNation(name)) {
                throw new TownyException(Translatable.of("msg_invalid_name"));
            }
            if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
                name = StringMgmt.capitalizeStrings(name);
            }
            if (TownyEconomyHandler.isActive() && TownySettings.getNationRenameCost() > 0.0) {
                if (!nation.getAccount().canPayFromHoldings(TownySettings.getNationRenameCost())) {
                    throw new TownyException(Translatable.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost())));
                }
                Nation finalNation = nation;
                String finalName = name;
                Confirmation.runOnAccept(() -> {
                    if (!finalNation.getAccount().canPayFromHoldings(TownySettings.getNationRenameCost())) {
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost())));
                        return;
                    }
                    finalNation.getAccount().withdraw(TownySettings.getNationRenameCost(), String.format("Nation renamed to: %s", finalName));
                    NationCommand.nationRename((Player)sender, finalNation, finalName);
                }).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost()))).sendTo(sender);
            } else {
                NationCommand.nationRename((Player)sender, nation, name);
            }
        }
    }

    private static void nationSetSpawnCost(CommandSender sender, Nation nation, String[] split, boolean admin) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set spawncost 70");
        } else {
            try {
                double amount = Double.parseDouble(split[1]);
                if (amount < 0.0) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_negative_money"));
                    return;
                }
                if (TownySettings.getSpawnTravelCost() < amount) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_cannot_set_spawn_cost_more_than", TownySettings.getSpawnTravelCost()));
                    return;
                }
                nation.setSpawnCost(amount);
                String name = sender instanceof Player ? ((Player)sender).getName() : "Console";
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_spawn_cost_set_to", name, Translatable.of("nation_sing"), split[1]));
                if (admin) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_spawn_cost_set_to", name, Translatable.of("nation_sing"), split[1]));
                }
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_must_be_num"));
                return;
            }
        }
    }

    private static void nationSetTaxes(CommandSender sender, Nation nation, String[] split, boolean admin) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set taxes 70");
        } else {
            int amount = Integer.parseInt(split[1].trim());
            if (amount < 0) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_negative_money"));
                return;
            }
            String name = sender instanceof Player ? ((Player)sender).getName() : "Console";
            try {
                nation.setTaxes(amount);
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_town_set_nation_tax", name, split[1]));
                if (admin) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_nation_tax", name, split[1]));
                }
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_must_be_int"));
            }
        }
    }

    private static void nationSetCapital(CommandSender sender, Nation nation, String[] split, boolean admin) {
        Town newCapital = TownyUniverse.getInstance().getTown(split[1]);
        if (newCapital == null) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_registered_1", split[1]));
            return;
        }
        if (TownySettings.getNumResidentsCreateNation() > 0 && newCapital.getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_not_enough_residents_capital", newCapital.getName()));
            return;
        }
        if (TownySettings.getMaxResidentsPerTown() > 0 && nation.getCapital().getNumResidents() > TownySettings.getMaxResidentsPerTown()) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_nation_capital_too_many_residents", newCapital.getName()));
            return;
        }
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set capital {town name}");
        } else {
            Resident oldKing = nation.getKing();
            Resident newKing = newCapital.getMayor();
            NationKingChangeEvent nationKingChangeEvent = new NationKingChangeEvent(oldKing, newKing);
            Bukkit.getPluginManager().callEvent((Event)nationKingChangeEvent);
            if (nationKingChangeEvent.isCancelled() && !admin) {
                TownyMessaging.sendErrorMsg((Object)sender, nationKingChangeEvent.getCancelMessage());
                return;
            }
            if (TownySettings.getNationRequiresProximity() > 0.0) {
                List<Town> removedTowns = nation.gatherOutOfRangeTowns(nation.getTowns(), newCapital);
                if (!removedTowns.isEmpty()) {
                    Nation finalNation = nation;
                    Confirmation.runOnAccept(() -> {
                        finalNation.setCapital(newCapital);
                        finalNation.removeOutOfRangeTowns();
                        plugin.resetCache();
                        TownyMessaging.sendPrefixedNationMessage(finalNation, Translatable.of("msg_new_king", newCapital.getMayor().getName(), finalNation.getName()));
                        if (admin) {
                            TownyMessaging.sendMsg(sender, Translatable.of("msg_new_king", newCapital.getMayor().getName(), finalNation.getName()));
                        }
                    }).setTitle(Translatable.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", "))).sendTo(sender);
                } else {
                    nation.setCapital(newCapital);
                    plugin.resetCache();
                    TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                    if (admin) {
                        TownyMessaging.sendMsg(sender, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                    }
                    nation.save();
                }
            } else {
                nation.setCapital(newCapital);
                plugin.resetCache();
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                if (admin) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                }
                nation.save();
            }
        }
    }

    private static void nationSetKing(CommandSender sender, Nation nation, String[] split, boolean admin) {
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)sender, "Eg: /nation set king Dumbo");
        } else {
            try {
                Resident newKing = NationCommand.getResidentOrThrow(split[1]);
                Resident oldKing = nation.getKing();
                Town newCapital = newKing.getTown();
                if (TownySettings.getNumResidentsCreateNation() > 0 && newCapital.getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_not_enough_residents_capital", newCapital.getName()));
                    return;
                }
                if (TownySettings.getMaxResidentsPerTown() > 0 && nation.getCapital().getNumResidents() > TownySettings.getMaxResidentsPerTown()) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_nation_capital_too_many_residents", newCapital.getName()));
                    return;
                }
                NationKingChangeEvent nationKingChangeEvent = new NationKingChangeEvent(oldKing, newKing);
                Bukkit.getPluginManager().callEvent((Event)nationKingChangeEvent);
                if (nationKingChangeEvent.isCancelled() && !admin) {
                    TownyMessaging.sendErrorMsg((Object)sender, nationKingChangeEvent.getCancelMessage());
                    return;
                }
                nation.setKing(newKing);
                plugin.deleteCache(oldKing.getName());
                plugin.deleteCache(newKing.getName());
                TownyPerms.assignPermissions(oldKing, null);
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_new_king", newKing.getName(), nation.getName()));
                if (admin) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_new_king", newKing.getName(), nation.getName()));
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        }
    }

    private static void parseNationSetSpawnCommand(Player player, Nation nation, boolean admin) throws TownyException {
        if (TownyAPI.getInstance().isWilderness(player.getLocation())) {
            throw new TownyException(Translatable.of("msg_cache_block_error_wild", "set spawn"));
        }
        NationSetSpawnEvent event = new NationSetSpawnEvent(nation, player, player.getLocation());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && !admin) {
            if (!event.getCancelMessage().isEmpty()) {
                TownyMessaging.sendErrorMsg((Object)player, event.getCancelMessage());
            }
            return;
        }
        Location newSpawn = admin ? player.getLocation() : event.getNewSpawn();
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(newSpawn);
        Town town = townBlock.getTownOrNull();
        if (nation.getCapital() != null && TownySettings.isNationSpawnOnlyAllowedInCapital() && !town.getUUID().equals(nation.getCapital().getUUID())) {
            throw new TownyException(Translatable.of("msg_err_spawn_not_within_capital"));
        }
        if (!nation.getTowns().contains(town)) {
            throw new TownyException(Translatable.of("msg_err_spawn_not_within_nationtowns"));
        }
        if (nation.hasSpawn()) {
            TownyUniverse.getInstance().removeSpawnPoint(nation.getSpawn());
        }
        nation.setSpawn(newSpawn);
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_nation_spawn"));
    }

    private static void parseNationBaltop(Player player, Nation nation) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            StringBuilder sb = new StringBuilder();
            ArrayList<Resident> residents = new ArrayList<Resident>(nation.getResidents());
            residents.sort(Comparator.comparingDouble(res -> res.getAccount().getCachedBalance()).reversed());
            int i = 0;
            for (Resident res2 : residents) {
                sb.append(Translatable.of("msg_baltop_book_format", ++i, res2.getName(), TownyEconomyHandler.getFormattedBalance(res2.getAccount().getCachedBalance())).forLocale((CommandSender)player) + "\n");
            }
            player.openBook(BookFactory.makeBook("Nation Baltop", nation.getName(), sb.toString()));
        });
    }

    public static void nationToggle(CommandSender sender, String[] split, boolean admin, Nation nation) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_TOGGLE_HELP.send(sender);
            return;
        }
        if (!admin) {
            Resident resident = NationCommand.getResidentOrThrow(((Player)sender).getUniqueId());
            nation = NationCommand.getNationFromResidentOrThrow(resident);
        } else {
            Resident resident = nation.getKing();
        }
        if (!admin && !TownyUniverse.getInstance().getPermissionSource().testPermission((Player)sender, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE.getNode(split[0].toLowerCase()))) {
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, split[0])) {
                TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, split[0]).execute(sender, "nation", split);
                return;
            }
            throw new TownyException(Translatable.of("msg_err_command_disable"));
        }
        Optional<Boolean> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        }
        switch (split[0].toLowerCase()) {
            case "peaceful": 
            case "neutral": {
                NationCommand.nationTogglePeaceful(sender, nation, choice, admin);
                break;
            }
            case "public": {
                NationCommand.nationTogglePublic(sender, nation, choice, admin);
                break;
            }
            case "open": {
                NationCommand.nationToggleOpen(sender, nation, choice, admin);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.NATION_TOGGLE, split[0]).execute(sender, "nation", split);
                    return;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", split[0]));
                return;
            }
        }
        nation.save();
    }

    private static void nationTogglePeaceful(CommandSender sender, Nation nation, Optional<Boolean> choice, boolean admin) throws TownyException {
        boolean peacefulState = choice.orElse(!nation.isNeutral());
        double cost = TownySettings.getNationNeutralityCost();
        if (nation.isNeutral() && peacefulState) {
            throw new TownyException(Translatable.of("msg_nation_already_peaceful"));
        }
        if (!nation.isNeutral() && !peacefulState) {
            throw new TownyException(Translatable.of("msg_nation_already_not_peaceful"));
        }
        if (peacefulState && TownyEconomyHandler.isActive() && !nation.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_nation_cant_peaceful"));
        }
        NationToggleNeutralEvent preEvent = new NationToggleNeutralEvent(sender, nation, admin, peacefulState);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            throw new TownyException(preEvent.getCancelMessage());
        }
        if (peacefulState && TownyEconomyHandler.isActive() && cost > 0.0) {
            nation.getAccount().withdraw(cost, "Peaceful Nation Cost");
            TownyMessaging.sendMsg(sender, Translatable.of("msg_you_paid", TownyEconomyHandler.getFormattedBalance(cost)));
        }
        nation.setNeutral(peacefulState);
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_peaceful").append(nation.isNeutral() ? "\u00a72" : "\u00a74 not").append(" peaceful."));
    }

    private static void nationTogglePublic(CommandSender sender, Nation nation, Optional<Boolean> choice, boolean admin) throws TownyException {
        NationTogglePublicEvent preEvent = new NationTogglePublicEvent(sender, nation, admin, choice.orElse(!nation.isPublic()));
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            throw new TownyException(preEvent.getCancelMessage());
        }
        nation.setPublic(preEvent.getFutureState());
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_changed_public", nation.isPublic() ? Translatable.of("enabled") : Translatable.of("disabled")));
    }

    private static void nationToggleOpen(CommandSender sender, Nation nation, Optional<Boolean> choice, boolean admin) throws TownyException {
        NationToggleOpenEvent preEvent = new NationToggleOpenEvent(sender, nation, admin, choice.orElse(!nation.isOpen()));
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            throw new TownyException(preEvent.getCancelMessage());
        }
        nation.setOpen(preEvent.getFutureState());
        TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_changed_open", nation.isOpen() ? Translatable.of("enabled") : Translatable.of("disabled")));
    }

    public static void nationRename(Player player, Nation nation, String newName) {
        NationPreRenameEvent event = new NationPreRenameEvent(nation, newName);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_rename_cancelled"));
            return;
        }
        try {
            TownyUniverse.getInstance().getDataSource().renameNation(nation, newName);
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_set_name", player.getName(), nation.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
        }
    }

    public static void nationSpawn(Player player, String[] split, boolean ignoreWarning) throws TownyException {
        Nation nation = NationCommand.getPlayerNationOrNationFromArg(player, split);
        String notAffordMSG = split.length == 0 ? Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player) : Translatable.of("msg_err_cant_afford_tp_nation", nation.getName()).forLocale((CommandSender)player);
        SpawnUtil.sendToTownySpawn(player, split, nation, notAffordMSG, false, ignoreWarning, SpawnType.NATION);
    }

    private static void nationTransaction(Player player, String[] args, boolean withdraw) {
        block12: {
            try {
                int amount;
                Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                Nation nation = NationCommand.getNationFromResidentOrThrow(resident);
                if (args.length < 2 || args.length > 3) {
                    throw new TownyException(Translatable.of("msg_must_specify_amnt", "/nation" + (withdraw ? " withdraw" : " deposit")));
                }
                try {
                    amount = Integer.parseInt(args[1].trim());
                }
                catch (NumberFormatException ex) {
                    throw new TownyException(Translatable.of("msg_error_must_be_int"));
                }
                if (args.length == 2) {
                    if (withdraw) {
                        MoneyUtil.nationWithdraw(player, resident, nation, amount);
                    } else {
                        MoneyUtil.nationDeposit(player, resident, nation, amount);
                    }
                    return;
                }
                if (withdraw) {
                    throw new TownyException(Translatable.of("msg_must_specify_amnt", "/nation withdraw"));
                }
                if (args.length != 3) break block12;
                if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT_OTHER.getNode())) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                Town town = TownyUniverse.getInstance().getTown(args[2]);
                if (town != null) {
                    if (!nation.hasTown(town)) {
                        throw new TownyException(Translatable.of("msg_err_not_same_nation", town.getName()));
                    }
                    MoneyUtil.townDeposit(player, resident, town, nation, amount);
                    break block12;
                }
                throw new NotRegisteredException();
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage((CommandSender)player));
            }
        }
    }

    private void nationStatusScreen(CommandSender sender, Nation nation) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus(nation, Translation.getLocale(sender))));
    }

    private int getPage(String[] split, int i) {
        int page = 1;
        if (split.length > i) {
            try {
                page = Integer.parseInt(split[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return page;
    }

    static {
        nationTabCompletes = Arrays.asList("list", "online", "leave", "withdraw", "deposit", "new", "add", "kick", "delete", "enemy", "rank", "ranklist", "say", "set", "toggle", "invite", "join", "merge", "townlist", "allylist", "enemylist", "ally", "spawn", "king", "bankhistory", "baltop");
        nationSetTabCompletes = Arrays.asList("king", "capital", "board", "taxes", "name", "spawn", "spawncost", "title", "surname", "tag", "mapcolor");
        nationListTabCompletes = Arrays.asList("residents", "balance", "founded", "name", "online", "open", "public", "townblocks", "towns");
        nationToggleTabCompletes = Arrays.asList("neutral", "peaceful", "public", "open");
        nationEnemyTabCompletes = Arrays.asList("add", "remove");
        nationAllyTabCompletes = Arrays.asList("add", "remove", "sent", "received", "accept", "deny");
        nationKingTabCompletes = Collections.singletonList("?");
        nationConsoleTabCompletes = Arrays.asList("?", "help", "list");
    }
}

