/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.annotations.Unmodifiable;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.db.TownySQLSource;
import com.palmergames.bukkit.towny.event.TownyLoadedDatabaseEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.KeyAlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnPoint;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.map.TownyMapData;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.tasks.BackupTask;
import com.palmergames.bukkit.towny.tasks.CleanupTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.Trie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyUniverse {
    private static TownyUniverse instance;
    private final Towny towny;
    private final Map<UUID, Resident> residentUUIDMap = new ConcurrentHashMap<UUID, Resident>();
    private final Map<String, Resident> residentNameMap = new ConcurrentHashMap<String, Resident>();
    private final Trie residentsTrie = new Trie();
    private final Map<String, Town> townNameMap = new ConcurrentHashMap<String, Town>();
    private final Map<UUID, Town> townUUIDMap = new ConcurrentHashMap<UUID, Town>();
    private final Trie townsTrie = new Trie();
    private final Map<String, Nation> nationNameMap = new ConcurrentHashMap<String, Nation>();
    private final Map<UUID, Nation> nationUUIDMap = new ConcurrentHashMap<UUID, Nation>();
    private final Trie nationsTrie = new Trie();
    private final Map<String, TownyWorld> worlds = new ConcurrentHashMap<String, TownyWorld>();
    private final Map<String, CustomDataField<?>> registeredMetadata = new HashMap();
    private final Map<WorldCoord, TownBlock> townBlocks = new ConcurrentHashMap<WorldCoord, TownBlock>();
    private CompletableFuture<Void> backupFuture;
    private final Map<Block, SpawnPoint> spawnPoints = new ConcurrentHashMap<Block, SpawnPoint>();
    private final List<Resident> jailedResidents = new ArrayList<Resident>();
    private final Map<UUID, Jail> jailUUIDMap = new ConcurrentHashMap<UUID, Jail>();
    private final Map<UUID, Long> hibernatedResidentMap = new ConcurrentHashMap<UUID, Long>();
    private final Map<String, String> replacementNamesMap = new ConcurrentHashMap<String, String>();
    private final Map<UUID, PlotGroup> plotGroupUUIDMap = new ConcurrentHashMap<UUID, PlotGroup>();
    private final Map<WorldCoord, TownyMapData> wildernessMapDataMap = new ConcurrentHashMap<WorldCoord, TownyMapData>();
    private final String rootFolder;
    private TownyDataSource dataSource;
    private TownyPermissionSource permissionSource;

    private TownyUniverse() {
        this.towny = Towny.getPlugin();
        this.rootFolder = this.towny.getDataFolder().getPath();
    }

    public static TownyUniverse getInstance() {
        if (instance == null) {
            instance = new TownyUniverse();
        }
        return instance;
    }

    public void performCleanupAndBackup() {
        this.backupFuture = CompletableFuture.runAsync(new CleanupTask()).thenRunAsync(new BackupTask());
    }

    public void clearAllObjects() {
        this.worlds.clear();
        this.nationNameMap.clear();
        this.nationUUIDMap.clear();
        this.townNameMap.clear();
        this.townUUIDMap.clear();
        this.residentNameMap.clear();
        this.residentUUIDMap.clear();
        this.townBlocks.clear();
        this.spawnPoints.clear();
        this.jailUUIDMap.clear();
        this.plotGroupUUIDMap.clear();
        this.wildernessMapDataMap.clear();
        this.hibernatedResidentMap.clear();
        this.replacementNamesMap.clear();
    }

    void loadAndSaveDatabase(String loadDbType, String saveDbType) {
        this.towny.getLogger().info("Database: [Load] " + loadDbType + " [Save] " + saveDbType);
        try {
            this.loadDatabase(loadDbType);
        }
        catch (TownyInitException e) {
            throw new TownyInitException(e.getMessage(), e.getError());
        }
        try {
            this.saveDatabase(saveDbType);
        }
        catch (TownyInitException e) {
            throw new TownyInitException(e.getMessage(), e.getError());
        }
    }

    private boolean loadDatabase(String loadDbType) {
        long startTime = System.currentTimeMillis();
        switch (loadDbType.toLowerCase()) {
            case "ff": 
            case "flatfile": {
                this.dataSource = new TownyFlatFileSource(this.towny, this);
                break;
            }
            case "mysql": {
                this.dataSource = new TownySQLSource(this.towny, this);
                break;
            }
            default: {
                throw new TownyInitException("Database: Database.yml unsupported load format: " + loadDbType, TownyInitException.TownyError.DATABASE_CONFIG);
            }
        }
        if (!this.dataSource.loadAll()) {
            throw new TownyInitException("Database: Failed to load database.", TownyInitException.TownyError.DATABASE);
        }
        long time = System.currentTimeMillis() - startTime;
        this.towny.getLogger().info("Database: Loaded in " + time + "ms.");
        this.towny.getLogger().info("Database: " + TownySettings.getUUIDPercent() + " of residents have stored UUIDs.");
        Bukkit.getPluginManager().callEvent((Event)new TownyLoadedDatabaseEvent());
        return true;
    }

    private boolean saveDatabase(String saveDbType) {
        try {
            switch (saveDbType.toLowerCase()) {
                case "ff": 
                case "flatfile": {
                    this.dataSource = new TownyFlatFileSource(this.towny, this);
                    break;
                }
                case "mysql": {
                    this.dataSource = new TownySQLSource(this.towny, this);
                    break;
                }
                default: {
                    throw new TownyInitException("Database.yml contains unsupported save format: " + saveDbType, TownyInitException.TownyError.DATABASE);
                }
            }
            if (TownySettings.getLoadDatabase().equalsIgnoreCase(saveDbType)) {
                this.dataSource.saveAllWorlds();
            } else {
                this.dataSource.saveAll();
            }
            return true;
        }
        catch (UnsupportedOperationException e) {
            throw new TownyInitException("Database: Failed to save database!", TownyInitException.TownyError.DATABASE);
        }
    }

    public void finishTasks() {
        if (this.backupFuture != null) {
            this.backupFuture.join();
        }
    }

    public TownyDataSource getDataSource() {
        return this.dataSource;
    }

    public TownyPermissionSource getPermissionSource() {
        return this.permissionSource;
    }

    public void setPermissionSource(TownyPermissionSource permissionSource) {
        this.permissionSource = permissionSource;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public boolean hasResident(@NotNull String residentName) {
        String filteredName;
        Validate.notNull((Object)residentName, (String)"Resident name cannot be null!");
        if (residentName.isEmpty()) {
            return false;
        }
        if (TownySettings.isFakeResident(residentName)) {
            return true;
        }
        try {
            filteredName = NameValidation.checkAndFilterPlayerName(residentName).toLowerCase();
        }
        catch (InvalidNameException ignored) {
            return false;
        }
        return this.residentNameMap.containsKey(filteredName);
    }

    public boolean hasResident(@NotNull UUID residentUUID) {
        Validate.notNull((Object)residentUUID, (String)"Resident uuid cannot be null!");
        return this.residentUUIDMap.containsKey(residentUUID);
    }

    @Nullable
    public Resident getResident(@NotNull String residentName) {
        Validate.notNull((Object)residentName, (String)"Resident name cannot be null!");
        if (residentName.isEmpty()) {
            return null;
        }
        String filteredName = residentName;
        try {
            filteredName = NameValidation.checkAndFilterPlayerName(residentName).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        Resident res = this.residentNameMap.get(filteredName);
        if (res == null && TownySettings.isFakeResident(residentName)) {
            Resident npc = new Resident(residentName);
            npc.setNPC(true);
            return npc;
        }
        return res;
    }

    @NotNull
    public Optional<Resident> getResidentOpt(@NotNull String residentName) {
        return Optional.ofNullable(this.getResident(residentName));
    }

    @Nullable
    public Resident getResident(@NotNull UUID residentUUID) {
        Validate.notNull((Object)residentUUID, (String)"Resident uuid cannot be null!");
        return this.residentUUIDMap.get(residentUUID);
    }

    @NotNull
    public Optional<Resident> getResidentOpt(@NotNull UUID residentUUID) {
        return Optional.ofNullable(this.getResident(residentUUID));
    }

    public void registerResidentUUID(@NotNull Resident resident) throws AlreadyRegisteredException {
        Validate.notNull((Object)resident, (String)"Resident cannot be null!");
        if (resident.getUUID() != null && this.residentUUIDMap.putIfAbsent(resident.getUUID(), resident) != null) {
            throw new AlreadyRegisteredException(String.format("UUID '%s' was already registered for resident '%s'!", resident.getUUID().toString(), resident.getName()));
        }
    }

    public void registerResident(@NotNull Resident resident) throws AlreadyRegisteredException {
        Validate.notNull((Object)resident, (String)"Resident cannot be null!");
        if (this.residentNameMap.putIfAbsent(resident.getName().toLowerCase(), resident) != null) {
            throw new AlreadyRegisteredException(String.format("The resident with name '%s' is already registered!", resident.getName()));
        }
        this.residentsTrie.addKey(resident.getName());
        this.registerResidentUUID(resident);
    }

    public void unregisterResident(@NotNull Resident resident) throws NotRegisteredException {
        Validate.notNull((Object)resident, (String)"Resident cannot be null!");
        if (this.residentNameMap.remove(resident.getName().toLowerCase()) == null) {
            throw new NotRegisteredException(String.format("The resident with the name '%s' is not registered!", resident.getName()));
        }
        this.residentsTrie.removeKey(resident.getName());
        if (resident.getUUID() != null && this.residentUUIDMap.remove(resident.getUUID()) == null) {
            throw new NotRegisteredException(String.format("The resident with the UUID '%s' is not registered!", resident.getUUID().toString()));
        }
    }

    @Deprecated
    public Map<String, Resident> getResidentMap() {
        return this.residentNameMap;
    }

    @Unmodifiable
    public Collection<Resident> getResidents() {
        return Collections.unmodifiableCollection(this.residentNameMap.values());
    }

    public int getNumResidents() {
        return this.residentNameMap.size();
    }

    public Trie getResidentsTrie() {
        return this.residentsTrie;
    }

    public List<Resident> getJailedResidentMap() {
        return this.jailedResidents;
    }

    public void registerHibernatedResident(UUID uuid, long registered) {
        this.hibernatedResidentMap.put(uuid, registered);
    }

    public void unregisterHibernatedResident(UUID uuid) {
        this.hibernatedResidentMap.remove(uuid);
    }

    public boolean hasHibernatedResdient(UUID uuid) {
        return this.hibernatedResidentMap.containsKey(uuid);
    }

    public Collection<UUID> getHibernatedResidents() {
        return Collections.unmodifiableCollection(this.hibernatedResidentMap.keySet());
    }

    @Nullable
    public long getHibernatedResidentRegistered(UUID uuid) {
        return this.hibernatedResidentMap.get(uuid);
    }

    public boolean hasTown(@NotNull String townName) {
        String formattedName;
        Validate.notNull((Object)townName, (String)"Town Name cannot be null!");
        if (townName.isEmpty()) {
            return false;
        }
        try {
            formattedName = NameValidation.checkAndFilterName(townName).toLowerCase();
        }
        catch (InvalidNameException e) {
            return false;
        }
        return this.townNameMap.containsKey(formattedName);
    }

    public boolean hasTown(@NotNull UUID townUUID) {
        Validate.notNull((Object)townUUID, (String)"Town UUID cannot be null!");
        return this.townUUIDMap.containsKey(townUUID);
    }

    @Nullable
    public Town getTown(@NotNull String townName) {
        String formattedName;
        Validate.notNull((Object)townName, (String)"Town Name cannot be null!");
        if (townName.isEmpty()) {
            return null;
        }
        try {
            formattedName = NameValidation.checkAndFilterName(townName).toLowerCase();
        }
        catch (InvalidNameException e) {
            return null;
        }
        return this.townNameMap.get(formattedName);
    }

    @Nullable
    public Town getTown(UUID townUUID) {
        return this.townUUIDMap.get(townUUID);
    }

    @Unmodifiable
    public Collection<Town> getTowns() {
        return Collections.unmodifiableCollection(this.townNameMap.values());
    }

    @Deprecated
    public Map<String, Town> getTownsMap() {
        return this.townNameMap;
    }

    public Trie getTownsTrie() {
        return this.townsTrie;
    }

    public void newTownInternal(String name) throws AlreadyRegisteredException, InvalidNameException {
        this.newTown(name, false);
    }

    public void newTown(@NotNull String name) throws AlreadyRegisteredException, InvalidNameException {
        Validate.notNull((Object)name, (String)"Name cannot be null!");
        this.newTown(name, true);
    }

    private void newTown(String name, boolean assignUUID) throws AlreadyRegisteredException, InvalidNameException {
        String filteredName = NameValidation.checkAndFilterName(name);
        Town town = new Town(filteredName, assignUUID ? UUID.randomUUID() : null);
        this.registerTown(town);
    }

    public void registerTownUUID(@NotNull Town town) throws AlreadyRegisteredException {
        Validate.notNull((Object)town, (String)"Town cannot be null!");
        if (town.getUUID() != null) {
            if (this.townUUIDMap.containsKey(town.getUUID())) {
                throw new AlreadyRegisteredException("UUID of town " + town.getName() + " was already registered!");
            }
            this.townUUIDMap.put(town.getUUID(), town);
        }
    }

    public void registerTown(@NotNull Town town) throws AlreadyRegisteredException {
        Validate.notNull((Object)town, (String)"Town cannot be null!");
        if (this.townNameMap.putIfAbsent(town.getName().toLowerCase(), town) != null) {
            throw new AlreadyRegisteredException(String.format("The town with name '%s' is already registered!", town.getName()));
        }
        this.townsTrie.addKey(town.getName());
        this.registerTownUUID(town);
    }

    public void unregisterTown(@NotNull Town town) throws NotRegisteredException {
        Validate.notNull((Object)town, (String)"Town cannot be null!");
        if (this.townNameMap.remove(town.getName().toLowerCase()) == null) {
            throw new NotRegisteredException(String.format("The town with the name '%s' is not registered!", town.getName()));
        }
        this.townsTrie.removeKey(town.getName());
        if (town.getUUID() != null && this.townUUIDMap.remove(town.getUUID()) == null) {
            throw new NotRegisteredException(String.format("The town with the UUID '%s' is not registered!", town.getUUID().toString()));
        }
    }

    public boolean hasNation(@NotNull String nationName) {
        String filteredName;
        Validate.notNull((Object)nationName, (String)"Nation Name cannot be null!");
        if (nationName.isEmpty()) {
            return false;
        }
        try {
            filteredName = NameValidation.checkAndFilterName(nationName).toLowerCase();
        }
        catch (InvalidNameException ignored) {
            return false;
        }
        return this.nationNameMap.containsKey(filteredName);
    }

    public boolean hasNation(@NotNull UUID nationUUID) {
        Validate.notNull((Object)nationUUID, (String)"Nation UUID cannot be null!");
        return this.nationUUIDMap.containsKey(nationUUID);
    }

    @Nullable
    public Nation getNation(@NotNull String nationName) {
        String filteredName;
        Validate.notNull((Object)nationName, (String)"Nation Name cannot be null!");
        if (nationName.isEmpty()) {
            return null;
        }
        try {
            filteredName = NameValidation.checkAndFilterName(nationName).toLowerCase();
        }
        catch (InvalidNameException ignored) {
            return null;
        }
        return this.nationNameMap.get(filteredName);
    }

    @Nullable
    public Nation getNation(@NotNull UUID nationUUID) {
        Validate.notNull((Object)nationUUID, (String)"Nation UUID cannot be null!");
        return this.nationUUIDMap.get(nationUUID);
    }

    @Unmodifiable
    public Collection<Nation> getNations() {
        return Collections.unmodifiableCollection(this.nationNameMap.values());
    }

    public int getNumNations() {
        return this.nationNameMap.size();
    }

    public void registerNationUUID(@NotNull Nation nation) throws AlreadyRegisteredException {
        Validate.notNull((Object)nation, (String)"Nation cannot be null!");
        if (nation.getUUID() != null) {
            if (this.nationUUIDMap.containsKey(nation.getUUID())) {
                throw new AlreadyRegisteredException("UUID of nation " + nation.getName() + " was already registered!");
            }
            this.nationUUIDMap.put(nation.getUUID(), nation);
        }
    }

    public void registerNation(@NotNull Nation nation) throws AlreadyRegisteredException {
        Validate.notNull((Object)nation, (String)"Nation cannot be null!");
        if (this.nationNameMap.putIfAbsent(nation.getName().toLowerCase(), nation) != null) {
            throw new AlreadyRegisteredException(String.format("The nation with name '%s' is already registered!", nation.getName()));
        }
        this.nationsTrie.addKey(nation.getName());
        this.registerNationUUID(nation);
    }

    public void unregisterNation(@NotNull Nation nation) throws NotRegisteredException {
        Validate.notNull((Object)nation, (String)"Nation cannot be null!");
        if (this.nationNameMap.remove(nation.getName().toLowerCase()) == null) {
            throw new NotRegisteredException(String.format("The nation with the name '%s' is not registered!", nation.getName()));
        }
        this.nationsTrie.removeKey(nation.getName());
        if (nation.getUUID() != null && this.nationUUIDMap.remove(nation.getUUID()) == null) {
            throw new NotRegisteredException(String.format("The nation with the UUID '%s' is not registered!", nation.getUUID().toString()));
        }
    }

    @Deprecated
    public Map<String, Nation> getNationsMap() {
        return this.nationNameMap;
    }

    public Trie getNationsTrie() {
        return this.nationsTrie;
    }

    public Map<String, TownyWorld> getWorldMap() {
        return this.worlds;
    }

    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Universe (1)");
        if (this.towny != null) {
            out.add(this.getTreeDepth(depth + 1) + "Server (" + BukkitTools.getServer().getName() + ")");
            out.add(this.getTreeDepth(depth + 2) + "Version: " + BukkitTools.getServer().getVersion());
            out.add(this.getTreeDepth(depth + 2) + "Worlds (" + BukkitTools.getWorlds().size() + "): " + Arrays.toString(BukkitTools.getWorlds().toArray(new World[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Worlds (" + this.worlds.size() + "):");
        for (TownyWorld townyWorld : this.worlds.values()) {
            out.addAll(townyWorld.getTreeString(depth + 2));
        }
        out.add(this.getTreeDepth(depth + 1) + "Nations (" + this.nationNameMap.size() + "):");
        for (Nation nation : this.nationNameMap.values()) {
            out.addAll(nation.getTreeString(depth + 2));
        }
        List<Town> townsWithoutNation = this.dataSource.getTownsWithoutNation();
        out.add(this.getTreeDepth(depth + 1) + "Towns (" + townsWithoutNation.size() + "):");
        for (Town town : townsWithoutNation) {
            out.addAll(town.getTreeString(depth + 2));
        }
        List<Resident> list = this.dataSource.getResidentsWithoutTown();
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + list.size() + "):");
        for (Resident resident : list) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    private String getTreeDepth(int depth) {
        char[] fill = new char[depth * 4];
        Arrays.fill(fill, ' ');
        if (depth > 0) {
            fill[0] = 124;
            int offset = (depth - 1) * 4;
            fill[offset] = 43;
            fill[offset + 1] = 45;
            fill[offset + 2] = 45;
        }
        return new String(fill);
    }

    public void newPlotGroupInternal(String uuid) {
        PlotGroup group = new PlotGroup(UUID.fromString(uuid), null, null);
        this.registerGroup(group);
    }

    public void registerGroup(PlotGroup group) {
        this.plotGroupUUIDMap.put(group.getID(), group);
    }

    public void unregisterGroup(PlotGroup group) {
        group.getTown().removePlotGroup(group);
        this.plotGroupUUIDMap.remove(group.getID());
    }

    public Collection<PlotGroup> getGroups() {
        return new ArrayList<PlotGroup>(this.plotGroupUUIDMap.values());
    }

    @Nullable
    public PlotGroup getGroup(UUID groupID) {
        return this.plotGroupUUIDMap.get(groupID);
    }

    @Deprecated
    public PlotGroup newGroup(Town town, String name, UUID id) throws AlreadyRegisteredException {
        PlotGroup newGroup = new PlotGroup(id, name, town);
        if (town.hasPlotGroupName(newGroup.getName())) {
            throw new AlreadyRegisteredException("group " + town.getName() + ":" + id + " already exists");
        }
        town.addPlotGroup(newGroup);
        return newGroup;
    }

    @Deprecated
    public boolean hasGroup(String townName, UUID groupID) {
        Town t = this.townNameMap.get(townName);
        if (t != null) {
            return t.getObjectGroupFromID(groupID) != null;
        }
        return false;
    }

    @Deprecated
    public boolean hasGroup(String townName, String groupName) {
        Town t = this.townNameMap.get(townName);
        if (t != null) {
            return t.hasPlotGroupName(groupName);
        }
        return false;
    }

    @Deprecated
    public PlotGroup getGroup(String townName, String groupName) {
        Town t = this.townNameMap.get(townName);
        if (t != null) {
            return t.getPlotObjectGroupFromName(groupName);
        }
        return null;
    }

    public void addCustomCustomDataField(CustomDataField<?> cdf) throws KeyAlreadyRegisteredException {
        if (this.getRegisteredMetadataMap().containsKey(cdf.getKey())) {
            throw new KeyAlreadyRegisteredException();
        }
        this.getRegisteredMetadataMap().put(cdf.getKey(), cdf);
    }

    public Map<String, CustomDataField<?>> getRegisteredMetadataMap() {
        return this.getRegisteredMetadata();
    }

    public Map<String, CustomDataField<?>> getRegisteredMetadata() {
        return this.registeredMetadata;
    }

    public TownBlock getTownBlock(WorldCoord worldCoord) throws NotRegisteredException {
        if (this.hasTownBlock(worldCoord)) {
            return this.townBlocks.get(worldCoord);
        }
        throw new NotRegisteredException();
    }

    @Nullable
    public TownBlock getTownBlockOrNull(WorldCoord worldCoord) {
        return this.townBlocks.get(worldCoord);
    }

    public Map<WorldCoord, TownBlock> getTownBlocks() {
        return this.townBlocks;
    }

    public void addTownBlock(TownBlock townBlock) {
        if (this.hasTownBlock(townBlock.getWorldCoord())) {
            return;
        }
        this.townBlocks.put(townBlock.getWorldCoord(), townBlock);
    }

    public boolean hasTownBlock(WorldCoord worldCoord) {
        return this.townBlocks.containsKey(worldCoord);
    }

    public void removeTownBlock(TownBlock townBlock) {
        if (this.removeTownBlock(townBlock.getWorldCoord())) {
            if (townBlock.hasResident()) {
                townBlock.getResidentOrNull().removeTownBlock(townBlock);
            }
            if (townBlock.hasTown()) {
                townBlock.getTownOrNull().removeTownBlock(townBlock);
            }
        }
    }

    public void removeTownBlocks(List<TownBlock> townBlocks) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(townBlocks)) {
            this.removeTownBlock(townBlock);
        }
    }

    private boolean removeTownBlock(WorldCoord worldCoord) {
        return this.townBlocks.remove(worldCoord) != null;
    }

    public Map<Block, SpawnPoint> getSpawnPoints() {
        return this.spawnPoints;
    }

    public SpawnPoint getSpawnPoint(Location loc) {
        return this.spawnPoints.get(loc.getBlock());
    }

    public boolean hasSpawnPoint(Location loc) {
        return this.spawnPoints.containsKey(loc.getBlock());
    }

    public void addSpawnPoint(SpawnPoint spawn) {
        this.spawnPoints.put(spawn.getBukkitLocation().getBlock(), spawn);
    }

    public void removeSpawnPoint(Location loc) {
        if (this.hasSpawnPoint(loc)) {
            this.spawnPoints.remove(loc.getBlock());
        }
    }

    public Map<UUID, Jail> getJailUUIDMap() {
        return this.jailUUIDMap;
    }

    @Nullable
    public Jail getJail(UUID uuid) {
        if (this.hasJail(uuid)) {
            return this.jailUUIDMap.get(uuid);
        }
        return null;
    }

    public boolean hasJail(UUID uuid) {
        return this.jailUUIDMap.containsKey(uuid);
    }

    public void registerJail(Jail jail) {
        this.jailUUIDMap.put(jail.getUUID(), jail);
    }

    public void unregisterJail(Jail jail) {
        this.jailUUIDMap.remove(jail.getUUID());
    }

    public void newJailInternal(String uuid) {
        Jail jail = new Jail(UUID.fromString(uuid), null, null, null);
        this.registerJail(jail);
    }

    public Map<WorldCoord, TownyMapData> getWildernessMapDataMap() {
        return this.wildernessMapDataMap;
    }

    public Map<String, String> getReplacementNameMap() {
        return this.replacementNamesMap;
    }

    @Deprecated
    public String getSaveDbType() {
        return TownySettings.getSaveDatabase();
    }

    @Deprecated
    public String getLoadDbType() {
        return TownySettings.getLoadDatabase();
    }
}

