/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.DatabaseConfig;
import com.palmergames.bukkit.towny.event.NationBonusCalculationEvent;
import com.palmergames.bukkit.towny.event.NationUpkeepCalculationEvent;
import com.palmergames.bukkit.towny.event.TownUpkeepCalculationEvent;
import com.palmergames.bukkit.towny.event.TownUpkeepPenalityCalculationEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.NationSpawnLevel;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownSpawnLevel;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.ItemLists;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class TownySettings {
    private static CommentedConfiguration config;
    private static CommentedConfiguration newConfig;
    private static int uuidCount;
    private static final SortedMap<Integer, Map<TownLevel, Object>> configTownLevel;
    private static final SortedMap<Integer, Map<NationLevel, Object>> configNationLevel;
    private static final List<String> ItemUseMaterials;
    private static final List<String> SwitchUseMaterials;
    private static final List<Class<?>> protectedMobs;

    public static void newTownLevel(int numResidents, String namePrefix, String namePostfix, String mayorPrefix, String mayorPostfix, int townBlockLimit, double townUpkeepMultiplier, int townOutpostLimit, int townBlockBuyBonusLimit, double debtCapModifier) {
        ConcurrentHashMap<TownLevel, Object> m = new ConcurrentHashMap<TownLevel, Object>();
        m.put(TownLevel.NAME_PREFIX, namePrefix);
        m.put(TownLevel.NAME_POSTFIX, namePostfix);
        m.put(TownLevel.MAYOR_PREFIX, mayorPrefix);
        m.put(TownLevel.MAYOR_POSTFIX, mayorPostfix);
        m.put(TownLevel.TOWN_BLOCK_LIMIT, townBlockLimit);
        m.put(TownLevel.UPKEEP_MULTIPLIER, townUpkeepMultiplier);
        m.put(TownLevel.OUTPOST_LIMIT, townOutpostLimit);
        m.put(TownLevel.TOWN_BLOCK_BUY_BONUS_LIMIT, townBlockBuyBonusLimit);
        m.put(TownLevel.DEBT_CAP_MODIFIER, debtCapModifier);
        configTownLevel.put(numResidents, m);
    }

    public static void newNationLevel(int numResidents, String namePrefix, String namePostfix, String capitalPrefix, String capitalPostfix, String kingPrefix, String kingPostfix, int townBlockLimitBonus, double nationUpkeepMultiplier, double nationTownUpkeepMultiplier, int nationZonesSize, int nationBonusOutpostLimit) {
        ConcurrentHashMap<NationLevel, Object> m = new ConcurrentHashMap<NationLevel, Object>();
        m.put(NationLevel.NAME_PREFIX, namePrefix);
        m.put(NationLevel.NAME_POSTFIX, namePostfix);
        m.put(NationLevel.CAPITAL_PREFIX, capitalPrefix);
        m.put(NationLevel.CAPITAL_POSTFIX, capitalPostfix);
        m.put(NationLevel.KING_PREFIX, kingPrefix);
        m.put(NationLevel.KING_POSTFIX, kingPostfix);
        m.put(NationLevel.TOWN_BLOCK_LIMIT_BONUS, townBlockLimitBonus);
        m.put(NationLevel.UPKEEP_MULTIPLIER, nationUpkeepMultiplier);
        m.put(NationLevel.NATION_TOWN_UPKEEP_MULTIPLIER, nationTownUpkeepMultiplier);
        m.put(NationLevel.NATIONZONES_SIZE, nationZonesSize);
        m.put(NationLevel.NATION_BONUS_OUTPOST_LIMIT, nationBonusOutpostLimit);
        configNationLevel.put(numResidents, m);
    }

    public static void loadTownLevelConfig() throws IOException {
        TownySettings.newTownLevel(0, "", " Ruins", "Spirit", "", 1, 1.0, 0, 0, 1.0);
        List levels = config.getMapList("levels.town_level");
        for (Map level : levels) {
            try {
                TownySettings.newTownLevel(Integer.parseInt(level.get("numResidents").toString()), String.valueOf(level.get("namePrefix")), String.valueOf(level.get("namePostfix")), String.valueOf(level.get("mayorPrefix")), String.valueOf(level.get("mayorPostfix")), Integer.parseInt(level.get("townBlockLimit").toString()), Double.parseDouble(level.get("upkeepModifier").toString()), Integer.parseInt(level.get("townOutpostLimit").toString()), Integer.parseInt(level.get("townBlockBuyBonusLimit").toString()), Double.parseDouble(level.get("debtCapModifier").toString()));
            }
            catch (NullPointerException e) {
                Towny.getPlugin().getLogger().warning("Your Towny config.yml's town_level section is out of date.");
                Towny.getPlugin().getLogger().warning("This can be fixed automatically by deleting the town_level section and letting Towny remake it on the next startup.");
                throw new IOException("Config.yml town_levels incomplete.");
            }
        }
    }

    public static void loadNationLevelConfig() throws IOException {
        TownySettings.newNationLevel(0, "Land of ", " (Nation)", "", "", "Leader ", "", 10, 1.0, 1.0, 1, 0);
        List levels = config.getMapList("levels.nation_level");
        for (Map level : levels) {
            try {
                TownySettings.newNationLevel(Integer.parseInt(level.get("numResidents").toString()), String.valueOf(level.get("namePrefix")), String.valueOf(level.get("namePostfix")), String.valueOf(level.get("capitalPrefix")), String.valueOf(level.get("capitalPostfix")), String.valueOf(level.get("kingPrefix")), String.valueOf(level.get("kingPostfix")), Integer.parseInt(level.get("townBlockLimitBonus").toString()), Double.parseDouble(level.get("upkeepModifier").toString()), Double.parseDouble(level.get("nationTownUpkeepModifier").toString()), Integer.parseInt(level.get("nationZonesSize").toString()), Integer.parseInt(level.get("nationBonusOutpostLimit").toString()));
            }
            catch (Exception e) {
                Towny.getPlugin().getLogger().warning("Your Towny config.yml's nation_level section is out of date.");
                Towny.getPlugin().getLogger().warning("This can be fixed automatically by deleting the nation_level section and letting Towny remake it on the next startup.");
                throw new IOException("Config.yml nation_levels incomplete.");
            }
        }
    }

    public static Map<TownLevel, Object> getTownLevel(int numResidents) {
        return (Map)configTownLevel.get(numResidents);
    }

    public static Map<NationLevel, Object> getNationLevel(int numResidents) {
        return (Map)configNationLevel.get(numResidents);
    }

    public static Map<TownLevel, Object> getTownLevel(Town town) {
        return TownySettings.getTownLevel(TownySettings.calcTownLevel(town));
    }

    public static Map<TownLevel, Object> getTownLevel(Town town, int residents) {
        return TownySettings.getTownLevel(TownySettings.calcTownLevel(town, residents));
    }

    public static Map<NationLevel, Object> getNationLevel(Nation nation) {
        return TownySettings.getNationLevel(TownySettings.calcNationLevel(nation));
    }

    public static CommentedConfiguration getConfig() {
        return config;
    }

    public static int calcTownLevel(Town town) {
        if (town.isRuined()) {
            return 0;
        }
        int n = town.getNumResidents();
        for (Integer level : configTownLevel.keySet()) {
            if (n < level) continue;
            return level;
        }
        return 0;
    }

    public static int calcTownLevel(Town town, int residents) {
        if (town.isRuined()) {
            return 0;
        }
        for (int level : configTownLevel.keySet()) {
            if (residents < level) continue;
            return level;
        }
        return 0;
    }

    public static int calcTownLevelId(Town town) {
        if (town.isRuined()) {
            return 0;
        }
        int townLevelId = -1;
        int numResidents = town.getNumResidents();
        for (Integer level : configTownLevel.keySet()) {
            if (level > numResidents) continue;
            ++townLevelId;
        }
        return townLevelId;
    }

    public static int calcNationLevel(Nation nation) {
        int n = nation.getNumResidents();
        for (Integer level : configNationLevel.keySet()) {
            if (n < level) continue;
            return level;
        }
        return 0;
    }

    public static void loadConfig(Path configPath, String version) {
        if (!FileMgmt.checkOrCreateFile(configPath.toString())) {
            throw new TownyInitException("Failed to touch '" + configPath + "'.", TownyInitException.TownyError.MAIN_CONFIG);
        }
        config = new CommentedConfiguration(configPath);
        if (!config.load()) {
            throw new TownyInitException("Failed to load Towny's config.yml.", TownyInitException.TownyError.MAIN_CONFIG);
        }
        TownySettings.setDefaults(version, configPath);
        config.save();
        TownySettings.loadSwitchAndItemUseMaterialsLists();
        TownySettings.loadProtectedMobsList();
        ChunkNotification.loadFormatStrings();
    }

    private static void loadProtectedMobsList() {
        protectedMobs.clear();
        protectedMobs.addAll(EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getStrArr(ConfigNodes.PROT_MOB_TYPES), "TownMobPVM:"));
    }

    private static void loadSwitchAndItemUseMaterialsLists() {
        SwitchUseMaterials.clear();
        ItemUseMaterials.clear();
        List<String> switches = TownySettings.getStrArr(ConfigNodes.PROT_SWITCH_MAT);
        for (String matName : switches) {
            if (ItemLists.GROUPS.contains(matName)) {
                List<String> group = ItemLists.getGrouping(matName);
                SwitchUseMaterials.addAll(group);
                continue;
            }
            SwitchUseMaterials.add(matName);
        }
        List<String> items = TownySettings.getStrArr(ConfigNodes.PROT_ITEM_USE_MAT);
        for (String matName : items) {
            if (ItemLists.GROUPS.contains(matName)) {
                List<String> group = ItemLists.getGrouping(matName);
                ItemUseMaterials.addAll(group);
                continue;
            }
            ItemUseMaterials.add(matName);
        }
    }

    public static void sendError(String msg) {
        Towny.getPlugin().getLogger().warning("Error could not read " + msg);
    }

    public static TownSpawnLevel.SpawnLevel getSpawnLevel(ConfigNodes node) {
        TownSpawnLevel.SpawnLevel level = TownSpawnLevel.SpawnLevel.valueOf(config.getString(node.getRoot()).toUpperCase());
        if (level == null) {
            level = TownSpawnLevel.SpawnLevel.valueOf(node.getDefault().toUpperCase());
        }
        return level;
    }

    public static NationSpawnLevel.NSpawnLevel getNSpawnLevel(ConfigNodes node) {
        NationSpawnLevel.NSpawnLevel level = NationSpawnLevel.NSpawnLevel.valueOf(config.getString(node.getRoot()).toUpperCase());
        if (level == null) {
            level = NationSpawnLevel.NSpawnLevel.valueOf(node.getDefault().toUpperCase());
        }
        return level;
    }

    public static boolean getBoolean(ConfigNodes node) {
        return Boolean.parseBoolean(config.getString(node.getRoot().toLowerCase(), node.getDefault()));
    }

    public static double getDouble(ConfigNodes node) {
        try {
            return Double.parseDouble(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 0.0;
        }
    }

    public static int getInt(ConfigNodes node) {
        try {
            return Integer.parseInt(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 0;
        }
    }

    public static String getString(ConfigNodes node) {
        return config.getString(node.getRoot().toLowerCase(), node.getDefault());
    }

    public static String getString(String root, String def) {
        String data = config.getString(root.toLowerCase(), def);
        if (data == null) {
            TownySettings.sendError(root.toLowerCase() + " from config.yml");
            return "";
        }
        return data;
    }

    @Deprecated
    public static String getLangString(String root) {
        String data = Translation.of(root);
        if (data == null) {
            TownySettings.sendError(root.toLowerCase() + " from " + config.getString("language"));
            return "";
        }
        return StringMgmt.translateHexColors(Colors.translateColorCodes(data));
    }

    public static List<Integer> getIntArr(ConfigNodes node) {
        String[] strArray = TownySettings.getString(node.getRoot(), node.getDefault()).split(",");
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (strArray != null) {
            for (String aStrArray : strArray) {
                if (aStrArray == null) continue;
                try {
                    list.add(Integer.parseInt(aStrArray.trim()));
                }
                catch (NumberFormatException e) {
                    TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
                }
            }
        }
        return list;
    }

    public static List<String> getStrArr(ConfigNodes node) {
        String[] strArray = TownySettings.getString(node.getRoot().toLowerCase(), node.getDefault()).split(",");
        ArrayList<String> list = new ArrayList<String>();
        if (strArray != null) {
            for (String aStrArray : strArray) {
                if (aStrArray == null) continue;
                list.add(aStrArray.trim());
            }
        }
        return list;
    }

    public static long getSeconds(ConfigNodes node) {
        try {
            return TimeTools.getSeconds(TownySettings.getString(node));
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 1L;
        }
    }

    public static void addComment(String root, String ... comments) {
        newConfig.addComment(root.toLowerCase(), comments);
    }

    private static void setDefaults(String version, Path configPath) {
        newConfig = new CommentedConfiguration(configPath);
        newConfig.load();
        for (ConfigNodes root : ConfigNodes.values()) {
            if (root.getComments().length > 0) {
                TownySettings.addComment(root.getRoot(), root.getComments());
            }
            if (root.getRoot().equals(ConfigNodes.LEVELS.getRoot())) {
                TownySettings.setDefaultLevels();
                continue;
            }
            if (root.getRoot().equals(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot()) || root.getRoot().equals(ConfigNodes.LEVELS_NATION_LEVEL.getRoot())) continue;
            if (root.getRoot().equals(ConfigNodes.VERSION.getRoot())) {
                TownySettings.setNewProperty(root.getRoot(), version);
                continue;
            }
            if (root.getRoot().equals(ConfigNodes.LAST_RUN_VERSION.getRoot())) {
                TownySettings.setNewProperty(root.getRoot(), TownySettings.getLastRunVersion(version));
                continue;
            }
            TownySettings.setNewProperty(root.getRoot(), config.get(root.getRoot().toLowerCase()) != null ? config.get(root.getRoot().toLowerCase()) : root.getDefault());
        }
        config = newConfig;
        newConfig = null;
    }

    private static void setDefaultLevels() {
        HashMap<String, Object> level;
        ArrayList levels;
        TownySettings.addComment(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), "# default Town levels.");
        if (!config.contains(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot())) {
            levels = new ArrayList();
            level = new HashMap<String, Object>();
            level.put("numResidents", 0);
            level.put("namePrefix", "");
            level.put("namePostfix", " Ruins");
            level.put("mayorPrefix", "Spirit ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 1);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 0);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 1);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Settlement)");
            level.put("mayorPrefix", "Hermit ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 16);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 0);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 2);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Hamlet)");
            level.put("mayorPrefix", "Chief ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 32);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 1);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 6);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Village)");
            level.put("mayorPrefix", "Baron Von ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 96);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 1);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 10);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Town)");
            level.put("mayorPrefix", "Viscount ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 160);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 2);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 14);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Large Town)");
            level.put("mayorPrefix", "Count Von ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 224);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 2);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 20);
            level.put("namePrefix", "");
            level.put("namePostfix", " (City)");
            level.put("mayorPrefix", "Earl ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 320);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 3);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 24);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Large City)");
            level.put("mayorPrefix", "Duke ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 384);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 3);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 28);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Metropolis)");
            level.put("mayorPrefix", "Lord ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 448);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 4);
            level.put("townBlockBuyBonusLimit", 0);
            level.put("debtCapModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), levels);
        } else {
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot()));
        }
        TownySettings.addComment(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), "# default Nation levels.");
        if (!config.contains(ConfigNodes.LEVELS_NATION_LEVEL.getRoot())) {
            levels = new ArrayList();
            level = new HashMap();
            level.put("numResidents", 0);
            level.put("namePrefix", "Land of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Leader ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 10);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 1);
            level.put("nationBonusOutpostLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 10);
            level.put("namePrefix", "Federation of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Count ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 20);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 1);
            level.put("nationBonusOutpostLimit", 1);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 20);
            level.put("namePrefix", "Dominion of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Duke ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 40);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 1);
            level.put("nationBonusOutpostLimit", 2);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 30);
            level.put("namePrefix", "Kingdom of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "King ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 60);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 2);
            level.put("nationBonusOutpostLimit", 3);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 40);
            level.put("namePrefix", "The ");
            level.put("namePostfix", " Empire");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Emperor ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 100);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 2);
            level.put("nationBonusOutpostLimit", 4);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 60);
            level.put("namePrefix", "The ");
            level.put("namePostfix", " Realm");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "God Emperor ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 140);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 3);
            level.put("nationBonusOutpostLimit", 5);
            levels.add(new HashMap(level));
            level.clear();
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), levels);
        } else {
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_NATION_LEVEL.getRoot()));
        }
    }

    public static String getKingPrefix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getKingPrefix.");
            return "";
        }
    }

    public static String getMayorPrefix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getMayorPrefix.");
            return "";
        }
    }

    public static String getCapitalPostfix(Town town) {
        try {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)((String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_POSTFIX)));
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getCapitalPostfix.");
            return "";
        }
    }

    public static String getTownPostfix(Town town) {
        try {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)((String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_POSTFIX)));
        }
        catch (Exception e) {
            TownySettings.sendError("getTownPostfix.");
            return "";
        }
    }

    public static String getNationPostfix(Nation nation) {
        try {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)((String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_POSTFIX)));
        }
        catch (Exception e) {
            TownySettings.sendError("getNationPostfix.");
            return "";
        }
    }

    public static String getNationPrefix(Nation nation) {
        try {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)((String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_PREFIX)));
        }
        catch (Exception e) {
            TownySettings.sendError("getNationPrefix.");
            return "";
        }
    }

    public static String getTownPrefix(Town town) {
        try {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)((String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_PREFIX)));
        }
        catch (Exception e) {
            TownySettings.sendError("getTownPrefix.");
            return "";
        }
    }

    public static String getCapitalPrefix(Town town) {
        try {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)((String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_PREFIX)));
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getCapitalPrefix.");
            return "";
        }
    }

    public static String getKingPostfix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getKingPostfix.");
            return "";
        }
    }

    public static String getMayorPostfix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getMayorPostfix.");
            return "";
        }
    }

    public static String getNPCPrefix() {
        return TownySettings.getString(ConfigNodes.FILTERS_NPC_PREFIX.getRoot(), ConfigNodes.FILTERS_NPC_PREFIX.getDefault());
    }

    public static boolean getBedUse() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DENY_BED_USE);
    }

    public static String getLoadDatabase() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_LOAD);
    }

    public static String getSaveDatabase() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_SAVE);
    }

    public static String getSQLHostName() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_HOSTNAME);
    }

    public static String getSQLPort() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_PORT);
    }

    public static String getSQLDBName() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_DBNAME);
    }

    public static String getSQLTablePrefix() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_TABLEPREFIX);
    }

    public static String getSQLUsername() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_USERNAME);
    }

    public static String getSQLPassword() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_PASSWORD);
    }

    public static String getSQLFlags() {
        return DatabaseConfig.getString(DatabaseConfig.DATABASE_FLAGS);
    }

    public static int getMaxPoolSize() {
        return DatabaseConfig.getInt(DatabaseConfig.DATABASE_POOLING_MAX_POOL_SIZE);
    }

    public static int getMaxLifetime() {
        return DatabaseConfig.getInt(DatabaseConfig.DATABASE_POOLING_MAX_LIFETIME);
    }

    public static int getConnectionTimeout() {
        return DatabaseConfig.getInt(DatabaseConfig.DATABASE_POOLING_CONNECTION_TIMEOUT);
    }

    public static int getMaxTownBlocks(Town town) {
        int ratio = TownySettings.getTownBlockRatio();
        int n = town.getBonusBlocks() + town.getPurchasedBlocks();
        n = ratio == 0 ? (n += ((Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.TOWN_BLOCK_LIMIT)).intValue()) : (n += town.getNumResidents() * ratio);
        n += TownySettings.getNationBonusBlocks(town);
        int ratioSizeLimit = TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_LIMIT);
        if (ratio != 0 && ratioSizeLimit > 0) {
            n = Math.min(ratioSizeLimit, n);
        }
        return n;
    }

    public static int getMaxTownBlocks(Town town, int residents) {
        int ratio = TownySettings.getTownBlockRatio();
        int amount = town.getBonusBlocks() + town.getPurchasedBlocks();
        amount = ratio == 0 ? (amount += ((Integer)TownySettings.getTownLevel(town, residents).get((Object)TownLevel.TOWN_BLOCK_LIMIT)).intValue()) : (amount += residents * ratio);
        return amount += TownySettings.getNationBonusBlocks(town);
    }

    public static int getMaxOutposts(Town town) {
        int townOutposts = (Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.OUTPOST_LIMIT);
        int nationOutposts = 0;
        if (town.hasNation()) {
            nationOutposts = (Integer)TownySettings.getNationLevel(town.getNationOrNull()).get((Object)NationLevel.NATION_BONUS_OUTPOST_LIMIT);
        }
        int n = townOutposts + nationOutposts;
        return n;
    }

    public static int getMaxBonusBlocks(Town town) {
        return (Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.TOWN_BLOCK_BUY_BONUS_LIMIT);
    }

    public static int getNationBonusBlocks(Nation nation) {
        int bonusBlocks = (Integer)TownySettings.getNationLevel(nation).get((Object)NationLevel.TOWN_BLOCK_LIMIT_BONUS);
        NationBonusCalculationEvent calculationEvent = new NationBonusCalculationEvent(nation, bonusBlocks);
        Bukkit.getPluginManager().callEvent((Event)calculationEvent);
        return calculationEvent.getBonusBlocks();
    }

    public static int getNationBonusBlocks(Town town) {
        if (town.hasNation()) {
            return TownySettings.getNationBonusBlocks(town.getNationOrNull());
        }
        return 0;
    }

    public static int getTownBlockRatio() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_RATIO);
    }

    public static int getTownBlockSize() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_SIZE);
    }

    public static boolean isFriendlyFireEnabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FRIENDLY_FIRE_ENABLED);
    }

    public static boolean isUsingEconomy() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ECONOMY);
    }

    public static boolean isFakeResident(String name) {
        return StringMgmt.containsIgnoreCase(TownySettings.getStrArr(ConfigNodes.PLUGIN_MODS_FAKE_RESIDENTS), name);
    }

    public static boolean isUsingEssentials() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ESSENTIALS);
    }

    public static void setUsingEssentials(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_ESSENTIALS.getRoot(), newSetting);
    }

    public static double getNewTownPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_TOWN);
    }

    public static double getNewNationPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_NATION);
    }

    public static boolean getUnclaimedZoneBuildRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_BUILD);
    }

    public static boolean getUnclaimedZoneDestroyRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_DESTROY);
    }

    public static boolean getUnclaimedZoneItemUseRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_ITEM_USE);
    }

    public static boolean getDebug() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEBUG_MODE);
    }

    public static String getTool() {
        return TownySettings.getString(ConfigNodes.PLUGIN_INFO_TOOL);
    }

    public static void setDebug(boolean b) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEBUG_MODE.getRoot(), b);
    }

    public static boolean getShowTownNotifications() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_SHOW_TOWN_NOTIFICATIONS);
    }

    public static boolean isNotificationOwnerShowingNationTitles() {
        return TownySettings.getBoolean(ConfigNodes.NOTIFICATION_OWNER_SHOWS_NATION_TITLE);
    }

    public static boolean isNotificationsAppearingInActionBar() {
        return TownySettings.getBoolean(ConfigNodes.NOTIFICATION_NOTIFICATIONS_APPEAR_IN_ACTION_BAR);
    }

    public static boolean getShowTownBoardOnLogin() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_DISPLAY_TOWNBOARD_ONLOGIN);
    }

    public static boolean getShowNationBoardOnLogin() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_DISPLAY_NATIONBOARD_ONLOGIN);
    }

    public static boolean nationCapitalsCantBeNeutral() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_CAPITAL_CANNOT_BE_NEUTRAL);
    }

    public static String getUnclaimedZoneName() {
        return Translation.of("UNCLAIMED_ZONE_NAME");
    }

    public static int getMaxTitleLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MODIFY_CHAT_MAX_LGTH);
    }

    public static int getMaxNameLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MAX_NAME_LGTH);
    }

    public static long getDeleteTime() {
        return TownySettings.getSeconds(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_TIME);
    }

    public static boolean isDeleteEcoAccount() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ECO);
    }

    public static boolean isDeleteTownlessOnly() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_TOWNLESS_ONLY);
    }

    public static boolean isDeletingOldResidents() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ENABLE);
    }

    public static String getDefaultTownName() {
        return TownySettings.getString(ConfigNodes.RES_SETTING_DEFAULT_TOWN_NAME);
    }

    public static List<String> getWorldMobRemovalEntities() {
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_WORLD);
    }

    public static List<String> getWildernessMobRemovalEntities() {
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_WILDERNESS);
    }

    public static List<String> getTownMobRemovalEntities() {
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_TOWN);
    }

    public static boolean isEconomyAsync() {
        return TownySettings.getBoolean(ConfigNodes.ECO_USE_ASYNC);
    }

    public static long getCachedBankTimeout() {
        return TownySettings.getSeconds(ConfigNodes.ECO_BANK_CACHE_TIMEOUT) * 1000L;
    }

    public static boolean isRemovingVillagerBabiesWorld() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_VILLAGER_BABIES_WORLD);
    }

    public static boolean isCreatureTriggeringPressurePlateDisabled() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_DISABLE_TRIGGER_PRESSURE_PLATE_STONE);
    }

    public static boolean isRemovingVillagerBabiesTown() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_VILLAGER_BABIES_TOWN);
    }

    public static List<String> getWildExplosionProtectionEntities() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_ENTITY_REVERT_LIST);
    }

    public static List<String> getWildExplosionRevertBlockWhitelist() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_REVERT_BLOCK_WHITELIST);
    }

    public static List<String> getWildExplosionProtectionBlocks() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_BLOCK_REVERT_LIST);
    }

    public static long getMobRemovalSpeed() {
        return TownySettings.getSeconds(ConfigNodes.PROT_MOB_REMOVE_SPEED);
    }

    public static long getHealthRegenSpeed() {
        return TownySettings.getSeconds(ConfigNodes.GTOWN_SETTINGS_REGEN_SPEED);
    }

    public static boolean hasHealthRegen() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_REGEN_ENABLE);
    }

    public static boolean getTownDefaultPublic() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_PUBLIC);
    }

    public static boolean getTownDefaultOpen() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_OPEN);
    }

    public static boolean getTownDefaultNeutral() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_NEUTRAL);
    }

    public static String getTownDefaultBoard() {
        return TownySettings.getString(ConfigNodes.TOWN_DEF_BOARD);
    }

    public static boolean getNationDefaultOpen() {
        return TownySettings.getBoolean(ConfigNodes.NATION_DEF_OPEN);
    }

    public static boolean isNationTagSetAutomatically() {
        return TownySettings.getBoolean(ConfigNodes.NATION_DEF_TAG);
    }

    public static boolean isTownTagSetAutomatically() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_TAG);
    }

    public static double getTownDefaultTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_TAX);
    }

    public static double getTownDefaultShopTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_SHOP_TAX);
    }

    public static double getTownDefaultEmbassyTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_EMBASSY_TAX);
    }

    public static double getTownDefaultPlotTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_PLOT_TAX);
    }

    public static boolean doesPlotTaxNonPaymentSetPlotForSale() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_TAXES_PLOT_TAX_PUTS_PLOT_FOR_SALE);
    }

    public static boolean getTownDefaultTaxPercentage() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_TAXES_TAXPERCENTAGE);
    }

    public static double getTownDefaultTaxMinimumTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_MINIMUMTAX);
    }

    public static boolean hasTownLimit() {
        return TownySettings.getTownLimit() != 0;
    }

    public static int getTownLimit() {
        return TownySettings.getInt(ConfigNodes.TOWN_LIMIT);
    }

    public static int getMaxPurchasedBlocks(Town town) {
        if (TownySettings.isBonusBlocksPerTownLevel()) {
            return TownySettings.getMaxBonusBlocks(town);
        }
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_PURCHASED_BLOCKS);
    }

    @Deprecated
    public static int getMaxPurchedBlocks(Town town) {
        return TownySettings.getMaxPurchasedBlocks(town);
    }

    public static int getMaxPurchasedBlocksNode() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_PURCHASED_BLOCKS);
    }

    public static int getMaxClaimRadiusValue() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_CLAIM_RADIUS_VALUE);
    }

    public static boolean isSellingBonusBlocks(Town town) {
        return TownySettings.getMaxPurchasedBlocks(town) != 0;
    }

    public static boolean isBonusBlocksPerTownLevel() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_MAX_PURCHASED_BLOCKS_USES_TOWN_LEVELS);
    }

    public static double getPurchasedBonusBlocksCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_PURCHASED_BONUS_TOWNBLOCK);
    }

    public static double getPurchasedBonusBlocksIncreaseValue() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_PURCHASED_BONUS_TOWNBLOCK_INCREASE);
    }

    public static double getPurchasedBonusBlocksMaxPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_PURCHASED_BONUS_TOWNBLOCKS_MAXIMUM);
    }

    public static boolean isTownSpawnPaidToTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_SPAWN_PAID_TO_TOWN);
    }

    public static double getNationNeutralityCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_NEUTRALITY);
    }

    public static double getTownNeutralityCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_NEUTRALITY);
    }

    public static boolean isAllowingOutposts() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_OUTPOSTS);
    }

    public static boolean isOutpostsLimitedByLevels() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_LIMIT_OUTPOST_USING_LEVELS);
    }

    public static boolean isOutpostLimitStoppingTeleports() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_OVER_OUTPOST_LIMIT_STOP_TELEPORT);
    }

    public static double getOutpostCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_OUTPOST);
    }

    public static List<String> getSwitchMaterials() {
        return SwitchUseMaterials;
    }

    public static List<String> getItemUseMaterials() {
        return ItemUseMaterials;
    }

    public static boolean isSwitchMaterial(String mat) {
        return SwitchUseMaterials.contains(mat);
    }

    public static boolean isItemUseMaterial(String mat) {
        return ItemUseMaterials.contains(mat);
    }

    public static List<String> getFireSpreadBypassMaterials() {
        return TownySettings.getStrArr(ConfigNodes.PROT_FIRE_SPREAD_BYPASS);
    }

    public static boolean isFireSpreadBypassMaterial(String mat) {
        return TownySettings.getFireSpreadBypassMaterials().contains(mat);
    }

    public static List<String> getUnclaimedZoneIgnoreMaterials() {
        return TownySettings.getStrArr(ConfigNodes.UNCLAIMED_ZONE_IGNORE);
    }

    public static List<Class<?>> getProtectedEntityTypes() {
        return protectedMobs;
    }

    public static List<String> getPotionTypes() {
        return TownySettings.getStrArr(ConfigNodes.PROT_POTION_TYPES);
    }

    public static void setProperty(String root, Object value) {
        config.set(root.toLowerCase(), value.toString());
    }

    private static void setNewProperty(String root, Object value) {
        if (value == null) {
            value = "";
        }
        newConfig.set(root.toLowerCase(), value.toString());
    }

    public static void setLanguage(String lang) {
        config.set(ConfigNodes.LANGUAGE.getRoot(), lang);
        config.save();
    }

    public static Object getProperty(String root) {
        return config.get(root.toLowerCase());
    }

    public static double getClaimPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK);
    }

    public static double getClaimPriceIncreaseValue() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK_INCREASE);
    }

    public static double getMaxClaimPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_MAX_PRICE_CLAIM_TOWNBLOCK);
    }

    public static double getClaimRefundPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK_REFUND);
    }

    public static boolean getUnclaimedZoneSwitchRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_SWITCH);
    }

    public static boolean getEndermanProtect() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_ENDERMAN);
    }

    public static long getDayInterval() {
        return Math.min(TownySettings.getSeconds(ConfigNodes.PLUGIN_DAY_INTERVAL), TimeTools.getSeconds("1d"));
    }

    public static long getNewDayTime() {
        long day;
        long time = TownySettings.getSeconds(ConfigNodes.PLUGIN_NEWDAY_TIME);
        if (time > (day = TownySettings.getDayInterval())) {
            TownySettings.setProperty(ConfigNodes.PLUGIN_NEWDAY_TIME.getRoot(), day);
            return day;
        }
        return time;
    }

    public static boolean isNewDayDeleting0PlotTowns() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_NEWDAY_DELETE_0_PLOT_TOWNS);
    }

    public static long getHourInterval() {
        return TownySettings.getSeconds(ConfigNodes.PLUGIN_HOUR_INTERVAL);
    }

    public static long getShortInterval() {
        return TownySettings.getSeconds(ConfigNodes.PLUGIN_SHORT_INTERVAL);
    }

    public static long getNewHourTime() {
        long hour;
        long time = TownySettings.getSeconds(ConfigNodes.PLUGIN_NEWHOUR_TIME);
        if (time > (hour = TownySettings.getHourInterval())) {
            TownySettings.setProperty(ConfigNodes.PLUGIN_NEWHOUR_TIME.getRoot(), hour);
            return hour;
        }
        return time;
    }

    public static TownSpawnLevel.SpawnLevel isAllowingTownSpawn() {
        return TownySettings.getSpawnLevel(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN);
    }

    public static TownSpawnLevel.SpawnLevel isAllowingPublicTownSpawnTravel() {
        return TownySettings.getSpawnLevel(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN_TRAVEL);
    }

    public static NationSpawnLevel.NSpawnLevel isAllowingNationSpawn() {
        return TownySettings.getNSpawnLevel(ConfigNodes.GNATION_SETTINGS_ALLOW_NATION_SPAWN);
    }

    public static NationSpawnLevel.NSpawnLevel isAllowingPublicNationSpawnTravel() {
        return TownySettings.getNSpawnLevel(ConfigNodes.GNATION_SETTINGS_ALLOW_NATION_SPAWN_TRAVEL);
    }

    public static List<String> getDisallowedTownSpawnZones() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_SETTINGS_PREVENT_TOWN_SPAWN_IN);
    }

    public static boolean isSpawnWarnConfirmationUsed() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_SPAWN_WARNINGS);
    }

    public static boolean isTaxingDaily() {
        return TownySettings.getBoolean(ConfigNodes.ECO_DAILY_TAXES_ENABLED);
    }

    public static double getMaxPlotTax() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_PLOT_TAX);
    }

    public static double getMaxTownTax() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TOWN_TAXES_MAX);
    }

    public static double getMaxNationTax() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_NATION_TAXES_MAX);
    }

    public static double getMaxPlotPrice() {
        return TownySettings.getDouble(ConfigNodes.GTOWN_MAX_PLOT_PRICE_COST);
    }

    public static double getMaxTownTaxPercent() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TOWN_TAX_PERCENT);
    }

    public static double getMaxTownTaxPercentAmount() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TOWN_TAX_PERCENT_AMOUNT);
    }

    public static boolean isBackingUpDaily() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DAILY_BACKUPS);
    }

    public static boolean isChargingDeath() {
        return TownySettings.getDeathPrice() > 0.0 || TownySettings.getDeathPriceTown() > 0.0 || TownySettings.getDeathPriceNation() > 0.0;
    }

    public static boolean isDeathPriceType() {
        return TownySettings.getString(ConfigNodes.ECO_PRICE_DEATH_TYPE).equalsIgnoreCase("fixed");
    }

    public static double getDeathPricePercentageCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH_PERCENTAGE_CAP);
    }

    public static boolean isDeathPricePercentageCapped() {
        return TownySettings.getDeathPricePercentageCap() > 0.0;
    }

    public static boolean isDeathPricePVPOnly() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_DEATH_PVP_ONLY);
    }

    public static double getDeathPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH);
    }

    public static double getDeathPriceTown() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH_TOWN);
    }

    public static double getDeathPriceNation() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH_NATION);
    }

    public static boolean isEcoClosedEconomyEnabled() {
        return TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED);
    }

    public static boolean isJailingAttackingEnemies() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_IS_JAILING_ATTACKING_ENEMIES);
    }

    public static boolean isJailingAttackingOutlaws() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_IS_JAILING_ATTACKING_OUTLAWS);
    }

    public static int getJailedOutlawJailHours() {
        return TownySettings.getInt(ConfigNodes.JAIL_OUTLAW_JAIL_HOURS);
    }

    public static boolean JailAllowsTeleportItems() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_JAIL_ALLOWS_TELEPORT_ITEMS);
    }

    public static boolean JailDeniesTownLeave() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_JAIL_DENIES_TOWN_LEAVE);
    }

    public static boolean isAllowingBail() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_BAIL_IS_ALLOWING_BAIL);
    }

    public static double getBailAmount() {
        return TownySettings.getDouble(ConfigNodes.JAIL_BAIL_BAIL_AMOUNT);
    }

    public static double getBailAmountMayor() {
        return TownySettings.getDouble(ConfigNodes.JAIL_BAIL_BAIL_AMOUNT_MAYOR);
    }

    public static double getBailAmountKing() {
        return TownySettings.getDouble(ConfigNodes.JAIL_BAIL_BAIL_AMOUNT_KING);
    }

    public static boolean doJailPlotsPreventPVP() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_PLOTS_DENY_PVP);
    }

    public static boolean doesJailingPreventLoggingOut() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_PREVENTS_LOGGING_OUT);
    }

    public static long newPlayerJailImmunity() {
        return TimeTools.getMillis(TownySettings.getString(ConfigNodes.JAIL_NEW_PLAYER_IMMUNITY));
    }

    public static boolean isDevMode() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEV_MODE_ENABLE);
    }

    public static void setDevMode(boolean choice) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEV_MODE_ENABLE.getRoot(), choice);
    }

    public static String getDevName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DEV_MODE_DEV_NAME);
    }

    public static double getTownUpkeepCost(Town town) {
        TownUpkeepCalculationEvent event = new TownUpkeepCalculationEvent(town, TownySettings.getTownUpkeepCostRaw(town));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getUpkeep();
    }

    private static double getTownUpkeepCostRaw(Town town) {
        double multiplier = 1.0;
        if (town != null) {
            multiplier = TownySettings.isUpkeepByPlot() ? (double)town.getTownBlocks().size() : Double.parseDouble(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString());
        }
        if (town.hasNation()) {
            double nationMultiplier = 1.0;
            try {
                nationMultiplier = Double.parseDouble(TownySettings.getNationLevel(town.getNationOrNull()).get((Object)NationLevel.NATION_TOWN_UPKEEP_MULTIPLIER).toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (TownySettings.isUpkeepByPlot()) {
                double amount = TownySettings.isTownLevelModifiersAffectingPlotBasedUpkeep() ? TownySettings.getTownUpkeep() * multiplier * Double.parseDouble(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString()) * nationMultiplier : TownySettings.getTownUpkeep() * multiplier * nationMultiplier;
                if (TownySettings.getPlotBasedUpkeepMinimumAmount() > 0.0) {
                    amount = Math.max(amount, TownySettings.getPlotBasedUpkeepMinimumAmount());
                }
                if (TownySettings.getPlotBasedUpkeepMaximumAmount() > 0.0) {
                    amount = Math.min(amount, TownySettings.getPlotBasedUpkeepMaximumAmount());
                }
                return amount;
            }
            return TownySettings.getTownUpkeep() * multiplier * nationMultiplier;
        }
        if (TownySettings.isUpkeepByPlot()) {
            double amount = TownySettings.isTownLevelModifiersAffectingPlotBasedUpkeep() ? TownySettings.getTownUpkeep() * multiplier * Double.parseDouble(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString()) : TownySettings.getTownUpkeep() * multiplier;
            if (TownySettings.getPlotBasedUpkeepMinimumAmount() > 0.0) {
                amount = Math.max(amount, TownySettings.getPlotBasedUpkeepMinimumAmount());
            }
            if (TownySettings.getPlotBasedUpkeepMaximumAmount() > 0.0) {
                amount = Math.min(amount, TownySettings.getPlotBasedUpkeepMaximumAmount());
            }
            return amount;
        }
        return TownySettings.getTownUpkeep() * multiplier;
    }

    public static double getTownUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_UPKEEP);
    }

    public static boolean isUpkeepByPlot() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED);
    }

    public static double getPlotBasedUpkeepMinimumAmount() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED_MINIMUM_AMOUNT);
    }

    public static double getPlotBasedUpkeepMaximumAmount() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED_MAXIMUM_AMOUNT);
    }

    public static boolean isTownLevelModifiersAffectingPlotBasedUpkeep() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED_TOWNLEVEL_MODIFIER);
    }

    public static boolean isUpkeepPayingPlots() {
        return TownySettings.getBoolean(ConfigNodes.ECO_UPKEEP_PLOTPAYMENTS);
    }

    public static double getTownPenaltyUpkeepCost(Town town) {
        TownUpkeepPenalityCalculationEvent event = new TownUpkeepPenalityCalculationEvent(town, TownySettings.getTownPenaltyUpkeepCostRaw(town));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getUpkeep();
    }

    private static double getTownPenaltyUpkeepCostRaw(Town town) {
        if (TownySettings.getUpkeepPenalty() > 0.0) {
            int overClaimed = town.getTownBlocks().size() - TownySettings.getMaxTownBlocks(town);
            if (!town.isOverClaimed()) {
                return 0.0;
            }
            if (TownySettings.isUpkeepPenaltyByPlot()) {
                return TownySettings.getUpkeepPenalty() * (double)overClaimed;
            }
            return TownySettings.getUpkeepPenalty();
        }
        return 0.0;
    }

    public static double getUpkeepPenalty() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_OVERCLAIMED_UPKEEP_PENALTY);
    }

    public static boolean isUpkeepPenaltyByPlot() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_OVERCLAIMED_UPKEEP_PENALTY_PLOTBASED);
    }

    public static double getNationUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_UPKEEP);
    }

    public static double getNationUpkeepCost(Nation nation) {
        NationUpkeepCalculationEvent event = new NationUpkeepCalculationEvent(nation, TownySettings.getNationUpkeepCostRaw(nation));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getUpkeep();
    }

    private static double getNationUpkeepCostRaw(Nation nation) {
        double multiplier = 1.0;
        if (nation != null) {
            if (TownySettings.isNationUpkeepPerPlot()) {
                int plotCount = nation.getTowns().stream().collect(Collectors.summingInt(town -> town.getTownBlocks().size()));
                if (TownySettings.isNationLevelModifierAffectingNationUpkeepPerTown()) {
                    return TownySettings.getNationUpkeep() * (double)plotCount * Double.parseDouble(TownySettings.getNationLevel(nation).get((Object)NationLevel.UPKEEP_MULTIPLIER).toString());
                }
                return TownySettings.getNationUpkeep() * (double)plotCount;
            }
            if (TownySettings.isNationUpkeepPerTown()) {
                if (TownySettings.isNationLevelModifierAffectingNationUpkeepPerTown()) {
                    return TownySettings.getNationUpkeep() * (double)nation.getTowns().size() * Double.parseDouble(TownySettings.getNationLevel(nation).get((Object)NationLevel.UPKEEP_MULTIPLIER).toString());
                }
                return TownySettings.getNationUpkeep() * (double)nation.getTowns().size();
            }
            multiplier = Double.parseDouble(TownySettings.getNationLevel(nation).get((Object)NationLevel.UPKEEP_MULTIPLIER).toString());
        }
        return TownySettings.getNationUpkeep() * multiplier;
    }

    private static boolean isNationLevelModifierAffectingNationUpkeepPerTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_NATION_UPKEEP_PERTOWN_NATIONLEVEL_MODIFIER);
    }

    public static boolean isNationUpkeepPerPlot() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_NATION_UPKEEP_PERPLOT);
    }

    public static boolean isNationUpkeepPerTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_NATION_UPKEEP_PERTOWN);
    }

    public static boolean getNationDefaultPublic() {
        return TownySettings.getBoolean(ConfigNodes.NATION_DEF_PUBLIC);
    }

    public static String getNationDefaultBoard() {
        return TownySettings.getString(ConfigNodes.NATION_DEF_BOARD);
    }

    public static String getFlatFileBackupType() {
        return TownySettings.getString(ConfigNodes.PLUGIN_FLATFILE_BACKUP);
    }

    public static long getBackupLifeLength() {
        long t = TimeTools.getMillis(TownySettings.getString(ConfigNodes.PLUGIN_BACKUPS_ARE_DELETED_AFTER));
        long minT = TimeTools.getMillis("1d");
        if (t >= 0L && t < minT) {
            t = minT;
        }
        return t;
    }

    public static boolean isUsingTowny() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_USING_TOWNY);
    }

    public static boolean isPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_PVP);
    }

    public static boolean isForcingPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_PVP_ON);
    }

    public static boolean isPlayerTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_PLAYER_CROP_TRAMPLING);
    }

    public static boolean isCreatureTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_CREATURE_CROP_TRAMPLING);
    }

    public static boolean isWorldMonstersOn() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_MONSTERS_ON);
    }

    public static boolean isWildernessMonstersOn() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WILDERNESS_MONSTERS_ON);
    }

    public static boolean isExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_EXPLOSION);
    }

    public static boolean isForcingExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_EXPLOSIONS_ON);
    }

    public static boolean isForcingMonsters() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_TOWN_MONSTERS_ON);
    }

    public static boolean isFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_FIRE);
    }

    public static boolean isForcingFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_FIRE_ON);
    }

    public static boolean isUsingPlotManagementDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE_ENABLE);
    }

    public static List<String> getPlotManagementDeleteIds() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE);
    }

    public static boolean isUsingPlotManagementMayorDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE_ENABLE);
    }

    public static List<String> getPlotManagementMayorDelete() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE);
    }

    public static boolean isUsingPlotManagementRevert() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_ENABLE);
    }

    public static long getPlotManagementSpeed() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_TIME);
    }

    public static boolean isUsingPlotManagementWildEntityRegen() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_ENABLE);
    }

    public static long getPlotManagementWildRegenDelay() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_TIME);
    }

    public static boolean isUsingPlotManagementWildBlockRegen() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_BLOCK_REVERT_ENABLE);
    }

    public static List<String> getPlotManagementIgnoreIds() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_IGNORE);
    }

    public static boolean isTownRespawning() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN);
    }

    public static boolean isTownRespawningInOtherWorlds() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN_SAME_WORLD_ONLY);
    }

    public static boolean isRespawnAnchorHigherPrecedence() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_RESPAWN_ANCHOR_HIGHER_PRECEDENCE);
    }

    public static int getHomeBlockMovementCooldownHours() {
        return TownySettings.getInt(ConfigNodes.GTOWN_HOMEBLOCK_MOVEMENT_COOLDOWN);
    }

    public static int getHomeBlockMovementDistanceInTownBlocks() {
        return TownySettings.getInt(ConfigNodes.GTOWN_HOMEBLOCK_MOVEMENT_DISTANCE);
    }

    public static int getMaxResidentsPerTown() {
        return TownySettings.getInt(ConfigNodes.GTOWN_MAX_RESIDENTS_PER_TOWN);
    }

    public static int getMaxResidentsPerTownCapitalOverride() {
        return Math.max(TownySettings.getInt(ConfigNodes.GTOWN_MAX_RESIDENTS_CAPITAL_OVERRIDE), TownySettings.getMaxResidentsPerTown());
    }

    public static int getMaxResidentsForTown(Town town) {
        if (town.isCapital()) {
            return TownySettings.getMaxResidentsPerTownCapitalOverride();
        }
        return TownySettings.getMaxResidentsPerTown();
    }

    public static boolean isTownyUpdating(String currentVersion) {
        return !TownySettings.isTownyUpToDate(currentVersion);
    }

    public static boolean isTownyUpToDate(String currentVersion) {
        return currentVersion.equals(TownySettings.getLastRunVersion(currentVersion));
    }

    public static String getLastRunVersion(String currentVersion) {
        return TownySettings.getString(ConfigNodes.LAST_RUN_VERSION.getRoot(), currentVersion);
    }

    public static String getLastRunVersion() {
        return TownySettings.getString(ConfigNodes.LAST_RUN_VERSION.getRoot(), "0.0.0.0");
    }

    public static void setLastRunVersion(String currentVersion) {
        TownySettings.setProperty(ConfigNodes.LAST_RUN_VERSION.getRoot(), currentVersion);
        config.save();
    }

    public static int getMinDistanceFromTownHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_DISTANCE_FROM_TOWN_HOMEBLOCK);
    }

    public static int getMinDistanceForOutpostsFromPlot() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_DISTANCE_FOR_OUTPOST_FROM_PLOT);
    }

    public static int getMaxDistanceForOutpostsFromTown() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_DISTANCE_FOR_OUTPOST_FROM_TOWN_PLOT);
    }

    public static int getMinDistanceFromTownPlotblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_PLOT_DISTANCE_FROM_TOWN_PLOT);
    }

    public static int getMaxDistanceForTownMerge() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_DISTANCE_FOR_MERGE);
    }

    public static int getBaseCostForTownMerge() {
        return TownySettings.getInt(ConfigNodes.ECO_PRICE_TOWN_MERGE);
    }

    public static int getPercentageCostPerPlot() {
        return TownySettings.getInt(ConfigNodes.ECO_PRICE_TOWN_MERGE_PER_PLOT_PERCENTAGE);
    }

    public static boolean isMinDistanceIgnoringTownsInSameNation() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_MIN_DISTANCE_IGNORED_FOR_NATIONS);
    }

    public static boolean isMinDistanceIgnoringTownsInAlliedNation() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_MIN_DISTANCE_IGNORED_FOR_ALLIES);
    }

    public static int getMaxDistanceBetweenHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_DISTANCE_BETWEEN_HOMEBLOCKS);
    }

    public static int getMaxResidentPlots(Resident resident) {
        int maxPlots = TownyUniverse.getInstance().getPermissionSource().getGroupPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_MAX_PLOTS.getNode());
        if (maxPlots == -1) {
            maxPlots = TownySettings.getInt(ConfigNodes.TOWN_MAX_PLOTS_PER_RESIDENT);
        }
        return maxPlots;
    }

    public static int getMaxResidentExtraPlots(Resident resident) {
        int extraPlots = TownyUniverse.getInstance().getPermissionSource().getPlayerPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_EXTRA_PLOTS.getNode());
        if (extraPlots == -1) {
            extraPlots = 0;
        }
        return extraPlots;
    }

    public static int getMaxResidentOutposts(Resident resident) {
        int maxOutposts = TownyUniverse.getInstance().getPermissionSource().getGroupPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_MAX_OUTPOSTS.getNode());
        return maxOutposts;
    }

    public static boolean getPermFlag_Resident_Friend_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_BUILD);
    }

    public static boolean getPermFlag_Resident_Friend_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_DESTROY);
    }

    public static boolean getPermFlag_Resident_Friend_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Friend_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_SWITCH);
    }

    public static boolean getPermFlag_Resident_Town_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_BUILD);
    }

    public static boolean getPermFlag_Resident_Town_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_DESTROY);
    }

    public static boolean getPermFlag_Resident_Town_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Town_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_SWITCH);
    }

    public static boolean getPermFlag_Resident_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_BUILD);
    }

    public static boolean getPermFlag_Resident_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Resident_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Resident_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Resident_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Resident_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_SWITCH);
    }

    public static boolean getPermFlag_Town_Default_PVP() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_PVP);
    }

    public static boolean getPermFlag_Town_Default_FIRE() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_FIRE);
    }

    public static boolean getPermFlag_Town_Default_Explosion() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_EXPLOSION);
    }

    public static boolean getPermFlag_Town_Default_Mobs() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_MOBS);
    }

    public static boolean getPermFlag_Town_Resident_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_BUILD);
    }

    public static boolean getPermFlag_Town_Resident_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_DESTROY);
    }

    public static boolean getPermFlag_Town_Resident_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Resident_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_SWITCH);
    }

    public static boolean getPermFlag_Town_Nation_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_BUILD);
    }

    public static boolean getPermFlag_Town_Nation_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_DESTROY);
    }

    public static boolean getPermFlag_Town_Nation_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Nation_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_SWITCH);
    }

    public static boolean getPermFlag_Town_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_BUILD);
    }

    public static boolean getPermFlag_Town_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Town_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Town_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Town_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Town_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_SWITCH);
    }

    public static boolean getDefaultResidentPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Friend_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Friend_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Friend_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Friend_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Resident_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Resident_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Resident_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Resident_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultNationPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Town_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Town_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Town_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Town_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Nation_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Nation_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Nation_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Nation_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultAllyPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultOutsiderPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultPermission(TownBlockOwner owner, TownyPermission.PermLevel level, TownyPermission.ActionType type) {
        switch (level) {
            case RESIDENT: {
                return TownySettings.getDefaultResidentPermission(owner, type);
            }
            case NATION: {
                return TownySettings.getDefaultNationPermission(owner, type);
            }
            case ALLY: {
                return TownySettings.getDefaultAllyPermission(owner, type);
            }
            case OUTSIDER: {
                return TownySettings.getDefaultOutsiderPermission(owner, type);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String getAcceptCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_ACCEPT_COMMAND);
    }

    public static String getDenyCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_DENY_COMMAND);
    }

    public static String getConfirmCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_CONFIRM_COMMAND);
    }

    public static String getCancelCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_CANCEL_COMMAND);
    }

    public static boolean getOutsidersPreventPVPToggle() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_OUTSIDERS_PREVENT_PVP_TOGGLE);
    }

    public static boolean isForcePvpNotAffectingHomeblocks() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_HOMEBLOCKS_PREVENT_FORCEPVP);
    }

    public static int getConfirmationTimeoutSeconds() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_CONFIRMATION_TIMEOUT);
    }

    public static long getTownInviteCooldown() {
        return TownySettings.getSeconds(ConfigNodes.INVITE_SYSTEM_COOLDOWN_TIME);
    }

    public static long getInviteExpirationTime() {
        return TownySettings.getSeconds(ConfigNodes.INVITE_SYSTEM_EXPIRATION_TIME);
    }

    public static boolean isAppendingToLog() {
        return !TownySettings.getBoolean(ConfigNodes.PLUGIN_RESET_LOG_ON_BOOT);
    }

    public static int getTownyTopSize() {
        return TownySettings.getInt(ConfigNodes.PLUGIN_TOWNY_TOP_SIZE);
    }

    public static String getNameFilterRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_FILTER_REGEX);
    }

    public static String getNameCheckRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_CHECK_REGEX);
    }

    public static String getStringCheckRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_STRING_CHECK_REGEX);
    }

    public static String getNameRemoveRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_REMOVE_REGEX);
    }

    public static int getTeleportWarmupTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_SPAWN_TIMER);
    }

    public static boolean isMovementCancellingSpawnWarmup() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_MOVEMENT_CANCELS_SPAWN_WARMUP);
    }

    public static boolean isDamageCancellingSpawnWarmup() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_DAMAGE_CANCELS_SPAWN_WARMUP);
    }

    public static int getSpawnCooldownTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_SPAWN_COOLDOWN_TIMER);
    }

    public static int getPVPCoolDownTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_PVP_COOLDOWN_TIMER);
    }

    public static String getTownAccountPrefix() {
        return TownySettings.getString(ConfigNodes.ECO_TOWN_PREFIX);
    }

    public static String getNationAccountPrefix() {
        return TownySettings.getString(ConfigNodes.ECO_NATION_PREFIX);
    }

    public static double getTownBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_TOWN);
    }

    public static int getTownMinDeposit() {
        return TownySettings.getInt(ConfigNodes.ECO_MIN_DEPOSIT_TOWN);
    }

    public static int getTownMinWithdraw() {
        return TownySettings.getInt(ConfigNodes.ECO_MIN_WITHDRAW_TOWN);
    }

    public static double getNationBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_NATION);
    }

    public static boolean getTownBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWALS);
    }

    public static void SetTownBankAllowWithdrawls(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWALS.getRoot(), newSetting);
    }

    public static boolean getNationBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWALS);
    }

    public static int getNationMinDeposit() {
        return TownySettings.getInt(ConfigNodes.ECO_MIN_DEPOSIT_NATION);
    }

    public static int getNationMinWithdraw() {
        return TownySettings.getInt(ConfigNodes.ECO_MIN_WITHDRAW_NATION);
    }

    public static boolean isBankActionDisallowedOutsideTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_DISALLOW_BANK_ACTIONS_OUTSIDE_TOWN);
    }

    public static boolean isBankActionLimitedToBankPlots() {
        return TownySettings.getBoolean(ConfigNodes.BANK_IS_LIMTED_TO_BANK_PLOTS);
    }

    public static void SetNationBankAllowWithdrawls(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWALS.getRoot(), newSetting);
    }

    public static int getMaxNumResidentsWithoutNation() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_MAX_NUMBER_RESIDENTS_WITHOUT_NATION);
    }

    public static int getNumResidentsJoinNation() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_REQUIRED_NUMBER_RESIDENTS_JOIN_NATION);
    }

    public static int getNumResidentsCreateNation() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_REQUIRED_NUMBER_RESIDENTS_CREATE_NATION);
    }

    public static boolean isRefundNationDisbandLowResidents() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_REFUND_DISBAND_LOW_RESIDENTS);
    }

    public static double getNationRequiresProximity() {
        return TownySettings.getDouble(ConfigNodes.GTOWN_SETTINGS_NATION_REQUIRES_PROXIMITY);
    }

    public static List<String> getFarmPlotBlocks() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_FARM_PLOT_ALLOW_BLOCKS);
    }

    public static List<String> getFarmAnimals() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_FARM_ANIMALS);
    }

    public static boolean getKeepInventoryInTowns() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_INVENTORY_ON_DEATH_IN_TOWN);
    }

    public static boolean getKeepInventoryInOwnTown() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_INVENTORY_ON_DEATH_IN_OWN_TOWN);
    }

    public static boolean getKeepInventoryInAlliedTowns() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_INVENTORY_ON_DEATH_IN_ALLIED_TOWN);
    }

    public static boolean getKeepExperienceInArenas() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_EXPERIENCE_ON_DEATH_IN_ARENA);
    }

    public static boolean getKeepInventoryInArenas() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_INVENTORY_ON_DEATH_IN_ARENA);
    }

    public static boolean getKeepExperienceInTowns() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_EXPERIENCE_ON_DEATH_IN_TOWN);
    }

    public static boolean isNotificationUsingTitles() {
        return TownySettings.getBoolean(ConfigNodes.NOTIFICATION_USING_TITLES);
    }

    public static int getAmountOfResidentsForOutpost() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_MINIMUM_AMOUNT_RESIDENTS_FOR_OUTPOSTS);
    }

    public static int getMaximumInvitesSentTown() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_SENT_TOWN);
    }

    public static int getMaximumInvitesSentNation() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_SENT_NATION);
    }

    public static int getMaximumRequestsSentNation() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_REQUESTS_SENT_NATION);
    }

    public static int getMaximumInvitesReceivedResident() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_RECEIVED_PLAYER);
    }

    public static int getMaximumInvitesReceivedTown() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_RECEIVED_TOWN);
    }

    public static int getMaximumRequestsReceivedNation() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_REQUESTS_RECEIVED_NATION);
    }

    public static boolean getNationZonesEnabled() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_ENABLE);
    }

    public static boolean getNationZonesCapitalsOnly() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_ONLY_CAPITALS);
    }

    public static boolean getNationZonesWarDisables() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_WAR_DISABLES);
    }

    public static boolean getNationZonesShowNotifications() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_SHOW_NOTIFICATIONS);
    }

    public static int getNationZonesCapitalBonusSize() {
        return TownySettings.getInt(ConfigNodes.GNATION_SETTINGS_NATIONZONE_CAPITAL_BONUS_SIZE);
    }

    public static boolean isNationSpawnOnlyAllowedInCapital() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_CAPITAL_SPAWN);
    }

    public static boolean isShowingRegistrationMessage() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_IS_SHOWING_WELCOME_MESSAGE);
    }

    public static int getMaxTownsPerNation() {
        return TownySettings.getInt(ConfigNodes.GNATION_SETTINGS_MAX_TOWNS_PER_NATION);
    }

    public static double getSpawnTravelCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_SPAWN_TRAVEL_PUBLIC);
    }

    public static boolean isAllySpawningRequiringPublicStatus() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_IS_ALLY_SPAWNING_REQUIRING_PUBLIC_STATUS);
    }

    public static String getNotificationTitlesTownTitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_TOWN_TITLE);
    }

    public static String getNotificationTitlesTownSubtitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_TOWN_SUBTITLE);
    }

    public static String getNotificationTitlesWildTitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_WILDERNESS_TITLE);
    }

    public static String getNotificationTitlesWildSubtitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_WILDERNESS_SUBTITLE);
    }

    public static double getTownRenameCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_TOWN_RENAME_COST);
    }

    public static double getNationRenameCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_NATION_RENAME_COST);
    }

    public static boolean isRemovingKillerBunny() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_TOWN_KILLER_BUNNY);
    }

    public static boolean isSkippingRemovalOfNamedMobs() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_SKIP_NAMED_MOBS);
    }

    public static List<String> getJailBlacklistedCommands() {
        return TownySettings.getStrArr(ConfigNodes.JAIL_BLACKLISTED_COMMANDS);
    }

    public static String getPAPIFormattingBoth() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_BOTH);
    }

    public static String getPAPIFormattingTown() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_TOWN);
    }

    public static String getPAPIFormattingNation() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_NATION);
    }

    public static String getPAPIFormattingNomad() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_NOMAD);
    }

    public static String getPAPIFormattingResident() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_RESIDENT);
    }

    public static String getPAPIFormattingMayor() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_MAYOR);
    }

    public static String getPAPIFormattingKing() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_KING);
    }

    public static String getPAPIRelationNone() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_REL_FORMATTING_NONE);
    }

    public static String getPAPIRelationSameTown() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_REL_FORMATTING_SAME_TOWN);
    }

    public static String getPAPIRelationSameNation() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_REL_FORMATTING_SAME_NATION);
    }

    public static String getPAPIRelationAlly() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_REL_FORMATTING_ALLY);
    }

    public static String getPAPIRelationEnemy() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_REL_FORMATTING_ENEMY);
    }

    public static double getPlotSetCommercialCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_COMMERCIAL);
    }

    public static double getPlotSetArenaCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_ARENA);
    }

    public static double getPlotSetEmbassyCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_EMBASSY);
    }

    public static double getPlotSetWildsCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_WILDS);
    }

    public static double getPlotSetInnCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_INN);
    }

    public static double getPlotSetJailCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_JAIL);
    }

    public static double getPlotSetFarmCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_FARM);
    }

    public static double getPlotSetBankCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_BANK);
    }

    public static int getMaxDistanceFromTownSpawnForInvite() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAX_DISTANCE_FROM_TOWN_SPAWN);
    }

    public static boolean getTownDisplaysXYZ() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_DISPLAY_XYZ_INSTEAD_OF_TOWNY_COORDS);
    }

    public static boolean isTownListRandom() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_DISPLAY_TOWN_LIST_RANDOMLY);
    }

    public static List<String> getOrderOfMayoralSuccession() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_ORDER_OF_MAYORAL_SUCCESSION);
    }

    public static boolean isWarAllowed() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WAR_ALLOWED);
    }

    public static boolean isNotificationsTownNamesVerbose() {
        return TownySettings.getBoolean(ConfigNodes.NOTIFICATION_TOWN_NAMES_ARE_VERBOSE);
    }

    public static Map<String, String> getNationColorsMap() {
        List<String> nationColorsList = TownySettings.getStrArr(ConfigNodes.GNATION_SETTINGS_ALLOWED_NATION_COLORS);
        HashMap<String, String> nationColorsMap = new HashMap<String, String>();
        for (String nationColor : nationColorsList) {
            String[] keyValuePair = nationColor.trim().split(":");
            nationColorsMap.put(keyValuePair[0], keyValuePair[1]);
        }
        return nationColorsMap;
    }

    public static Map<String, String> getTownColorsMap() {
        List<String> townColorsList = TownySettings.getStrArr(ConfigNodes.GTOWN_SETTINGS_ALLOWED_TOWN_COLORS);
        HashMap<String, String> townColorsMap = new HashMap<String, String>();
        for (String nationColor : townColorsList) {
            String[] keyValuePair = nationColor.trim().split(":");
            townColorsMap.put(keyValuePair[0], keyValuePair[1]);
        }
        return townColorsMap;
    }

    public static String getUUIDPercent() {
        double fraction = (double)uuidCount / (double)TownyUniverse.getInstance().getNumResidents();
        if (fraction == 1.0) {
            return "100%";
        }
        if (fraction > 0.89) {
            return "90%+";
        }
        if (fraction > 0.79) {
            return "80%+";
        }
        if (fraction > 0.69) {
            return "70%+";
        }
        if (fraction > 0.59) {
            return "60%+";
        }
        if (fraction > 0.49) {
            return "50%+";
        }
        return "<50%";
    }

    public static int getUUIDCount() {
        return uuidCount;
    }

    public static void setUUIDCount(int hasUUID) {
        uuidCount = hasUUID;
    }

    public static void incrementUUIDCount() {
        ++uuidCount;
    }

    public static boolean isTownBankruptcyEnabled() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANKRUPTCY_ENABLED);
    }

    public static double getDebtCapMaximum() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANKRUPTCY_DEBT_CAP_MAXIMUM);
    }

    public static double getDebtCapOverride() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANKRUPTCY_DEBT_CAP_OVERRIDE);
    }

    public static boolean isDebtCapDeterminedByTownLevel() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANKRUPTCY_DEBT_CAP_USES_TOWN_LEVELS);
    }

    public static boolean isUpkeepDeletingTownsThatReachDebtCap() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANKRUPTCY_UPKEEP_DELETE_TOWNS_THAT_REACH_DEBT_CAP);
    }

    public static boolean isNationTaxKickingTownsThatReachDebtCap() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANKRUPTCY_NATION_KICKS_TOWNS_THAT_REACH_DEBT_CAP);
    }

    public static boolean doesNationTaxDeleteConqueredTownsWhichCannotPay() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANKRUPTCY_DOES_NATION_TAX_DELETE_CONQUERED_TOWNS);
    }

    public static boolean doBankruptTownsPayNationTax() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANKRUPTCY_DO_BANKRUPT_TOWNS_PAY_NATION_TAX);
    }

    public static boolean canOutlawsEnterTowns() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_OUTLAWS_TO_ENTER_TOWN);
    }

    public static boolean canOutlawsTeleportOutOfTowns() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_OUTLAWS_TO_TELEPORT_OUT_OF_TOWN);
    }

    public static boolean canOutlawsUseTeleportItems() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_OUTLAWS_USE_TELEPORT_ITEMS);
    }

    public static boolean areNewOutlawsTeleportedAway() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_OUTLAW_TELEPORT_ON_BECOMING_OUTLAWED);
    }

    public static int getOutlawTeleportWarmup() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_OUTLAW_TELEPORT_WARMUP);
    }

    public static String getOutlawTeleportWorld() {
        return TownySettings.getString(ConfigNodes.GTOWN_SETTINGS_OUTLAW_TELEPORT_WORLD);
    }

    public static boolean doTownsGetWarnedOnOutlaw() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_WARN_TOWN_ON_OUTLAW);
    }

    public static List<String> getOutlawBlacklistedCommands() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_SETTINGS_OUTLAW_BLACKLISTED_COMMANDS);
    }

    public static boolean getVisualizedSpawnPointsEnabled() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_VISUALIZED_SPAWN_POINTS_ENABLED);
    }

    public static List<String> getBlacklistedNames() {
        return TownySettings.getStrArr(ConfigNodes.PLUGIN_NAME_BLACKLIST);
    }

    public static boolean doesFrostWalkerRequireBuildPerms() {
        return TownySettings.getBoolean(ConfigNodes.PROT_FROST_WALKER);
    }

    public static boolean isNotificationsAppearingOnBossbar() {
        return TownySettings.getBoolean(ConfigNodes.NOTIFICATION_NOTIFICATIONS_APPEAR_ON_BOSSBAR);
    }

    public static boolean allowTownCommandBlacklisting() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ENABLE_COMMAND_BLACKLISTING);
    }

    public static List<String> getTownBlacklistedCommands() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_TOWN_BLACKLISTED_COMMANDS);
    }

    public static List<String> getPlayerOwnedPlotLimitedCommands() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_TOWN_LIMITED_COMMANDS);
    }

    public static boolean getPreventFluidGriefingEnabled() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_PREVENT_FLUID_GRIEFING);
    }

    public static int getMaxTagLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MAX_TAG_LENGTH);
    }

    public static boolean getTownAutomaticCapitalisationEnabled() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_AUTOMATIC_CAPITALISATION);
    }

    public static List<String> getTouristBlockedCommands() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_TOWN_TOURIST_BLOCKED_COMMANDS);
    }

    public static boolean isContextsEnabled() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_LUCKPERMS_CONTEXTS);
    }

    public static boolean isShowingUpdateNotifications() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_UPDATE_NOTIFICATIONS_ALERTS);
    }

    public static boolean isUpdateNotificationsMajorOnly() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_UPDATE_NOTIFICATIONS_MAJOR_ONLY);
    }

    public static int getMaxNationAllies() {
        return TownySettings.getInt(ConfigNodes.GNATION_SETTINGS_MAX_ALLIES);
    }

    public static String getBankHistoryBookFormat() {
        return TownySettings.getString(ConfigNodes.BANKHISTORY_BOOK);
    }

    public static boolean getTownRuinsEnabled() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_RUINING_TOWN_RUINS_ENABLED);
    }

    public static int getTownRuinsMaxDurationHours() {
        return Math.min(TownySettings.getInt(ConfigNodes.TOWN_RUINING_TOWN_RUINS_MAX_DURATION_HOURS), 8760);
    }

    public static int getTownRuinsMinDurationHours() {
        return TownySettings.getInt(ConfigNodes.TOWN_RUINING_TOWN_RUINS_MIN_DURATION_HOURS);
    }

    public static boolean getTownRuinsReclaimEnabled() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_RUINING_TOWN_RUINS_RECLAIM_ENABLED);
    }

    public static double getEcoPriceReclaimTown() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_RECLAIM_RUINED_TOWN);
    }

    public static boolean areRuinsMadePublic() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_RUINING_TOWNS_BECOME_PUBLIC);
    }

    public static void saveConfig() {
        config.save();
    }

    public static long getSpawnProtection() {
        return TimeTools.getTicks(TownySettings.getString(ConfigNodes.GTOWN_SETTINGS_RESPAWN_PROTECTION));
    }

    public static boolean isUsingWebMapStatusScreens() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_WEB_MAP_USING_STATUSSCREEN);
    }

    public static String getWebMapUrl() {
        return TownySettings.getString(ConfigNodes.PLUGIN_WEB_MAP_URL);
    }

    static {
        configTownLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
        configNationLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
        ItemUseMaterials = new ArrayList<String>();
        SwitchUseMaterials = new ArrayList<String>();
        protectedMobs = new ArrayList();
    }

    public static enum TownLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        MAYOR_PREFIX,
        MAYOR_POSTFIX,
        TOWN_BLOCK_LIMIT,
        UPKEEP_MULTIPLIER,
        OUTPOST_LIMIT,
        TOWN_BLOCK_BUY_BONUS_LIMIT,
        DEBT_CAP_MODIFIER;

    }

    public static enum NationLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        CAPITAL_PREFIX,
        CAPITAL_POSTFIX,
        KING_PREFIX,
        KING_POSTFIX,
        TOWN_BLOCK_LIMIT_BONUS,
        UPKEEP_MULTIPLIER,
        NATION_TOWN_UPKEEP_MULTIPLIER,
        NATIONZONES_SIZE,
        NATION_BONUS_OUTPOST_LIMIT;

    }
}

