/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.event.townblockstatus.NationZoneTownBlockStatusEvent;
import com.palmergames.bukkit.towny.exceptions.KeyAlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.paperlib.PaperLib;
import com.palmergames.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownyAPI {
    private static TownyAPI instance;
    private final Towny towny = Towny.getPlugin();
    private final TownyUniverse townyUniverse = TownyUniverse.getInstance();

    private TownyAPI() {
    }

    @Nullable
    public Location getTownSpawnLocation(Player player) {
        Resident resident = this.townyUniverse.getResident(player.getUniqueId());
        if (resident == null) {
            return null;
        }
        if (resident.hasTown()) {
            return resident.getTownOrNull().getSpawnOrNull();
        }
        return null;
    }

    @Nullable
    public Location getNationSpawnLocation(Player player) {
        Resident resident = this.townyUniverse.getResident(player.getUniqueId());
        if (resident == null) {
            return null;
        }
        try {
            Town t;
            if (resident.hasTown() && (t = resident.getTown()).hasNation()) {
                Nation nation = t.getNation();
                return nation.getSpawn();
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public Town getResidentTownOrNull(Resident resident) {
        return resident.getTownOrNull();
    }

    @Nullable
    public Nation getResidentNationOrNull(Resident resident) {
        if (resident.hasNation()) {
            return resident.getTownOrNull().getNationOrNull();
        }
        return null;
    }

    @Nullable
    public Nation getTownNationOrNull(Town town) {
        return town.getNationOrNull();
    }

    @Nullable
    public Nation getNation(UUID uuid) {
        return TownyUniverse.getInstance().getNation(uuid);
    }

    @Nullable
    public Town getTown(UUID uuid) {
        return TownyUniverse.getInstance().getTown(uuid);
    }

    @Nullable
    public Resident getResident(UUID uuid) {
        return TownyUniverse.getInstance().getResident(uuid);
    }

    @Nullable
    public Resident getResident(Player player) {
        return this.getResident(player.getUniqueId());
    }

    @Nullable
    public Nation getNation(String name) {
        return TownyUniverse.getInstance().getNation(name);
    }

    @Nullable
    public Town getTown(String name) {
        return TownyUniverse.getInstance().getTown(name);
    }

    @Nullable
    public Resident getResident(String name) {
        return TownyUniverse.getInstance().getResident(name);
    }

    public Player getPlayer(Resident resident) {
        if (resident.isNPC()) {
            return null;
        }
        Player player = null;
        if (resident.hasUUID()) {
            player = BukkitTools.getPlayer(resident.getUUID());
        }
        if (player == null) {
            player = BukkitTools.getPlayerExact(resident.getName());
        }
        return player;
    }

    @Nullable
    public UUID getPlayerUUID(Resident resident) {
        if (resident.isNPC()) {
            return null;
        }
        if (resident.hasUUID()) {
            return resident.getUUID();
        }
        Player player = BukkitTools.getPlayerExact(resident.getName());
        if (player != null) {
            return player.getUniqueId();
        }
        return null;
    }

    public List<Player> getOnlinePlayers(ResidentList owner) {
        return Bukkit.getOnlinePlayers().stream().filter(player -> owner.hasResident(player.getName())).collect(Collectors.toList());
    }

    public List<Player> getOnlinePlayersInTown(Town town) {
        return this.getOnlinePlayers(town);
    }

    public List<Player> getOnlinePlayersInNation(Nation nation) {
        return this.getOnlinePlayers(nation);
    }

    public List<Player> getOnlinePlayersAlliance(Nation nation) {
        ArrayList<Player> players = new ArrayList<Player>(this.getOnlinePlayers(nation));
        if (!nation.getAllies().isEmpty()) {
            for (Nation nations : nation.getAllies()) {
                players.addAll(this.getOnlinePlayers(nations));
            }
        }
        return players;
    }

    public boolean isWilderness(Block block) {
        return this.isWilderness(block.getLocation());
    }

    public boolean isWilderness(Location location) {
        return this.isWilderness(WorldCoord.parseWorldCoord(location));
    }

    public boolean isWilderness(WorldCoord worldCoord) {
        return !worldCoord.hasTownBlock() || !worldCoord.getTownBlockOrNull().hasTown();
    }

    public boolean isPVP(Location location) {
        return !this.isTownyWorld(location.getWorld()) || CombatUtil.preventPvP(this.getTownyWorld(location.getWorld().getName()), this.getTownBlock(location));
    }

    public boolean isTownyWorld(World world) {
        try {
            return this.townyUniverse.getDataSource().getWorld(world.getName()).isUsingTowny();
        }
        catch (NotRegisteredException notRegisteredException) {
            return false;
        }
    }

    @Nullable
    public TownyWorld getTownyWorld(String worldName) {
        try {
            return this.townyUniverse.getDataSource().getWorld(worldName);
        }
        catch (NotRegisteredException ignored) {
            return null;
        }
    }

    @Nullable
    public TownyWorld getTownyWorld(World world) {
        return this.getTownyWorld(world.getName());
    }

    @Nullable
    public Town getTown(Location location) {
        WorldCoord worldCoord = WorldCoord.parseWorldCoord(location);
        return worldCoord.getTownOrNull();
    }

    @Nullable
    public Town getTownOrNull(TownBlock townBlock) {
        return townBlock.getTownOrNull();
    }

    @Nullable
    public Resident getResidentOrNull(TownBlock townBlock) {
        return townBlock.getResidentOrNull();
    }

    @Nullable
    public String getTownName(Location location) {
        Town town = this.getTown(location);
        return town != null ? town.getName() : null;
    }

    @Nullable
    public UUID getTownUUID(Location location) {
        Town town = this.getTown(location);
        return town != null ? town.getUUID() : null;
    }

    @Nullable
    public TownBlock getTownBlock(Location location) {
        WorldCoord worldCoord = WorldCoord.parseWorldCoord(location);
        return worldCoord.getTownBlockOrNull();
    }

    @Nullable
    public TownBlock getTownBlock(@NotNull Player player) {
        return WorldCoord.parseWorldCoord(player.getLocation()).getTownBlockOrNull();
    }

    @Nullable
    public TownBlock getTownBlock(WorldCoord wc) {
        return wc.getTownBlockOrNull();
    }

    @Deprecated
    public List<Resident> getActiveResidents() {
        return new ArrayList<Resident>(this.townyUniverse.getResidents());
    }

    @Deprecated
    public boolean isActiveResident(Resident resident) {
        return resident.isOnline();
    }

    public TownyDataSource getDataSource() {
        return this.townyUniverse.getDataSource();
    }

    public List<Resident> getOnlineResidents(ResidentList owner) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : owner.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName())) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    @Deprecated
    public void jailTeleport(Player player, Location location) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.towny, () -> PaperLib.teleportAsync((Entity)player, location, PlayerTeleportEvent.TeleportCause.PLUGIN), (long)TownySettings.getTeleportWarmupTime() * 20L);
    }

    public void requestTeleport(Player player, Location spawnLoc) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident != null) {
            TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc);
        }
    }

    public void abortTeleportRequest(Resident resident) {
        TeleportWarmupTimerTask.abortTeleportRequest(resident);
    }

    public void registerCustomDataField(CustomDataField<?> field) throws KeyAlreadyRegisteredException {
        this.townyUniverse.addCustomCustomDataField(field);
    }

    public boolean isNationZone(Location location) {
        if (!this.isWilderness(location)) {
            return false;
        }
        PlayerCache.TownBlockStatus status = this.hasNationZone(location);
        return status.equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE);
    }

    public PlayerCache.TownBlockStatus hasNationZone(Location location) {
        return this.hasNationZone(WorldCoord.parseWorldCoord(location));
    }

    public PlayerCache.TownBlockStatus hasNationZone(WorldCoord worldCoord) {
        int nationZoneRadius;
        TownBlock nearestTownblock = TownyAPI.getInstance().getTownyWorld(worldCoord.getWorldName()).getClosestTownblockWithNationFromCoord(worldCoord);
        if (nearestTownblock == null) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        Town nearestTown = nearestTownblock.getTownOrNull();
        if (nearestTown == null || !nearestTown.hasNation()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        if (TownySettings.getNationZonesWarDisables() && nearestTown.getNationOrNull().hasActiveWar()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        if (!nearestTown.isCapital() && TownySettings.getNationZonesCapitalsOnly()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        if (!nearestTown.isNationZoneEnabled()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        int distance = (int)MathUtil.distance(worldCoord.getX(), nearestTownblock.getX(), worldCoord.getZ(), nearestTownblock.getZ());
        if (distance <= (nationZoneRadius = nearestTown.getNationZoneSize())) {
            NationZoneTownBlockStatusEvent event = new NationZoneTownBlockStatusEvent(nearestTown);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
            }
            return PlayerCache.TownBlockStatus.NATION_ZONE;
        }
        return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
    }

    public static void addTranslations(Plugin plugin, Map<String, Map<String, String>> translations) {
        Translation.addTranslations(translations);
        Towny.getPlugin().getLogger().info("Loaded additional language files for plugin: " + plugin.getName());
    }

    public static TownyAPI getInstance() {
        if (instance == null) {
            instance = new TownyAPI();
        }
        return instance;
    }

    @Deprecated
    public boolean isWarTime() {
        return false;
    }
}

