/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.earth2me.essentials.Essentials;
import com.palmergames.adventure.platform.bukkit.BukkitAudiences;
import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.config.migration.ConfigMigrator;
import com.palmergames.bukkit.metrics.bukkit.Metrics;
import com.palmergames.bukkit.metrics.charts.SimplePie;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyPlaceholderExpansion;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.TownyUpdateChecker;
import com.palmergames.bukkit.towny.chat.TNCRegister;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.PlotCommand;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyAdminCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.command.TownyWorldCommand;
import com.palmergames.bukkit.towny.command.commandobjects.AcceptCommand;
import com.palmergames.bukkit.towny.command.commandobjects.CancelCommand;
import com.palmergames.bukkit.towny.command.commandobjects.ConfirmCommand;
import com.palmergames.bukkit.towny.command.commandobjects.DenyCommand;
import com.palmergames.bukkit.towny.db.DatabaseConfig;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.exceptions.initialization.TownyInitException;
import com.palmergames.bukkit.towny.hooks.LuckPermsContexts;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.listeners.TownyBlockListener;
import com.palmergames.bukkit.towny.listeners.TownyCustomListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityMonitorListener;
import com.palmergames.bukkit.towny.listeners.TownyInventoryListener;
import com.palmergames.bukkit.towny.listeners.TownyLoginListener;
import com.palmergames.bukkit.towny.listeners.TownyPlayerListener;
import com.palmergames.bukkit.towny.listeners.TownyServerListener;
import com.palmergames.bukkit.towny.listeners.TownyVehicleListener;
import com.palmergames.bukkit.towny.listeners.TownyWorldListener;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.MetadataLoader;
import com.palmergames.bukkit.towny.permissions.BukkitPermSource;
import com.palmergames.bukkit.towny.permissions.GroupManagerSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.permissions.VaultPermSource;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Version;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.JavaUtil;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Towny
extends JavaPlugin {
    private static final Version NETHER_VER = Version.fromString("1.16.1");
    private static final Version CUR_BUKKIT_VER = Version.fromString(Bukkit.getBukkitVersion());
    private final String version = this.getDescription().getVersion();
    private final TownyPlayerListener playerListener = new TownyPlayerListener(this);
    private final TownyVehicleListener vehicleListener = new TownyVehicleListener(this);
    private final TownyBlockListener blockListener = new TownyBlockListener(this);
    private final TownyCustomListener customListener = new TownyCustomListener(this);
    private final TownyEntityListener entityListener = new TownyEntityListener(this);
    private final TownyServerListener serverListener = new TownyServerListener(this);
    private final TownyEntityMonitorListener entityMonitorListener = new TownyEntityMonitorListener(this);
    private final TownyWorldListener worldListener = new TownyWorldListener(this);
    private final TownyInventoryListener inventoryListener = new TownyInventoryListener();
    private final TownyLoginListener loginListener = new TownyLoginListener();
    private final HUDManager HUDManager = new HUDManager(this);
    private TownyUniverse townyUniverse;
    private final Map<String, PlayerCache> playerCache = Collections.synchronizedMap(new HashMap());
    private Essentials essentials = null;
    private boolean citizens2 = false;
    private final List<TownyInitException.TownyError> errors = new ArrayList<TownyInitException.TownyError>();
    private static Towny plugin;
    private static BukkitAudiences adventure;

    public Towny() {
        plugin = this;
    }

    public void onEnable() {
        Bukkit.getLogger().info("====================      Towny      ========================");
        this.townyUniverse = TownyUniverse.getInstance();
        BukkitTools.initialize(this);
        TownyTimerHandler.initialize(this);
        TownyEconomyHandler.initialize(this);
        TownyFormatter.initialize();
        PlayerCacheUtil.initialize(this);
        TownyPerms.initialize(this);
        InviteHandler.initialize(this);
        try {
            this.loadFoundation(false);
            this.checkPlugins();
            this.cycleTimers();
            this.resetCache();
            TownyUpdateChecker.checkForUpdates(this);
            SpawnUtil.initialize(this);
            this.registerSpecialCommands();
            this.registerCommands();
            this.addMetricsCharts();
        }
        catch (TownyInitException tie) {
            this.addError(tie.getError());
            this.getLogger().log(Level.SEVERE, tie.getMessage(), tie);
        }
        adventure = BukkitAudiences.create((Plugin)this);
        if (!this.isError() && TownySettings.isTownyUpdating(this.getVersion())) {
            this.printChangelogToConsole();
            TownySettings.setLastRunVersion(this.getVersion());
            this.townyUniverse.getDataSource().saveAll();
            this.townyUniverse.getDataSource().cleanup();
        }
        if (!this.isError(TownyInitException.TownyError.MAIN_CONFIG) && !this.isError(TownyInitException.TownyError.PERMISSIONS)) {
            TownyPerms.registerPermissionNodes();
        }
        this.registerEvents();
        Bukkit.getLogger().info("=============================================================");
        if (this.isError()) {
            plugin.getLogger().warning("[WARNING] - ***** SAFE MODE ***** " + this.version);
        } else {
            plugin.getLogger().info("Version: " + this.version + " - Plugin Enabled");
        }
        Bukkit.getLogger().info("=============================================================");
        if (!this.isError()) {
            for (Player player : BukkitTools.getOnlinePlayers()) {
                if (player == null) continue;
                if (player.getName().contains(" ")) {
                    player.kickPlayer("Invalid name!");
                    return;
                }
                if (BukkitTools.scheduleSyncDelayedTask(new OnPlayerLogin(this, player), 0L) != -1) continue;
                TownyMessaging.sendErrorMsg("Could not schedule OnLogin.");
            }
        }
    }

    public void loadFoundation(boolean reload) {
        this.loadDatabaseConfig(reload);
        this.loadConfig(reload);
        this.loadLocalization(reload);
        this.loadPermissions(reload);
        TownyLogger.getInstance();
        this.townyUniverse.clearAllObjects();
        this.townyUniverse.loadAndSaveDatabase(TownySettings.getLoadDatabase(), TownySettings.getSaveDatabase());
        MetadataLoader.getInstance().scheduleDeserialization();
        if (!TownySettings.getLastRunVersion().equals(this.getVersion())) {
            ConfigMigrator migrator = new ConfigMigrator(TownySettings.getConfig(), "config-migration.json");
            migrator.migrate();
        }
        this.loadTownAndNationLevels();
        this.townyUniverse.performCleanupAndBackup();
    }

    private void loadConfig(boolean reload) {
        TownySettings.loadConfig(this.getDataFolder().toPath().resolve("settings").resolve("config.yml"), this.getVersion());
        if (reload) {
            if (this.isError(TownyInitException.TownyError.MAIN_CONFIG)) {
                this.removeError(TownyInitException.TownyError.MAIN_CONFIG);
            }
            TownyMessaging.sendMsg(Translatable.of("msg_reloaded_config"));
        }
    }

    private void loadLocalization(boolean reload) {
        Translation.loadTranslationRegistry();
        if (reload) {
            if (this.isError(TownyInitException.TownyError.LOCALIZATION)) {
                this.removeError(TownyInitException.TownyError.LOCALIZATION);
            }
            TownyMessaging.sendMsg(Translatable.of("msg_reloaded_lang"));
        }
    }

    private void loadDatabaseConfig(boolean reload) {
        if (!this.checkForLegacyDatabaseConfig()) {
            throw new TownyInitException("Unable to migrate old database settings to Towny\\data\\settings\\database.yml", TownyInitException.TownyError.DATABASE_CONFIG);
        }
        DatabaseConfig.loadDatabaseConfig(this.getDataFolder().toPath().resolve("settings").resolve("database.yml"));
        if (reload && this.isError(TownyInitException.TownyError.DATABASE_CONFIG)) {
            this.removeError(TownyInitException.TownyError.DATABASE_CONFIG);
        }
    }

    public void loadPermissions(boolean reload) {
        TownyPerms.loadPerms(this.getDataFolder().toPath().resolve("settings").resolve("townyperms.yml"));
        if (reload) {
            if (this.isError(TownyInitException.TownyError.PERMISSIONS)) {
                this.removeError(TownyInitException.TownyError.PERMISSIONS);
            }
            TownyPerms.updateOnlinePerms();
        }
    }

    private void loadTownAndNationLevels() {
        try {
            TownySettings.loadTownLevelConfig();
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to load town level config", TownyInitException.TownyError.MAIN_CONFIG);
        }
        try {
            TownySettings.loadNationLevelConfig();
        }
        catch (IOException e) {
            throw new TownyInitException("Failed to load nation level config", TownyInitException.TownyError.MAIN_CONFIG);
        }
    }

    private boolean checkForLegacyDatabaseConfig() {
        Path configYMLPath = this.getDataFolder().toPath().resolve("settings").resolve("config.yml");
        if (!Files.exists(configYMLPath, new LinkOption[0])) {
            return true;
        }
        CommentedConfiguration config = new CommentedConfiguration(configYMLPath);
        if (!config.load()) {
            return false;
        }
        if (config.contains("plugin.database.database_load")) {
            String dbload = config.getString("plugin.database.database_load");
            String dbsave = config.getString("plugin.database.database_save");
            String hostname = config.getString("plugin.database.sql.hostname");
            String port = config.getString("plugin.database.sql.port");
            String dbname = config.getString("plugin.database.sql.dbname");
            String tableprefix = config.getString("plugin.database.sql.table_prefix");
            String username = config.getString("plugin.database.sql.username");
            String password = config.getString("plugin.database.sql.password");
            String flags = config.getString("plugin.database.sql.flags");
            String max_pool = config.getString("plugin.database.sql.pooling.max_pool_size");
            String max_lifetime = config.getString("plugin.database.sql.pooling.max_lifetime");
            String connection_timeout = config.getString("plugin.database.sql.pooling.connection_timeout");
            Path databaseYMLPath = this.getDataFolder().toPath().resolve("settings").resolve("database.yml");
            if (FileMgmt.checkOrCreateFile(databaseYMLPath.toString())) {
                CommentedConfiguration databaseConfig = new CommentedConfiguration(databaseYMLPath);
                databaseConfig.set("database.database_load", dbload);
                databaseConfig.set("database.database_save", dbsave);
                databaseConfig.set("database.sql.hostname", hostname);
                databaseConfig.set("database.sql.port", port);
                databaseConfig.set("database.sql.dbname", dbname);
                databaseConfig.set("database.sql.table_prefix", tableprefix);
                databaseConfig.set("database.sql.username", username);
                databaseConfig.set("database.sql.password", password);
                databaseConfig.set("database.sql.flags", flags);
                databaseConfig.set("database.sql.pooling.max_pool_size", max_pool);
                databaseConfig.set("database.sql.pooling.max_lifetime", max_lifetime);
                databaseConfig.set("database.sql.pooling.connection_timeout", connection_timeout);
                databaseConfig.save();
                this.getLogger().info("Database settings migrated to towny\\data\\settings\\database.yml");
            } else {
                this.getLogger().severe("Unable to migrate old database settings to towny\\data\\settings\\database.yml");
                return false;
            }
        }
        return true;
    }

    public void onDisable() {
        Bukkit.getLogger().info("==============================================================");
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (townyUniverse.getDataSource() != null && !this.isError()) {
            townyUniverse.getDataSource().saveQueues();
        }
        this.toggleTimersOff();
        TownyRegenAPI.cancelProtectionRegenTasks();
        this.playerCache.clear();
        try {
            plugin.getLogger().info("Finishing File IO Tasks...");
            townyUniverse.getDataSource().finishTasks();
            townyUniverse.finishTasks();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
        this.townyUniverse = null;
        plugin.getLogger().info("Version: " + this.version + " - Plugin Disabled");
        Bukkit.getLogger().info("=============================================================");
    }

    public void checkCitizens() {
        this.citizens2 = this.getServer().getPluginManager().isPluginEnabled("Citizens");
    }

    private void checkPlugins() {
        Plugin test;
        this.checkCitizens();
        plugin.getLogger().info("Searching for third-party plugins...");
        String ecowarn = "";
        ArrayList<String> addons = new ArrayList<String>();
        String permissions = this.returnPermissionsProviders();
        String economy = "";
        if (TownySettings.isUsingEconomy()) {
            if (TownyEconomyHandler.setupEconomy()) {
                File f;
                economy = "  Economy: " + TownyEconomyHandler.getVersion();
                if (TownyEconomyHandler.getVersion().startsWith("Essentials Economy")) {
                    ecowarn = "Warning: This version of Essentials Economy has been known to reset town and nation bank accounts to their default amount. Update your EssentialsX to version 2.19.0 or newer: https://essentialsx.net/downloads.html";
                }
                if (!(f = new File(TownyUniverse.getInstance().getRootFolder(), "debtAccountsConverted.txt")).exists()) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> MoneyUtil.convertLegacyDebtAccounts(), 600L);
                }
            } else {
                ecowarn = "Warning: No compatible Economy plugins found. Install Vault.jar or Reserve.jar with any of the supported eco systems. If you do not want an economy to be used, set using_economy: false in your Towny config.yml.";
            }
        }
        if ((test = this.getServer().getPluginManager().getPlugin("TownyCamps")) != null) {
            addons.add(String.format("%s v%s", "TownyCamps", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("TownyChat")) != null) {
            addons.add(String.format("%s v%s", "TownyChat", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("TownyCultures")) != null) {
            addons.add(String.format("%s v%s", "TownyCultures", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("TownyFlight")) != null) {
            addons.add(String.format("%s v%s", "TownyFlight", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("TownyHistories")) != null) {
            addons.add(String.format("%s v%s", "TownyHistories", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("SiegeWar")) != null) {
            addons.add(String.format("%s v%s", "SiegeWar", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("FlagWar")) != null) {
            addons.add(String.format("%s v%s", "FlagWar", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("Essentials")) == null) {
            TownySettings.setUsingEssentials(false);
        } else if (TownySettings.isUsingEssentials()) {
            this.essentials = (Essentials)test;
            addons.add(String.format("%s v%s", "Essentials", test.getDescription().getVersion()));
        }
        test = this.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        if (test != null) {
            new TownyPlaceholderExpansion(this).register();
            addons.add(String.format("%s v%s", "PlaceholderAPI", test.getDescription().getVersion()));
        }
        if ((test = this.getServer().getPluginManager().getPlugin("LuckPerms")) != null && TownySettings.isContextsEnabled()) {
            new LuckPermsContexts();
            addons.add(String.format("%s v%s", "LuckPerms", test.getDescription().getVersion()));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("TheNewChat")) {
            TNCRegister.initialize();
        }
        plugin.getLogger().info("Plugins found: ");
        plugin.getLogger().info(permissions);
        if (!economy.isEmpty()) {
            plugin.getLogger().info(economy);
        }
        if (!addons.isEmpty()) {
            plugin.getLogger().info("  Add-ons: " + WordUtils.wrap((String)StringMgmt.join(addons, ", "), (int)52, (String)(System.lineSeparator() + "                           "), (boolean)true));
        }
        if (!ecowarn.isEmpty()) {
            plugin.getLogger().info(WordUtils.wrap((String)ecowarn, (int)55, (String)(System.lineSeparator() + "                           "), (boolean)true));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("TheNewChat")) {
            TNCRegister.initialize();
        }
        if ((test = this.getServer().getPluginManager().getPlugin("Questioner")) != null) {
            String questioner = "Warning: Questioner.jar present on server, Towny no longer requires Questioner for invites/confirmations. You may safely remove Questioner.jar from your plugins folder.";
            plugin.getLogger().info(WordUtils.wrap((String)questioner, (int)55, (String)(System.lineSeparator() + "                           "), (boolean)true));
        }
    }

    private String returnPermissionsProviders() {
        String output = "  Permissions: TownyPerms, ";
        Plugin test = this.getServer().getPluginManager().getPlugin("GroupManager");
        if (test != null) {
            TownyUniverse.getInstance().setPermissionSource(new GroupManagerSource(this, test));
            output = output + String.format("%s v%s", "GroupManager", test.getDescription().getVersion());
        } else {
            test = this.getServer().getPluginManager().getPlugin("Vault");
            if (test != null) {
                Chat chat = (Chat)this.getServer().getServicesManager().load(Chat.class);
                if (chat == null) {
                    test = null;
                } else {
                    TownyUniverse.getInstance().setPermissionSource(new VaultPermSource(this, chat));
                    RegisteredServiceProvider vaultPermProvider = plugin.getServer().getServicesManager().getRegistration(Permission.class);
                    output = vaultPermProvider != null ? output + vaultPermProvider.getPlugin().getName() + " " + vaultPermProvider.getPlugin().getDescription().getVersion() + " via Vault" : output + String.format("%s v%s", "Vault", test.getDescription().getVersion());
                }
            }
            if (test == null) {
                TownyUniverse.getInstance().setPermissionSource(new BukkitPermSource(this));
                output = output + "BukkitPermissions";
            }
        }
        return output;
    }

    private void cycleTimers() {
        this.toggleTimersOff();
        TownyTimerHandler.toggleTownyRepeatingTimer(true);
        TownyTimerHandler.toggleDailyTimer(true);
        TownyTimerHandler.toggleHourlyTimer(true);
        TownyTimerHandler.toggleShortTimer(true);
        TownyTimerHandler.toggleMobRemoval(true);
        TownyTimerHandler.toggleHealthRegen(TownySettings.hasHealthRegen());
        TownyTimerHandler.toggleTeleportWarmup(TownySettings.getTeleportWarmupTime() > 0);
        TownyTimerHandler.toggleCooldownTimer(TownySettings.getPVPCoolDownTime() > 0 || TownySettings.getSpawnCooldownTime() > 0);
        TownyTimerHandler.toggleDrawSmokeTask(true);
        TownyTimerHandler.toggleDrawSpointsTask(TownySettings.getVisualizedSpawnPointsEnabled());
    }

    private void toggleTimersOff() {
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleHourlyTimer(false);
        TownyTimerHandler.toggleShortTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyTimerHandler.toggleCooldownTimer(false);
        TownyTimerHandler.toggleDrawSmokeTask(false);
        TownyTimerHandler.toggleDrawSpointsTask(false);
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (!this.isError()) {
            pluginManager.registerEvents((Listener)this.HUDManager, (Plugin)this);
            pluginManager.registerEvents((Listener)this.entityMonitorListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.vehicleListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.serverListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.customListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.worldListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.loginListener, (Plugin)this);
        }
        pluginManager.registerEvents((Listener)this.playerListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.blockListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.entityListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.inventoryListener, (Plugin)this);
    }

    private void printChangelogToConsole() {
        try {
            int i;
            List<String> changeLog = JavaUtil.readTextFromJar("/ChangeLog.txt");
            int startingIndex = 0;
            int linesDisplayed = 0;
            String lastVersion = Version.fromString(TownySettings.getLastRunVersion()).toString();
            plugin.getLogger().info("------------------------------------");
            plugin.getLogger().info("ChangeLog since v" + lastVersion + ":");
            block2: for (i = changeLog.size() - 1; i >= 0; --i) {
                if (!changeLog.get(i).startsWith(lastVersion)) continue;
                for (int j = i + 1; j < changeLog.size(); ++j) {
                    if (changeLog.get(j).trim().startsWith("-")) continue;
                    startingIndex = j;
                    break block2;
                }
                break;
            }
            if (startingIndex != 0) {
                for (i = startingIndex; i < changeLog.size(); ++i) {
                    if (linesDisplayed > 100) {
                        plugin.getLogger().info("\u00a7e<snip>");
                        plugin.getLogger().info("\u00a7eChangelog continues for another " + (changeLog.size() - (startingIndex + 99)) + " lines.");
                        plugin.getLogger().info("\u00a7eTo read the full changelog since " + lastVersion + ", go to https://github.com/TownyAdvanced/Towny/blob/master/resources/ChangeLog.txt#L" + ++startingIndex);
                        break;
                    }
                    String line = changeLog.get(i);
                    if (line.replaceAll(" ", "").replaceAll("\t", "").length() <= 0) continue;
                    Bukkit.getLogger().info(line.trim().startsWith("-") ? line : "\u00a7e" + line);
                    ++linesDisplayed;
                }
            } else {
                plugin.getLogger().warning("Could not find starting index for the changelog.");
            }
            plugin.getLogger().info("------------------------------------");
        }
        catch (IOException e) {
            plugin.getLogger().warning("Could not read ChangeLog.txt");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isError() {
        return !this.errors.isEmpty();
    }

    private boolean isError(@NotNull TownyInitException.TownyError error) {
        return this.errors.contains((Object)error);
    }

    public void addError(@NotNull TownyInitException.TownyError error) {
        this.errors.add(error);
    }

    private void removeError(@NotNull TownyInitException.TownyError error) {
        this.errors.remove((Object)error);
    }

    @NotNull
    public List<TownyInitException.TownyError> getErrors() {
        return this.errors;
    }

    public boolean isEssentials() {
        return TownySettings.isUsingEssentials() && this.essentials != null;
    }

    public boolean isCitizens2() {
        return this.citizens2;
    }

    public Essentials getEssentials() throws TownyException {
        if (this.essentials == null) {
            throw new TownyException("Essentials is not installed, or not enabled!");
        }
        return this.essentials;
    }

    public World getServerWorld(String name) throws NotRegisteredException {
        World world = BukkitTools.getWorld(name);
        if (world == null) {
            throw new NotRegisteredException(String.format("A world called '$%s' has not been registered.", name));
        }
        return world;
    }

    public boolean hasCache(Player player) {
        return this.playerCache.containsKey(player.getName().toLowerCase());
    }

    public PlayerCache newCache(Player player) {
        try {
            PlayerCache cache = new PlayerCache(TownyUniverse.getInstance().getDataSource().getWorld(player.getWorld().getName()), player);
            this.playerCache.put(player.getName().toLowerCase(), cache);
            return cache;
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg((Object)player, "Could not create permission cache for this world (" + player.getWorld().getName() + ".");
            return null;
        }
    }

    public void deleteCache(Player player) {
        this.deleteCache(player.getName());
    }

    public void deleteCache(String name) {
        this.playerCache.remove(name.toLowerCase());
    }

    public PlayerCache getCache(Player player) {
        PlayerCache cache = this.playerCache.get(player.getName().toLowerCase());
        if (cache == null && (cache = this.newCache(player)) != null) {
            cache.setLastTownBlock(WorldCoord.parseWorldCoord((Entity)player));
        }
        return cache;
    }

    public void resetCache() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            this.getCache(player).resetAndUpdate(WorldCoord.parseWorldCoord((Entity)player));
        }
    }

    public void updateCache(WorldCoord worldCoord) {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !Coord.parseCoord((Entity)player).equals(worldCoord)) continue;
            this.getCache(player).resetAndUpdate(worldCoord);
        }
    }

    public void updateCache() {
        WorldCoord worldCoord = null;
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            worldCoord = WorldCoord.parseWorldCoord((Entity)player);
            PlayerCache cache = this.getCache(player);
            if (cache.getLastTownBlock() == worldCoord) continue;
            cache.resetAndUpdate(worldCoord);
        }
    }

    public void updateCache(Player player) {
        WorldCoord worldCoord = WorldCoord.parseWorldCoord((Entity)player);
        PlayerCache cache = this.getCache(player);
        if (!cache.getLastTownBlock().equals(worldCoord)) {
            cache.resetAndUpdate(worldCoord);
        }
    }

    public void resetCache(Player player) {
        this.getCache(player).resetAndUpdate(WorldCoord.parseWorldCoord((Entity)player));
    }

    public void setPlayerMode(Player player, String[] modes, boolean notify) {
        if (player == null) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getName());
        if (resident != null) {
            resident.setModes(modes, notify);
        }
    }

    public void removePlayerMode(Player player) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getName());
        if (resident != null) {
            resident.clearModes();
        }
    }

    public List<String> getPlayerMode(Player player) {
        return this.getPlayerMode(player.getName());
    }

    public List<String> getPlayerMode(String name) {
        Resident resident = TownyUniverse.getInstance().getResident(name);
        return resident != null ? resident.getModes() : null;
    }

    public boolean hasPlayerMode(Player player, String mode) {
        return this.hasPlayerMode(player.getUniqueId(), mode);
    }

    public boolean hasPlayerMode(UUID uuid, String mode) {
        Resident resident = TownyUniverse.getInstance().getResident(uuid);
        return resident != null && resident.hasMode(mode);
    }

    public boolean hasPlayerMode(String name, String mode) {
        Resident resident = TownyUniverse.getInstance().getResident(name);
        return resident != null && resident.hasMode(mode);
    }

    public String getConfigPath() {
        return this.getDataFolder().getPath() + File.separator + "settings" + File.separator + "config.yml";
    }

    public Object getSetting(String root) {
        return TownySettings.getProperty(root);
    }

    public static Towny getPlugin() {
        return plugin;
    }

    public TownyPlayerListener getPlayerListener() {
        return this.playerListener;
    }

    public TownyVehicleListener getVehicleListener() {
        return this.vehicleListener;
    }

    public TownyEntityListener getEntityListener() {
        return this.entityListener;
    }

    public TownyEntityMonitorListener getEntityMonitorListener() {
        return this.entityMonitorListener;
    }

    public TownyWorldListener getWorldListener() {
        return this.worldListener;
    }

    public HUDManager getHUDManager() {
        return this.HUDManager;
    }

    public static BukkitAudiences getAdventure() {
        return adventure;
    }

    private void registerSpecialCommands() {
        ArrayList<BukkitCommand> commands = new ArrayList<BukkitCommand>(4);
        commands.add(new AcceptCommand(TownySettings.getAcceptCommand()));
        commands.add(new DenyCommand(TownySettings.getDenyCommand()));
        commands.add(new ConfirmCommand(TownySettings.getConfirmCommand()));
        commands.add(new CancelCommand(TownySettings.getCancelCommand()));
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.registerAll("towny", commands);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new TownyInitException("An issue has occured while registering custom commands.", TownyInitException.TownyError.OTHER, e);
        }
    }

    private void registerCommands() {
        this.getCommand("townyadmin").setExecutor((CommandExecutor)new TownyAdminCommand(this));
        this.getCommand("townyworld").setExecutor((CommandExecutor)new TownyWorldCommand(this));
        this.getCommand("resident").setExecutor((CommandExecutor)new ResidentCommand(this));
        this.getCommand("towny").setExecutor((CommandExecutor)new TownyCommand(this));
        TownCommand townCommandExecutor = new TownCommand(this);
        this.getCommand("town").setExecutor((CommandExecutor)townCommandExecutor);
        this.getCommand("t").setTabCompleter((TabCompleter)townCommandExecutor);
        this.getCommand("nation").setExecutor((CommandExecutor)new NationCommand(this));
        this.getCommand("plot").setExecutor((CommandExecutor)new PlotCommand(this));
        this.getCommand("invite").setExecutor((CommandExecutor)new InviteCommand(this));
    }

    private void addMetricsCharts() {
        Metrics metrics = new Metrics(this, 2244);
        metrics.addCustomChart(new SimplePie("language", () -> TownySettings.getString(ConfigNodes.LANGUAGE)));
        metrics.addCustomChart(new SimplePie("server_type", () -> {
            if (Bukkit.getServer().getName().equalsIgnoreCase("paper")) {
                return "Paper";
            }
            if (Bukkit.getServer().getName().equalsIgnoreCase("craftbukkit")) {
                if (Towny.isSpigotOrDerivative()) {
                    return "Spigot";
                }
                return "CraftBukkit";
            }
            return "Unknown";
        }));
        metrics.addCustomChart(new SimplePie("nation_zones_enabled", () -> TownySettings.getNationZonesEnabled() ? "true" : "false"));
        metrics.addCustomChart(new SimplePie("database_type", () -> TownySettings.getSaveDatabase().toLowerCase()));
        metrics.addCustomChart(new SimplePie("town_block_size", () -> String.valueOf(TownySettings.getTownBlockSize())));
        metrics.addCustomChart(new SimplePie("closed_economy_enabled", () -> String.valueOf(TownySettings.isEcoClosedEconomyEnabled())));
        metrics.addCustomChart(new SimplePie("resident_uuids_stored", TownySettings::getUUIDPercent));
    }

    public static boolean is116Plus() {
        return CUR_BUKKIT_VER.compareTo(NETHER_VER) >= 0;
    }

    private static boolean isSpigotOrDerivative() {
        try {
            Class.forName("org.bukkit.entity.Player$Spigot");
            return true;
        }
        catch (ClassNotFoundException tr) {
            return false;
        }
    }
}

