/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class ChunkNotification {
    public static String notificationFormat = "\u00a76 ~ %s";
    public static String notificationSplitter = "\u00a77 - ";
    public static String areaWildernessNotificationFormat = "\u00a72%s";
    public static String areaWildernessPvPNotificationFormat = "\u00a72%s";
    public static String areaTownNotificationFormat = "\u00a72%s";
    public static String areaTownPvPNotificationFormat = "\u00a72%s";
    public static String ownerNotificationFormat = "\u00a7a%s";
    public static String noOwnerNotificationFormat = "\u00a7a%s";
    public static String plotNotificationSplitter = " ";
    public static String plotNotificationFormat = "%s";
    public static String homeBlockNotification = "\u00a7b[Home]";
    public static String outpostBlockNotification = "\u00a7b[Outpost]";
    public static String forSaleNotificationFormat = "\u00a7e[For Sale: %s]";
    public static String notForSaleNotificationFormat = "\u00a7e[Not For Sale]";
    public static String plotTypeNotificationFormat = "\u00a76[%s]";
    public static String groupNotificationFormat = "\u00a7f[%s]";
    WorldCoord from;
    WorldCoord to;
    boolean fromWild = false;
    boolean toWild = false;
    boolean toForSale = false;
    boolean fromForSale = false;
    boolean toHomeBlock = false;
    boolean toOutpostBlock = false;
    boolean toPlotGroupBlock = false;
    TownBlock fromTownBlock;
    TownBlock toTownBlock = null;
    Town fromTown = null;
    Town toTown = null;
    Resident fromResident = null;
    Resident toResident = null;
    TownBlockType fromPlotType = null;
    TownBlockType toPlotType = null;
    PlotGroup fromPlotGroup = null;
    PlotGroup toPlotGroup = null;

    public static void loadFormatStrings() {
        notificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_FORMAT));
        notificationSplitter = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_SPLITTER));
        areaWildernessNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_AREA_WILDERNESS));
        areaWildernessPvPNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_AREA_WILDERNESS_PVP));
        areaTownNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_AREA_TOWN));
        areaTownPvPNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_AREA_TOWN_PVP));
        ownerNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_OWNER));
        noOwnerNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_NO_OWNER));
        plotNotificationSplitter = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_PLOT_SPLITTER));
        plotNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_PLOT_FORMAT));
        homeBlockNotification = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_PLOT_HOMEBLOCK));
        outpostBlockNotification = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_PLOT_OUTPOSTBLOCK));
        forSaleNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_PLOT_FORSALE));
        plotTypeNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_PLOT_TYPE));
        groupNotificationFormat = Colors.translateColorCodes(TownySettings.getString(ConfigNodes.NOTIFICATION_GROUP));
    }

    public ChunkNotification(WorldCoord from, WorldCoord to) {
        this.from = from;
        this.to = to;
        if (from.hasTownBlock()) {
            this.fromTownBlock = from.getTownBlockOrNull();
            this.fromPlotType = this.fromTownBlock.getType();
            boolean bl = this.fromForSale = this.fromTownBlock.getPlotPrice() != -1.0;
            if (this.fromTownBlock.hasPlotObjectGroup()) {
                this.fromPlotGroup = this.fromTownBlock.getPlotObjectGroup();
                this.fromForSale = this.fromPlotGroup.getPrice() != -1.0;
            }
            this.fromTown = this.fromTownBlock.getTownOrNull();
            this.fromResident = this.fromTownBlock.getResidentOrNull();
        } else {
            this.fromWild = true;
        }
        if (to.hasTownBlock()) {
            this.toTownBlock = to.getTownBlockOrNull();
            this.toPlotType = this.toTownBlock.getType();
            this.toTown = this.toTownBlock.getTownOrNull();
            this.toResident = this.toTownBlock.getResidentOrNull();
            this.toForSale = this.toTownBlock.getPlotPrice() != -1.0;
            this.toHomeBlock = this.toTownBlock.isHomeBlock();
            this.toOutpostBlock = this.toTownBlock.isOutpost();
            this.toPlotGroupBlock = this.toTownBlock.hasPlotObjectGroup();
            if (this.toPlotGroupBlock) {
                this.toPlotGroup = this.toTownBlock.getPlotObjectGroup();
                this.toForSale = this.toPlotGroup.getPrice() != -1.0;
            }
        } else {
            this.toWild = true;
        }
    }

    public String getNotificationString(Resident resident) {
        if (notificationFormat.length() == 0) {
            return null;
        }
        List<String> outputContent = this.getNotificationContent(resident);
        if (outputContent.size() == 0) {
            return null;
        }
        return String.format(notificationFormat, StringMgmt.join(outputContent, notificationSplitter));
    }

    public List<String> getNotificationContent(Resident resident) {
        ArrayList<String> out = new ArrayList<String>();
        String output = this.getAreaNotification(resident);
        if (output != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getAreaPvPNotification(resident)) != null && output.length() > 0) {
            out.add(output);
        }
        if (!resident.hasMode("ignoreplots") && (output = this.getOwnerOrPlotNameNotification(resident)) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getTownPVPNotification(resident)) != null && output.length() > 0) {
            out.add(output);
        }
        if (!resident.hasMode("ignoreplots") && (output = this.getPlotNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        return out;
    }

    public String getAreaNotification(Resident resident) {
        if (this.fromWild ^ this.toWild || !this.fromWild && !this.toWild && this.fromTown != null && this.toTown != null && this.fromTown != this.toTown) {
            if (this.toWild) {
                if (TownySettings.getNationZonesEnabled() && TownySettings.getNationZonesShowNotifications()) {
                    Player player = BukkitTools.getPlayer(resident.getName());
                    TownyWorld toWorld = this.to.getTownyWorldOrNull();
                    if (PlayerCacheUtil.fetchTownBlockStatus(player, this.to).equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE)) {
                        Town nearestTown = null;
                        nearestTown = toWorld.getClosestTownWithNationFromCoord(this.to.getCoord(), nearestTown);
                        return String.format(areaWildernessNotificationFormat, Translatable.of("nation_zone_this_area_under_protection_of", toWorld.getUnclaimedZoneName(), nearestTown.getNationOrNull().getName()).forLocale(resident));
                    }
                }
                return String.format(areaWildernessNotificationFormat, this.to.getTownyWorldOrNull().getUnclaimedZoneName());
            }
            if (TownySettings.isNotificationsTownNamesVerbose()) {
                return String.format(areaTownNotificationFormat, this.toTown.getFormattedName());
            }
            return String.format(areaTownNotificationFormat, this.toTown);
        }
        if (this.fromWild && this.toWild && TownySettings.getNationZonesEnabled() && TownySettings.getNationZonesShowNotifications()) {
            Player player = BukkitTools.getPlayer(resident.getName());
            TownyWorld toWorld = this.to.getTownyWorldOrNull();
            if (PlayerCacheUtil.fetchTownBlockStatus(player, this.to).equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE) && PlayerCacheUtil.fetchTownBlockStatus(player, this.from).equals((Object)PlayerCache.TownBlockStatus.UNCLAIMED_ZONE)) {
                Town nearestTown = null;
                nearestTown = toWorld.getClosestTownWithNationFromCoord(this.to.getCoord(), nearestTown);
                return String.format(areaWildernessNotificationFormat, Translatable.of("nation_zone_this_area_under_protection_of", toWorld.getUnclaimedZoneName(), nearestTown.getNationOrNull().getName()).forLocale(resident));
            }
            if (PlayerCacheUtil.fetchTownBlockStatus(player, this.to).equals((Object)PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) && PlayerCacheUtil.fetchTownBlockStatus(player, this.from).equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE)) {
                return String.format(areaWildernessNotificationFormat, this.to.getTownyWorldOrNull().getUnclaimedZoneName());
            }
        }
        return null;
    }

    public String getAreaPvPNotification(Resident resident) {
        if ((this.fromWild ^ this.toWild || !this.fromWild && !this.toWild && this.fromTown != null && this.toTown != null && this.fromTown != this.toTown) && this.toWild) {
            return String.format(areaWildernessPvPNotificationFormat, this.to.getTownyWorldOrNull().isPVP() && this.testWorldPVP() ? " " + Translatable.of("status_title_pvp").forLocale(resident) : "");
        }
        return null;
    }

    public String getOwnerOrPlotNameNotification(Resident resident) {
        if (this.toWild) {
            return null;
        }
        if (this.fromResident != this.toResident || this.fromTownBlock != null && !this.fromTownBlock.getName().equalsIgnoreCase(this.toTownBlock.getName()) || this.fromTownBlock != null && this.fromTownBlock.hasPlotObjectGroup() && !this.toTownBlock.hasPlotObjectGroup()) {
            if (this.toResident != null) {
                String resName = TownySettings.isNotificationOwnerShowingNationTitles() ? this.toResident.getFormattedTitleName() : this.toResident.getFormattedName();
                return String.format(ownerNotificationFormat, Colors.translateColorCodes(this.toTownBlock.getName().isEmpty() ? resName : this.toTownBlock.getName()));
            }
            return String.format(noOwnerNotificationFormat, this.toTownBlock.getName().isEmpty() ? Translatable.of("UNCLAIMED_PLOT_NAME").forLocale(resident) : Colors.translateColorCodes(this.toTownBlock.getName()));
        }
        return null;
    }

    public String getTownPVPNotification(Resident resident) {
        if (!this.toWild && (this.fromWild || this.toTownBlock.getPermissions().pvp != this.fromTownBlock.getPermissions().pvp)) {
            return String.format(areaTownPvPNotificationFormat, !CombatUtil.preventPvP(this.to.getTownyWorldOrNull(), this.toTownBlock) ? Translatable.of("status_title_pvp").forLocale(resident) : Translatable.of("status_title_nopvp").forLocale(resident));
        }
        return null;
    }

    private boolean testWorldPVP() {
        return this.to.getTownyWorldOrNull().isPVP();
    }

    public String getPlotNotification() {
        if (plotNotificationFormat.length() == 0) {
            return null;
        }
        List<String> outputContent = this.getPlotNotificationContent();
        if (outputContent.size() == 0) {
            return null;
        }
        return String.format(plotNotificationFormat, StringMgmt.join(outputContent, plotNotificationSplitter));
    }

    public List<String> getPlotNotificationContent() {
        ArrayList<String> out = new ArrayList<String>();
        String output = this.getHomeblockNotification();
        if (output != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getOutpostblockNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getForSaleNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getPlotTypeNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getGroupNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        return out;
    }

    public String getHomeblockNotification() {
        if (this.toHomeBlock) {
            return homeBlockNotification;
        }
        return null;
    }

    public String getOutpostblockNotification() {
        if (this.toOutpostBlock) {
            return outpostBlockNotification;
        }
        return null;
    }

    public String getForSaleNotification() {
        if (this.toForSale && this.toPlotGroupBlock && this.fromPlotGroup != this.toPlotGroup) {
            return String.format(forSaleNotificationFormat, TownyEconomyHandler.isActive() ? TownyEconomyHandler.getFormattedBalance(this.toTownBlock.getPlotObjectGroup().getPrice()) : "$ 0");
        }
        if (this.toForSale && !this.toPlotGroupBlock) {
            return String.format(forSaleNotificationFormat, TownyEconomyHandler.isActive() ? TownyEconomyHandler.getFormattedBalance(this.toTownBlock.getPlotPrice()) : "$ 0");
        }
        if (!this.toForSale && this.fromForSale && !this.toWild) {
            return notForSaleNotificationFormat;
        }
        return null;
    }

    public String getGroupNotification() {
        if (this.toPlotGroupBlock && this.fromPlotGroup != this.toPlotGroup) {
            return String.format(groupNotificationFormat, this.toTownBlock.getPlotObjectGroup().getName());
        }
        return null;
    }

    public String getPlotTypeNotification() {
        if (this.fromPlotType != this.toPlotType && this.toPlotType != null && this.toPlotType != TownBlockType.RESIDENTIAL) {
            return String.format(plotTypeNotificationFormat, this.toPlotType.toString());
        }
        return null;
    }
}

