/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.config;

import com.palmergames.bukkit.towny.Towny;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class CommentedConfiguration
extends YamlConfiguration {
    private final HashMap<String, String> comments = new HashMap();
    private final Path path;
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);

    public CommentedConfiguration(Path path) {
        this.path = path;
    }

    public boolean load() {
        try {
            this.load(this.path.toFile());
        }
        catch (IOException | InvalidConfigurationException e) {
            Towny.getPlugin().getLogger().warning(String.format("Loading error: Failed to load file %s (does it pass a yaml parser?).", this.path));
            Towny.getPlugin().getLogger().warning("https://jsonformatter.org/yaml-parser");
            Towny.getPlugin().getLogger().warning(e.getMessage());
            return false;
        }
        return true;
    }

    public void save() {
        boolean saved = true;
        try {
            this.save(this.path.toFile());
        }
        catch (Exception e) {
            saved = false;
        }
        if (!this.comments.isEmpty() && saved) {
            List<String> yamlContents;
            StringBuilder newContents = new StringBuilder();
            String currentPath = "";
            int depth = 0;
            try {
                yamlContents = Files.readAllLines(this.path, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Towny.getPlugin().getLogger().warning(String.format("Saving error: Failed to save file %s.", this.path));
                Towny.getPlugin().getLogger().warning(e.getMessage());
                yamlContents = new ArrayList<String>();
            }
            for (String line : yamlContents) {
                boolean node;
                if (line.contains(": ") || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                    node = true;
                    int index = line.indexOf(": ");
                    if (index < 0) {
                        index = line.length() - 1;
                    }
                    if (currentPath.isEmpty()) {
                        currentPath = line.substring(0, index);
                    } else {
                        int whiteSpace = 0;
                        for (int n = 0; n < line.length() && line.charAt(n) == ' '; ++n) {
                            ++whiteSpace;
                        }
                        if (whiteSpace / 2 > depth) {
                            currentPath = currentPath + "." + line.substring(whiteSpace, index);
                            ++depth;
                        } else if (whiteSpace / 2 < depth) {
                            int newDepth = whiteSpace / 2;
                            for (int i = 0; i < depth - newDepth; ++i) {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                            }
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                                currentPath = currentPath + ".";
                            }
                            currentPath = currentPath + line.substring(whiteSpace, index);
                            depth = newDepth;
                        } else {
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                                currentPath = currentPath + ".";
                            }
                            currentPath = currentPath + line.substring(whiteSpace, index);
                        }
                    }
                } else {
                    node = false;
                }
                if (node) {
                    String comment = this.comments.get(currentPath);
                    line = comment != null ? comment + System.getProperty("line.separator") + line + System.getProperty("line.separator") : line + System.getProperty("line.separator");
                }
                if (!node) {
                    newContents.append(line).append(System.getProperty("line.separator"));
                    continue;
                }
                newContents.append(line);
            }
            while (newContents.toString().startsWith(" " + System.getProperty("line.separator"))) {
                newContents = new StringBuilder(newContents.toString().replaceFirst(" " + System.getProperty("line.separator"), ""));
            }
            try {
                Files.write(this.path, newContents.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                Towny.getPlugin().getLogger().warning(String.format("Saving error: Failed to write to file %s.", this.path));
                Towny.getPlugin().getLogger().warning(e.getMessage());
            }
        }
    }

    public void addComment(String path, String ... commentLines) {
        StringBuilder commentstring = new StringBuilder();
        StringBuilder leadingSpaces = new StringBuilder();
        for (int n = 0; n < path.length(); ++n) {
            if (path.charAt(n) != '.') continue;
            leadingSpaces.append("  ");
        }
        for (String line : commentLines) {
            line = !line.isEmpty() ? leadingSpaces + line : " ";
            if (commentstring.length() > 0) {
                commentstring.append(System.getProperty("line.separator"));
            }
            commentstring.append(line);
        }
        this.comments.put(path, commentstring.toString());
    }

    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlOptions.setWidth(10000);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        String dump = this.yaml.dump((Object)this.getValues(false));
        if (dump.equals("{}\n")) {
            dump = "";
        }
        return dump;
    }
}

