/*
 * Decompiled with CFR 0.152.
 */
package com.ruiwenliu.Horizontallibrary.weight;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zhy.autolayout.utils.AutoUtils;

public class SpaceItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int DEFAULT_COLUMN = Integer.MAX_VALUE;
    private int space;
    private int column;

    public SpaceItemDecoration(int space) {
        this(space, Integer.MAX_VALUE);
    }

    public SpaceItemDecoration(int space, int column) {
        this.space = AutoUtils.getPercentWidthSize((int)space);
        this.column = column;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.top = this.space;
        int pos = parent.getChildLayoutPosition(view);
        int total = parent.getChildCount();
        if (this.isFirstRow(pos)) {
            outRect.top = 0;
        }
        if (this.isLastRow(pos, total)) {
            outRect.bottom = 5;
        }
        if (this.column != Integer.MAX_VALUE) {
            float avg = (float)((this.column - 1) * this.space) * 1.0f / (float)this.column;
            outRect.left = (int)((float)(pos % this.column) * ((float)this.space - avg));
            outRect.right = (int)(avg - (float)(pos % this.column) * ((float)this.space - avg));
        }
    }

    boolean isFirstRow(int pos) {
        return pos < this.column;
    }

    boolean isLastRow(int pos, int total) {
        return total - pos <= this.column;
    }
}

