/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.widget;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import org.liquidplayer.widget.HtmlAnsiOutputStream;

class AnsiConsoleTextView
extends TextView {
    private ArrayList<Listener> listeners = new ArrayList();
    private final ConsoleOutputStream stream = new ConsoleOutputStream(new ByteArrayOutputStream());

    public AnsiConsoleTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void print(String string) {
        this.stream.print(string, false);
    }

    public void println(String string) {
        this.stream.print(string, true);
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private class ConsoleOutputStream
    extends HtmlAnsiOutputStream {
        private ByteArrayOutputStream os;
        private int index;
        private CharSequence displayText;
        private Boolean refreshQueued;
        private final Object lock;
        private Runnable updateText;
        private final Object consoleThreadLock;
        private final Semaphore consoleSemaphore;
        private final ArrayList<String> consoleStrings;
        private final Thread consoleThread;
        private final Runnable consoleThreadRunnable;
        private final ArrayList<Integer[]> cursorPositionStack;

        ConsoleOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            super(byteArrayOutputStream);
            this.refreshQueued = false;
            this.lock = new Object();
            this.updateText = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ConsoleOutputStream.this.lock;
                    synchronized (object) {
                        AnsiConsoleTextView.this.setText(ConsoleOutputStream.this.displayText);
                        ConsoleOutputStream.this.refreshQueued = false;
                    }
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            for (Listener listener : AnsiConsoleTextView.this.listeners) {
                                listener.onDisplayUpdated();
                            }
                        }
                    });
                }
            };
            this.consoleThreadLock = new Object();
            this.consoleSemaphore = new Semaphore(0);
            this.consoleStrings = new ArrayList();
            this.consoleThreadRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            int strings;
                            String out = "";
                            ConsoleOutputStream.this.consoleSemaphore.acquire();
                            Object object = ConsoleOutputStream.this.consoleThreadLock;
                            synchronized (object) {
                                strings = ConsoleOutputStream.this.consoleStrings.size();
                                for (String string : ConsoleOutputStream.this.consoleStrings) {
                                    out = out.concat(string);
                                }
                                ConsoleOutputStream.this.consoleStrings.clear();
                            }
                            try {
                                ConsoleOutputStream.this.write(out.getBytes("UTF-8"));
                                ConsoleOutputStream.this.flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            if (strings <= 1) continue;
                            ConsoleOutputStream.this.consoleSemaphore.acquire(strings - 1);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            };
            this.cursorPositionStack = new ArrayList();
            this.os = byteArrayOutputStream;
            this.displayText = AnsiConsoleTextView.this.getText();
            this.index = this.displayText.length();
            this.consoleThread = new Thread(this.consoleThreadRunnable);
            this.consoleThread.start();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.consoleThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void print(String string, boolean addCr) {
            if (addCr) {
                string = string.concat("\n");
            }
            Object object = this.consoleThreadLock;
            synchronized (object) {
                this.consoleStrings.add(string);
                this.consoleSemaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                Spanned text_ = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)new String(this.os.toByteArray(), "UTF-8"), (int)0) : Html.fromHtml((String)new String(this.os.toByteArray(), "UTF-8"));
                this.os.reset();
                if (this.index == this.displayText.length()) {
                    this.displayText = TextUtils.concat((CharSequence[])new CharSequence[]{this.displayText, text_});
                } else if (this.index < this.displayText.length()) {
                    if (this.index + text_.length() >= this.displayText.length()) {
                        this.displayText = TextUtils.concat((CharSequence[])new CharSequence[]{this.displayText.subSequence(0, this.index), text_});
                    } else {
                        CharSequence first = this.displayText.subSequence(0, this.index);
                        CharSequence last = this.displayText.subSequence(this.index + text_.length(), this.displayText.length());
                        this.displayText = TextUtils.concat((CharSequence[])new CharSequence[]{first, text_, last});
                    }
                } else {
                    Log.e((String)"Console flush", (String)"index is greater than total buffer length");
                    this.displayText = TextUtils.concat((CharSequence[])new CharSequence[]{this.displayText, text_});
                    this.index = this.displayText.length();
                }
                this.index += text_.length();
                if (!this.refreshQueued.booleanValue()) {
                    this.refreshQueued = true;
                    new Handler(Looper.getMainLooper()).post(this.updateText);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEraseScreen(int eraseOption) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                switch (eraseOption) {
                    case 0: {
                        this.displayText = this.displayText.subSequence(0, this.index);
                        break;
                    }
                    case 1: {
                        this.displayText = "";
                        this.index = 0;
                        break;
                    }
                    case 2: {
                        this.displayText = "";
                        this.index = 0;
                    }
                }
            }
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processCursorTo(int row, int col) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                int next;
                int count;
                this.index = 0;
                String text = this.displayText.toString();
                for (count = 1; count < row && this.index < text.length() && (next = text.indexOf(10, this.index)) >= 0; ++count) {
                    this.index = next + 1;
                }
                for (count = 1; count < col && this.index < text.length() && text.charAt(this.index) != '\n'; ++count) {
                    ++this.index;
                }
            }
            this.flush();
        }

        private int[] currentCursorPos() {
            int[] pos = new int[]{1, 1};
            String text = this.displayText.toString();
            for (int i = 0; i < this.index; ++i) {
                if (text.charAt(i) == '\n') {
                    pos[0] = pos[0] + 1;
                    pos[1] = 0;
                    continue;
                }
                pos[1] = pos[1] + 1;
            }
            return pos;
        }

        @Override
        protected void processCursorToColumn(int x) throws IOException {
            int[] pos = this.currentCursorPos();
            this.processCursorTo(pos[0], Math.max(1, x));
        }

        @Override
        protected void processCursorUpLine(int count) throws IOException {
            int[] pos = this.currentCursorPos();
            this.processCursorTo(Math.max(pos[0] - count, 1), 1);
        }

        @Override
        protected void processCursorDownLine(int count) throws IOException {
            int[] pos = this.currentCursorPos();
            this.processCursorTo(pos[0] + count, 1);
        }

        @Override
        protected void processCursorLeft(int count) throws IOException {
            int[] pos = this.currentCursorPos();
            this.processCursorTo(pos[0], Math.max(pos[1] - count, 1));
        }

        @Override
        protected void processCursorRight(int count) throws IOException {
            int[] pos = this.currentCursorPos();
            this.processCursorTo(pos[0], pos[1] + count);
        }

        @Override
        protected void processCursorDown(int count) throws IOException {
            int[] pos = this.currentCursorPos();
            this.processCursorTo(pos[0] + count, pos[1]);
        }

        @Override
        protected void processCursorUp(int count) throws IOException {
            int[] pos = this.currentCursorPos();
            this.processCursorTo(Math.max(pos[0] - count, 1), pos[1]);
        }

        @Override
        protected void processRestoreCursorPosition() throws IOException {
            if (this.cursorPositionStack.size() > 0) {
                Integer[] pos = this.cursorPositionStack.get(this.cursorPositionStack.size() - 1);
                this.cursorPositionStack.remove(this.cursorPositionStack.size() - 1);
                this.processCursorTo(pos[0], pos[1]);
            }
        }

        @Override
        protected void processSaveCursorPosition() throws IOException {
            int[] p = this.currentCursorPos();
            Integer[] pp = new Integer[]{p[0], p[1]};
            this.cursorPositionStack.add(pp);
        }

        @Override
        protected void processScrollDown(int optionInt) throws IOException {
            Log.d((String)"ConsoleTextView", (String)"processScrollDown");
        }

        @Override
        protected void processScrollUp(int optionInt) throws IOException {
            Log.d((String)"ConsoleTextView", (String)"processScrollUp");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEraseLine(int eraseOption) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                switch (eraseOption) {
                    case 0: {
                        String dt = this.displayText.toString();
                        int next = dt.indexOf(10, this.index);
                        if (next >= 0) {
                            this.displayText = TextUtils.concat((CharSequence[])new CharSequence[]{this.displayText.subSequence(0, this.index), this.displayText.subSequence(next, dt.length())});
                            break;
                        }
                        this.displayText = this.displayText.subSequence(0, this.index);
                        break;
                    }
                    case 1: {
                        String dt = this.displayText.toString();
                        int currIndex = this.index;
                        int[] currPos = this.currentCursorPos();
                        this.processCursorTo(currPos[0], 1);
                        this.displayText = TextUtils.concat((CharSequence[])new CharSequence[]{this.displayText.subSequence(0, this.index), this.displayText.subSequence(currIndex, dt.length())});
                        break;
                    }
                    case 2: {
                        int[] currPos = this.currentCursorPos();
                        this.processCursorTo(currPos[0], 1);
                        this.processEraseLine(0);
                        break;
                    }
                }
            }
            this.flush();
        }
    }

    static interface Listener {
        public void onDisplayUpdated();
    }
}

