/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSObjectWrapper;
import org.liquidplayer.javascript.JSValue;

class JSObjectPropertiesMap<V>
extends JSObjectWrapper
implements Map<String, V> {
    private final Class<V> mType;

    public JSObjectPropertiesMap(JSObject object, Class<V> cls) {
        super(object);
        this.mType = cls;
    }

    public JSObjectPropertiesMap(JSContext context, Map map, Class<V> cls) {
        super(new JSObject(context, map));
        this.mType = cls;
    }

    public JSObjectPropertiesMap(JSContext context, Class<V> cls) {
        super(new JSObject(context));
        this.mType = cls;
    }

    @Override
    public int size() {
        return this.propertyNames().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hasProperty(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        String[] properties;
        for (String key : properties = this.propertyNames()) {
            if (!this.property(key).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        JSValue val = this.property(key.toString());
        if (val.isUndefined().booleanValue()) {
            return null;
        }
        return (V)val.toJavaObject(this.mType);
    }

    @Override
    public V put(String key, V value) {
        V oldValue = this.get(key);
        this.property(key, value);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.get(key);
        this.deleteProperty(key.toString());
        return oldValue;
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends V> map) {
        for (String string : map.keySet()) {
            this.put(string, map.get(string));
        }
    }

    @Override
    public void clear() {
        for (String prop : this.propertyNames()) {
            this.deleteProperty(prop);
        }
    }

    @Override
    @NonNull
    public Set keySet() {
        return new HashSet<String>(Arrays.asList(this.propertyNames()));
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                String[] propertyNames = JSObjectPropertiesMap.this.propertyNames();
                if (index > propertyNames.length) {
                    throw new IndexOutOfBoundsException();
                }
                return JSObjectPropertiesMap.this.get(propertyNames[index]);
            }

            @Override
            public int size() {
                return JSObjectPropertiesMap.this.propertyNames().length;
            }

            @Override
            public boolean contains(Object val) {
                return JSObjectPropertiesMap.this.containsValue(val);
            }
        };
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, V>> entrySet() {
        return new AbstractSet<Map.Entry<String, V>>(){

            @Override
            @NonNull
            public Iterator<Map.Entry<String, V>> iterator() {
                return new SetIterator();
            }

            @Override
            public int size() {
                return JSObjectPropertiesMap.this.propertyNames().length;
            }
        };
    }

    private class SetIterator
    implements Iterator<Map.Entry<String, V>> {
        private String current = null;
        private String removal = null;

        SetIterator() {
            String[] properties = JSObjectPropertiesMap.this.propertyNames();
            if (properties.length > 0) {
                this.current = properties[0];
            }
        }

        @Override
        public boolean hasNext() {
            String[] properties;
            if (this.current == null) {
                return false;
            }
            for (String prop : properties = JSObjectPropertiesMap.this.propertyNames()) {
                if (!this.current.equals(prop)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<String, V> next() {
            int i;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String[] properties = JSObjectPropertiesMap.this.propertyNames();
            Map.Entry entry = null;
            for (i = 0; i < properties.length; ++i) {
                if (!this.current.equals(properties[i])) continue;
                final String key = properties[i];
                entry = new Map.Entry<String, V>(){

                    @Override
                    public String getKey() {
                        return (String)key;
                    }

                    @Override
                    public V getValue() {
                        return JSObjectPropertiesMap.this.get(key);
                    }

                    @Override
                    public V setValue(V object) {
                        return JSObjectPropertiesMap.this.put((String)key, object);
                    }
                };
                break;
            }
            this.removal = this.current;
            this.current = i + 1 < properties.length ? properties[i + 1] : null;
            if (entry != null) {
                return entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.removal == null) {
                throw new NoSuchElementException();
            }
            JSObjectPropertiesMap.this.deleteProperty(this.removal);
            this.removal = null;
        }
    }
}

