/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObjectPropertiesMap;
import org.liquidplayer.javascript.JSValue;

public class JSObject
extends JSValue {
    public static final int JSPropertyAttributeNone = 0;
    public static final int JSPropertyAttributeReadOnly = 2;
    public static final int JSPropertyAttributeDontEnum = 4;
    public static final int JSPropertyAttributeDontDelete = 8;
    protected final List<JSObject> zombies = new ArrayList<JSObject>();
    private JSObject thiz = null;

    public JSObject(JSContext ctx) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSObject.this.valueRef = JSObject.this.make(JSObject.this.context.ctxRef());
                JSObject.this.addJSExports();
            }
        });
        this.context.persistObject(this);
    }

    protected void addJSExports() {
        try {
            Method[] methods;
            for (Field f : this.getClass().getDeclaredFields()) {
                if (!f.isAnnotationPresent(jsexport.class)) continue;
                f.setAccessible(true);
                if (!Property.class.isAssignableFrom(f.getType())) continue;
                Property prop = (Property)f.get(this);
                if (prop == null) {
                    Constructor<?> ctor = f.getType().getDeclaredConstructor(JSObject.class);
                    ctor.setAccessible(true);
                    prop = (Property)ctor.newInstance(this);
                    f.set(this, prop);
                }
                prop.setName(f.getName(), f.getAnnotation(jsexport.class).type(), f.getAnnotation(jsexport.class).attributes());
            }
            for (Method m : methods = this.getClass().getDeclaredMethods()) {
                if (!m.isAnnotationPresent(jsexport.class)) continue;
                m.setAccessible(true);
                JSFunction f = new JSFunction(this.context, m, JSObject.class, this);
                this.property(m.getName(), f, m.getAnnotation(jsexport.class).attributes());
            }
        }
        catch (Exception e) {
            this.context.throwJSException(new JSException(this.context, e.toString()));
        }
    }

    public JSObject() {
    }

    protected JSObject(long objRef, JSContext ctx) {
        super(objRef, ctx);
        this.context.persistObject(this);
    }

    public JSObject(JSContext ctx, final Class<?> iface) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                Method[] methods;
                JSObject.this.valueRef = JSObject.this.make(JSObject.this.context.ctxRef());
                JSObject.this.addJSExports();
                for (Method m : methods = iface.getDeclaredMethods()) {
                    JSFunction f = new JSFunction(JSObject.this.context, m, JSObject.class, JSObject.this);
                    JSObject.this.property(m.getName(), f);
                }
            }
        });
        this.context.persistObject(this);
    }

    public JSObject(JSContext ctx, Map map) {
        this(ctx);
        new JSObjectPropertiesMap<Object>(this, Object.class).putAll(map);
        this.addJSExports();
    }

    public boolean hasProperty(final String prop) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JSValue.JNIReturnObject();
                this.jni.bool = JSObject.this.hasProperty(JSObject.this.context.ctxRef(), JSObject.this.valueRef, prop);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public JSValue property(final String prop) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSObject.this.getProperty(JSObject.this.context.ctxRef(), JSObject.this.valueRef, prop);
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return new JSValue(this.context);
        }
        return new JSValue(runnable.jni.reference, this.context);
    }

    public void property(final String prop, final Object value, final int attributes) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                long ref = value instanceof JSValue ? ((JSValue)value).valueRef() : new JSValue(JSObject.this.context, value).valueRef();
                this.jni = JSObject.this.setProperty(JSObject.this.context.ctxRef(), JSObject.this.valueRef, prop, ref, attributes);
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
        }
    }

    public void property(String prop, Object value) {
        this.property(prop, value, 0);
    }

    public boolean deleteProperty(final String prop) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSObject.this.deleteProperty(JSObject.this.context.ctxRef(), JSObject.this.valueRef, prop);
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return false;
        }
        return runnable.jni.bool;
    }

    public JSValue propertyAtIndex(final int index) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSObject.this.getPropertyAtIndex(JSObject.this.context.ctxRef(), JSObject.this.valueRef, index);
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return new JSValue(this.context);
        }
        return new JSValue(runnable.jni.reference, this.context);
    }

    public void propertyAtIndex(final int index, final Object value) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSObject.this.setPropertyAtIndex(JSObject.this.context.ctxRef(), JSObject.this.valueRef, index, value instanceof JSValue ? ((JSValue)value).valueRef() : new JSValue(JSObject.this.context, value).valueRef());
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
        }
    }

    public String[] propertyNames() {
        StringArrayReturnClass runnable = new StringArrayReturnClass(){

            @Override
            public void run() {
                this.sArray = JSObject.this.copyPropertyNames(JSObject.this.context.ctxRef(), JSObject.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.sArray;
    }

    public boolean isFunction() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JSValue.JNIReturnObject();
                this.jni.bool = JSObject.this.isFunction(JSObject.this.context.ctxRef(), JSObject.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public boolean isConstructor() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JSValue.JNIReturnObject();
                this.jni.bool = JSObject.this.isConstructor(JSObject.this.context.ctxRef(), JSObject.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    @Override
    public int hashCode() {
        return this.valueRef().intValue();
    }

    public JSValue prototype() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JSValue.JNIReturnObject();
                this.jni.reference = JSObject.this.getPrototype(JSObject.this.context.ctxRef(), JSObject.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return new JSValue(runnable.jni.reference, this.context);
    }

    public void prototype(final JSValue proto) {
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSObject.this.setPrototype(JSObject.this.context.ctxRef(), JSObject.this.valueRef, proto.valueRef());
            }
        });
    }

    @Override
    protected void finalize() throws Throwable {
        this.context.finalizeObject(this);
        super.finalize();
    }

    protected void setThis(JSObject thiz) {
        this.thiz = thiz;
    }

    public JSObject getThis() {
        return this.thiz;
    }

    public JSValue __nullFunc() {
        return new JSValue(this.context);
    }

    protected native long make(long var1);

    protected native JSValue.JNIReturnObject makeArray(long var1, long[] var3);

    protected native long makeDate(long var1, long[] var3);

    protected native long makeError(long var1, String var3);

    protected native JSValue.JNIReturnObject makeRegExp(long var1, String var3, String var4);

    protected native long getPrototype(long var1, long var3);

    protected native void setPrototype(long var1, long var3, long var5);

    protected native boolean hasProperty(long var1, long var3, String var5);

    protected native JSValue.JNIReturnObject getProperty(long var1, long var3, String var5);

    protected native JSValue.JNIReturnObject setProperty(long var1, long var3, String var5, long var6, int var8);

    protected native JSValue.JNIReturnObject deleteProperty(long var1, long var3, String var5);

    protected native JSValue.JNIReturnObject getPropertyAtIndex(long var1, long var3, int var5);

    protected native JSValue.JNIReturnObject setPropertyAtIndex(long var1, long var3, int var5, long var6);

    protected native boolean isFunction(long var1, long var3);

    protected native JSValue.JNIReturnObject callAsFunction(long var1, long var3, long var5, long[] var7);

    protected native boolean isConstructor(long var1, long var3);

    protected native JSValue.JNIReturnObject callAsConstructor(long var1, long var3, long[] var5);

    protected native String[] copyPropertyNames(long var1, long var3);

    protected native JSValue.JNIReturnObject makeFunction(long var1, String var3, String var4, String var5, int var6);

    private abstract class StringArrayReturnClass
    implements Runnable {
        public String[] sArray;

        private StringArrayReturnClass() {
        }
    }

    private abstract class JNIReturnClass
    implements Runnable {
        JSValue.JNIReturnObject jni;

        private JNIReturnClass() {
        }
    }

    public class Property<T> {
        private T temp = null;
        private Class pT;
        private Integer attributes = null;
        private String name = null;

        private Property() {
        }

        public void set(T v) {
            this.temp = v;
            if (this.temp != null) {
                this.pT = this.temp.getClass();
            }
            if (this.name != null) {
                if (this.attributes != null) {
                    JSObject.this.property(this.name, v, this.attributes);
                    this.attributes = null;
                } else {
                    JSObject.this.property(this.name, v);
                }
            }
        }

        public T get() {
            if (this.temp == null && this.pT == Object.class) {
                JSObject.this.context.throwJSException(new JSException(JSObject.this.context, "object has no defined type"));
                return null;
            }
            if (this.name != null) {
                return (T)JSObject.this.property(this.name).toJavaObject(this.pT);
            }
            return this.temp;
        }

        private void setName(String n, Class cls, int attributes) {
            this.name = n;
            this.attributes = attributes;
            if (this.temp != null) {
                JSObject.this.property(this.name, this.temp, this.attributes);
                this.attributes = null;
            } else {
                this.pT = cls;
                JSObject.this.property(this.name, new JSValue(JSObject.this.context));
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface jsexport {
        public Class type() default Object.class;

        public int attributes() default 0;
    }
}

